/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.biz.BizCalcGroupInfo;
import com.kingdee.eas.ma.biz.client.AbstractBizCalcImportUI;
import com.kingdee.eas.ma.biz.client.utils.BizCalcExportHelper;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.utils.XmlFileFilter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BizCalcImportUI
extends AbstractBizCalcImportUI {
    private static final long serialVersionUID = -2471980784793585808L;
    private static final Logger logger = CoreUIObject.getLogger(BizCalcImportUI.class);

    protected String getBgSchemeId() {
        return (String)this.getUIContext().get("BGSCHEME_ID");
    }

    protected String getOrgUnitId() {
        return (String)this.getUIContext().get("ORGUNIT_ID");
    }

    protected String getBizCalcGroupId() {
        if (this.getUIContext().get("BIZCALCGROUP") instanceof BizCalcGroupInfo) {
            return ((BizCalcGroupInfo)this.getUIContext().get("BIZCALCGROUP")).getId().toString();
        }
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOpenFile.setIcon((Icon)((ImageIcon)ResourceBase.getIcon((String)"com.kingdee.eas.tools.datatask.ui.ImageResource.tbtn_open", (Locale)new Locale("L1"))));
        this.panelProgress.setVisible(false);
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.setSelectedIndex(0);
        this.setBtnState(true);
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFile.getText())) {
            return;
        }
        ProgressThread process = new ProgressThread();
        process.start();
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForImp((Object)this.getUIContext());
        fileChooser.setDialogTitle(this.getUITitle());
        String filePath = this.fileSelect(fileChooser);
        if (!StringUtils.isEmpty((String)filePath)) {
            this.txtFile.setText(filePath.toString());
            this.txtFile.setUserObject((Object)fileChooser.getSelectedFile());
        }
    }

    private String fileSelect(KDFileChooser fileChooser) {
        String filePath = null;
        fileChooser.setFileFilter((FileFilter)new XmlFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (filePath.lastIndexOf(".") == -1) {
                filePath = filePath + ".xml";
            } else {
                String formatStr = filePath.subSequence(filePath.lastIndexOf("."), filePath.length()).toString();
                if (!formatStr.equals(".xml")) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"importErrorFormat"));
                    this.destroyWindow();
                    SysUtil.abort();
                }
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        return filePath;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    public void importBizCalc(String fileName) throws Exception {
        String message = this.doImport(fileName);
        if (!StringUtils.isEmpty((String)message)) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizCalcImportFailed"), (String)message, (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizCalcImportSuccess"));
        }
    }

    protected String doImport(String fileName) throws Exception {
        return BizCalcExportHelper.importBizCalc(this.getBgSchemeId(), this.getOrgUnitId(), fileName, (ErrorHandleModeEnum)this.comboError.getSelectedItem(), this.getBizCalcGroupId());
    }

    class ProgressThread
    extends Thread {
        ProgressThread() {
        }

        @Override
        public void run() {
            String fileName = BizCalcImportUI.this.txtFile.getText();
            BizCalcImportUI.this.setBtnState(false);
            BizCalcImportUI.this.btnOpenFile.setEnabled(false);
            BizCalcImportUI.this.panelProgress.setVisible(true);
            try {
                BizCalcImportUI.this.importBizCalc(fileName);
                new BgFileUtil().storeDefaultPathForIMP((Object)BizCalcImportUI.this.txtFile, (Object)BizCalcImportUI.this.getUIContext());
                BizCalcImportUI.this.getUIWindow().hide();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                BizCalcImportUI.this.handUIException(e);
            }
            finally {
                BizCalcImportUI.this.setBtnState(true);
                BizCalcImportUI.this.btnOpenFile.setEnabled(true);
                BizCalcImportUI.this.panelProgress.setVisible(false);
            }
        }
    }
}

