/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.client.AbstractBizCalcMemberMapUI;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.client.NewDimensionSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizCalcMemberMapUI
extends AbstractBizCalcMemberMapUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = 2065527750205389806L;
    private static final Logger logger = CoreUIObject.getLogger(BizCalcMemberMapUI.class);
    public static final String col_right = "right";
    public static final String col_left = "left";

    public BizCalcMemberMapUI() throws Exception {
        this.txtDescription.setText(this.txtDescription.getText().replaceAll("\\\\r\\\\n", "\r\n"));
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
    }

    public BizCalcInfo getBizCalcInfo() {
        return (BizCalcInfo)this.getUIContext().get("InitDataObject");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        BgViewHelper.removeEditHelper((KDTable)this.tblMain);
        this.loadSourceDimension();
        this.loadTargetDimension();
    }

    protected void loadTargetDimension() {
        if (StringUtils.isEmpty((String)this.getBizCalcInfo().getMemberMap())) {
            return;
        }
        Map<String, String> memberMap = this.getBizCalcInfo().getMemberMaps();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            BgDimensionBaseInfo right = ((SourceDisplayInfo)row.getCell(col_right).getValue()).getDimension();
            String rightSrc = this.getSchemeHelper().getSrcNumber(right.getNumber());
            if (!memberMap.containsKey(rightSrc)) continue;
            String leftSrc = memberMap.get(rightSrc);
            DimSettingDisplayInfo left = new DimSettingDisplayInfo((BgDimSettingsInfo)this.getSchemeHelper().getDimSettingMap().get(((BgDimensionInfo)this.getSchemeHelper().getDimensionBySrcNumber().get(leftSrc)).getNumber()));
            row.getCell(col_left).setValue((Object)left);
        }
    }

    protected void loadSourceDimension() {
        List otherDims = this.getSchemeHelper().getAccAndOtherDim(true);
        for (String dimNumber : otherDims) {
            if (DimensionConstants.DEF_CSL_NUMBER.equals(dimNumber)) continue;
            IRow row = this.tblMain.addRow();
            row.getCell(col_right).setValue((Object)new SourceDisplayInfo((BgDimensionBaseInfo)this.getSchemeHelper().getDimension(dimNumber)));
            ArrayList<String> hideDim = new ArrayList<String>();
            hideDim.add(dimNumber);
            NewDimensionSelectDialog dia = new NewDimensionSelectDialog((CoreUI)this, false, true, hideDim, null);
            dia.setBgSchemeId(this.getSchemeHelper().getBgSchemeId());
            dia.setOnlyMbgDim(Boolean.valueOf(true));
            KDBizPromptBox prmt = new KDBizPromptBox();
            prmt.setEditable(false);
            prmt.setSelector((KDPromptSelector)dia);
            row.getCell(col_left).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmt));
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        StringBuffer dimMap = new StringBuffer();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            BgDimensionBaseInfo right = ((SourceDisplayInfo)row.getCell(col_right).getValue()).getDimension();
            DimSettingDisplayInfo left = (DimSettingDisplayInfo)row.getCell(col_left).getValue();
            if (left == null) continue;
            if (dimMap.length() > 0) {
                dimMap.append(",");
            }
            dimMap.append(this.getSchemeHelper().getSrcNumber(right.getNumber())).append(":").append(this.getSchemeHelper().getSrcNumber(left.getDimSettingInfo().getDimNumber()));
        }
        if (dimMap.length() > 0) {
            this.getBizCalcInfo().setMemberMap(dimMap.toString());
        } else {
            this.getBizCalcInfo().setMemberMap(null);
        }
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

