/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizFilterTypeEnum;
import com.kingdee.eas.ma.biz.BizParameter;
import com.kingdee.eas.ma.biz.IBizCalc;
import com.kingdee.eas.ma.biz.client.AbstractBizCalcSetUI;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BizCalcSetUI
extends AbstractBizCalcSetUI {
    private static final long serialVersionUID = 3954481460788539508L;
    private static final Logger logger = CoreUIObject.getLogger(BizCalcSetUI.class);
    private final String defultText = EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"quickQueryText");
    public final String COL_ID = "id";
    public final String COL_SELECT = "selector";
    public final String COL_NUMBER = "number";
    public final String COL_NAME = "name";
    public final String COL_GROUP = "group";
    public final String COL_FORMULA = "formula";
    public final String COL_DESCRIPTION = "description";
    private Set<String> companyIds = new HashSet<String>();
    private TreeModel baseTreeModel = null;
    private Map<String, TreeModel> orgTreeMap = new HashMap<String, TreeModel>();
    private OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
    private KDPopupMenu popMenu = new KDPopupMenu();
    private LongTimeDialog dialog = null;
    private boolean isRefeshOrgUnitTree = false;
    private Map<String, Set<String>> bizRefMap = new HashMap<String, Set<String>>();

    public Set<String> getCompanyIds() {
        return this.companyIds;
    }

    public TreeModel getBaseTreeModel() {
        return this.baseTreeModel;
    }

    public void setBaseTreeModel(TreeModel baseTreeModel) {
        this.baseTreeModel = baseTreeModel;
    }

    public Map<String, TreeModel> getOrgTreeMap() {
        return this.orgTreeMap;
    }

    public OrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public CtrlUnitInfo getCtrlUnit() {
        return this.ctrlUnit;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        MbgUpdateHelper.checkUpdate();
        this.init();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setEnabled(true);
        this.btnSave.setVisible(true);
        this.menuItemSave.setEnabled(true);
        this.menuItemSave.setVisible(true);
        this.btnOrgSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnOrgClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    protected void init() throws Exception {
        this.initBgOrgTree();
        this.initBgOrgView();
        this.initOrgUnit();
        this.initBgScheme();
        this.initOther();
        this.txtSearch.setText(this.defultText);
    }

    protected void initOrgUnit() throws Exception {
        this.prmtOrgUnit.setEditable(false);
        BgCommCHelper.initOrgUnit((CoreUIObject)this, (KDBizPromptBox)this.prmtOrgUnit, (Object)this.getUnitInfo(), (String)this.getCtrlUnit().getId().toString(), (String)this.getListPermissionItem());
    }

    protected String getListPermissionItem() {
        return "mbg_BizCalcSet01_list";
    }

    protected void initBgScheme() throws Exception {
        this.prmtBgScheme.setEditable(false);
    }

    protected void initBgOrgView() throws Exception {
        this.prmtBgOrgView.setQueryInfo("com.kingdee.eas.ma.mbg.BgOrgViewQuery");
        this.prmtBgOrgView.setEditFormat("$number$");
        this.prmtBgOrgView.setDisplayFormat("$name$");
        this.prmtBgOrgView.setCommitFormat("$number$");
        this.prmtBgOrgView.setEnabledMultiSelection(false);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        this.prmtBgOrgView.setEntityViewInfo(view);
    }

    protected void initBgOrgTree() throws Exception {
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.setModel((TreeModel)new DefaultTreeModel(null));
        this.treeOrgUnit.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent e) {
                try {
                    BizCalcSetUI.this.treeOrgUnit_nodeStateChange(e);
                }
                catch (Exception ex) {
                    BizCalcSetUI.this.handUIException(ex);
                }
            }
        });
        this.iniOrgTreePoppMenu();
    }

    public void iniOrgTreePoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    BizCalcSetUI.this.popMenu.show((Component)BizCalcSetUI.this.treeOrgUnit, e.getX(), e.getY());
                }
            }
        });
        this.popMenu.add((Action)((Object)this.actionDirectChild));
        this.popMenu.add((Action)((Object)this.actionCompany));
        this.popMenu.add((Action)((Object)this.actionSchemeLeaf));
        this.popMenu.add((Action)((Object)this.actionSchemeNoLeaf));
    }

    protected void initOther() {
        this.tblMain.checkParsed();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        if (e.getNewValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"isNullOrgUnit"));
            this.prmtOrgUnit.setDataNoNotify(e.getOldValue());
        } else {
            this.setFilterBgScheme((OrgUnitInfo)e.getNewValue());
            BgNFCHelper.setDefaultBgSchemeByOrgUnit((KDBizPromptBox)this.prmtBgScheme, (OrgUnitInfo)((OrgUnitInfo)e.getNewValue()), (RptSrcTypeEnum)BgNFCHelper.getSourceType((IUIObject)this), (boolean)true);
            if (this.prmtBgScheme.getData() == null) {
                this.prmtBgOrgView.setDataNoNotify(null);
                this.treeOrgUnit.setModel(null);
                this.setBaseTreeModel(null);
                this.filterBgOrgView(null);
                this.tblMain.removeRows();
            }
        }
    }

    protected void setFilterBgScheme(OrgUnitInfo orgUnitInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (e.getNewValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"isNullBgScheme"));
            this.prmtBgScheme.setDataNoNotify(e.getOldValue());
        } else {
            BgSchemeInfo tmpScheme = (BgSchemeInfo)e.getNewValue();
            this.prmtBgScheme.setDataNoNotify((Object)this.queryBgScheme(tmpScheme.getId()));
            if (this.getSelBgScheme() != null) {
                this.filterBgOrgView(this.getSelBgScheme().getOrgViewIds());
            }
        }
    }

    protected BgSchemeInfo getSelBgScheme() {
        return (BgSchemeInfo)this.prmtBgScheme.getData();
    }

    protected BgSchemeInfo queryBgScheme(BOSUuid bgSchemeId) throws BOSException, EASBizException {
        return BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), BgSchemeUtils.getBizSelectors());
    }

    protected void filterBgOrgView(Set<String> bgOrgViewIds) throws Exception {
        BOSUuid bgOrgViewId;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bgOrgViewIds != null && !bgOrgViewIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", bgOrgViewIds, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"#", CompareType.INCLUDE));
        }
        view.setFilter(filter);
        this.prmtBgOrgView.setEntityViewInfo(view);
        if (this.getSelBgScheme() != null && (bgOrgViewId = this.getSelBgScheme().getEditOrgViewId()) != null) {
            this.prmtBgOrgView.setData((Object)this.queryBgOrgView(bgOrgViewId));
        }
    }

    protected BgOrgViewInfo queryBgOrgView(BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        return BgOrgViewFactory.getRemoteInstance().getBgOrgViewInfo((IObjectPK)new ObjectUuidPK(bgOrgViewId), BgOrgUnitUtils.getBgOrgViewSelectors());
    }

    @Override
    protected void prmtBgOrgView_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgOrgView_dataChanged(e);
        if (e.getNewValue() instanceof BgOrgViewInfo) {
            this.initBgOrgTree((BgOrgViewInfo)e.getNewValue());
            this.execQuery();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"isNullBgOrgView"));
            this.prmtBgOrgView.setDataNoNotify(e.getOldValue());
        }
    }

    protected BgOrgViewInfo getSelBgOrgView() {
        return (BgOrgViewInfo)this.prmtBgOrgView.getData();
    }

    protected void initBgOrgTree(BgOrgViewInfo bgOrgView) throws Exception {
        if (bgOrgView == null) {
            return;
        }
        String bgOrgViewId = bgOrgView.getId().toString();
        if (this.getOrgTreeMap().containsKey(bgOrgViewId)) {
            this.baseTreeModel = this.getOrgTreeMap().get(bgOrgViewId);
        } else {
            this.baseTreeModel = BgOrgUnitUtils.getOrgTreeModel((KDTree)this.treeOrgUnit, null, (String)bgOrgViewId, (boolean)true);
            this.getOrgTreeMap().put(bgOrgViewId, this.baseTreeModel);
        }
        this.treeOrgUnit.setModel(this.baseTreeModel);
        this.selectOrgNode(false, this.getRootNode(), true, this.treeOrgUnit);
    }

    protected void initBgOrgTree(String filterString) throws Exception {
        if (StringUtils.isEmpty((String)filterString)) {
            this.treeOrgUnit.setModel(this.getBaseTreeModel());
        } else {
            this.treeOrgUnit.setModel(BgOrgUnitUtils.clipAndCloneTreeModel((TreeModel)this.getBaseTreeModel(), (String[])new String[]{"number", "name"}, (String)filterString, (boolean)true));
        }
    }

    protected String getSearchText(KDTextField txt) {
        if (!this.defultText.equals(txt.getText())) {
            return txt.getText();
        }
        return null;
    }

    protected void filterOrgTree() throws Exception {
        String filterString = this.getSearchText(this.txtSearch);
        if (this.getSelBgOrgView() == null) {
            return;
        }
        DefaultKingdeeTreeNode node = this.getRootNode();
        this.refeshOrgUnitTree(node);
        this.initBgOrgTree(filterString);
    }

    protected DefaultKingdeeTreeNode getSelectOrgUnitNode() {
        if (this.treeOrgUnit.getSelectionPath() != null) {
            return (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    protected DefaultKingdeeTreeNode getRootNode() {
        if (this.treeOrgUnit.getModel() != null) {
            return (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        }
        return null;
    }

    protected DefaultKingdeeTreeNode getCurrOrgUnitNode() {
        DefaultKingdeeTreeNode node = this.getRootNode();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            node = this.getSelectOrgUnitNode();
        }
        return node;
    }

    public LongTimeDialog getLTDialog() {
        return this.dialog;
    }

    public void setLTDialog(LongTimeDialog dialog) {
        this.dialog = dialog;
    }

    public void setRefeshOrgUnitTree(boolean isRefeshOrgUnitTree) {
        this.isRefeshOrgUnitTree = isRefeshOrgUnitTree;
    }

    public boolean isRefeshOrgUnitTree() {
        return this.isRefeshOrgUnitTree;
    }

    public void refeshOrgUnitTree() throws Exception {
        if (!this.isRefeshOrgUnitTree()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.refeshOrgUnitTree(root);
            this.setRefeshOrgUnitTree(true);
        }
    }

    private void refeshOrgUnitTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() == 1) {
            try {
                BgOrgUnitUtils.addChildNode((DefaultKingdeeTreeNode)root, (String)this.getSelBgOrgView().getId().toString(), (boolean)false);
            }
            catch (Exception ex) {
                logger.error((Object)"OrgUnitUtils.addChildNode Error:", (Throwable)ex);
                this.handUIException(ex);
            }
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.refeshOrgUnitTree(node);
        }
    }

    @Override
    public void actionSelectAllOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAllOrg_actionPerformed(e);
        DefaultKingdeeTreeNode node = this.getRootNode();
        this.refeshOrgUnitTree(node);
        this.selectOrgNode(true, node, true, this.treeOrgUnit);
        this.executeQuery();
    }

    @Override
    public void actionClearAllOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAllOrg_actionPerformed(e);
        DefaultKingdeeTreeNode node = this.getRootNode();
        this.selectOrgNode(false, node, true, this.treeOrgUnit);
        this.executeQuery();
    }

    @Override
    public void actionDirectChild_actionPerformed(ActionEvent e) throws Exception {
        super.actionDirectChild_actionPerformed(e);
        DefaultKingdeeTreeNode node = this.getCurrOrgUnitNode();
        this.refeshOrgUnitTree(node);
        BgOrgUnitUtils.selectDirectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
        this.executeQuery();
    }

    @Override
    public void actionCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionCompany_actionPerformed(e);
        DefaultKingdeeTreeNode node = this.getCurrOrgUnitNode();
        this.refeshOrgUnitTree(node);
        if (this.getCompanyIds().isEmpty()) {
            this.getCompanyIds().addAll(BgBaseFacadeFactory.getRemoteInstance().getCompanyIds());
        }
        BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)node, this.getCompanyIds());
        this.executeQuery();
    }

    @Override
    public void actionSchemeLeaf_actionPerformed(ActionEvent e) throws Exception {
        super.actionSchemeLeaf_actionPerformed(e);
        DefaultKingdeeTreeNode node = this.getRootNode();
        this.refeshOrgUnitTree(node);
        this.selectOrgNode(false, node, true, this.treeOrgUnit);
        this.selectBgSchemeOrg(true);
        this.executeQuery();
    }

    @Override
    public void actionSchemeNoLeaf_actionPerformed(ActionEvent e) throws Exception {
        super.actionSchemeNoLeaf_actionPerformed(e);
        DefaultKingdeeTreeNode node = this.getRootNode();
        this.refeshOrgUnitTree(node);
        this.selectOrgNode(false, node, true, this.treeOrgUnit);
        this.selectBgSchemeOrg(false);
        this.executeQuery();
    }

    protected void selectBgSchemeOrg(boolean isLeaf) throws Exception {
        if (this.getSelBgOrgView() == null) {
            return;
        }
        Set orgIds = BgSchemeFactory.getRemoteInstance().getRefOrgUnit(this.getSelBgOrgView().getId(), isLeaf);
        this.selectOrgNode(this.treeOrgUnit, orgIds);
    }

    protected Set<String> getSelOrgIds() {
        HashSet<String> selOrgUnitIds = new HashSet<String>();
        DefaultKingdeeTreeNode node = null;
        BgOrgUnitInfo bgOrgUnit = null;
        DefaultKingdeeTreeNode root = this.getRootNode();
        if (root.isChecked() && root.getUserObject() instanceof BgOrgUnitInfo && (bgOrgUnit = (BgOrgUnitInfo)root.getUserObject()) != null) {
            selOrgUnitIds.add(bgOrgUnit.getOrgUnitID());
        }
        Enumeration _enum = root.depthFirstEnumeration();
        while (_enum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)_enum.nextElement();
            if (!node.isChecked() || !(node.getUserObject() instanceof BgOrgUnitInfo) || (bgOrgUnit = (BgOrgUnitInfo)node.getUserObject()) == null) continue;
            selOrgUnitIds.add(bgOrgUnit.getOrgUnitID());
        }
        return selOrgUnitIds;
    }

    protected void selectOrgNode(boolean selected, DefaultKingdeeTreeNode root, boolean isIncludeChildren, KDTree treeOrgUnit) throws Exception {
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)selected, (DefaultKingdeeTreeNode)root, (boolean)isIncludeChildren, (KDTree)treeOrgUnit);
    }

    protected void selectOrgNode(KDTree kdTree, Set<String> selOrgUnitIds) throws Exception {
        BgOrgUnitUtils.selectOrgUnit((KDTree)kdTree, selOrgUnitIds);
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
    }

    protected void treeOrgUnit_nodeStateChange(TreeNodeStateChangeEvent e) throws Exception {
        this.executeQuery();
    }

    @Override
    protected void radioUnRelate_actionPerformed(ActionEvent e) throws Exception {
        super.radioUnRelate_actionPerformed(e);
        this.radioClick(e);
    }

    @Override
    protected void radioRelate_actionPerformed(ActionEvent e) throws Exception {
        super.radioRelate_actionPerformed(e);
        this.radioClick(e);
    }

    @Override
    protected void radioAll_actionPerformed(ActionEvent e) throws Exception {
        super.radioAll_actionPerformed(e);
        this.radioClick(e);
    }

    protected void radioClick(ActionEvent e) throws Exception {
        this.executeQuery();
    }

    @Override
    protected void comSerachType_actionPerformed(ActionEvent e) throws Exception {
        super.comSerachType_actionPerformed(e);
    }

    @Override
    protected void comSerachType_itemStateChanged(ItemEvent e) throws Exception {
        super.comSerachType_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            BizFilterTypeEnum type = (BizFilterTypeEnum)((Object)e.getItem());
            if (1 == type.getValue()) {
                this.executeQuery();
            } else if (0 == type.getValue()) {
                this.initBgOrgTree("");
            }
        }
    }

    @Override
    protected void txtSearch_actionPerformed(ActionEvent e) throws Exception {
        super.txtSearch_actionPerformed(e);
    }

    @Override
    protected void txtSearch_keyReleased(KeyEvent e) throws Exception {
        super.txtSearch_keyReleased(e);
        if (10 == e.getKeyCode()) {
            // empty if block
        }
    }

    @Override
    protected void txtSearch_focusGained(FocusEvent e) throws Exception {
        super.txtSearch_focusGained(e);
        if (this.defultText.equals(this.txtSearch.getText())) {
            this.txtSearch.setText(null);
        }
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        BizFilterTypeEnum type;
        super.txtSearch_focusLost(e);
        String filterString = this.getSearchText(this.txtSearch);
        if (StringUtils.isEmpty((String)filterString)) {
            this.txtSearch.setText(this.defultText);
        }
        if (1 == (type = (BizFilterTypeEnum)((Object)this.comSerachType.getSelectedItem())).getValue()) {
            this.filterOrgTree();
        } else if (0 == type.getValue()) {
            this.executeQuery();
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectAllRows(true);
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        this.selectAllRows(false);
    }

    protected void selectAllRows(boolean isSelect) {
        int rowCount = this.tblMain.getRowCount();
        for (int index = 0; index < rowCount; ++index) {
            this.tblMain.getRow(index).getCell("selector").setValue((Object)isSelect);
        }
    }

    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectAllRows(true);
    }

    protected void btnClearClear_actionPerformed(ActionEvent e) throws Exception {
        this.selectAllRows(false);
    }

    protected void executeQuery() throws Exception {
        this.tblMain.removeRows();
        BgSchemeInfo bgScheme = this.getSelBgScheme();
        BgOrgViewInfo bgOrgView = this.getSelBgOrgView();
        if (bgScheme == null || bgOrgView == null) {
            return;
        }
        this.fillData(this.getParameter());
    }

    public BizCalcCollection getBizCalcCollection() {
        BizCalcCollection bizCalcCollection = new BizCalcCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgSchemeId", (Object)this.getSelBgScheme().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(BizParameter.getSelectors());
        view.getSorter().add(new SorterItemInfo("number"));
        try {
            bizCalcCollection = BizCalcFactory.getRemoteInstance().getBizCalcCollection(view);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return bizCalcCollection;
    }

    protected boolean checkSave() throws EASBizException, BOSException {
        this.tblMain.getEditManager().editingStopped();
        boolean isModify = false;
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            ICell select = this.tblMain.getCell(r, "selector");
            if (select.getUserObject().equals(select.getValue())) continue;
            isModify = true;
            break;
        }
        if (isModify) {
            int re = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"Confirm_Save"));
            if (re == 0) {
                this.runSave();
                return true;
            }
            if (re == 1) {
                return true;
            }
            if (re == 2) {
                return false;
            }
        }
        return true;
    }

    protected BizParameter getParameter() {
        BizParameter parameter = new BizParameter();
        parameter.setSchemeId(this.getSelBgScheme().getId().toString());
        parameter.getSelOrgUnitIds().addAll(this.getSelOrgIds());
        parameter.setSelectType(this.getSelectType());
        parameter.setFilterType(this.getFilterType());
        parameter.setFilterString(this.getSearchText(this.txtSearch));
        IRow row = null;
        Boolean oldSel = false;
        Boolean nowSel = false;
        String bizId = null;
        int rowCount = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.tblMain.getRow(rowIndex);
            bizId = (String)row.getCell("id").getValue();
            oldSel = (Boolean)row.getCell("selector").getUserObject();
            if (oldSel.compareTo(nowSel = (Boolean)row.getCell("selector").getValue()) == 0) continue;
            if (oldSel.booleanValue()) {
                parameter.getUnSelBizIds().add(bizId);
                continue;
            }
            parameter.getSelBizIds().add(bizId);
        }
        return parameter;
    }

    protected int getSelectType() {
        if (this.radioUnRelate.isSelected()) {
            return 0;
        }
        if (this.radioRelate.isSelected()) {
            return 1;
        }
        if (this.radioAll.isSelected()) {
            return 2;
        }
        return -1;
    }

    protected int getFilterType() {
        BizFilterTypeEnum type = (BizFilterTypeEnum)((Object)this.comSerachType.getSelectedItem());
        return type.getValue();
    }

    public Map<String, Set<String>> getBizRefMap() {
        return this.bizRefMap;
    }

    protected void fillData(BizParameter parameter) throws Exception {
        BizCalcCollection colls;
        this.tblMain.checkParsed();
        this.tblMain.setEnabled(true);
        this.tblMain.setEditable(true);
        this.getBizRefMap().clear();
        if (parameter == null || parameter.getSelOrgUnitIds().isEmpty()) {
            return;
        }
        Map tmpMap = this.getBizInterface().getRuleIds(parameter);
        if (tmpMap != null) {
            this.getBizRefMap().putAll(tmpMap);
        }
        if ((colls = this.getBizCalcCollection()) == null || colls.isEmpty()) {
            return;
        }
        this.formateTableColumn();
        Set<String> refBizIds = this.getRefBizIds(parameter);
        BizCalcInfo bizCalc = null;
        IRow row = null;
        int rowSize = 0;
        int size = colls.size();
        for (int index = 0; index < size; ++index) {
            bizCalc = colls.get(index);
            if (!this.isShow(bizCalc, refBizIds, parameter)) continue;
            row = this.tblMain.addRow();
            row.setUserObject((Object)bizCalc);
            row.getCell("id").setValue((Object)bizCalc.getId().toString());
            row.getCell("selector").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)bizCalc.getNumber());
            row.getCell("name").setValue((Object)bizCalc.getName());
            row.getCell("description").setValue((Object)bizCalc.getDescription());
            if (parameter.getSelectType() == 2 || parameter.getSelectType() == 1) {
                if (refBizIds.contains(bizCalc.getId().toString())) {
                    row.getCell("selector").setValue((Object)Boolean.TRUE);
                    row.getCell("selector").setUserObject((Object)Boolean.TRUE);
                } else {
                    row.getCell("selector").setUserObject((Object)Boolean.FALSE);
                }
            } else {
                row.getCell("selector").setUserObject((Object)Boolean.FALSE);
            }
            ++rowSize;
        }
        this.tblMain.setRowCount(rowSize);
        this.tblMain.reLayoutAndPaint();
    }

    protected void formateTableColumn() {
        KDCheckBox box = new KDCheckBox();
        KDTDefaultCellEditor edit = new KDTDefaultCellEditor((JCheckBox)box);
        this.tblMain.getColumn("selector").setEditor((ICellEditor)edit);
        this.tblMain.getColumn("selector").getStyleAttributes().setLocked(false);
    }

    protected Set<String> getRefBizIds(BizParameter parameter) {
        HashSet<String> bizIds = new HashSet<String>();
        HashSet<String> refBizIds = new HashSet<String>();
        Set<String> tmpSet = null;
        Set<String> allIds = this.getBizRefMap().get(BgBaseConstants.ORGUNIT_ID);
        refBizIds.addAll(allIds);
        for (String orgUnitId : parameter.getSelOrgUnitIds()) {
            if (this.getBizRefMap().containsKey(orgUnitId)) {
                tmpSet = this.getBizRefMap().get(orgUnitId);
                refBizIds.retainAll(tmpSet);
                continue;
            }
            refBizIds.clear();
            break;
        }
        if (parameter.getSelectType() == 0) {
            bizIds.addAll(allIds);
            bizIds.removeAll(refBizIds);
        } else {
            bizIds.addAll(refBizIds);
        }
        return bizIds;
    }

    protected boolean isShow(BizCalcInfo bizCalc, Set<String> bizID, BizParameter parameter) {
        if (bizCalc == null || bizID == null || parameter == null) {
            return false;
        }
        boolean re = true;
        if (!(parameter.getFilterType() != 0 || StringUtils.isEmpty((String)parameter.getFilterString()) || this.isLike(bizCalc.getName(), parameter.getFilterString()) || this.isLike(bizCalc.getNumber(), parameter.getFilterString()))) {
            re = false;
        }
        if (re && parameter.getSelectType() != 2 && !bizID.contains(bizCalc.getId().toString())) {
            re = false;
        }
        return re;
    }

    private boolean isLike(String str1, String str2) {
        if (StringUtils.isEmpty((String)str1) || StringUtils.isEmpty((String)str2)) {
            return false;
        }
        return str1.indexOf(str2) >= 0;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.executeQuery();
    }

    @Override
    public void actionSaveRelation_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelBgScheme() == null || this.getSelBgScheme().isIsFiling()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"isNullOrFiling"));
            SysUtil.abort();
        }
        if (this.getSelBgOrgView() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BizConstants.BIZ_RESOURCE, (String)"isNullBgOrgView"));
            SysUtil.abort();
        }
        this.runSave();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.setNextMessageText("");
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
        this.executeQuery();
    }

    protected void runSave() throws BOSException, EASBizException {
        BizParameter parameter = this.getParameter();
        if (parameter != null && !parameter.getSelOrgUnitIds().isEmpty()) {
            this.getBizInterface().saveRuleDispRelation(parameter);
        }
    }

    public KDTreeNode getSelectedTreeNode() {
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() > 1) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected IBizCalc getBizInterface() throws BOSException {
        return BizCalcFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getUnitInfo().getId().toString());
        }
        return handler;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BizCalcSetUI.this.popMenu.show((Component)BizCalcSetUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

