/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.client.AbstractBizPtoMembersUI;
import com.kingdee.eas.ma.biz.client.BizCalcDimensionMemberSelectDialog;
import com.kingdee.eas.ma.biz.client.BizCalcMembersUI;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgPeriodFunctionDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BizPtoMembersUI
extends AbstractBizPtoMembersUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BizPtoMembersUI.class);
    public static final String PERIOD_BEGIN = BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"begin_period");
    public static final String PERIOD_END = BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"end_period");

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected List<BgDimensionInfo> getPtoAllDimensions(List<BgDimensionInfo> allDimension) {
        ArrayList<BgDimensionInfo> dimensions = new ArrayList<BgDimensionInfo>();
        BgDimensionInfo dim = null;
        BgDimensionInfo beginPeriodDim = null;
        BgDimensionInfo endPeriodDim = null;
        for (int i = 0; i < allDimension.size(); ++i) {
            dim = allDimension.get(i);
            if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                beginPeriodDim = dim.clone();
                beginPeriodDim.setNumber("BG_Period1");
                beginPeriodDim.setName(PERIOD_BEGIN);
                dimensions.add(beginPeriodDim);
                endPeriodDim = dim.clone();
                endPeriodDim.setNumber("BG_Period2");
                endPeriodDim.setName(PERIOD_END);
                dimensions.add(endPeriodDim);
                continue;
            }
            dimensions.add(dim);
        }
        return dimensions;
    }

    @Override
    protected void initPanel() throws Exception {
        List<BgDimensionInfo> allDimension = (List<BgDimensionInfo>)this.getUIContext().get("allDimensions");
        allDimension = this.getPtoAllDimensions(allDimension);
        Map memberMap = (Map)this.getUIContext().get("memberMap");
        if (allDimension != null) {
            int x = 0;
            int y = 10;
            int width = 348;
            int height = 19;
            int yCompGap = 15;
            int xCompGap = 20;
            int yindex = 0;
            int totalHeight = 0;
            boolean isShowOrg = this.getSchemeHelper() == null || !this.getSchemeHelper().isBgCsl();
            int skip = isShowOrg ? 0 : -1;
            int i = 0;
            while (i < allDimension.size()) {
                BgDimensionInfo dim = allDimension.get(i);
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + dim.getNumber());
                container.setBoundLabelText(dim.getName());
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + (yindex + skip) * (height + yCompGap), width, height));
                this.pnlMain.add((Component)container, null);
                totalHeight += height + yCompGap;
                Object dialog = null;
                if (dim.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dim.getNumber().equals("BG_Period1") || dim.getNumber().equals("BG_Period2")) {
                    dialog = new BgPeriodFunctionDialog((CoreUIObject)this, false, false);
                    dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
                    dialog.setOrgId((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    dialog.setDimension((Object)this.getSchemeHelper().getDimension(DimensionConstants.DEF_PERIOD_NUMBER));
                    dialog.setCanSelectUserPeriod(true);
                    Set numSet = BizFacadeFactory.getRemoteInstance().queryPeriodType(this.getSchemeHelper().getBgSchemeId());
                    dialog.setBgPeriodTypeNumbers(numSet);
                    dialog.setNeedFunctionType(false);
                } else {
                    dialog = new BizCalcDimensionMemberSelectDialog((Component)((Object)this), this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dim.getNumber()), (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID));
                    ((BizCalcDimensionMemberSelectDialog)((Object)dialog)).setShowOusealup(false);
                    ((BizCalcDimensionMemberSelectDialog)((Object)dialog)).setMulti(false);
                    if (this.getUIContext().get("isHiddenPartCsldim") instanceof Boolean) {
                        ((BizCalcDimensionMemberSelectDialog)((Object)dialog)).setHiddenCslPartDim((Boolean)this.getUIContext().get("isHiddenPartCsldim"));
                    }
                }
                KDBizPromptBox prmt = new KDBizPromptBox();
                prmt.setUserObject((Object)dim);
                prmt.setName("prmt" + dim.getNumber());
                prmt.setSelector((KDPromptSelector)dialog);
                container.setBoundEditor((JComponent)prmt);
                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                    prmt.addDataChangeListener(new DataChangeListener(){

                        public void dataChanged(DataChangeEvent eventObj) {
                            BgDimensionMember orgMember = (BgDimensionMember)eventObj.getNewValue();
                            if (orgMember != null) {
                                BizPtoMembersUI.this.resetDimDialog(orgMember.getNumber());
                            }
                        }
                    });
                }
                prmt.setEditFormatter((IFormatter)new BizCalcMembersUI.CalcMemDispFormatter());
                prmt.setDisplayFormatter((IFormatter)new BizCalcMembersUI.CalcMemDispFormatter());
                if (memberMap != null && memberMap.containsKey(dim.getNumber())) {
                    prmt.setData(memberMap.get(dim.getNumber()));
                }
                this.getCompList().add(prmt);
                ++i;
                ++yindex;
            }
            if (this.isNeedProcessType()) {
                KDLabelContainer container = new KDLabelContainer();
                container.setName("cont" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundLabelText(BgProcessHelper.DEF_PROCESS_NAME);
                container.setBoundLabelLength(100);
                container.setBoundLabelUnderline(true);
                container.setBounds(new Rectangle(x, y + (yindex + skip) * (height + yCompGap), width, height));
                this.pnlMain.add((Component)container);
                totalHeight += height + yCompGap;
                KDBizPromptBox prmtBgProcess = BgExamineHelper.getBgProcessPrmBox((CoreUI)this, (boolean)false);
                prmtBgProcess.setName("prmt" + BgProcessHelper.DEF_PROCESS_NUMBER);
                container.setBoundEditor((JComponent)prmtBgProcess);
                if (memberMap != null && memberMap.containsKey(BgProcessHelper.DEF_PROCESS_NUMBER)) {
                    if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof BgDimensionMember) {
                        prmtBgProcess.setData((Object)BgProcessHelper.memberToEnum((BgDimensionMember)((BgDimensionMember)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER))));
                    } else if (memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER) instanceof Set) {
                        prmtBgProcess.setData(BgProcessHelper.membersToEnums((Set)((Set)memberMap.get(BgProcessHelper.DEF_PROCESS_NUMBER))));
                    }
                }
                this.getCompList().add(prmtBgProcess);
            }
            if ((double)(totalHeight += yCompGap) > this.spMain.getPreferredSize().getHeight() - (double)yCompGap) {
                int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 150;
                if (maxHeight > 700) {
                    maxHeight = 700;
                }
                int initHeight = this.spMain.getHeight();
                this.pnlMain.setPreferredSize(new Dimension(width, totalHeight + yCompGap));
                Dimension bounds = this.getPreferredSize();
                if (totalHeight > maxHeight - yCompGap) {
                    bounds.height = bounds.height + maxHeight - initHeight;
                    this.setPreferredSize(new Dimension(bounds.width, bounds.height));
                    this.spMain.setVerticalScrollBarPolicy(22);
                } else {
                    bounds.height = (int)((double)bounds.height + this.pnlMain.getPreferredSize().getHeight() - (double)initHeight);
                    this.setPreferredSize(new Dimension(bounds.width, bounds.height));
                    this.spMain.setVerticalScrollBarPolicy(21);
                }
            }
        }
    }

    @Override
    protected String generateFormula() {
        int memberSize = 0;
        StringBuffer forStr = new StringBuffer();
        String beginPeriodStr = "";
        String endPeriodStr = "";
        forStr.append("PTO").append(":").append("[");
        for (KDBizPromptBox prmt : this.getCompList()) {
            BgDimensionMember dim = null;
            if (prmt.getData() != null) {
                if (prmt.getData() instanceof BgDimensionMember) {
                    dim = (BgDimensionMember)prmt.getData();
                } else if (prmt.getData() instanceof BgPeriodInfo) {
                    BgPeriodInfo p = (BgPeriodInfo)prmt.getData();
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, p.getName(), p.getNumber());
                    dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                } else if (prmt.getData() instanceof List) {
                    List periodVar = (List)prmt.getData();
                    if (!periodVar.isEmpty()) {
                        dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, (String)periodVar.get(0), (String)periodVar.get(0));
                        dim.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                    }
                } else if (prmt.getData() instanceof StringBuffer) {
                    dim = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, prmt.getData().toString(), prmt.getData().toString());
                } else if (prmt.getData() instanceof BgProcessEnum) {
                    BgProcessEnum bEnum = (BgProcessEnum)prmt.getData();
                    dim = BgProcessHelper.getMember((String)bEnum.getName());
                }
            }
            if (dim == null) continue;
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR);
            if (dim.getSrcNumber() != null) {
                if (dim.getSrcNumber().equals(DimensionConstants.DEF_PERIOD_SRCNUMBER) || dim.getSrcNumber().equals("BgP1") || dim.getSrcNumber().equals("BgP2")) {
                    Object userObject = prmt.getUserObject();
                    if (userObject instanceof BgDimensionInfo && ((BgDimensionInfo)userObject).getName().equals(PERIOD_BEGIN)) {
                        forStr.append("BgP1").append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                        beginPeriodStr = dim.getNumber();
                    } else if (userObject instanceof BgDimensionInfo && ((BgDimensionInfo)userObject).getName().equals(PERIOD_END)) {
                        forStr.append("BgP2").append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                        endPeriodStr = dim.getNumber();
                    } else {
                        forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                    }
                } else {
                    forStr.append(dim.getSrcNumber()).append(BgBaseConstants.SEP_FOUR_STR).append(dim.getNumber());
                }
            } else {
                forStr.append(dim.getNumber());
            }
            forStr.append(BgBaseConstants.DOUBLE_QUOTATION_STR).append(BgBaseConstants.SEP_THR_STR);
            ++memberSize;
        }
        if (this.getCompList().size() > 0) {
            forStr.delete(forStr.length() - 1, forStr.length()).append("]");
        }
        if (memberSize == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizAtLeastOneDim"));
            SysUtil.abort();
        }
        if (!BizPtoUtils.checkBeginAndEndPeriodType(beginPeriodStr, endPeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"periodTypeNotEqual"));
            SysUtil.abort();
        }
        if (!BizPtoUtils.checkBeginPeriodBeforeEndPeriod(beginPeriodStr, endPeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"periodCompare"));
            SysUtil.abort();
        }
        return forStr.toString();
    }
}

