/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.FormulaPicker;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.client.BizCalcMembersUI;
import com.kingdee.eas.ma.biz.client.BizPtoMembersUI;
import com.kingdee.eas.ma.biz.client.IBizKDPaneTools;
import com.kingdee.eas.ma.biz.client.utils.BizCalcClientHelper;
import com.kingdee.eas.ma.biz.client.utils.BizCalcUtils;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionProcess;
import com.kingdee.eas.ma.mbg.client.FunctionSelectF7UI;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.apache.log4j.Logger;

public class BizTextPaneDoubleClick
implements IBizKDPaneTools {
    private static final Logger logger = CoreUIObject.getLogger(BizTextPaneDoubleClick.class);

    @Override
    public void doubleClick(KDTextPane JTP, UIContext ctx) {
        JTP.addMouseListener((MouseListener)new BizMouseAdapter(ctx));
    }

    public void doubleClick(UIContext uiContext, KDTextPane txtPane) {
        if (uiContext == null || txtPane == null) {
            return;
        }
        String txt = "";
        Caret caret = null;
        int caretMark = 0;
        int caretDot = 0;
        try {
            txt = txtPane.getDocument().getText(0, txtPane.getDocument().getLength());
            caret = txtPane.getCaret();
            caretMark = caret.getMark();
            caretDot = caret.getDot();
            if (caretMark > caretDot) {
                caretMark = caret.getDot();
                caretDot = caret.getMark();
            }
        }
        catch (BadLocationException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        String formulaName = null;
        String formulaUIName = null;
        String formula = null;
        UIContext ctx = new UIContext();
        ctx.put((Object)"Owner", uiContext.get((Object)"Owner"));
        StringBuffer functionStr = new StringBuffer();
        Map<String, Object> memberMap = null;
        if (!StringUtils.isEmpty((String)txt)) {
            formulaName = BizCalcClientHelper.parseFormulName(txt, caretMark, caretDot);
        }
        if (!StringUtils.isEmpty(formulaName)) {
            formula = BizCalcClientHelper.parseFormula(txt, caretMark, formulaName, txtPane);
        }
        if (!StringUtils.isEmpty(formula)) {
            formulaUIName = BizCalcClientHelper.getFormulaUIName(formulaName, formula);
        }
        if (formulaName != null && formula != null) {
            if (BizCalcUtils.NULL_VAR.equals(formula)) {
                return;
            }
            if (formulaName.equals("MBR") || formulaName.equals("LEAF_MBR") || formulaName.equals("NLEAF_MBR")) {
                memberMap = BizCalcClientHelper.parseMBRMember(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula, null);
                ctx.put((Object)"ID", null);
                ctx.put((Object)"bgScheme", uiContext.get((Object)"bgScheme"));
                ctx.put((Object)BgBaseConstants.ORGUNIT_ID, uiContext.get((Object)BgBaseConstants.ORGUNIT_ID));
                ctx.put((Object)"BGSCHEME_HELPER", (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper());
                ctx.put((Object)"allDimensions", (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper().getAllDimensions());
                ctx.put((Object)"memberMap", memberMap);
                ctx.put((Object)"formulaName", (Object)formulaName);
                ctx.put((Object)"isHiddenPartCsldim", (Object)true);
            } else if (formulaName.equals("PTO")) {
                memberMap = BizCalcClientHelper.parsePTOMember(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula, null);
                ctx.put((Object)"ID", null);
                ctx.put((Object)"bgScheme", uiContext.get((Object)"bgScheme"));
                ctx.put((Object)BgBaseConstants.ORGUNIT_ID, uiContext.get((Object)BgBaseConstants.ORGUNIT_ID));
                ctx.put((Object)"BGSCHEME_HELPER", (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper());
                ctx.put((Object)"allDimensions", (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper().getAllDimensions());
                ctx.put((Object)"memberMap", memberMap);
                ctx.put((Object)"formulaName", (Object)formulaName);
                ctx.put((Object)"isHiddenPartCsldim", (Object)true);
            } else if (formulaName.equals("FX")) {
                Object data = null;
                if (BizCalcCommonHelper.getBoolFn().contains(BizCalcCommonHelper.getFunctionName(formula))) {
                    data = formula.indexOf("@IsMember") != -1 ? (org.apache.commons.lang.StringUtils.countMatches((String)formula, (String)"@") > 1 ? BizCalcClientHelper.parseMemFXInMathFX(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula) : BizCalcClientHelper.parseAllFXMember(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula)) : BizCalcClientHelper.parseFXMember(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula);
                } else if (BizCalcCommonHelper.getMathFn().contains(BizCalcCommonHelper.getFunctionName(formula))) {
                    data = BizCalcCommonHelper.getFunctionName(formula).equals("@ABS") ? formula.split("\\(")[1].split("\\)")[0].trim() : (org.apache.commons.lang.StringUtils.countMatches((String)formula, (String)"@") > 1 ? BizCalcClientHelper.parseMemFXInMathFX(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula) : BizCalcClientHelper.parseAllFXMember(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula));
                }
                ctx.put((Object)"ID", null);
                ctx.put((Object)BgBaseConstants.ORGUNIT_ID, uiContext.get((Object)BgBaseConstants.ORGUNIT_ID));
                ctx.put((Object)DimensionConstants.DIMENSION, (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper().getAllDimensions());
                ctx.put((Object)BgBaseConstants.BGSCHEME_ID, (Object)((BgSchemeInfo)uiContext.get((Object)"bgScheme")).getId().toString());
                ctx.put((Object)"functionStr", (Object)functionStr);
                ctx.put((Object)"member", data);
            } else if (formulaName.equals("VAR")) {
                BgDimensionMember member = BizCalcClientHelper.parseVARMember(((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper(), formulaName, formula);
                ctx.put((Object)BgBaseConstants.ORGUNIT_ID, uiContext.get((Object)BgBaseConstants.ORGUNIT_ID));
                ctx.put((Object)"BGSCHEME_ID", (Object)((BgSchemeInfo)uiContext.get((Object)"bgScheme")).getId().toString());
                ctx.put((Object)"BGSCHEME_HELPER", (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper());
                ctx.put((Object)"canSelectAllDim", (Object)true);
                ctx.put((Object)"SelectType", (Object)BgMemberSelectTypeEnum.Variate);
                ctx.put((Object)"canSelectType", (Object)false);
                ArrayList<BgDimensionMember> memList = new ArrayList<BgDimensionMember>();
                if (member != null) {
                    ctx.put((Object)"selectDim", (Object)((BizCalcMainUI)((Object)uiContext.get((Object)"Owner"))).getSchemeHelper().getDimension(member.getType()));
                    ctx.put((Object)"member", (Object)member);
                    memList.add(member);
                }
                MbgViewListResultData data = new MbgViewListResultData();
                data.setMembers(memList);
                data.setMemberType(BgMemberSelectTypeEnum.Variate);
                ctx.put((Object)"backfillMember", (Object)data);
            } else if (formulaName.equals("GVF") || formulaName.equals("DESC")) {
                // empty if block
            }
            String newFormula = null;
            if (formulaName.equals("FX")) {
                try {
                    String fnName = BizCalcCommonHelper.getFunctionName(formula);
                    MbgFunctionProcess openFun = new MbgFunctionProcess(fnName, null, ctx);
                    openFun.process();
                    if (!StringUtils.isEmpty((String)functionStr.toString())) {
                        newFormula = "FX:[" + functionStr.toString() + "]";
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)txtPane, (Throwable)exc);
                }
            } else if (formulaName.equals("GVF")) {
                try {
                    StringBuffer acctFormula = new StringBuffer(formula != null ? formula.substring(5, formula.length() - 1) : "");
                    FormulaPicker picker = new FormulaPicker((Component)txtPane);
                    RptContextManager rptContext = new RptContextManager();
                    rptContext.setReportInfo((VirtualSheetParamInfo)this.createRptInfo());
                    picker.setRptContextManager(rptContext);
                    rptContext.setPropertyAdapter(new IReportPropertyAdapter(){

                        public void initReportProperties(IObjectValue vo, Context ctx) {
                        }

                        public Object getReportProperty(String name) {
                            return null;
                        }
                    });
                    picker.setFormulaFilter("include:formulas{Acct,AcctItem}");
                    picker.setFormulaPickListener((FormulaPickListener)new FormulaListen(acctFormula));
                    picker.show();
                    if (!StringUtils.isEmpty((String)acctFormula.toString())) {
                        newFormula = "GVF:[" + acctFormula.toString() + "]";
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)txtPane, (Throwable)exc);
                }
            } else {
                try {
                    IUIWindow window = UIFactory.createUIFactory().create(formulaUIName, (Map)ctx, null, OprtState.EDIT);
                    window.show();
                    if (formulaName.equals("MBR") || formulaName.equals("LEAF_MBR") || formulaName.equals("NLEAF_MBR")) {
                        newFormula = ((BizCalcMembersUI)window.getUIObject()).getFormula();
                    } else if (formulaName.equals("VAR")) {
                        newFormula = ((FunctionSelectF7UI)window.getUIObject()).getFormula();
                    } else if (formulaName.equals("PTO")) {
                        newFormula = ((BizPtoMembersUI)window.getUIObject()).getFormula();
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)txtPane, (Throwable)exc);
                }
            }
            if (newFormula != null && !newFormula.equals(formula)) {
                int startIndex = txtPane.getSelectionStart();
                int endIndex = txtPane.getSelectionEnd();
                try {
                    txtPane.getDocument().remove(startIndex, formula.length());
                    txtPane.getDocument().insertString(startIndex, newFormula, null);
                }
                catch (BadLocationException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                txtPane.getCaret().setDot(startIndex + newFormula.length());
            } else {
                txtPane.getCaret().setDot(txtPane.getSelectionEnd());
            }
        }
    }

    public ReportBaseInfo createRptInfo() {
        ReportBaseInfo cslInfo = new ReportBaseInfo();
        return cslInfo;
    }

    private class FormulaListen
    implements FormulaPickListener {
        StringBuffer formula = null;

        public FormulaListen(StringBuffer formula) {
            this.formula = formula;
        }

        public void setFormulaLine(String line) {
            this.formula.delete(0, this.formula.length());
            this.formula.append(line);
        }

        public String pickFormulaLine() {
            return this.formula.toString();
        }
    }

    protected class BizMouseAdapter
    extends MouseAdapter {
        private UIContext uiContext;

        public BizMouseAdapter(UIContext ctx) {
            this.uiContext = ctx;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 2) {
                BizTextPaneDoubleClick.this.doubleClick(this.uiContext, (KDTextPane)e.getSource());
            }
        }
    }
}

