/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client.utils;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcGroupInfo;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetCollection;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizRefBgTemplateCollection;
import com.kingdee.eas.ma.biz.BizRefBgTemplateFactory;
import com.kingdee.eas.ma.biz.BizRefBgTemplateInfo;
import com.kingdee.eas.ma.biz.BizRelyCollection;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.BizRelyInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.BizStateEnum;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BizCalcExportHelper {
    public static final String ENCODING = "UTF-8";
    private static final String DOCUMENT_BIZCALC = "BizCalc";
    private static final String DOCUMENT_NUMBER = "number";
    private static final String DOCUMENT_NAME = "name";
    private static final String DOCUMENT_DESCRIPTION = "description";
    private static final String DOCUMENT_MEMBERMAP = "memberMap";
    private static final String DOCUMENT_ISBGEXE = "isBGExe";
    private static final String DOCUMENT_BIZCALCSUBSET = "bizCalcSubset";
    private static final String DOCUMENT_SEQ = "seq";
    private static final String DOCUMENT_FORMULA = "formula";
    private static final String DOCUMENT_SCOPE = "scope";
    private static final String DOCUMENT_BGMEMBERALIAS = "bgMemberAlias";
    private static final String DOCUMENT_BGMEMBERNUM = "bgMemberNum";
    private static final String DOCUMENT_BGMEMBERTYPE = "bgMemberType";
    private static final String DOCUMENT_BIZDATATYPE = "bizDataType";
    private static final String DOCUMENT_FILLTYPE = "fillType";
    private static final String DOCUMENT_REFFIELD = "refField";
    private static final String DOCUMENT_BIZRELY = "bizRely";
    private static final String DOCUMENT_BIZREFBGTEMPLATE = "bizRefBgTemplate";
    private static final String DOCUMENT_BIZCALCGROUP = "bizCalcGroup";
    private static final String DOCUMENT_SHOWDIMNUMS = "showDimNums";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBizCalc(List<String> selectIds, File file) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(DOCUMENT_NUMBER);
        sic.add(DOCUMENT_NAME);
        sic.add(DOCUMENT_DESCRIPTION);
        sic.add(DOCUMENT_MEMBERMAP);
        sic.add(DOCUMENT_ISBGEXE);
        sic.add("bizCalcSubset.id");
        sic.add("bizCalcSubset.seq");
        sic.add("bizCalcSubset.name");
        sic.add("bizCalcSubset.formula");
        sic.add("bizCalcSubset.scope.id");
        sic.add("bizCalcSubset.scope.bgMemberNum");
        sic.add("bizCalcSubset.scope.bgMemberAlias");
        sic.add("bizCalcSubset.scope.bgMemberType");
        sic.add("bizCalcSubset.scope.bizDataType");
        sic.add("bizCalcSubset.scope.refField");
        sic.add("bizCalcSubset.scope.seq");
        sic.add("bizCalcSubset.scope.fillType");
        sic.add("bizCalcSubset.showDimNums");
        evi.setSelector(sic);
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo(DOCUMENT_NUMBER));
        evi.getSorter().add(new SorterItemInfo("bizCalcSubset.seq"));
        evi.getSorter().add(new SorterItemInfo("bizCalcSubset.scope.seq"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BizCalcCollection calcs = BizCalcFactory.getRemoteInstance().getBizCalcCollection(evi);
        evi.getSelector().clear();
        evi.getSelector().add("bizCalc.id");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.number");
        evi.getSelector().add("bgTemplate.name");
        evi.getSorter().clear();
        evi.getSorter().add(new SorterItemInfo("bizCalc.id"));
        evi.getSorter().add(new SorterItemInfo("bgTemplate.number"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bizCalc.id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BizRefBgTemplateCollection refBgTemplate = BizRefBgTemplateFactory.getRemoteInstance().getBizRefBgTemplateCollection(evi);
        HashMap<String, List<BizRefBgTemplateInfo>> refBgTemplateMap = new HashMap<String, List<BizRefBgTemplateInfo>>();
        String id = null;
        for (int i = 0; i < refBgTemplate.size(); ++i) {
            BizRefBgTemplateInfo info = refBgTemplate.get(i);
            id = info.getBizCalc().getId().toString();
            if (!refBgTemplateMap.containsKey(id)) {
                refBgTemplateMap.put(id, new ArrayList());
            }
            ((List)refBgTemplateMap.get(id)).add(info);
        }
        evi.getSelector().clear();
        evi.getSelector().add("bizCalc.id");
        evi.getSelector().add("relyBiz.id");
        evi.getSelector().add("relyBiz.number");
        evi.getSelector().add("relyBiz.name");
        evi.getSorter().clear();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bizCalc.id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BizRelyCollection bizRely = BizRelyFactory.getRemoteInstance().getBizRelyCollection(evi);
        HashMap<String, List<BizRelyInfo>> bizRelyMap = new HashMap<String, List<BizRelyInfo>>();
        for (int i = 0; i < bizRely.size(); ++i) {
            id = bizRely.get(i).getBizCalc().getId().toString();
            if (!bizRelyMap.containsKey(id)) {
                bizRelyMap.put(id, new ArrayList());
            }
            ((List)bizRelyMap.get(id)).add(bizRely.get(i));
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElement = doc.addElement(DOCUMENT_BIZCALC);
        rootElement.addComment(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"bizCalcExportMsg"));
        for (int i = 0; i < calcs.size(); ++i) {
            BizCalcExportHelper.buildDocument(rootElement, calcs.get(i), refBgTemplateMap, bizRelyMap);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
        }
    }

    private static void buildDocument(Element rootElement, BizCalcInfo bizCalcInfo, Map<String, List<BizRefBgTemplateInfo>> refBgTemplateMap, Map<String, List<BizRelyInfo>> bizRelyMap) {
        Element bizElement = rootElement.addElement(DOCUMENT_BIZCALC);
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NUMBER, (Object)bizCalcInfo.getNumber());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_NAME, (Object)bizCalcInfo.getName());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_ISBGEXE, (Object)bizCalcInfo.isIsBGExe());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_DESCRIPTION, (Object)bizCalcInfo.getDescription());
        BgViewHelper.addElementText((Element)bizElement, (String)DOCUMENT_MEMBERMAP, (Object)bizCalcInfo.getMemberMap());
        BizCalcExportHelper.buildDocument(bizElement, bizCalcInfo.getBizCalcSubset());
        BizCalcExportHelper.buildDocument(bizElement, refBgTemplateMap.get(bizCalcInfo.getId().toString()));
        BizCalcExportHelper.buildDocumentRely(bizElement, bizRelyMap.get(bizCalcInfo.getId().toString()));
        BizCalcExportHelper.buildDocument(bizElement, bizCalcInfo.getBizCalcGroup());
    }

    private static void buildDocument(Element bizElement, BizCalcSubsetCollection bizCalcSubset) {
        for (int i = 0; i < bizCalcSubset.size(); ++i) {
            BizCalcExportHelper.buildDocument(bizElement, bizCalcSubset.get(i));
        }
    }

    private static void buildDocument(Element bizElement, BizCalcSubsetInfo bizCalcSubsetInfo) {
        Element subSetElement = bizElement.addElement(DOCUMENT_BIZCALCSUBSET);
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_SEQ, (Object)bizCalcSubsetInfo.getSeq());
        String formula = bizCalcSubsetInfo.getBizFormula();
        if (formula != null) {
            BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_FORMULA, (Object)formula.replaceAll("\r\n", DimensionConstants.TICK_SEPARATOR));
        }
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_NAME, (Object)bizCalcSubsetInfo.getName());
        BgViewHelper.addElementText((Element)subSetElement, (String)DOCUMENT_SHOWDIMNUMS, (Object)bizCalcSubsetInfo.getShowDimNums());
        for (int i = 0; i < bizCalcSubsetInfo.getScope().size(); ++i) {
            BizCalcExportHelper.buildDocument(subSetElement, bizCalcSubsetInfo.getScope().get(i));
        }
    }

    private static void buildDocument(Element subSetElement, BizScopeInfo bizScopeInfo) {
        Element scopeElement = subSetElement.addElement(DOCUMENT_SCOPE);
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERALIAS, (Object)bizScopeInfo.getBgMemberAlias());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERNUM, (Object)bizScopeInfo.getBgMemberNum());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BGMEMBERTYPE, (Object)bizScopeInfo.getBgMemberType());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_BIZDATATYPE, (Object)bizScopeInfo.getBizDataType().getName());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_FILLTYPE, (Object)bizScopeInfo.getFillType().getName());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_REFFIELD, (Object)bizScopeInfo.getRefField());
        BgViewHelper.addElementText((Element)scopeElement, (String)DOCUMENT_SEQ, (Object)bizScopeInfo.getSeq());
    }

    private static void buildDocumentRely(Element bizElement, List<BizRelyInfo> bizRelyInfos) {
        if (bizRelyInfos == null) {
            return;
        }
        for (int i = 0; i < bizRelyInfos.size(); ++i) {
            BizCalcExportHelper.buildDocument(bizElement, bizRelyInfos.get(i));
        }
    }

    private static void buildDocument(Element bizElement, BizRelyInfo bizRelyInfo) {
        if (bizRelyInfo == null) {
            return;
        }
        Element bizRelyElement = bizElement.addElement(DOCUMENT_BIZRELY);
        BgViewHelper.addElementText((Element)bizRelyElement, (String)DOCUMENT_NUMBER, (Object)bizRelyInfo.getRelyBiz().getNumber());
        BgViewHelper.addElementText((Element)bizRelyElement, (String)DOCUMENT_NAME, (Object)bizRelyInfo.getRelyBiz().getName());
    }

    private static void buildDocument(Element bizElement, List<BizRefBgTemplateInfo> refTemps) {
        if (bizElement == null || refTemps == null || refTemps.isEmpty()) {
            return;
        }
        for (int i = 0; i < refTemps.size(); ++i) {
            BizCalcExportHelper.buildDocument(bizElement, refTemps.get(i));
        }
    }

    private static void buildDocument(Element bizElement, BizRefBgTemplateInfo bizRefBgTemplateInfo) {
        if (bizElement == null || bizRefBgTemplateInfo == null || StringUtils.isEmpty((String)bizRefBgTemplateInfo.getBgTemplate().getNumber())) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BIZREFBGTEMPLATE);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bizRefBgTemplateInfo.getBgTemplate().getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bizRefBgTemplateInfo.getBgTemplate().getName());
    }

    private static void buildDocument(Element bizElement, BizCalcGroupInfo bizCalcGroupInfo) {
        if (bizElement == null || bizCalcGroupInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BIZCALCGROUP);
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NUMBER, (Object)bizCalcGroupInfo.getNumber());
        BgViewHelper.addElementText((Element)tElement, (String)DOCUMENT_NAME, (Object)bizCalcGroupInfo.getName());
    }

    public static String importBizCalc(String bgSchemeId, String orgUnitId, String filePath, ErrorHandleModeEnum errorHandle, String bizCalcGroupId) throws Exception {
        LinkedHashMap<String, BizCalcInfo> calcMap = new LinkedHashMap<String, BizCalcInfo>();
        HashMap<String, BgTemplateCollection> refBgTempMap = new HashMap<String, BgTemplateCollection>();
        HashMap<String, List<BizCalcInfo>> relyMap = new HashMap<String, List<BizCalcInfo>>();
        BizCalcExportHelper.unParse(filePath, calcMap, refBgTempMap, relyMap, bizCalcGroupId);
        return BizCalcFactory.getRemoteInstance().importBizCalc(bgSchemeId, orgUnitId, calcMap, refBgTempMap, relyMap, errorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unParse(String filePath, Map<String, BizCalcInfo> calcMap, Map<String, BgTemplateCollection> refBgTempMap, Map<String, List<BizCalcInfo>> relyMap, String bizCalcGroupId) throws Exception {
        SAXReader reader = new SAXReader();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(new File(filePath));
            Document document = reader.read((InputStream)fileInputStream);
            Element rootElement = document.getRootElement();
            Iterator it = rootElement.elementIterator(DOCUMENT_BIZCALC);
            while (it.hasNext()) {
                BizCalcExportHelper.unParseBizCalc((Element)it.next(), calcMap, refBgTempMap, relyMap, bizCalcGroupId);
            }
        }
    }

    private static void unParseBizCalc(Element bizElement, Map<String, BizCalcInfo> calcMap, Map<String, BgTemplateCollection> refBgTempMap, Map<String, List<BizCalcInfo>> relyMap, String bizCalcGroupId) {
        BizCalcInfo bizCalc = new BizCalcInfo();
        bizCalc.setId(BOSUuid.create((BOSObjectType)bizCalc.getBOSType()));
        bizCalc.setState(BizStateEnum.SAVED);
        calcMap.put(bizCalc.getId().toString(), bizCalc);
        bizCalc.setNumber(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NUMBER));
        bizCalc.setName(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_NAME));
        bizCalc.setIsBGExe(Boolean.parseBoolean(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_ISBGEXE)));
        bizCalc.setDescription(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_DESCRIPTION));
        bizCalc.setMemberMap(BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_MEMBERMAP));
        Iterator it = bizElement.elementIterator(DOCUMENT_BIZCALCSUBSET);
        while (it.hasNext()) {
            BizCalcSubsetInfo subSet = new BizCalcSubsetInfo();
            subSet.setBizCalc(bizCalc);
            bizCalc.getBizCalcSubset().add(subSet);
            BizCalcExportHelper.unParseSubSet((Element)it.next(), subSet);
        }
        it = bizElement.elementIterator(DOCUMENT_BIZREFBGTEMPLATE);
        while (it.hasNext()) {
            BizCalcExportHelper.unParseRefBgTemplate((Element)it.next(), bizCalc.getId().toString(), refBgTempMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BIZRELY);
        while (it.hasNext()) {
            BizCalcExportHelper.unParseRely((Element)it.next(), bizCalc.getId().toString(), relyMap);
        }
        BizCalcExportHelper.umParseBizCalcGroup(bizCalc, bizElement, bizCalcGroupId);
    }

    private static void umParseBizCalcGroup(BizCalcInfo bizCalc, Element bizElement, String bizCalcGroupId) {
        if (StringUtils.isEmpty((String)bizCalcGroupId)) {
            if (BgViewHelper.getElementValue((Element)bizElement, (String)DOCUMENT_BIZCALCGROUP) != null) {
                Iterator it = bizElement.elementIterator(DOCUMENT_BIZCALCGROUP);
                while (it.hasNext()) {
                    Element bizCalcGroupElement = (Element)it.next();
                    BizCalcGroupInfo bizCalcGroupInfo = new BizCalcGroupInfo();
                    if (bizCalcGroupElement != null) {
                        bizCalcGroupInfo.setNumber(BgViewHelper.getElementValue((Element)bizCalcGroupElement, (String)DOCUMENT_NUMBER));
                        bizCalcGroupInfo.setName(BgViewHelper.getElementValue((Element)bizCalcGroupElement, (String)DOCUMENT_NAME));
                        if (BgViewHelper.getElementValue((Element)bizCalcGroupElement, (String)DOCUMENT_NUMBER).equals("PRE")) {
                            bizCalcGroupInfo.setId(BOSUuid.read((String)"IkpMdUyjQyOGom8OtZ0y2TQyFtQ="));
                        } else {
                            bizCalcGroupInfo.setId(BOSUuid.create((BOSObjectType)bizCalcGroupInfo.getBOSType()));
                        }
                    } else {
                        bizCalcGroupInfo.setId(BOSUuid.read((String)"IkpMdUyjQyOGom8OtZ0y2TQyFtQ="));
                        bizCalcGroupInfo.setNumber("PRE");
                        bizCalcGroupInfo.setName(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"default_bizCalcGroup"));
                    }
                    bizCalc.setBizCalcGroup(bizCalcGroupInfo);
                }
            } else {
                BizCalcGroupInfo bizCalcGroupInfo = new BizCalcGroupInfo();
                bizCalcGroupInfo.setId(BOSUuid.read((String)"IkpMdUyjQyOGom8OtZ0y2TQyFtQ="));
                bizCalcGroupInfo.setNumber("PRE");
                bizCalcGroupInfo.setName(BgCommCHelper.getMessageStr((String)BizConstants.BIZ_RESOURCE, (String)"default_bizCalcGroup"));
                bizCalc.setBizCalcGroup(bizCalcGroupInfo);
            }
        } else {
            BizCalcGroupInfo bizCalcGroupInfo = new BizCalcGroupInfo();
            bizCalcGroupInfo.setId(BOSUuid.read((String)bizCalcGroupId));
            bizCalc.setBizCalcGroup(bizCalcGroupInfo);
        }
    }

    private static void unParseRely(Element relyElement, String bizCalcId, Map<String, List<BizCalcInfo>> relyMap) {
        if (relyElement == null) {
            return;
        }
        BizCalcInfo bizCalcInfo = new BizCalcInfo();
        if (!relyMap.containsKey(bizCalcId)) {
            relyMap.put(bizCalcId, new ArrayList());
        }
        relyMap.get(bizCalcId).add(bizCalcInfo);
        bizCalcInfo.setNumber(BgViewHelper.getElementValue((Element)relyElement, (String)DOCUMENT_NUMBER));
        bizCalcInfo.setName(BgViewHelper.getElementValue((Element)relyElement, (String)DOCUMENT_NAME));
    }

    private static void unParseRefBgTemplate(Element refBgTemplateElement, String bizCalcId, Map<String, BgTemplateCollection> refBgTempMap) {
        if (StringUtils.isEmpty((String)BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER))) {
            return;
        }
        if (!refBgTempMap.containsKey(bizCalcId)) {
            refBgTempMap.put(bizCalcId, new BgTemplateCollection());
        }
        BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
        refBgTempMap.get(bizCalcId).add(bgTemplateInfo);
        bgTemplateInfo.setNumber(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NUMBER));
        bgTemplateInfo.setName(BgViewHelper.getElementValue((Element)refBgTemplateElement, (String)DOCUMENT_NAME));
    }

    private static void unParseSubSet(Element subSetElement, BizCalcSubsetInfo subSetInfo) {
        String showDimNums;
        subSetInfo.setId(BOSUuid.create((BOSObjectType)subSetInfo.getBOSType()));
        subSetInfo.setSeq(Integer.parseInt(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_SEQ)));
        subSetInfo.setName(BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_NAME));
        String formula = BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_FORMULA);
        if (formula != null) {
            subSetInfo.setBizFormula(formula.replaceAll(DimensionConstants.TICK_SEPARATOR, "\r\n"));
        }
        if (!StringUtils.isEmpty((String)(showDimNums = BgViewHelper.getElementValue((Element)subSetElement, (String)DOCUMENT_SHOWDIMNUMS)))) {
            subSetInfo.setShowDimNums(showDimNums);
        }
        Iterator it = subSetElement.elementIterator(DOCUMENT_SCOPE);
        while (it.hasNext()) {
            BizScopeInfo scope = new BizScopeInfo();
            scope.setBizCalcSubset(subSetInfo);
            subSetInfo.getScope().add(scope);
            BizCalcExportHelper.unParseScope((Element)it.next(), scope);
        }
    }

    private static void unParseScope(Element scopeElement, BizScopeInfo scopeInfo) {
        scopeInfo.setId(BOSUuid.create((BOSObjectType)scopeInfo.getBOSType()));
        scopeInfo.setSeq(Integer.parseInt(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_SEQ)));
        scopeInfo.setBgMemberAlias(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERALIAS));
        scopeInfo.setBgMemberNum(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERNUM));
        scopeInfo.setBgMemberType(Integer.parseInt(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BGMEMBERTYPE)));
        scopeInfo.setBizDataType(BgMemberSelectTypeEnum.getEnum((String)BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_BIZDATATYPE)));
        scopeInfo.setFillType(DimensionMemberTypeEnum.getEnum((String)BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_FILLTYPE)));
        scopeInfo.setRefField(BgViewHelper.getElementValue((Element)scopeElement, (String)DOCUMENT_REFFIELD));
    }
}

