/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client.utils;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizUtils;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class BizCalcUtils
extends BizUtils {
    public static final String NULL_VAR = "VAR:[" + BgBaseConstants.DOUBLE_QUOTATION_STR + "NULL" + BgBaseConstants.DOUBLE_QUOTATION_STR + "]";
    public static final int IFELSE_BLANK = 3;

    public DimensionMemberSelectDialog getDimensionMemberSelectDialog() {
        return new DimensionMemberSelectDialog();
    }

    public NewDimensionMemberSelectDialog getNewDimensionMemberSelectDialog() {
        return new NewDimensionMemberSelectDialog();
    }

    public static boolean hasCalcOperation(int oprtationType) {
        return oprtationType == 11 || oprtationType == 12 || oprtationType == 8 || oprtationType == 9;
    }

    public static int getOperation(String operationStr) {
        int op = -1;
        if ("=".equals(operationStr)) {
            op = 20;
        } else if ("==".equals(operationStr)) {
            op = 13;
        } else if ("+".equals(operationStr)) {
            op = 11;
        } else if ("/".equals(operationStr)) {
            op = 9;
        } else if ("-".equals(operationStr)) {
            op = 12;
        } else if (">=".equals(operationStr)) {
            op = 14;
        } else if (">".equals(operationStr)) {
            op = 15;
        } else if ("<=".equals(operationStr)) {
            op = 16;
        } else if ("<".equals(operationStr)) {
            op = 17;
        } else if ("*".equals(operationStr)) {
            op = 8;
        } else if ("<>".equals(operationStr)) {
            op = 18;
        } else if ("(".equals(operationStr)) {
            op = 110;
        } else if (")".equals(operationStr)) {
            op = 111;
        } else if ("IF".equals(operationStr)) {
            op = 112;
        } else if (",".equals(operationStr)) {
            op = 122;
        } else if ("AND".equalsIgnoreCase(operationStr)) {
            op = 133;
        } else if ("OR".equalsIgnoreCase(operationStr)) {
            op = 134;
        } else if (";".equalsIgnoreCase(operationStr)) {
            op = 135;
        } else if ("NOT".equalsIgnoreCase(operationStr)) {
            op = 137;
        } else if ("ELSE".equalsIgnoreCase(operationStr)) {
            op = 136;
        } else if ("NULL".equals(operationStr)) {
            op = 138;
        }
        return op;
    }

    public static String getOperation(int operationType) {
        String op = null;
        switch (operationType) {
            case 11: {
                op = "+";
                break;
            }
            case 9: {
                op = "/";
                break;
            }
            case 12: {
                op = "-";
                break;
            }
            case 13: {
                op = "=";
                break;
            }
            case 14: {
                op = ">=";
                break;
            }
            case 15: {
                op = ">";
                break;
            }
            case 16: {
                op = "<=";
                break;
            }
            case 17: {
                op = "<";
                break;
            }
            case 8: {
                op = "*";
                break;
            }
            case 18: {
                op = "<>";
                break;
            }
            case 110: {
                op = "(";
                break;
            }
            case 111: {
                op = ")";
                break;
            }
            case 112: {
                op = "IF";
                break;
            }
            case 122: {
                op = ",";
                break;
            }
            case 133: {
                op = "AND";
                break;
            }
            case 134: {
                op = "OR";
                break;
            }
            case 138: {
                op = "NULL";
            }
        }
        return op;
    }

    public static List<String> getParentBgIndexNums(Collection<String> bgIndexNums) {
        ArrayList<String> queryList = new ArrayList<String>();
        if (!bgIndexNums.isEmpty()) {
            String bgIndexNum2 = null;
            String srcNumber = null;
            String number = null;
            String[] tmpStrs = null;
            for (String bgIndexNum2 : bgIndexNums) {
                tmpStrs = bgIndexNum2.split(":");
                srcNumber = tmpStrs[0];
                number = tmpStrs[1];
                if (number == null || (tmpStrs = number.split("\\.")) == null) continue;
                if (tmpStrs.length > 0) {
                    number = tmpStrs[0];
                    queryList.add(srcNumber + ":" + number);
                }
                int in = tmpStrs.length;
                for (int i = 1; i < in; ++i) {
                    number = number + "." + tmpStrs[i];
                    queryList.add(srcNumber + ":" + number);
                }
            }
        }
        return queryList;
    }

    public static String getDimDataKey(ICalcData calcData) {
        return DimUtils.getDimDataKey((String)calcData.getFormula(), (String)calcData.getBgVersionNumber());
    }

    public void checkFormula(BizCalcInfo bizCalc) throws Exception {
    }

    public IRow addMbgDim(BizCalcMainUI ui, IRow row, MbgDimInfo mbgDim, boolean isMulti, String orgId, boolean isEnableProperty) {
        if (ui == null || row == null || mbgDim == null) {
            return null;
        }
        ICell cell = null;
        boolean isHiddenPartCslDim = false;
        if (DimensionBaseConstants.DEF_CSL_Consolidation.equals(mbgDim.getNumber())) {
            isHiddenPartCslDim = true;
        }
        cell = row.getCell("dimType");
        cell.setUserObject((Object)mbgDim);
        cell.setValue((Object)mbgDim.getName());
        cell.getStyleAttributes().setLocked(true);
        cell = row.getCell("dimValue");
        if (cell.getValue() != null) {
            cell.setValue(null);
        }
        DimensionMemberSelectDialog dialog = this.getDimensionMemberSelectDialog();
        dialog.setEnableProperty(isEnableProperty);
        dialog.setOwner((Component)((Object)ui));
        dialog.setMulti(isMulti);
        dialog.setOnlySelectItem(true);
        dialog.setSelectCombinItem(false);
        dialog.setOnlyRefDim(true);
        dialog.setDimension((Object)ui.getSchemeHelper().getDimension(mbgDim.getNumber()));
        dialog.setOrgId(orgId);
        dialog.setBgSchemeId(ui.getBgSchemeInfo().getId().toString());
        dialog.setHiddenCslPartDim(isHiddenPartCslDim);
        KDBizPromptBox promptbox = new KDBizPromptBox();
        promptbox.setEditable(false);
        promptbox.setEditFormat("$number$");
        promptbox.setDisplayFormat("$name$");
        promptbox.setCommitFormat("$number$");
        promptbox.setSelector((KDPromptSelector)dialog);
        row.getCell("dimValue").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptbox));
        return row;
    }

    public void loadScope(BizCalcMainUI ui, BizCalcInfo bizCalc, KDTable scopeTable, Map<String, MbgDimInfo> dimMap) {
        if (bizCalc == null || scopeTable == null || dimMap == null) {
            return;
        }
        BizScopeInfo scope = null;
        BizScopeCollection colls = new BizScopeCollection();
        String srcNumber = null;
        String number = null;
        String dimNumber = null;
        String refField = null;
        String[] tmpStrs = null;
        BgScenarioInfo scenario = null;
        BgDimensionMember member = null;
        BgPeriodInfo bgPeriod = null;
        BgVersionInfo bgVersion = null;
        CurrencyInfo currency = null;
        BgElementInfo bgElement = null;
        BgScenarioCollection scenarios = new BgScenarioCollection();
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        BgPeriodCollection bgPeriods = new BgPeriodCollection();
        BgVersionCollection bgVersions = new BgVersionCollection();
        CurrencyCollection currencys = new CurrencyCollection();
        BgElementCollection bgElements = new BgElementCollection();
        TreeMap dimMemberMap = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        HashMap<String, String> dimFieldMap = new HashMap<String, String>();
        HashMap<String, MbgDimInfo> tmpDimMap = new HashMap<String, MbgDimInfo>();
        List<BgDimensionMember> dimMembers = null;
        MbgDimInfo dimension2 = null;
        HashMap<String, String> srcDimMap = new HashMap<String, String>();
        for (MbgDimInfo dimension2 : dimMap.values()) {
            srcDimMap.put(dimension2.getSrcNumber(), dimension2.getNumber());
            dimFieldMap.put(dimension2.getSrcNumber(), dimension2.getRefField());
            tmpDimMap.put(dimension2.getRefField(), dimension2);
        }
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            scope = colls.get(i);
            if (scope.getBgMemberType() == BizConstants.BIZ_BGSCENARIO_TYPE_VALUE) {
                scenario = new BgScenarioInfo();
                scenario.setNumber(scope.getBgMemberNum());
                scenario.setName(scope.getBgMemberAlias());
                scenarios.add(scenario);
                continue;
            }
            if (scope.getBgMemberType() == BizConstants.BIZ_BGINDEX_TYPE_VALUE) {
                tmpStrs = scope.getBgMemberNum().split(":");
                member = new BgDimensionMember(DimensionBaseConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, scope.getBgMemberAlias(), tmpStrs[1]);
                member.setSrcNumber(tmpStrs[0]);
                members.add(member);
                continue;
            }
            if (scope.getBgMemberType() == BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                bgPeriod = new BgPeriodInfo();
                bgPeriod.setNumber(scope.getBgMemberNum());
                bgPeriod.setName(scope.getBgMemberAlias());
                bgPeriods.add(bgPeriod);
                continue;
            }
            if (scope.getBgMemberType() == BizConstants.BIZ_BGVERSION_TYPE_VALUE) {
                bgVersion = new BgVersionInfo();
                bgVersion.setNumber(scope.getBgMemberNum());
                bgVersion.setName(scope.getBgMemberAlias());
                bgVersions.add(bgVersion);
                continue;
            }
            if (scope.getBgMemberType() == BizConstants.BIZ_CURRENCY_TYPE_VALUE) {
                currency = new CurrencyInfo();
                currency.setNumber(scope.getBgMemberNum());
                currency.setName(scope.getBgMemberAlias());
                currencys.add(currency);
                continue;
            }
            if (scope.getBgMemberType() == BizConstants.BIZ_BGELEMENT_TYPE_VALUE) {
                bgElement = new BgElementInfo();
                bgElement.setNumber(scope.getBgMemberNum());
                bgElement.setName(scope.getBgMemberAlias());
                bgElements.add(bgElement);
                continue;
            }
            if (scope.getBgMemberType() != BizConstants.BIZ_EXTDIM_TYPE_VALUE || (tmpStrs = scope.getBgMemberNum().split(":")) == null) continue;
            srcNumber = tmpStrs[0];
            number = tmpStrs[1];
            dimNumber = (String)srcDimMap.get(srcNumber);
            refField = (String)dimFieldMap.get(srcNumber);
            if (dimMemberMap.containsKey(refField)) {
                dimMembers = (List)dimMemberMap.get(refField);
            } else {
                dimMembers = new ArrayList();
                dimMemberMap.put(refField, dimMembers);
            }
            member = new BgDimensionMember(dimNumber, refField, scope.getBgMemberAlias(), number);
            member.setSrcNumber(srcNumber);
            dimMembers.add(member);
        }
        if (!scenarios.isEmpty()) {
            scopeTable.getCell(0, "dimValue").setValue((Object)scenarios);
        } else {
            scopeTable.getCell(0, "dimValue").setValue(null);
        }
        if (!members.isEmpty()) {
            scopeTable.getCell(1, "dimValue").setValue(members);
        } else {
            scopeTable.getCell(1, "dimValue").setValue(null);
        }
        if (!bgPeriods.isEmpty()) {
            scopeTable.getCell(2, "dimValue").setValue((Object)bgPeriods);
        } else {
            scopeTable.getCell(2, "dimValue").setValue(null);
        }
        if (!bgVersions.isEmpty()) {
            scopeTable.getCell(3, "dimValue").setValue((Object)bgVersions);
        } else {
            scopeTable.getCell(3, "dimValue").setValue(null);
        }
        if (!currencys.isEmpty()) {
            scopeTable.getCell(4, "dimValue").setValue((Object)currencys);
        } else {
            scopeTable.getCell(4, "dimValue").setValue(null);
        }
        if (!bgElements.isEmpty()) {
            scopeTable.getCell(5, "dimValue").setValue((Object)bgElements);
        } else {
            scopeTable.getCell(5, "dimValue").setValue(null);
        }
        if (scopeTable.getRowCount() > 6) {
            MbgDimInfo mbgDim = null;
            IRow row = null;
            int rowCount = scopeTable.getRowCount();
            for (int rowIndex = 6; rowIndex < rowCount; ++rowIndex) {
                row = scopeTable.getRow(rowIndex);
                if (!(row.getCell("dimType").getUserObject() instanceof MbgDimInfo) || !dimMemberMap.containsKey((mbgDim = (MbgDimInfo)row.getCell("dimType").getUserObject()).getRefField())) continue;
                dimMembers = (List)dimMemberMap.get(mbgDim.getRefField());
                row.getCell("dimValue").setValue(dimMembers);
            }
        }
    }

    public static void insertOperation(KDTextPane expressionFunc, int operationType) throws Exception {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setForeground(attr, Color.BLACK);
        int position = 0;
        position = expressionFunc.getCaretPosition();
        switch (operationType) {
            case 11: {
                expressionFunc.getDocument().insertString(position, "+", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 9: {
                expressionFunc.getDocument().insertString(position, "/", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 12: {
                expressionFunc.getDocument().insertString(position, "-", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 20: {
                expressionFunc.getDocument().insertString(position, "=", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 14: {
                expressionFunc.getDocument().insertString(position, ">=", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 15: {
                expressionFunc.getDocument().insertString(position, ">", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 16: {
                expressionFunc.getDocument().insertString(position, "<=", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 17: {
                expressionFunc.getDocument().insertString(position, "<", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 13: {
                expressionFunc.getDocument().insertString(position, "==", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 8: {
                expressionFunc.getDocument().insertString(position, "*", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 18: {
                expressionFunc.getDocument().insertString(position, "<>", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 135: {
                expressionFunc.getDocument().insertString(position, ";", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 110: {
                expressionFunc.getDocument().insertString(position, "(", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 111: {
                expressionFunc.getDocument().insertString(position, ")", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 112: {
                expressionFunc.getDocument().insertString(position, "IF [   ] {   }\nELSE {   };", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 136: {
                expressionFunc.getDocument().insertString(position, "ELSE [   ] {   }", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 133: {
                expressionFunc.getDocument().insertString(position, " AND ", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 134: {
                expressionFunc.getDocument().insertString(position, " OR ", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 137: {
                expressionFunc.getDocument().insertString(position, "NOT ", attr);
                expressionFunc.requestFocus();
                break;
            }
            case 138: {
                expressionFunc.getDocument().insertString(position, NULL_VAR + " ", attr);
                expressionFunc.requestFocus();
            }
        }
    }

    public static void setSubsetColor(Map bizSubsetButtonMap, KDButton curButton, Color color) {
        if (bizSubsetButtonMap == null || curButton == null || color == null) {
            return;
        }
        String subsetName = null;
        KDButton button = null;
        for (Object obj : bizSubsetButtonMap.keySet()) {
            subsetName = obj.toString();
            button = (KDButton)bizSubsetButtonMap.get(subsetName);
            button.setForeground(Color.BLACK);
            if (!button.getName().equals(curButton.getName())) continue;
            button.setForeground(color);
        }
    }

    public static Map sortButtonLocation(Map bizSubsetButtonMap) {
        if (bizSubsetButtonMap == null) {
            return null;
        }
        ArrayList<Integer> sortList = new ArrayList<Integer>();
        HashMap<Integer, String> sortSubsetButtonMap = new HashMap<Integer, String>();
        for (Object obj : bizSubsetButtonMap.keySet()) {
            String buttonName = obj.toString();
            KDButton button = (KDButton)bizSubsetButtonMap.get(buttonName);
            int xLocation = button.getX();
            sortSubsetButtonMap.put(xLocation, buttonName);
            sortList.add(xLocation);
        }
        Collections.sort(sortList);
        return sortSubsetButtonMap;
    }
}

