/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.client.utils;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.ma.biz.client.BizCalcMainUI;
import com.kingdee.eas.ma.biz.client.utils.ComponentDragSourceForBizCalc;
import com.kingdee.eas.ma.biz.client.utils.TransferableForBizCalc;
import com.kingdee.eas.ma.mbg.client.BgExamineMainUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class PanelDropTargetForBizCalc
implements DropTargetListener {
    private EditUI bizCalcMainUi;
    protected JPanel panel;
    protected Point lastP;

    public PanelDropTargetForBizCalc(EditUI bizCalcMainUi, JPanel panel) {
        this.bizCalcMainUi = bizCalcMainUi;
        this.panel = panel;
        new DropTarget(panel, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        if (this.lastP != null && (this.lastP.x != p.x || this.lastP.y != p.y)) {
            this.markTarget(this.lastP);
            this.panel.updateUI();
        }
        this.markTarget(p);
        this.lastP = p;
    }

    private void markTarget(Point p) {
        Graphics g = this.panel.getGraphics();
        g.setColor(Color.RED);
        int lenx = 25;
        int leny = 25;
        g.drawLine(p.x - 25, p.y, p.x + 25, p.y);
        g.drawLine(p.x, p.y - 25, p.x, p.y + 25);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        try {
            String subSetName = (String)tr.getTransferData(TransferableForBizCalc.SUBSETNAME_FLAVOR);
            KDButton button = (KDButton)tr.getTransferData(TransferableForBizCalc.BUTTON_FLAVOR);
            if (this.bizCalcMainUi instanceof BizCalcMainUI) {
                ((BizCalcMainUI)this.bizCalcMainUi).getBizSubsetButtonMap().put(subSetName, button);
                button.addActionListener(((BizCalcMainUI)this.bizCalcMainUi).actionListener);
            } else if (this.bizCalcMainUi instanceof BgExamineMainUI) {
                ((BgExamineMainUI)this.bizCalcMainUi).getBizSubsetButtonMap().put(subSetName, button);
                button.addActionListener(((BgExamineMainUI)this.bizCalcMainUi).actionListener);
            }
            this.panel.remove((Component)button);
            this.panel.add((Component)button, null, this.getDropPositionIndex(dtde.getLocation()));
            this.panel.updateUI();
            this.createDragSource(dtde, subSetName, button);
            button.doClick();
            dtde.dropComplete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    private int getDropPositionIndex(Point dropPoint) {
        Point p;
        Component[] cs = this.panel.getComponents();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int j = 0; j < cs.length; ++j) {
            p = cs[j].getLocation();
            p.x += cs[j].getWidth();
            p.y += cs[j].getHeight();
            list.add(p);
        }
        int index = -1;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            p = (Point)list.get(i);
            if (dropPoint.x > p.x || dropPoint.y > p.y) continue;
            index = i;
            break;
        }
        return index;
    }

    protected void createDragSource(DropTargetDropEvent dtde, String subSetName, KDButton button) {
        ComponentDragSourceForBizCalc.createDragSource(button, subSetName, dtde.getDropAction());
    }
}

