/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.face.IBizCalc;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizParameterExUtils;
import com.kingdee.eas.ma.biz.execute.calc.impl.ICalcMember;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.data.impl.MbgDataFacadeImpl;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataFacade;
import com.kingdee.eas.ma.mbg.app.olap.impl.BizCalcStrategy;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.query.QueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionBase;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcImpl
extends Thread
implements IBizCalc {
    private static Logger logger = Logger.getLogger(BizCalcImpl.class);
    private Context ctx = null;
    private IBizParameter parameter = null;
    private List<ICalcMember> calcs = new ArrayList<ICalcMember>();
    private boolean isAudit = false;
    private boolean isMultiProcessType = false;
    private List<ICalcData> saveDatas = null;
    private IDimensionParameter dimParam = null;

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setParameter(IBizParameter parameter) {
        this.parameter = parameter;
    }

    public IBizParameter getParameter() {
        return this.parameter;
    }

    public void setCalcs(List<ICalcMember> calcs) {
        this.calcs = calcs;
    }

    public List<ICalcMember> getCalcs() {
        return this.calcs;
    }

    public boolean isMultiProcessType() {
        return this.isMultiProcessType;
    }

    public void setMultiProcessType(boolean isMultiProcessType) {
        this.isMultiProcessType = isMultiProcessType;
    }

    public BizCalcImpl(Context ctx, IBizParameter parameter, boolean isAudit) {
        this.setCtx(ctx);
        this.setParameter(parameter);
        this.isAudit = isAudit;
    }

    public BizCalcImpl(Context ctx, IBizParameter parameter) {
        this.setCtx(ctx);
        this.setParameter(parameter);
    }

    public BizCalcImpl(Context ctx) {
        this.setCtx(ctx);
    }

    public Map calc() throws Exception {
        Map bgDataMap;
        Map<Object, Object> result = new HashMap();
        if (this.getCtx() == null) {
            return result;
        }
        IDimensionParameter parameter = this.transParameter(this.getParameter());
        if (parameter != null && (bgDataMap = (Map)BgDimensionFacadeFactory.getLocalInstance((Context)this.getCtx()).dimensionQuery(parameter)) != null) {
            if (parameter.getControlManager().isMultiProcessType() && parameter.getControlManager().isSaveMultiData()) {
                this.setMultiProcessType(true);
                result = this.transMultiResult(parameter, bgDataMap);
            } else {
                this.setMultiProcessType(false);
                result = this.transResult(parameter, bgDataMap);
            }
        }
        return result;
    }

    public void processBizParameter(IDimensionParameter dimParam) throws Exception {
        BizParameterExUtils.processBizParameter(this.getCtx(), dimParam);
    }

    public IDimensionParameter transParameter(IBizParameter parameter) throws Exception {
        DimensionParameter dimParam = new DimensionParameter();
        dimParam.setBgSchemeId(parameter.getBgSchemeId());
        dimParam.setOrgUnitId(parameter.getOrgUnitId());
        dimParam.setUnionId(parameter.getUnionId());
        dimParam.setBillId(parameter.getBillId());
        dimParam.setValueType(parameter.getValueType());
        dimParam.addPeriodStandardNumber(parameter.getBgPeriodNum());
        dimParam.getControlManager().setBizCalc(parameter.getControlManager().isBizCalc());
        HashMap<String, Set<String>> tmpExecuteDimData = new HashMap<String, Set<String>>();
        if (parameter.getExecuteDimData() != null) {
            tmpExecuteDimData.putAll(parameter.getExecuteDimData());
        }
        dimParam.setExecuteDimData(tmpExecuteDimData);
        dimParam.setBgOrgViewId(parameter.getDataManager().getBgScheme().getEditOrgViewId());
        if (parameter.getDataManager().getBgScheme() == null) {
            parameter.getDataManager().setBgScheme(BgViewServerHelper.getBgSchemeCubeInfo((Context)this.getCtx(), (BOSUuid)parameter.getBgSchemeId()));
        }
        dimParam.getDataManager().setBgScheme(parameter.getDataManager().getBgScheme());
        if (parameter.getDataManager().getOrgUnit() == null) {
            parameter.getDataManager().setOrgUnit(MbgDataHelper.getBaseOrgUnitInfo((Context)this.getCtx(), (BOSUuid)parameter.getOrgUnitId()));
        }
        dimParam.getDataManager().setOrgUnit(parameter.getDataManager().getOrgUnit());
        if (dimParam.getBgOrgViewId() != null) {
            BgOrgUnitInfo bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo((Context)this.getCtx(), (BOSUuid)dimParam.getBgOrgViewId(), (BOSUuid)dimParam.getOrgUnitId());
            dimParam.getDataManager().setBgOrgUnit(bgOrgUnit);
        }
        dimParam.setCalcIds(parameter.getCalcIds());
        dimParam.getControlManager().setBackCalc(parameter.getControlManager().isBackCalc());
        dimParam.getControlManager().setAdjust(parameter.getControlManager().isAdjust());
        dimParam.getControlManager().setSaveMultiData(parameter.getControlManager().isSaveMultiData());
        MbgDimInfo mbgDim2 = null;
        DimensionObject dimension2 = null;
        IDimension _dimension2 = null;
        MemberObject member = null;
        QueryData queryData = null;
        Connection conn = null;
        try {
            Map executeDimData;
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            Map mbgDims = DimUtils.getDimNumMap((Connection)conn, (Locale)this.getCtx().getLocale());
            if (dimParam.getDataManager().getMbgDims().isEmpty()) {
                Map srcFieldMap = dimParam.getDataManager().getSrcFieldMap();
                Map fieldSrcMap = dimParam.getDataManager().getFieldSrcMap();
                Map _mbgDims = dimParam.getDataManager().getMbgDims();
                for (MbgDimInfo mbgDim2 : mbgDims.values()) {
                    _mbgDims.put(mbgDim2.getRefField(), mbgDim2);
                    srcFieldMap.put(mbgDim2.getSrcNumber(), mbgDim2.getRefField());
                    fieldSrcMap.put(mbgDim2.getRefField(), mbgDim2.getSrcNumber());
                }
            }
            if (dimParam.getDataManager().getDimensions() == null) {
                dimParam.getDataManager().setDimensions(DimUtils.getDimensionColls((Context)this.getCtx()));
            }
            BizCalcStrategy calcStrategy = new BizCalcStrategy();
            if (parameter.getBillId() != null) {
                String type = parameter.getBillId().getType().toString();
                BgFormInfo dimDataQuery = null;
                IMbgViewBase view = null;
                IBgDimensionManagerBase manager = null;
                BgDimensionBaseInfo dimInfo = null;
                BOSUuid _billId = parameter.getBillId();
                if (type.equals("2DC6EFE2")) {
                    BgActualRecordInfo bgActualRecord = MbgDataHelper.getBgActualRecord((Connection)conn, (Locale)this.getCtx().getLocale(), (BOSUuid)_billId);
                    _billId = bgActualRecord.getBgForm().getId();
                    parameter.setValueType(16);
                    dimParam.setValueType(parameter.getValueType());
                    dimDataQuery = BgFormFactory.getLocalInstance((Context)this.getCtx()).getBgFormInfo((IObjectPK)new ObjectUuidPK(_billId), BgFormInfo.getFormSelector2());
                } else if (type.equals("3BA5F027")) {
                    dimParam.setValueType(1);
                    dimDataQuery = BgFormFactory.getLocalInstance((Context)this.getCtx()).getBgFormInfo((IObjectPK)new ObjectUuidPK(_billId), BgFormInfo.getFormSelector2());
                } else if (type.equals("655ADD42")) {
                    dimParam.setValueType(64);
                    dimDataQuery = MbgCslDataHelper.getBgCslFormInfo((Context)this.getCtx(), (Connection)conn, (String)_billId.toString());
                } else if (type.equals("9E7BD5E2")) {
                    dimParam.setValueType(64);
                    dimDataQuery = MbgCslDataHelper.getMBgWorkPaperInfo((Context)this.getCtx(), (Connection)conn, (String)_billId.toString());
                }
                if (dimDataQuery != null) {
                    dimParam.setBgTemplateId(new BOSUuid[]{dimDataQuery.getBizTemplateId()});
                    view = dimDataQuery.getView(this.getCtx(), parameter.getDataManager().getBgScheme());
                    if (view != null && view.getSheetManagers() != null) {
                        int in = view.getSheetManagers().size();
                        for (int i = 0; i < in; ++i) {
                            manager = ((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager();
                            if (manager == null) continue;
                            if (i > 0) {
                                queryData = new QueryData();
                            }
                            if (manager instanceof MbgViewListDimensionManager) {
                                DimUtils.transMbgDimMember((MbgViewListDimensionManager)((MbgViewListDimensionManager)manager));
                            }
                            for (int j = 0; j < manager.getDimension().size(); ++j) {
                                dimInfo = (BgDimensionBaseInfo)manager.getDimension().get(j);
                                if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                                mbgDim2 = (MbgDimInfo)mbgDims.get(dimInfo.getNumber());
                                dimension2 = new DimensionObject();
                                dimension2.setNumber(dimInfo.getNumber());
                                dimension2.setField(mbgDim2.getRefField());
                                dimension2.setSrcNumber(mbgDim2.getSrcNumber());
                                List memList = dimInfo.getMember();
                                if (memList != null && !memList.isEmpty()) {
                                    BgDimensionMember dimensionMember = null;
                                    int xn = memList.size();
                                    for (int x = 0; x < xn; ++x) {
                                        dimensionMember = (BgDimensionMember)memList.get(x);
                                        member = new MemberObject();
                                        member.setName(dimensionMember.getName());
                                        member.setNumber(dimensionMember.getNumber());
                                        member.setSrcNumber(dimensionMember.getSrcNumber());
                                        dimension2.getDimensionMember().add(member);
                                    }
                                }
                                if (queryData == null) {
                                    if (DimUtils.checkBaseDimension((String)dimension2.getNumber())) {
                                        dimParam.getColDims().add(dimension2);
                                    } else {
                                        dimParam.getRowDims().add(dimension2);
                                    }
                                    dimParam.getDimensionMap().put(dimension2.getNumber(), dimension2);
                                    continue;
                                }
                                _dimension2 = dimension2.toMbgDim(this.getCtx(), (IDimensionParameter)dimParam);
                                queryData.getMbgDimMap().put(_dimension2.getField(), _dimension2);
                            }
                            if (queryData == null) continue;
                            dimParam.getQuerys().add(queryData);
                        }
                    }
                } else {
                    throw new BgFormException(BgFormException.NOBGFORMINFO);
                }
                calcStrategy.queryCalc(this.getCtx(), (IDimensionParameter)dimParam);
                dimParam.getDataManager().setCalcStrategy(calcStrategy);
            } else {
                this.processBizParameter((IDimensionParameter)dimParam);
                calcStrategy.queryCalc(this.getCtx(), (IDimensionParameter)dimParam);
                dimParam.getDataManager().setCalcStrategy(calcStrategy);
                executeDimData = dimParam.getExecuteDimData();
                Set refCalcNumbers = null;
                String[] tmpStrs = null;
                Set dimNums = parameter.getDataManager().getBgScheme().getDimNums();
                if (parameter.getUnionId() == null && dimNums.contains(DimensionBaseConstants.DEF_CSL_NUMBER)) {
                    dimNums.remove(DimensionBaseConstants.DEF_CSL_NUMBER);
                }
                for (String dimNum : dimNums) {
                    mbgDim2 = (MbgDimInfo)mbgDims.get(dimNum);
                    if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimNum)) continue;
                    dimension2 = new DimensionObject();
                    dimension2.setNumber(dimNum);
                    dimension2.setSrcNumber(mbgDim2.getSrcNumber());
                    dimension2.setField(mbgDim2.getRefField());
                    if (calcStrategy.getRefNumMap() != null && calcStrategy.getRefNumMap().containsKey(dimension2.getField())) {
                        refCalcNumbers = (Set)calcStrategy.getRefNumMap().get(dimension2.getField());
                        for (String memberNumber : refCalcNumbers) {
                            if (executeDimData != null && executeDimData.get(dimension2.getField()) != null && !((Set)executeDimData.get(dimension2.getField())).contains(memberNumber)) continue;
                            if (DimUtils.checkBaseDimensionByField((String)dimension2.getField()) || DimensionConstants.DEF_CSL_FIELD.equals(dimension2.getField())) {
                                member = new MemberObject();
                                member.setNumber(memberNumber);
                                dimension2.addMember((IMember)member);
                                continue;
                            }
                            tmpStrs = memberNumber.split(":");
                            if (tmpStrs.length != 2) continue;
                            member = new MemberObject();
                            member.setNumber(tmpStrs[1]);
                            member.setSrcNumber(tmpStrs[0]);
                            dimension2.addMember((IMember)member);
                        }
                    } else {
                        this.queryMembers(conn, (IDimensionParameter)dimParam, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimension2, dimension2.getField());
                        this.filterExecuteMember(executeDimData, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimension2);
                    }
                    if (DimUtils.checkBaseDimension((String)dimension2.getNumber())) {
                        dimParam.getColDims().add(dimension2);
                    } else {
                        dimParam.getRowDims().add(dimension2);
                    }
                    dimParam.getDimensionMap().put(dimension2.getNumber(), dimension2);
                }
                DimUtils.sortDims((List)dimParam.getRowDims());
                DimUtils.sortDims((List)dimParam.getColDims());
            }
            if (dimParam.getControlManager().isBackCalc() && !calcStrategy.hasBizCalc()) {
                executeDimData = null;
                return executeDimData;
            }
            if (!calcStrategy.getMembers().isEmpty()) {
                this.putCalcMember((IDimensionParameter)dimParam, calcStrategy.getMembers());
            }
            DimUtils.transScenarioAndVersion((Context)this.getCtx(), (Connection)conn, (IDimensionParameter)dimParam, null);
            for (DimensionObject dimension2 : dimParam.getDimensionMap().values()) {
                DimUtils.queryItemLongNumber((Context)this.getCtx(), (IDimensionParameter)dimParam, (IDimensionBase)dimension2);
                DimUtils.transScenarioNumber((Context)this.getCtx(), (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimension2);
                DimUtils.transVersionNumber((Context)this.getCtx(), (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimension2);
                DimUtils.transMdxMemberNumber((Context)this.getCtx(), (IDimensionParameter)dimParam, (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dimension2);
            }
            if (!dimParam.getQuerys().isEmpty()) {
                int in = dimParam.getQuerys().size();
                for (int i = 0; i < in; ++i) {
                    queryData = (IQueryData)dimParam.getQuerys().get(i);
                    for (IDimension _dimension2 : queryData.getMbgDimMap().values()) {
                        MbgCubeUtils.queryItemLongNumber((Context)this.getCtx(), (IDimensionParameter)dimParam, (IDimension)_dimension2);
                        MbgCubeUtils.transScenarioNumber((Context)this.getCtx(), (Map)dimParam.getDataManager().getBgScenarioMap(), (IDimension)_dimension2);
                        MbgCubeUtils.transVersionNumber((Context)this.getCtx(), (Map)dimParam.getDataManager().getBgVersionMap(), (IDimension)_dimension2);
                        MbgCubeUtils.transBgPeriodMember((Context)this.getCtx(), (IDimensionParameter)dimParam, (IDimension)_dimension2, (boolean)false);
                    }
                }
            }
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            logger.error((Object)"transParameter error! sql:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        dimParam.getControlManager().setBizCalc(false);
        return dimParam;
    }

    public void filterExecuteMember(Map<String, Set<String>> executeDimData, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        if (executeDimData != null && executeDimData.get(dimension.getField()) != null) {
            Set<String> executeDimMember = executeDimData.get(dimension.getField());
            List dimensionMember = dimension.getDimensionMember();
            IMember member = null;
            String number = null;
            Iterator iter = dimensionMember.iterator();
            while (iter.hasNext()) {
                member = (IMember)iter.next();
                number = member.getNumber();
                if (executeDimMember.contains(number)) continue;
                iter.remove();
            }
        }
    }

    protected void putCalcMember(IDimensionParameter dimParam, List<ICalcMember> members) {
        if (dimParam == null || members == null || members.isEmpty()) {
            return;
        }
        for (ICalcMember member : members) {
            if (!(member instanceof BizCalcMember)) continue;
            this.putCalcMember(dimParam, (BizCalcMember)member);
        }
    }

    protected void putCalcMember(IDimensionParameter dimParam, BizCalcMember calcMember) {
        if (dimParam == null || calcMember == null) {
            return;
        }
        String[] tmpStrs = null;
        IExpress expr = null;
        List<IExpress> express = null;
        BizCalcSubsetInfo subCalc = null;
        BizScopeInfo scope = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        MemberObject member = null;
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        Set<String> filter = null;
        Map variateMap = dimParam.getDataManager().getVariate();
        List dims = dimParam.getDims();
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dims.get(i);
            if (filterMap.containsKey(dimension.getField())) {
                filter = (Set)filterMap.get(dimension.getField());
            } else {
                filter = new HashSet();
                filterMap.put(dimension.getField(), filter);
            }
            int jn = dimension.getDimensionMember().size();
            for (int j = 0; j < jn; ++j) {
                filter.add(((IMember)dimension.getDimensionMember().get(j)).getDimNumber());
            }
        }
        Map executeDimData = dimParam.getExecuteDimData();
        Set executeSet = null;
        int in2 = calcMember.getCalc().getBizCalcSubset().size();
        for (int i = 0; i < in2; ++i) {
            int j;
            int jn;
            subCalc = calcMember.getCalc().getBizCalcSubset().get(i);
            if (!subCalc.getScope().isEmpty()) {
                jn = subCalc.getScope().size();
                for (j = 0; j < jn; ++j) {
                    scope = subCalc.getScope().get(j);
                    if (scope.getBgMemberType() == BizConstants.BIZ_BGORGUNIT_TYPE_VALUE) continue;
                    if (executeDimData != null && !executeDimData.isEmpty()) {
                        executeSet = (Set)executeDimData.get(scope.getRefField());
                    }
                    if ((dimension = dimParam.getDimension(scope.getRefField())) == null) continue;
                    if (filterMap.containsKey(dimension.getField())) {
                        filter = (Set)filterMap.get(dimension.getField());
                    } else {
                        filter = new HashSet();
                        filterMap.put(dimension.getField(), filter);
                    }
                    int valueType = scope.getBizDataType().getValue();
                    if (valueType == 1) {
                        if (0 != scope.getFillType().getValue() || StringUtils.isEmpty((String)scope.getBgMemberNum()) || executeSet != null && !executeSet.contains(scope.getBgMemberNum()) || (tmpStrs = scope.getBgMemberNum().split(":")) == null) continue;
                        member = new MemberObject();
                        if (tmpStrs.length > 1) {
                            member.setSrcNumber(tmpStrs[0]);
                            member.setNumber(tmpStrs[1]);
                        } else {
                            member.setNumber(tmpStrs[0]);
                        }
                        if (filter.contains(member.getDimNumber())) continue;
                        filter.add(member.getDimNumber());
                        dimension.addMember((IMember)member);
                        continue;
                    }
                    if (valueType != 2 || variateMap == null || !variateMap.containsKey(scope.getBgMemberNum())) continue;
                    String dimNumber = (String)variateMap.get(scope.getBgMemberNum());
                    if (executeSet != null && !executeSet.contains(dimNumber) || StringUtils.isEmpty((String)dimNumber) || (tmpStrs = dimNumber.split(":")) == null) continue;
                    member = new MemberObject();
                    if (tmpStrs.length > 1) {
                        member.setSrcNumber(tmpStrs[0]);
                        member.setNumber(tmpStrs[1]);
                    } else {
                        member.setNumber(tmpStrs[0]);
                    }
                    if (filter.contains(member.getDimNumber())) continue;
                    filter.add(member.getDimNumber());
                    dimension.addMember((IMember)member);
                }
            }
            try {
                express = subCalc.getExpres();
                if (express == null) continue;
                jn = express.size();
                for (j = 0; j < jn; ++j) {
                    expr = express.get(j);
                    if (expr == null) continue;
                    if (expr instanceof BinaryExpr) {
                        this.putCalcMember(dimParam, (BinaryExpr)expr, filterMap);
                        continue;
                    }
                    if (!(expr instanceof ConditionExpr)) continue;
                    this.putCalcMember(dimParam, (ConditionExpr)expr, filterMap);
                }
                continue;
            }
            catch (ParseException ex) {
                logger.error((Object)"parse script Error:", (Throwable)ex);
            }
        }
    }

    protected void putCalcMember(IDimensionParameter dimParam, BinaryExpr expr, Map<String, Set<String>> filterMap) {
        VariateExpr variateExpr;
        MdxMemberExpr mdxMember;
        if (dimParam == null || expr == null) {
            return;
        }
        if (expr.left instanceof MdxMemberExpr) {
            mdxMember = (MdxMemberExpr)expr.left;
            this.putCalcMember(dimParam, mdxMember, filterMap);
        } else if (expr.left instanceof VariateExpr) {
            variateExpr = (VariateExpr)expr.left;
            if (variateExpr.expr != null) {
                this.putCalcMember(dimParam, variateExpr.expr, filterMap);
            }
        }
        if (expr.right instanceof BinaryExpr) {
            this.putCalcMember(dimParam, (BinaryExpr)expr.right, filterMap);
        } else if (expr.right instanceof MdxMemberExpr) {
            mdxMember = (MdxMemberExpr)expr.right;
            this.putCalcMember(dimParam, mdxMember, filterMap);
        } else if (expr.right instanceof VariateExpr) {
            variateExpr = (VariateExpr)expr.right;
            if (variateExpr.expr != null) {
                this.putCalcMember(dimParam, variateExpr.expr, filterMap);
            }
        }
    }

    protected void putCalcMember(IDimensionParameter dimParam, ConditionExpr conditionExpr, Map<String, Set<String>> filterMap) {
        if (dimParam == null || conditionExpr == null) {
            return;
        }
        IExpress expr = null;
        List<IExpress> expres = conditionExpr.getAllExpresss();
        int in = expres.size();
        for (int i = 0; i < in; ++i) {
            expr = expres.get(i);
            if (expr instanceof BinaryExpr) {
                this.putCalcMember(dimParam, (BinaryExpr)expr, filterMap);
                continue;
            }
            if (!(expr instanceof ConditionExpr)) continue;
            this.putCalcMember(dimParam, (ConditionExpr)expr, filterMap);
        }
    }

    protected void putCalcMember(IDimensionParameter dimParam, MdxMemberExpr expr, Map<String, Set<String>> filterMap) {
        if (dimParam == null || expr == null || expr.params == null) {
            return;
        }
        IExpress memberExpr = null;
        MemberObject member = null;
        Map executeDimData = dimParam.getExecuteDimData();
        Set executeSet = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            memberExpr = expr.params.get(i);
            if (memberExpr instanceof MemberExpr) {
                memberExpr = (MemberExpr)memberExpr;
                if (((MemberExpr)memberExpr).field == null) {
                    ((MemberExpr)memberExpr).field = (String)dimParam.getDataManager().getSrcFieldMap().get(((MemberExpr)memberExpr).srcNumber);
                }
                member = new MemberObject();
                member.setSrcNumber(((MemberExpr)memberExpr).srcNumber);
                member.setNumber(((MemberExpr)memberExpr).number);
                if (executeDimData != null && !executeDimData.isEmpty()) {
                    executeSet = (Set)executeDimData.get(((MemberExpr)memberExpr).field);
                }
                if (executeSet != null && !executeSet.contains(((MemberExpr)memberExpr).number)) continue;
                this.putCalcMember(dimParam, ((MemberExpr)memberExpr).field, (IMember)member, filterMap);
                continue;
            }
            if (!(memberExpr instanceof FunctionExpr)) continue;
            memberExpr = (FunctionExpr)memberExpr;
        }
    }

    protected void putCalcMember(IDimensionParameter dimParam, String field, IMember member, Map<String, Set<String>> filterMap) {
        if (dimParam == null || field == null || member == null || filterMap == null) {
            return;
        }
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = dimParam.getDimension(field);
        if (dimension != null) {
            Set<Object> filter = null;
            if (filterMap.containsKey(dimension.getField())) {
                filter = filterMap.get(dimension.getField());
            } else {
                filter = new HashSet();
                filterMap.put(dimension.getField(), filter);
            }
            if (!filter.contains(member.getDimNumber())) {
                filter.add(member.getDimNumber());
                dimension.addMember(member);
            }
        }
    }

    @Override
    public Map<String, Map<String, ICalcData>> transResult(IDimensionParameter parameter, Map<String, Map<String, IBgNData>> result) {
        HashMap<String, Map<String, ICalcData>> calcDataMap = new HashMap<String, Map<String, ICalcData>>();
        if (parameter == null || result == null || result.isEmpty()) {
            return calcDataMap;
        }
        Map scenObjMap = parameter.getDataManager().getBgScenarioMap();
        Object scenario = null;
        Map verNumInnMap = (Map)parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD);
        Map scenNumInnMap = (Map)parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
        boolean type = false;
        String orgUnitId = null;
        Object var10_10 = null;
        BizCalcData calcData = null;
        Map<String, IBgNData> dataMap = null;
        Map<String, BizCalcData> calcMap = null;
        Map.Entry<String, Map<String, IBgNData>> entry22 = null;
        for (Map.Entry<String, Map<String, IBgNData>> entry22 : result.entrySet()) {
            orgUnitId = entry22.getKey();
            dataMap = entry22.getValue();
            if (dataMap.isEmpty()) continue;
            if (calcDataMap.containsKey(orgUnitId)) {
                calcMap = (Map)calcDataMap.get(orgUnitId);
            } else {
                calcMap = new HashMap();
                calcDataMap.put(orgUnitId, calcMap);
            }
            for (BgNDataInfo bgNDataInfo : dataMap.values()) {
                calcData = new BizCalcData();
                calcData.setFormula(bgNDataInfo.getFormula());
                calcData.setDimNumber(bgNDataInfo.getBgItemNumber());
                calcData.setBgPeriodNumber(bgNDataInfo.getBgPeriodNumber());
                calcData.setBgElementNumber(bgNDataInfo.getBgElementNumber());
                calcData.setBgScenarioNumber(bgNDataInfo.getBgScenario());
                calcData.setBgScenario(Integer.valueOf((String)scenNumInnMap.get(calcData.getBgScenarioNumber())));
                calcData.setBgVersionNumber(bgNDataInfo.getBgVersion());
                calcData.setBgVersion(Integer.valueOf((String)verNumInnMap.get(calcData.getBgVersionNumber())));
                calcData.setCurrencyNumber(bgNDataInfo.getCurrencyNumber());
                calcData.setValue(DimUtils.getValue((IBgNData)bgNDataInfo, (int)this.getParameter().getValueType(), (Map)scenObjMap));
                calcData.setBgDataSource(bgNDataInfo.getBgDataSource());
                calcMap.put(calcData.getDimDataKey(), calcData);
            }
        }
        return calcDataMap;
    }

    public Map<String, Map<String, Map<String, ICalcData>>> transMultiResult(IDimensionParameter parameter, Map<String, Map<String, Map<String, IBgNData>>> result) {
        HashMap<String, Map<String, Map<String, ICalcData>>> calcDataMap = new HashMap<String, Map<String, Map<String, ICalcData>>>();
        if (parameter == null || result == null || result.isEmpty()) {
            return calcDataMap;
        }
        Map scenObjMap = parameter.getDataManager().getBgScenarioMap();
        Object scenario = null;
        Map verNumInnMap = (Map)parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_VERSION_FIELD);
        Map scenNumInnMap = (Map)parameter.getDataManager().getNumInnMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
        BgOrgUnitInfo bgOrgUnitInfo = parameter.getDataManager().getBgOrgUnit();
        boolean type = false;
        String orgUnitId = null;
        String processType22 = null;
        Object var12_12 = null;
        BizCalcData calcData = null;
        Map<String, Map<String, IBgNData>> pDataMap = null;
        Map<String, IBgNData> dataMap = null;
        Map pCalcMap = null;
        Map<String, BizCalcData> calcMap = null;
        Map.Entry<String, Map<String, Map<String, IBgNData>>> entry22 = null;
        for (Map.Entry<String, Map<String, Map<String, IBgNData>>> entry22 : result.entrySet()) {
            orgUnitId = entry22.getKey();
            pDataMap = entry22.getValue();
            if (pDataMap.isEmpty()) continue;
            for (String processType22 : pDataMap.keySet()) {
                if (bgOrgUnitInfo != null && (bgOrgUnitInfo.isIsLeaf() && DimensionCommonHelper.isDecompose((BgProcessEnum)BgProcessEnum.getEnum((String)processType22)) || !bgOrgUnitInfo.isIsLeaf() && !DimensionCommonHelper.isDecompose((BgProcessEnum)BgProcessEnum.getEnum((String)processType22)))) continue;
                dataMap = pDataMap.get(processType22);
                if (calcDataMap.containsKey(processType22)) {
                    pCalcMap = (Map)calcDataMap.get(processType22);
                } else {
                    pCalcMap = new HashMap();
                    calcDataMap.put(processType22, pCalcMap);
                }
                if (pCalcMap.containsKey(orgUnitId)) {
                    calcMap = (Map)pCalcMap.get(orgUnitId);
                } else {
                    calcMap = new HashMap();
                    pCalcMap.put(orgUnitId, calcMap);
                }
                for (BgNDataInfo bgNDataInfo : dataMap.values()) {
                    calcData = new BizCalcData();
                    calcData.setFormula(bgNDataInfo.getFormula());
                    calcData.setDimNumber(bgNDataInfo.getBgItemNumber());
                    calcData.setBgPeriodNumber(bgNDataInfo.getBgPeriodNumber());
                    calcData.setBgElementNumber(bgNDataInfo.getBgElementNumber());
                    calcData.setBgScenarioNumber(bgNDataInfo.getBgScenario());
                    calcData.setBgScenario(Integer.valueOf((String)scenNumInnMap.get(calcData.getBgScenarioNumber())));
                    calcData.setBgVersionNumber(bgNDataInfo.getBgVersion());
                    calcData.setBgVersion(Integer.valueOf((String)verNumInnMap.get(calcData.getBgVersionNumber())));
                    calcData.setCurrencyNumber(bgNDataInfo.getCurrencyNumber());
                    calcData.setValue(DimUtils.getValue((IBgNData)bgNDataInfo, (int)this.getParameter().getValueType(), (Map)scenObjMap));
                    calcData.setBgDataSource(bgNDataInfo.getBgDataSource());
                    calcMap.put(calcData.getDimDataKey(), calcData);
                }
            }
        }
        return calcDataMap;
    }

    @Override
    public void updateResult(Map<String, Map<String, ICalcData>> result) throws Exception {
        if (this.getCtx() == null || this.getParameter() == null || result == null || result.isEmpty()) {
            return;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        String _userId = user != null ? user.getId().toString() : null;
        String _bgSchemeId = this.getParameter().getDataManager().getBgScheme().getId().toString();
        String _orgUnitId = this.getParameter().getOrgUnitId().toString();
        int dataType = DimensionConstants.DEFAULT_DATA_TYPE;
        if (this.getParameter().getValueType() == 64) {
            dataType = DimensionConstants.CFS_DATA_TYPE;
        } else if (this.getParameter().getValueType() == 16 || this.getParameter().getValueType() == 32 || this.getParameter().getValueType() == 2048) {
            dataType = DimensionConstants.ADDACTUAL_DATA_TYPE;
        } else if (this.getParameter().getValueType() == 256) {
            dataType = DimensionConstants.DECOMPOSE_DATA_TYPE;
        } else if (this.getParameter().getValueType() == 512) {
            dataType = DimensionConstants.DECOMPOSE_SENDDOWN_DATA_TYPE;
        } else if (this.getParameter().getValueType() == 1024) {
            dataType = DimensionConstants.DECOMPOSE_GATHER_DATA_TYPE;
        } else if (this.getParameter().getControlManager().isAdjust()) {
            dataType = DimensionConstants.ADJUST_DATA_TYPE;
        }
        IMbgDataFacade facade = MbgDataFacade.getInstance((Context)this.getCtx(), (String)_userId, (String)_bgSchemeId, (int)dataType, (boolean)this.isAudit);
        facade.setIgnoreDataState(true);
        facade.setCanRemoveData(false);
        if (this.getParameter().getBillId() != null) {
            facade.setBillId(this.getParameter().getBillId().toString());
            if (result.keySet().size() > 1) {
                facade.setBillId(null);
            }
        }
        if (this.getParameter().getUnionId() != null) {
            facade.setUnionId(this.getParameter().getUnionId().toString());
        }
        Map.Entry<String, Map<String, ICalcData>> entry2 = null;
        Map<String, ICalcData> calcMap = null;
        ICalcData calcData2 = null;
        for (Map.Entry<String, Map<String, ICalcData>> entry2 : result.entrySet()) {
            _orgUnitId = entry2.getKey();
            calcMap = entry2.getValue();
            for (ICalcData calcData2 : calcMap.values()) {
                facade.addMbgData(_orgUnitId, calcData2.getFormula(), calcData2.getBgVersionNumber(), calcData2.getValue(), calcData2.getBgDataSource());
            }
        }
        facade.submit();
    }

    public void setSaveDatas(List<ICalcData> saveDatas) {
        this.saveDatas = saveDatas;
    }

    public List<ICalcData> getSaveDatas() {
        return this.saveDatas;
    }

    public void setDimParam(IDimensionParameter dimParam) {
        this.dimParam = dimParam;
    }

    public IDimensionParameter getDimParam() {
        return this.dimParam;
    }

    @Override
    public void run() {
        this.updataCalcData();
    }

    public void updataCalcData() {
        if (this.getCtx() == null || this.getDimParam() == null || this.getSaveDatas() == null || this.getSaveDatas().isEmpty()) {
            return;
        }
        long ct = System.currentTimeMillis();
        logger.info((Object)"begin runBackUpdate!");
        try {
            MbgDataFacadeImpl facade = new MbgDataFacadeImpl();
            facade.setCtx(this.getCtx());
            facade.setValueType(this.getDimParam().getValueType());
            facade.setBgScheme(this.getDimParam().getDataManager().getBgScheme());
            facade.setOrgUnitId(this.getDimParam().getOrgUnitId());
            facade.setBillId(this.getDimParam().getBillId());
            facade.setAdjust(this.getDimParam().getControlManager().isAdjust());
            facade.setAudit(this.isAudit);
            if (this.getDimParam().getDataManager().getDimDataQuery() != null) {
                facade.setProcessType(this.getDimParam().getDataManager().getDimDataQuery().getProcessType() != null ? this.getDimParam().getDataManager().getDimDataQuery().getProcessType() : BgProcessEnum.C01);
            }
            BgSchemeInfo bgScheme = this.getDimParam().getDataManager().getBgScheme();
            if (this.getDimParam().getValueType() == 16 || this.getDimParam().getValueType() == 32 || this.getDimParam().getValueType() == 2048) {
                facade.setCubeName(BgCubeUtils.getDailyActualCubeName((String)bgScheme.getRefCube()));
                facade.setCubeEntryName(BgCubeUtils.getDailyActualEntryCubeName((String)bgScheme.getRefCube()));
            }
            List editScen = null;
            editScen = this.getDimParam().getValueType() == 16 || this.getDimParam().getValueType() == 32 || this.getDimParam().getValueType() == 2048 ? BgScenarioHelper.getAcScenario((Context)this.getCtx()) : BgScenarioHelper.getAllScenario((Context)this.getCtx());
            if (editScen != null) {
                String editScenStr = null;
                int in = editScen.size();
                for (int i = 0; i < in; ++i) {
                    editScenStr = i == 0 ? ((BgScenarioInfo)editScen.get(i)).getNumber() : editScenStr + "," + ((BgScenarioInfo)editScen.get(i)).getNumber();
                }
                facade.setEditScen(editScenStr);
            }
            for (ICalcData calcData : this.getSaveDatas()) {
                facade.addMbgData(calcData);
            }
            facade.save();
        }
        catch (Exception ex) {
            logger.error((Object)"biz clac save datas error:", (Throwable)ex);
        }
        logger.info((Object)("end runBackUpdate! use = " + (System.currentTimeMillis() - ct) + "ms."));
    }

    public void queryMembers(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        if (DimUtils.checkBaseDimensionByField((String)field) || DimensionConstants.DEF_CSL_FIELD.equals(field)) {
            this.queryBaseMember(conn, dimParam, dimension, field);
        } else {
            this.queryDefMember(conn, dimParam, dimension, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryDefMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        String dimNumber = null;
        String[] tmpStrs = null;
        IRowSet rst = null;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)dimParam.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            BgSchemeInfo bgSchemeInfo = dimParam.getDataManager().getBgScheme();
            BOSUuid memberId = null;
            if (bgSchemeInfo != null) {
                memberId = bgSchemeInfo.getViewId(dimension.getNumber());
                if (memberId == null) {
                    bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)this.ctx).getBgSchemeInfo("select * where id = '" + dimParam.getBgSchemeId().toString() + "'");
                    memberId = bgSchemeInfo.getViewId(dimension.getNumber());
                    dimParam.getDataManager().setBgScheme(bgSchemeInfo);
                }
            } else {
                bgSchemeInfo = BgSchemeFactory.getLocalInstance((Context)this.ctx).getBgSchemeInfo("select * where id = '" + dimParam.getBgSchemeId().toString() + "'");
                memberId = bgSchemeInfo.getViewId(dimension.getNumber());
                dimParam.getDataManager().setBgScheme(bgSchemeInfo);
            }
            if (dimension.getNumber() != null && dimension.getNumber().equals("BG_Account")) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select distinct " + field + " from " + dimParam.getDataManager().getBgScheme().getRefCube() + " where FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?) and " + field + " in(select concat('" + dimension.getSrcNumber() + ":',fnumber) from t_mbg_bgaccount )"), (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            } else {
                String ss = "select t3.ftable from T_MBG_MbgView t1 inner join T_MBG_MbgDim t2 on t2.fid=t1.fmbgdimid inner join t_mbg_bgvirtualview t3 on t1.fid=t3.fid where t2.fnumber = '" + dimension.getNumber() + "' and t1.FId = '" + memberId + "'";
                rst = BgDBUtils.executeQuery((Connection)conn, (String)ss);
                String tableName = null;
                if (rst.next()) {
                    tableName = rst.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rst);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select distinct " + field + " from " + dimParam.getDataManager().getBgScheme().getRefCube() + " where FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?) and " + field + " in (select fdimnumber from " + tableName + ")"), (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            }
            while (rst.next()) {
                dimNumber = rst.getString(1);
                if (StringUtils.isEmpty((String)dimNumber) || (tmpStrs = dimNumber.split(":")) == null || tmpStrs.length <= 1) continue;
                member = new MemberObject();
                member.setNumber(tmpStrs[1]);
                member.setSrcNumber(tmpStrs[0]);
                dimension.addMember((IMember)member);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"queryDefMember error: ", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
    }

    private void queryBaseMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        if (DimensionConstants.DEF_PERIOD_FIELD.equals(field)) {
            this.queryPeriodMember(conn, dimParam, dimension, field);
        } else if (DimensionConstants.DEF_SCENARIO_FIELD.equals(field)) {
            this.queryScenarioMember(conn, dimParam, dimension, field);
        } else if (DimensionConstants.DEF_VERSION_FIELD.equals(field)) {
            this.queryVersionMember(conn, dimParam, dimension, field);
        } else if (DimensionConstants.DEF_ELEMENT_FIELD.equals(field)) {
            this.queryElementMember(conn, dimParam, dimension, field);
        } else if (DimensionConstants.DEF_CURRENCY_FIELD.equals(field)) {
            this.queryCurrencyMember(conn, dimParam, dimension, field);
        } else if (DimensionConstants.DEF_CSL_FIELD.equals(field)) {
            this.queryCslMember(conn, dimParam, dimension, field);
        }
    }

    private void queryCslMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        member = new MemberObject();
        member.setNumber("CSL-01");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-02");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-03");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-04");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-05");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-06");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-07");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
        member = new MemberObject();
        member.setNumber("CSL-08");
        member.setSrcNumber(DimensionConstants.DEF_CSL_SRCNUMBER);
        dimension.getDimensionMember().add(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryPeriodMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        IRowSet rst = null;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)dimParam.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            String cubeName = BgCubeUtils.getCubeName((String)dimParam.getDataManager().getBgScheme().getRefCube(), (int)dimParam.getValueType());
            String sql = null;
            sql = dimParam.getUnionId() != null ? "select distinct t.FNumber from T_MBG_BgPeriod t left join " + cubeName + " d on t.FID = d.FBgPeriodId where d.FOrgUnitId = ?" : "select distinct t.FNumber from T_MBG_BgPeriod t left join " + cubeName + " d on t.FID = d.FBgPeriodId where d.FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)";
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"queryDefMember error: ", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryScenarioMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        IRowSet rst = null;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)dimParam.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            String cubeName = BgCubeUtils.getCubeName((String)dimParam.getDataManager().getBgScheme().getRefCube(), (int)dimParam.getValueType());
            String sql = null;
            sql = dimParam.getUnionId() != null ? "select distinct t.FNumber from T_MBG_BgScenario t left join " + cubeName + " d on t.FSCENARIOID = d.FScenario where d.FOrgUnitId  = ?" : "select distinct t.FNumber from T_MBG_BgScenario t left join " + cubeName + " d on t.FSCENARIOID = d.FScenario where d.FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)";
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"queryDefMember error: ", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryVersionMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        IRowSet rst = null;
        boolean hasVersion = false;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)dimParam.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            String cubeName = BgCubeUtils.getCubeName((String)dimParam.getDataManager().getBgScheme().getRefCube(), (int)dimParam.getValueType());
            String sql = null;
            sql = dimParam.getUnionId() != null ? "select distinct t.FNumber from T_MBG_BgVersion t left join " + cubeName + " d on t.FVERSIONID = d.FVersion where d.FOrgUnitId = ?" : "select distinct t.FNumber from T_MBG_BgVersion t left join " + cubeName + " d on t.FVERSIONID = d.FVersion where d.FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)";
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
                hasVersion = true;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"queryDefMember error: ", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        if (!hasVersion) {
            this.queryBgFormVersionMember(conn, dimParam, dimension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryBgFormVersionMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        if (conn == null || dimParam == null || dimension == null || dimParam.getCalcIds().isEmpty()) {
            return;
        }
        List calcIds = dimParam.getCalcIds();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct v1.FNUMBER   FROM  T_MBG_BgVersion v1  join  T_MBG_BGFORM f1 on f1.FBGVERSIONID  = v1.FID  where f1.FBGTEMPLATEID  in (SELECT FBGTEMPLATEID  FROM T_MBG_BizRefBgTemplate where FBIZCALCID in (");
        for (BOSUuid calcId : calcIds) {
            sql.append("'" + calcId.toString() + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")) ");
        IRowSet rst = null;
        MemberObject member = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"queryDefMember error: ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryElementMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        IRowSet rst = null;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)dimParam.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            String cubeName = BgCubeUtils.getCubeName((String)dimParam.getDataManager().getBgScheme().getRefCube(), (int)dimParam.getValueType());
            String sql = null;
            sql = dimParam.getUnionId() != null ? "select distinct t.FNumber from T_MBG_BgElement t left join " + cubeName + " d on t.FID = d.FBgElementId where d.FOrgUnitId = ?" : "select distinct t.FNumber from T_MBG_BgElement t left join " + cubeName + " d on t.FID = d.FBgElementId where d.FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)";
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"queryDefMember error: ", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryCurrencyMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension, String field) {
        if (conn == null || dimParam == null || dimension == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        MemberObject member = null;
        IRowSet rst = null;
        boolean hasCurrency = false;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)dimParam.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            String cubeName = BgCubeUtils.getCubeName((String)dimParam.getDataManager().getBgScheme().getRefCube(), (int)dimParam.getValueType());
            String sql = null;
            sql = dimParam.getUnionId() != null ? "select distinct t.FNumber from T_BD_Currency t left join " + cubeName + " d on t.FID = d.FCurrencyId where d.FOrgUnitId  = ?" : "select distinct t.FNumber from T_BD_Currency t left join " + cubeName + " d on t.FID = d.FCurrencyId where d.FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)";
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{dimParam.getOrgUnitId().toString()});
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
                hasCurrency = true;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception ex) {
            logger.error((Object)"queryDefMember error: ", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        if (!hasCurrency) {
            this.queryBgFormCurrencyMember(conn, dimParam, dimension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryBgFormCurrencyMember(Connection conn, IDimensionParameter dimParam, com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension) {
        if (conn == null || dimParam == null || dimension == null || dimParam.getCalcIds().isEmpty()) {
            return;
        }
        List calcIds = dimParam.getCalcIds();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct c1.FNUMBER   FROM  T_BD_CURRENCY c1  join  T_MBG_BGFORM f1 on f1.FCURRENCYID  = c1.FID  where f1.FBGTEMPLATEID  in (SELECT FBGTEMPLATEID  FROM T_MBG_BizRefBgTemplate where FBIZCALCID in (");
        for (BOSUuid calcId : calcIds) {
            sql.append("'" + calcId.toString() + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")) ");
        IRowSet rst = null;
        MemberObject member = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                member = new MemberObject();
                member.setNumber(rst.getString(1));
                dimension.getDimensionMember().add(member);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"queryDefMember error: ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        SQLUtils.cleanup((ResultSet)rst);
    }
}

