/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr;

import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.util.StringUtils;

public class FormulaProxy {
    public static final String FORMULA_START_TAG = "GVF:[";
    public static final String FORMULA_END_TAG = "]";

    public static boolean isFormula(String formulaStr) {
        return FormulaProxy.verify(formulaStr);
    }

    public static FormulaExpr parse(String formulaStr) throws ParseException {
        return FormulaProxy.getFormulaExpr(formulaStr);
    }

    public static boolean verify(String formulaStr) {
        boolean check = false;
        if (StringUtils.isEmpty((String)formulaStr)) {
            return check;
        }
        String _formulaStr = formulaStr.trim();
        if (_formulaStr.startsWith(FORMULA_START_TAG) && _formulaStr.endsWith(FORMULA_END_TAG)) {
            _formulaStr = _formulaStr.substring(FORMULA_START_TAG.length(), _formulaStr.length() - FORMULA_END_TAG.length());
            Expression express = null;
            try {
                express = ExcelFormulaPaserHelper.parse((String)_formulaStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (express != null) {
                check = true;
            }
        }
        return check;
    }

    public static FormulaExpr getFormulaExpr(String formulaStr) {
        if (!FormulaProxy.verify(formulaStr)) {
            return null;
        }
        FormulaExpr expr = new FormulaExpr();
        String _str = formulaStr.trim().substring(5);
        _str = _str.substring(0, _str.length() - 1);
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)_str);
            if (expression instanceof FunctionExpr) {
                expr.formulaName = ((FunctionExpr)expression).funcionName;
                expr.params = ((FunctionExpr)expression).parameters;
            }
        }
        catch (Exception e) {
            expr = null;
        }
        return expr;
    }
}

