/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr;

import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.CalcExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperandExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.expr.oper.NotOper;
import com.kingdee.eas.ma.biz.expr.oper.SubOper;
import java.util.List;
import java.util.Stack;

public class MbgExprParse {
    private final List tokens;

    public MbgExprParse(List tokens) {
        this.tokens = tokens;
    }

    public IExpress parse() throws ParseException {
        if (this.tokens == null || this.tokens.isEmpty()) {
            return null;
        }
        Stack<CalcExpr> stack = new Stack<CalcExpr>();
        int in = this.tokens.size();
        for (int i = 0; i < in; ++i) {
            Object obj = this.tokens.get(i);
            if (obj instanceof AbstractOper) {
                this.buildBinaryOp(stack, (AbstractOper)obj);
                continue;
            }
            if (obj instanceof FunctionExpr) {
                FunctionExpr funExpr = (FunctionExpr)obj;
                stack.push(funExpr);
                continue;
            }
            if (obj instanceof MdxMemberExpr) {
                MdxMemberExpr memExpr = (MdxMemberExpr)obj;
                stack.push(memExpr);
                continue;
            }
            if (!(obj instanceof CalcExpr)) continue;
            CalcExpr calcExpr = (CalcExpr)obj;
            stack.push(calcExpr);
        }
        return (IExpress)stack.pop();
    }

    private void buildBinaryOp(Stack stack, AbstractOper operType) throws ParseException {
        BinaryExpr be = new BinaryExpr(operType);
        if (stack.isEmpty()) {
            throw new ParseException(" cannot Parse, sorry ");
        }
        be.right = (IExpress)stack.pop();
        if (stack.isEmpty()) {
            if (operType instanceof SubOper) {
                if (!(be.right instanceof OperandExpr)) {
                    throw new ParseException(" cannot Parse, sorry ");
                }
            } else if (!(operType instanceof NotOper) && !(operType instanceof SubOper)) {
                throw new ParseException(" cannot Parse, sorry ");
            }
        } else {
            be.left = (IExpress)stack.pop();
        }
        stack.push(be);
    }
}

