/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr;

import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.util.StringUtils;

public class VariateProxy {
    private static final String VARIATE_EXPR_TAG = "VAR:\\[(\"|\\w|.)+\\]";
    private static final String VARIATE_TAG_BEGIN = "VAR:\\[\"";
    private static final String VARIATE_TAG_END = "\"\\]";

    public static boolean isVariate(String variateStr) {
        return VariateProxy.verify(variateStr);
    }

    public static VariateExpr parse(String mdxMemberStr) throws ParseException {
        return VariateProxy.getVariateExpr(mdxMemberStr);
    }

    public static boolean verify(String variateStr) {
        if (StringUtils.isEmpty((String)variateStr)) {
            return false;
        }
        return variateStr.trim().matches(VARIATE_EXPR_TAG);
    }

    public static VariateExpr getVariateExpr(String variateStr) {
        if (!VariateProxy.verify(variateStr)) {
            return null;
        }
        VariateExpr expr = new VariateExpr();
        expr.setOriginalExpr(variateStr);
        expr.name = variateStr.trim().replaceFirst(VARIATE_TAG_BEGIN, "").replaceFirst(VARIATE_TAG_END, "");
        return expr;
    }
}

