/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse;

import com.kingdee.eas.ma.biz.ParseException;
import java.util.ArrayList;
import java.util.List;

public final class Parse2Expr {
    private String script = null;
    private int point = 0;
    private int length = 0;
    private char look;
    private List<String> exprs = new ArrayList<String>();
    private static final char STACK_OPERATOR = '\u0000';
    private static final char TAB = '\t';
    private static final char ENTER = '\r';
    private static final char LINE_FEED = '\n';
    private static final char SEMICOLON = ';';

    public List<String> getExprs() {
        return this.exprs;
    }

    public void parse(String script) throws ParseException {
        this.init(script);
        while (this.look != '\u0000') {
            this.readScript();
            this.getChar();
        }
    }

    private void init(String script) {
        this.exprs.clear();
        if (script != null && script.trim().length() > 0) {
            this.script = script.trim();
            this.point = 0;
            this.length = this.script.length();
        }
        this.getChar();
    }

    private void getChar() {
        if (this.point == this.length) {
            this.look = '\u0000';
            return;
        }
        this.look = this.script.charAt(this.point++);
    }

    private void readScript() {
        String script = "";
        int count = 0;
        boolean isAcct = false;
        boolean isMbgRefBgTem = false;
        int index = 0;
        String convertScript = "";
        while ((!this.isSemicolon(this.look) || count != 0 || isAcct || isMbgRefBgTem) && this.look != '\u0000') {
            char quo;
            if (!this.isOther(this.look)) {
                if (this.look == '{') {
                    ++count;
                }
                if (this.look == '}') {
                    --count;
                }
                script = script + this.look;
                convertScript = convertScript + this.look;
            }
            if (convertScript.contains("Acct")) {
                isAcct = true;
                quo = '\"';
                if (quo == this.look) {
                    ++index;
                }
                if (index > 1) {
                    isAcct = false;
                    index = 0;
                    convertScript = "";
                }
            }
            if (convertScript.toUpperCase().contains("MbgRefBgTem".toUpperCase())) {
                isMbgRefBgTem = true;
                quo = '\"';
                if (quo == this.look) {
                    ++index;
                }
                if (index > 1) {
                    isMbgRefBgTem = false;
                    index = 0;
                    convertScript = "";
                }
            }
            this.getChar();
        }
        if (script != null && script.trim().length() > 0) {
            this.exprs.add(script.trim());
        }
    }

    private boolean isSemicolon(char c) {
        return ';' == c;
    }

    private boolean isOther(char c) {
        return '\t' == c || '\r' == c || '\n' == c;
    }
}

