/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse;

import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.FormulaProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.FunctionProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParse;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MemberProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.VariateProxy;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.OperandExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.IParseExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.parse.Parse2Cond;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.expr.oper.AddOper;
import com.kingdee.eas.ma.biz.expr.oper.AndOper;
import com.kingdee.eas.ma.biz.expr.oper.AssignmentOper;
import com.kingdee.eas.ma.biz.expr.oper.DivOper;
import com.kingdee.eas.ma.biz.expr.oper.EqualOper;
import com.kingdee.eas.ma.biz.expr.oper.GreaterEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.GreaterThanOper;
import com.kingdee.eas.ma.biz.expr.oper.LeftParentheses;
import com.kingdee.eas.ma.biz.expr.oper.LessEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.LessthanOper;
import com.kingdee.eas.ma.biz.expr.oper.ModOper;
import com.kingdee.eas.ma.biz.expr.oper.MultiplyOper;
import com.kingdee.eas.ma.biz.expr.oper.NotEqualOper;
import com.kingdee.eas.ma.biz.expr.oper.NotOper;
import com.kingdee.eas.ma.biz.expr.oper.OperationType;
import com.kingdee.eas.ma.biz.expr.oper.OrOper;
import com.kingdee.eas.ma.biz.expr.oper.SubOper;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Stack;

public final class Parse2RPN
implements IParseExpr {
    public boolean isCheckNameExpr = true;
    private String formulaStr = null;
    private int point = 0;
    private int length = 0;
    private char look;
    private List operand = new Stack();
    private List operator = new Stack();
    private static final char STACK_OPERATOR = '\u0000';
    private static final char TAB = '\t';
    private static final char ENTER = '\r';
    private static final char LINE_FEED = '\n';
    private static final char WHITE = ' ';
    private static final char FUNCTION_OPERATOR = '@';
    private static final char[] OPERATIONS = new char[]{'+', '-', '*', '/', '=', '<', '>'};

    public Parse2RPN(String formulaStr) throws ParseException {
        if (formulaStr == null || formulaStr.trim().length() == 0) {
            this.Expected(" formulaStr is null!");
        } else {
            this.formulaStr = formulaStr.trim();
            this.point = 0;
            this.length = this.formulaStr.length();
        }
    }

    @Override
    public void parse() throws ParseException {
        this.init();
        while (this.look != '\u0000') {
            boolean isTeam = this.team();
            if (this.isOperation(this.look) || this.look == '(' || this.look == ')') {
                this.readOperation(this.look);
                continue;
            }
            if (isTeam) continue;
            this.Expected(this.look + "");
        }
        this.pushS22S1();
    }

    @Override
    public List getTokens() {
        return this.operand;
    }

    @Override
    public IExpress getExpr() throws ParseException {
        MbgExprParse p2 = new MbgExprParse(this.getTokens());
        return p2.parse();
    }

    private void init() {
        this.getChar();
    }

    private void getChar() {
        if (this.point == this.length) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaStr.charAt(this.point++);
        this.look = this.toDBC(this.look);
    }

    private char toDBC(char c) {
        int _char = c;
        if (_char == 12288) {
            _char = 32;
        } else if (_char > 65280 && _char < 65375) {
            _char = (char)(_char - 65248);
        } else {
            switch (_char) {
                case 65285: {
                    _char = 37;
                    break;
                }
                case 65286: {
                    _char = 38;
                    break;
                }
                case 65288: {
                    _char = 40;
                    break;
                }
                case 65289: {
                    _char = 41;
                    break;
                }
                case 65290: {
                    _char = 42;
                    break;
                }
                case 65291: {
                    _char = 43;
                    break;
                }
                case 65292: {
                    _char = 44;
                    break;
                }
                case 65293: {
                    _char = 45;
                    break;
                }
                case 65294: {
                    _char = 46;
                    break;
                }
                case 65295: {
                    _char = 47;
                    break;
                }
                case 65306: {
                    _char = 58;
                    break;
                }
                case 65307: {
                    _char = 59;
                    break;
                }
                case 65308: {
                    _char = 60;
                    break;
                }
                case 65309: {
                    _char = 61;
                    break;
                }
                case 65310: {
                    _char = 62;
                    break;
                }
                case 65312: {
                    _char = 64;
                    break;
                }
                case 65339: {
                    _char = 91;
                    break;
                }
                case 65341: {
                    _char = 93;
                    break;
                }
                case 65343: {
                    _char = 95;
                    break;
                }
                case 65371: {
                    _char = 123;
                    break;
                }
                case 65372: {
                    _char = 124;
                    break;
                }
                case 65373: {
                    _char = 125;
                }
            }
        }
        return (char)_char;
    }

    private void match(char x) throws ParseException {
        if (this.look != x) {
            this.Expected("" + x + "");
        } else {
            this.getChar();
            this.SkipWhite();
        }
    }

    private void Expected(String c) throws ParseException {
        throw new ParseException(" cannot Parse, sorry : " + c);
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '@';
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean isNumeric(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        int in = str.length();
        for (int i = 0; i < in; ++i) {
            char _char = str.charAt(i);
            if (this.isDigit(_char) || '.' == _char || '%' == _char) continue;
            return false;
        }
        return this.checkNumeric(str);
    }

    private boolean checkNumeric(String str) {
        if (str != null) {
            return str.matches("\\-?([\\d]+\\.)?[\\d]+%?");
        }
        return false;
    }

    private boolean isAlphanumeric(char c) {
        return this.IsAlpha(c) || this.isDigit(c);
    }

    private boolean isOperation(char c) {
        for (char tmpChar : OPERATIONS) {
            if (tmpChar != c) continue;
            return true;
        }
        return false;
    }

    private boolean isLogicOper(String c) {
        String _c = c.trim();
        return this.isAnd(_c) || this.isNot(_c) || this.isOr(_c);
    }

    private boolean isAnd(String c) {
        return "AND".equalsIgnoreCase(c);
    }

    private void and() throws ParseException {
        this.pushCheck2S2(new AndOper());
    }

    private boolean isNot(String c) {
        return "NOT".equalsIgnoreCase(c);
    }

    private void not() throws ParseException {
        this.pushCheck2S2(new NotOper());
    }

    private boolean isOr(String c) {
        return "OR".equalsIgnoreCase(c);
    }

    private void or() throws ParseException {
        this.pushCheck2S2(new OrOper());
    }

    private boolean isIf(char c) {
        return 'I' == c;
    }

    private boolean isFunction(char c) {
        return '@' == c;
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.getChar();
        }
    }

    private void push2S2(AbstractOper oper) {
        ((Stack)this.operator).push(oper);
    }

    private void pushCheck2S2(AbstractOper oper) {
        if (this.operator.isEmpty()) {
            ((Stack)this.operator).push(oper);
        } else {
            AbstractOper _oper = null;
            while (!this.operator.isEmpty()) {
                _oper = (AbstractOper)((Stack)this.operator).pop();
                if (_oper.getSID() == 1 || OperationType.comparePRI(oper.getSID(), _oper.getSID()) > 0) {
                    ((Stack)this.operator).push(_oper);
                    ((Stack)this.operator).push(oper);
                    break;
                }
                ((Stack)this.operand).push(_oper);
            }
            if (this.operator.isEmpty()) {
                ((Stack)this.operator).push(oper);
            }
        }
    }

    private void pushS22S1() {
        AbstractOper _oper = null;
        while (!this.operator.isEmpty()) {
            _oper = (AbstractOper)((Stack)this.operator).pop();
            ((Stack)this.operand).push(_oper);
        }
    }

    private void pushS22S1ByRightP() {
        AbstractOper _oper = null;
        while (!this.operator.isEmpty() && 1 != (_oper = (AbstractOper)((Stack)this.operator).pop()).getSID()) {
            ((Stack)this.operand).push(_oper);
        }
    }

    private void add() throws ParseException {
        this.match('+');
        this.pushCheck2S2(new AddOper());
    }

    private void sub() throws ParseException {
        this.match('-');
        this.pushCheck2S2(new SubOper());
    }

    private void div() throws ParseException {
        this.match('/');
        this.pushCheck2S2(new DivOper());
    }

    private void mod() throws ParseException {
        this.match('%');
        this.pushCheck2S2(new ModOper());
    }

    private void multiply() throws ParseException {
        this.match('*');
        this.pushCheck2S2(new MultiplyOper());
    }

    private void assignment() throws ParseException {
        this.match('=');
        if (this.look == '=') {
            this.equal();
        } else {
            this.pushCheck2S2(new AssignmentOper());
        }
    }

    private void equal() throws ParseException {
        this.match('=');
        this.pushCheck2S2(new EqualOper());
    }

    private void leftParentheses() throws ParseException {
        this.match('(');
        this.push2S2(new LeftParentheses());
    }

    private void rightParentheses() throws ParseException {
        this.match(')');
        this.pushS22S1ByRightP();
    }

    private String readNumber() throws ParseException {
        if (!this.isDigit(this.look)) {
            this.Expected(" read Number error!");
        }
        String number = "";
        while (this.isDigit(this.look) || this.look == '.') {
            number = number + this.look;
            this.getChar();
        }
        return number;
    }

    private void readFunction() throws ParseException {
        String functionStr = this.getFunction();
        FunctionExpr funExpr = this.checkHasFunction(functionStr);
        if (funExpr != null) {
            this.operand.add(funExpr);
        } else {
            this.Expected(" error function!" + functionStr);
        }
    }

    private String getFunction() throws ParseException {
        if (!this.isFunction(this.look)) {
            this.Expected(" read function error!");
        }
        int count = 0;
        String function = "";
        while (!(this.isOperation(this.look) && count == 0 || this.look == '\u0000')) {
            if (this.look == '(') {
                ++count;
            }
            if (this.look == ')') {
                --count;
            }
            if (count < 0) break;
            function = function + this.look;
            this.getChar();
        }
        this.SkipWhite();
        return function;
    }

    private void readIf() throws ParseException {
        String functionStr = this.getIf();
        ConditionExpr funExpr = this.checkHasIf(functionStr);
        if (funExpr != null) {
            this.operand.add(funExpr);
        } else {
            this.Expected(" error If!" + functionStr);
        }
    }

    private ConditionExpr checkHasIf(String functionStr) throws ParseException {
        Parse2Cond parse = new Parse2Cond(functionStr);
        parse.parse();
        return (ConditionExpr)parse.getExpr();
    }

    private String getIf() throws ParseException {
        if (!this.isIf(this.look)) {
            this.Expected(" read if error!");
        }
        int countLeft = 0;
        int counRight = 0;
        StringBuffer formulaStr = new StringBuffer();
        while (this.look != '\u0000') {
            if (this.look == '[') {
                ++countLeft;
            }
            if (this.look == ']') {
                ++counRight;
            }
            formulaStr.append(this.look);
            this.getChar();
            if (countLeft != counRight || countLeft == 0) continue;
        }
        this.readResult(formulaStr);
        while (this.look != '\u0000' && BizParseHelper.isBlank(this.look)) {
            formulaStr.append(this.look);
            this.getChar();
        }
        while (this.readElse(formulaStr)) {
            this.readResult(formulaStr);
        }
        this.SkipWhite();
        return formulaStr.toString();
    }

    private boolean readElse(StringBuffer ifStr) {
        while (this.look != '\u0000' && BizParseHelper.isBlank(this.look)) {
            ifStr.append(this.look);
            this.getChar();
        }
        if (this.look == 'E' && this.formulaStr.charAt(this.point) == 'L' && this.formulaStr.charAt(this.point + 1) == 'S' && this.formulaStr.charAt(this.point + 2) == 'E') {
            for (int i = 0; i < 4; ++i) {
                ifStr.append(this.look);
                this.getChar();
            }
            return true;
        }
        return false;
    }

    private void readResult(StringBuffer ifStr) {
        int countLeft = 0;
        int counRight = 0;
        while (this.look != '\u0000') {
            if (this.look == '{') {
                ++countLeft;
            }
            if (this.look == '}') {
                ++counRight;
            }
            ifStr.append(this.look);
            this.getChar();
            if (countLeft != counRight || countLeft == 0) continue;
            return;
        }
    }

    private boolean isFunction(String str) {
        return FunctionProxy.isFunction(str);
    }

    private FunctionExpr checkHasFunction(String functionStr) throws ParseException {
        return FunctionProxy.parse(functionStr);
    }

    private void readAlphanumeric() throws ParseException {
        String str = this.getAlphanumeric();
        if (this.isNumeric(str)) {
            this.operand.add(new OperandExpr(str));
        } else if (this.isFormula(str)) {
            FormulaExpr expr = this.checkHasFormula(str);
            if (expr != null) {
                this.operand.add(expr);
            } else {
                this.Expected(" error function!" + str);
            }
        } else if (this.isMember(str)) {
            if (!StringUtils.isEmpty((String)str) && str.startsWith("PTO")) {
                List<MdxMemberExpr> exprs = this.checkHasPTOMember(str);
                if (exprs != null) {
                    this.operand.addAll(exprs);
                } else {
                    this.Expected(" error member!" + str);
                }
            } else {
                MdxMemberExpr expr = this.checkHasMember(str);
                if (expr != null) {
                    this.operand.add(expr);
                } else {
                    this.Expected(" error member!" + str);
                }
            }
        } else if (this.isVariate(str)) {
            VariateExpr expr = this.checkHasVariate(str);
            if (expr != null) {
                this.operand.add(expr);
            } else {
                this.Expected(" error variate!" + str);
            }
        } else if (this.isLogicOper(str)) {
            if (this.isAnd(str)) {
                this.and();
            } else if (this.isNot(str)) {
                this.not();
            } else if (this.isOr(str)) {
                this.or();
            }
        } else if (this.isFunction(str)) {
            FunctionExpr expr = this.checkHasFunction(str);
            if (expr != null) {
                this.operand.add(expr);
            } else {
                this.Expected(" error function!" + str);
            }
        } else if (str.matches("\\d+\\D+")) {
            this.Expected(" error function!" + str);
        } else if (this.isCheckNameExpr) {
            this.Expected(" error function!" + str);
        } else {
            this.operand.add(new NameExpr(str.trim()));
        }
    }

    private String getAlphanumeric() throws ParseException {
        String alphanumeric = "";
        int count = 0;
        int count1 = 0;
        int strCount = 0;
        while (!(strCount <= 0 && count <= 0 && count1 <= 0 && this.isOperation(this.look) || this.look == '\u0000')) {
            if (this.look == '(') {
                if (alphanumeric.equals("NOT")) break;
                ++count;
            }
            if (this.look == ')') {
                --count;
            }
            if (this.look == '[') {
                ++count1;
            }
            if (this.look == ']') {
                --count1;
            }
            if (this.look == '\"' && ++strCount >= 2) {
                strCount = 0;
            }
            if (this.look == ' ' && strCount == 0 && count == 0 && count1 == 0 || count < 0 || count1 < 0) break;
            alphanumeric = alphanumeric + this.look;
            this.getChar();
        }
        this.SkipWhite();
        return alphanumeric;
    }

    private boolean isFormula(String formulaStr) {
        return FormulaProxy.isFormula(formulaStr);
    }

    private FormulaExpr checkHasFormula(String formulaStr) throws ParseException {
        return FormulaProxy.parse(formulaStr);
    }

    private boolean isMember(String memberStr) {
        return MemberProxy.isMember(memberStr);
    }

    private MdxMemberExpr checkHasMember(String memberStr) throws ParseException {
        return MemberProxy.parse(memberStr);
    }

    private List<MdxMemberExpr> checkHasPTOMember(String memberStr) throws ParseException {
        return MemberProxy.parsePTO(memberStr);
    }

    private boolean isVariate(String variateStr) {
        return VariateProxy.isVariate(variateStr);
    }

    private VariateExpr checkHasVariate(String variateStr) throws ParseException {
        return VariateProxy.parse(variateStr);
    }

    private void readOperation(char c) throws ParseException {
        if ('+' == c) {
            this.add();
        } else if ('-' == c) {
            this.sub();
        } else if ('*' == c) {
            this.multiply();
        } else if ('/' == c) {
            this.div();
        } else if ('=' == c) {
            this.assignment();
        } else if ('>' == c) {
            this.greaterThan();
        } else if ('<' == c) {
            this.lessThan();
        } else if ('(' == c) {
            this.leftParentheses();
        } else if (')' == c) {
            this.rightParentheses();
        }
        if (')' != c) {
            this.dealNegativeNumber();
        }
    }

    private void dealNegativeNumber() throws ParseException {
        if (this.look == '-') {
            String numeric = null;
            this.getChar();
            this.SkipWhite();
            try {
                numeric = "-" + this.readNumber();
                if (this.checkNumeric(numeric)) {
                    this.operand.add(new OperandExpr(numeric));
                } else {
                    this.Expected("" + numeric);
                }
            }
            catch (ParseException ex) {
                this.point -= 2;
                this.getChar();
            }
        }
    }

    private void greaterThan() throws ParseException {
        this.match('>');
        if (this.look == '=') {
            this.greaterEqual();
        } else {
            this.pushCheck2S2(new GreaterThanOper());
        }
    }

    private void greaterEqual() throws ParseException {
        this.match('=');
        this.pushCheck2S2(new GreaterEqualOper());
    }

    private void lessThan() throws ParseException {
        this.match('<');
        if (this.look == '=') {
            this.lessEqual();
        } else if (this.look == '>') {
            this.notEqual();
        } else {
            this.pushCheck2S2(new LessthanOper());
        }
    }

    private void lessEqual() throws ParseException {
        this.match('=');
        this.pushCheck2S2(new LessEqualOper());
    }

    private void notEqual() throws ParseException {
        this.match('>');
        this.pushCheck2S2(new NotEqualOper());
    }

    private boolean team() throws ParseException {
        this.SkipWhite();
        if (this.isFunction(this.look)) {
            this.readFunction();
        } else if (this.isIf(this.look)) {
            this.readIf();
        } else if (this.isAlphanumeric(this.look)) {
            this.readAlphanumeric();
        } else if (this.look == '(' || this.look == ')') {
            this.readOperation(this.look);
        } else {
            return false;
        }
        return true;
    }
}

