/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.BizFacadeFactory;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MemberProxy;
import com.kingdee.eas.ma.biz.expr.oper.AbstractOper;
import com.kingdee.eas.ma.biz.parse.BizExprParser;
import com.kingdee.eas.ma.biz.parse.BizParseExceptionHandler;
import com.kingdee.eas.ma.biz.parse.BizParseHelper;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.eas.ma.biz.parse.expr.IBizExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizAssignmentExpr;
import com.kingdee.eas.ma.biz.parse.expr.impl.BizConditionExpr;
import com.kingdee.eas.ma.biz.parse.operand.impl.Operand;
import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgVariateCollection;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgVariate;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgProcessHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class BizParseDimMemHelper {
    private Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap = null;
    private Map<String, String> bizBgVariateMap = null;
    private Map<String, Set<String>> childOrgMap = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, Map<String, Set<String>>> bizScopeSrcMap = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Map<String, BizScopeCollection>> bizScopeMap = null;
    private Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = null;
    private Map<String, Map<String, String>> memberMap = null;
    private String bizName = null;
    private String subsetName = null;
    private Integer line = null;

    public BizParseDimMemHelper(Map<String, Map<String, Map<Integer, List<IBizExpr>>>> exprMap, Map<String, String> bizBgVariateMap, BgSchemeDimensionHelper schemeHelper, Map<String, Map<String, Set<String>>> bizScopeSrcMap, Map<String, Map<String, BizScopeCollection>> bizScopeMap, Map<String, Map<String, String>> memberMap, Map<String, Set<String>> childOrgMap, Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions) {
        this.exprMap = exprMap;
        this.bizBgVariateMap = bizBgVariateMap;
        this.childOrgMap = childOrgMap;
        this.schemeHelper = schemeHelper;
        this.bizScopeSrcMap = bizScopeSrcMap;
        this.bizScopeMap = bizScopeMap;
        this.allExceptions = allExceptions;
        this.memberMap = memberMap;
    }

    public void verifyMemberIsExist() throws EASBizException, BOSException {
        this.parseScopeVariate();
        this.parseExprVariate();
        this.queryBgVariate();
        this.queryBgOrgUnit();
        HashMap<String, Map<String, Map<Integer, Set<String>>>> bizMemberMap = new HashMap<String, Map<String, Map<Integer, Set<String>>>>();
        HashMap<String, Set<String>> dimMemMap = new HashMap<String, Set<String>>();
        this.parseExprMem(bizMemberMap, dimMemMap);
        this.parseScopeMem(dimMemMap);
        this.queryDimMember(bizMemberMap, dimMemMap);
    }

    private void queryDimMember(Map<String, Map<String, Map<Integer, Set<String>>>> bizMemberMap, Map<String, Set<String>> dimMemMap) throws EASBizException, BOSException {
        Map ref_dim = this.schemeHelper.getDimensionByRefField();
        ref_dim.put(BgProcessHelper.DEF_PROCESS_FIELD, BgProcessHelper.getDimension());
        BizScopeInfo scope = null;
        String orgTreeId = null;
        if (this.schemeHelper.getClass().getName().equalsIgnoreCase(DimensionConstants.CSLSCHEME_HELPER) && this.schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() != null) {
            orgTreeId = this.schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        }
        Map existMemMap = null;
        existMemMap = this.schemeHelper.getContext() == null ? BizFacadeFactory.getRemoteInstance().queryDimMember(dimMemMap, this.schemeHelper.getBgSchemeId(), true, orgTreeId) : BizFacadeFactory.getLocalInstance(this.schemeHelper.getContext()).queryDimMember(dimMemMap, this.schemeHelper.getBgSchemeId(), true, orgTreeId);
        if (existMemMap != null) {
            for (String bizName : bizMemberMap.keySet()) {
                Map<String, Map<Integer, Set<String>>> subsetMemberMap = bizMemberMap.get(bizName);
                for (String subsetName : subsetMemberMap.keySet()) {
                    BizScopeCollection scopes;
                    Map<Integer, Set<String>> lineMemberMap = subsetMemberMap.get(subsetName);
                    for (Integer line : lineMemberMap.keySet()) {
                        Set<String> srcMemSet = lineMemberMap.get(line);
                        for (String srcMem : srcMemSet) {
                            String[] numbers;
                            if (BizParseHelper.isNum(srcMem) || srcMem.equals("BgP")) continue;
                            String[] member = srcMem.split(":");
                            String src = member[0];
                            String number = this.getMemberNumber(member);
                            for (String n : numbers = number.split(",")) {
                                String dimNum = null;
                                if (this.schemeHelper.getDimensionBySrcNumber() != null && this.schemeHelper.getDimensionBySrcNumber().get(src) != null) {
                                    dimNum = ((BgDimensionInfo)this.schemeHelper.getDimensionBySrcNumber().get(src)).getNumber();
                                } else if (BgProcessHelper.DEF_PROCESS_SRC.equals(src)) {
                                    dimNum = BgProcessHelper.DEF_PROCESS_NUMBER;
                                } else if ("BgP1".equals(src)) {
                                    dimNum = "BG_Period1";
                                } else if ("BgP2".equals(src)) {
                                    dimNum = "BG_Period2";
                                }
                                if ((DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimNum) || "BG_Period1".equals(dimNum) || "BG_Period2".equals(dimNum)) && BgPeriodNVariableHelper.checkCanConvert((String)n) || this.checkHasMember(existMemMap, dimNum, n)) continue;
                                this.recordException(BizCalcParseException.ERROR_MEMBER, this.getSrcMemberNumber(member), bizName, subsetName, line);
                            }
                        }
                    }
                    if (this.bizScopeMap == null || !this.bizScopeMap.containsKey(bizName) || !this.bizScopeMap.get(bizName).containsKey(subsetName) || (scopes = this.bizScopeMap.get(bizName).get(subsetName)) == null || scopes.isEmpty()) continue;
                    for (int i = 0; i < scopes.size(); ++i) {
                        scope = scopes.get(i);
                        if (scope.getRefField() == null) continue;
                        if (!ref_dim.containsKey(scope.getRefField())) {
                            this.recordException(BizCalcParseException.ERROR_SCOPE_NO_REFFIELD, new Object[]{subsetName, scope.getRefField()}, bizName, subsetName, (Integer)-1);
                            continue;
                        }
                        if (BgMemberSelectTypeEnum.Member.equals((Object)scope.getBizDataType())) {
                            if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(scope.getRefField()) && BgPeriodNVariableHelper.checkCanConvert((String)scope.getBgMemberNum()) || this.checkHasMember(existMemMap, ((BgDimensionInfo)ref_dim.get(scope.getRefField())).getNumber(), this.getMemberNumber(scope.getBgMemberNum().split(":")))) continue;
                            this.recordException(BizCalcParseException.ERROR_SCOPE_NO_MEMBER, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                            continue;
                        }
                        if (BgMemberSelectTypeEnum.Variate.equals((Object)scope.getBizDataType())) {
                            String number = this.bizBgVariateMap.get(scope.getBgMemberNum());
                            if (this.checkHasMember(existMemMap, ((BgDimensionInfo)ref_dim.get(scope.getRefField())).getNumber(), this.getMemberNumber(number.split(":")))) continue;
                            this.recordException(BizCalcParseException.ERROR_SCOPE_NO_MEMBER, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                            continue;
                        }
                        if (!BgMemberSelectTypeEnum.Function.equals((Object)scope.getBizDataType())) continue;
                        Set numbers = MbgFunctionHelper.getMemNumByScopeMemFunction((String)scope.getBgMemberNum());
                        for (String number : numbers) {
                            if (number.indexOf(":") > 0) {
                                if (BgPeriodNVariableHelper.checkCanConvert((String)number) || this.checkHasMember(existMemMap, ((BgDimensionInfo)ref_dim.get(scope.getRefField())).getNumber(), this.getMemberNumber(number.split(":")))) continue;
                                this.recordException(BizCalcParseException.ERROR_SCOPE_NO_FUNCTION, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                                continue;
                            }
                            String memberNumber = this.bizBgVariateMap.get(number);
                            if (this.checkHasMember(existMemMap, ((BgDimensionInfo)ref_dim.get(scope.getRefField())).getNumber(), this.getMemberNumber(memberNumber.split(":")))) continue;
                            this.recordException(BizCalcParseException.ERROR_SCOPE_NO_FUNCTION, new Object[]{subsetName, scope.getBgMemberNum()}, bizName, subsetName, (Integer)-1);
                        }
                    }
                }
            }
        }
    }

    private boolean checkHasMember(Map<String, Set<String>> existMemMap, String dimNumber, String number) {
        return existMemMap != null && existMemMap.get(dimNumber) != null && existMemMap.get(dimNumber).contains(number);
    }

    private boolean checkVarHasSameSrc(List<String> memberList) {
        if (memberList == null) {
            return false;
        }
        String baseSrc = null;
        for (String member : memberList) {
            String src = member.split(":")[0];
            if (baseSrc == null) {
                baseSrc = src;
                continue;
            }
            if (baseSrc.equals(src)) continue;
            return false;
        }
        return true;
    }

    private void parseExprMem(Map<String, Map<String, Map<Integer, Set<String>>>> bizMemberMap, Map<String, Set<String>> dimMemMap) {
        Set<String> lineMembers = null;
        Set<String> dimMembers = null;
        Iterator<String> iterator = this.exprMap.keySet().iterator();
        while (iterator.hasNext()) {
            String bizName;
            this.bizName = bizName = iterator.next();
            Map<String, Map<Integer, List<IBizExpr>>> subsetMap = this.exprMap.get(bizName);
            Map<String, Set<String>> subSetScopeSrc = this.bizScopeSrcMap.get(bizName);
            Map<String, Map<Integer, Set<String>>> subsetMemberMap = bizMemberMap.get(bizName);
            if (subsetMemberMap == null) {
                subsetMemberMap = new HashMap<String, Map<Integer, Set<String>>>();
                bizMemberMap.put(bizName, subsetMemberMap);
            }
            Iterator<String> iterator2 = subsetMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String subsetName;
                this.subsetName = subsetName = iterator2.next();
                Map<Integer, List<IBizExpr>> lineMap = subsetMap.get(subsetName);
                Set<String> scopeSrc = subSetScopeSrc != null ? subSetScopeSrc.get(subsetName) : null;
                Map<Integer, Set<String>> lineMemberMap = subsetMemberMap.get(subsetName);
                if (lineMemberMap == null) {
                    lineMemberMap = new HashMap<Integer, Set<String>>();
                    subsetMemberMap.put(subsetName, lineMemberMap);
                }
                Iterator<Integer> iterator3 = lineMap.keySet().iterator();
                while (iterator3.hasNext()) {
                    Integer line;
                    this.line = line = iterator3.next();
                    List<IBizExpr> exprList = lineMap.get(line);
                    for (IBizExpr expr : exprList) {
                        if (expr instanceof BizAssignmentExpr) {
                            lineMembers = this.parseAssignmentExpr(expr, scopeSrc);
                        } else if (expr instanceof BizConditionExpr) {
                            lineMembers = this.parseAssignmentExpr(expr, scopeSrc);
                        }
                        if (lineMembers == null) continue;
                        Set<String> lineMember = lineMemberMap.get(line);
                        if (lineMember == null) {
                            lineMember = new HashSet<String>();
                            lineMemberMap.put(line, lineMember);
                        }
                        lineMember.addAll(lineMembers);
                        for (String dimMem : lineMembers) {
                            String[] member = dimMem.split(":");
                            String src = member[0];
                            String number = this.getMemberNumber(member);
                            String[] numbers = number.split(",");
                            String dimNum = null;
                            if (BgProcessHelper.DEF_PROCESS_SRC.equals(src)) {
                                dimNum = BgProcessHelper.DEF_PROCESS_NUMBER;
                            } else if (this.schemeHelper.getDimensionBySrcNumber() != null && this.schemeHelper.getDimensionBySrcNumber().get(src) != null) {
                                dimNum = ((BgDimensionInfo)this.schemeHelper.getDimensionBySrcNumber().get(src)).getNumber();
                            } else if (src.equals("BgP1")) {
                                dimNum = "BG_Period1";
                            } else if (src.equals("BgP2")) {
                                dimNum = "BG_Period2";
                            }
                            dimMembers = dimMemMap.get(dimNum);
                            if (dimMembers == null) {
                                dimMembers = new HashSet<String>();
                                dimMemMap.put(dimNum, dimMembers);
                            }
                            for (String n : numbers) {
                                dimMembers.add(n);
                            }
                        }
                    }
                }
            }
        }
    }

    private void parseScopeMem(Map<String, Set<String>> dimMemMap) {
        Map ref_dim = this.schemeHelper.getDimensionByRefField();
        ref_dim.put(BgProcessHelper.DEF_PROCESS_FIELD, BgProcessHelper.getDimension());
        BizScopeInfo scope = null;
        if (this.bizScopeMap != null && !this.bizScopeMap.isEmpty()) {
            String dimNumber = null;
            String memberNumber = null;
            for (Map<String, BizScopeCollection> subSetScope : this.bizScopeMap.values()) {
                if (subSetScope == null) continue;
                for (BizScopeCollection scopes : subSetScope.values()) {
                    if (scopes == null) continue;
                    for (int i = 0; i < scopes.size(); ++i) {
                        scope = scopes.get(i);
                        if (!ref_dim.containsKey(scope.getRefField())) continue;
                        dimNumber = ((BgDimensionInfo)ref_dim.get(scope.getRefField())).getNumber();
                        if (!dimMemMap.containsKey(dimNumber)) {
                            dimMemMap.put(dimNumber, new HashSet());
                        }
                        if (BgMemberSelectTypeEnum.Member.equals((Object)scope.getBizDataType())) {
                            memberNumber = dimNumber.equals(BgProcessHelper.DEF_PROCESS_NUMBER) ? scope.getBgMemberNum() : this.splitScopeBgMemberNum(dimNumber, scope.getBgMemberNum());
                            dimMemMap.get(dimNumber).add(memberNumber);
                            continue;
                        }
                        if (BgMemberSelectTypeEnum.Variate.equals((Object)scope.getBizDataType())) {
                            memberNumber = this.bizBgVariateMap.get(scope.getBgMemberNum());
                            if (this.schemeHelper.getDimensionBySrcNumber().get(memberNumber.split(":")[0]) == null) continue;
                            dimMemMap.get(dimNumber).add(memberNumber.split(":")[1]);
                            continue;
                        }
                        if (!BgMemberSelectTypeEnum.Function.equals((Object)scope.getBizDataType())) continue;
                        Set numbers = MbgFunctionHelper.getMemNumByScopeMemFunction((String)scope.getBgMemberNum());
                        for (String number : numbers) {
                            if (number.indexOf(":") > 0) {
                                if (BgPeriodNVariableHelper.checkCanConvert((String)number)) continue;
                                dimMemMap.get(dimNumber).add(this.getMemberNumber(number.split(":")));
                                continue;
                            }
                            memberNumber = this.bizBgVariateMap.get(number);
                            dimMemMap.get(dimNumber).add(memberNumber);
                        }
                    }
                }
            }
        }
    }

    private String splitScopeBgMemberNum(String dimNumber, String bgMemberNum) {
        if (!(dimNumber.equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimNumber.equals(DimensionConstants.DEF_SCENARIO_NUMBER) || dimNumber.equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimNumber.equals(DimensionConstants.DEF_VERSION_NUMBER) || dimNumber.equals(DimensionConstants.DEF_CURRENCY_NUMBER) || dimNumber.equals(DimensionConstants.DEF_ELEMENT_NUMBER))) {
            return bgMemberNum.split(":")[1];
        }
        return bgMemberNum;
    }

    private Set<String> parseBizConditionExpr(IBizExpr expr) {
        HashSet<String> lineMembers = new HashSet<String>();
        Stack exprStack = expr.getExpr();
        ArrayList<Operand> operList = new ArrayList<Operand>();
        for (Object obj : exprStack) {
            if (!(obj instanceof Operand)) continue;
            operList.add((Operand)obj);
        }
        List<Set<String>> memberList = this.getDimMemberList(operList, true);
        for (Set<String> rightMember : memberList) {
            lineMembers.addAll(rightMember);
        }
        return lineMembers;
    }

    private Set<String> parseAssignmentExpr(IBizExpr expr, Set<String> scopeSrc) {
        HashSet<String> lineMembers = new HashSet<String>();
        Stack exprStack = expr.getExpr();
        boolean left = true;
        Operand leftOper = null;
        ArrayList<Operand> rightOperList = new ArrayList<Operand>();
        AbstractOper setOper = null;
        for (Object obj : exprStack) {
            if (obj instanceof AbstractOper) {
                if (!((AbstractOper)obj).getOper().equals("=")) continue;
                setOper = (AbstractOper)obj;
                left = false;
                continue;
            }
            if (left) {
                leftOper = (Operand)obj;
                continue;
            }
            rightOperList.add((Operand)obj);
        }
        if (leftOper != null && leftOper.getOperand() != null && leftOper.getOperand().indexOf("PTO") >= 0) {
            this.recordException(BizCalcParseException.ERROR_PTO_LEFT, leftOper.getOperand());
        }
        Set<String> leftMemberSet = this.getDimMemberSet(leftOper, false, false);
        List<Set<String>> rightMemberList = this.getDimMemberList(rightOperList, false);
        lineMembers.addAll(leftMemberSet);
        for (Set<String> rightMember : rightMemberList) {
            lineMembers.addAll(rightMember);
        }
        if (leftMemberSet == null || leftMemberSet != null && leftMemberSet.size() == 0 || rightMemberList == null) {
            return lineMembers;
        }
        int constantsCount = 0;
        boolean isBreak = false;
        boolean isRecordScopeError = false;
        for (String leftMember : leftMemberSet) {
            Set<String> rightMemberSet;
            String dimSrc = leftMember.split(":")[0];
            String beginPeriodStr = "";
            Object endPeriodStr = "";
            for (int i = 0; i < rightMemberList.size() && (rightMemberSet = rightMemberList.get(i)) != null; ++i) {
                HashSet<String> tempSet = new HashSet<String>();
                if (rightMemberSet.size() == 1) {
                    Object member = null;
                    for (String o : rightMemberSet) {
                        member = o;
                    }
                    if (BizParseHelper.isNum(member)) {
                        ++constantsCount;
                        rightMemberSet.remove(member);
                        lineMembers.remove(member);
                    }
                }
                for (String dimMem : rightMemberSet) {
                    String[] numbers;
                    String[] member = dimMem.split(":");
                    String src = member[0];
                    String number = this.getMemberNumber(member);
                    for (String n : numbers = number.split(",")) {
                        tempSet.add(src + ":" + n);
                    }
                    if (src.equals("BgP1")) {
                        beginPeriodStr = number;
                        continue;
                    }
                    if (!src.equals("BgP2")) continue;
                    endPeriodStr = number;
                }
                if (leftMemberSet.size() == rightMemberSet.size() && tempSet.containsAll(leftMemberSet)) {
                    this.recordException(BizCalcParseException.ERROR_EXPR_SAME, ((Operand)rightOperList.get(i)).getOperand());
                    break;
                }
                boolean hasDim = false;
                if (rightMemberSet != null && rightMemberSet.size() > 0) {
                    for (String rightMember : rightMemberSet) {
                        if (!rightMember.startsWith(dimSrc) && (this.memberMap == null || !this.memberMap.containsKey(this.bizName) || !this.memberMap.get(this.bizName).containsKey(dimSrc))) continue;
                        hasDim = true;
                    }
                    if (!(hasDim || BizParseHelper.isBoolFX(((Operand)rightOperList.get(i)).getOperand()) || BizParseHelper.isMathFX(((Operand)rightOperList.get(i)).getOperand()) && !"Abs".equalsIgnoreCase(BizCalcCommonHelper.getFunctionName(((Operand)rightOperList.get(i)).getOperand())))) {
                        if (expr instanceof BizConditionExpr && ((BizConditionExpr)expr).isCondition()) {
                            this.recordException(BizCalcParseException.ERROR_IF_CONDDIM, ((Operand)rightOperList.get(i)).getOperand());
                        } else {
                            this.recordException(BizCalcParseException.ERROR_EXPR_LESS, ((Operand)rightOperList.get(i)).getOperand());
                        }
                        isBreak = true;
                        break;
                    }
                    if (hasDim && BizParseHelper.isBoolFX(((Operand)rightOperList.get(i)).getOperand())) {
                        this.recordException(BizCalcParseException.ERROR_IF_MEMBER, ((Operand)rightOperList.get(i)).getOperand());
                        isBreak = true;
                        break;
                    }
                }
                if (!BizPtoUtils.checkBeginAndEndPeriodType(beginPeriodStr, (String)endPeriodStr)) {
                    this.recordException(BizCalcParseException.ERROR_PERIODTYPENOTEQUAL, ((Operand)rightOperList.get(i)).getOperand());
                    isBreak = true;
                }
                if (BizPtoUtils.checkBeginPeriodBeforeEndPeriod(beginPeriodStr, (String)endPeriodStr)) continue;
                this.recordException(BizCalcParseException.ERROR_PERIODCOMPARE, ((Operand)rightOperList.get(i)).getOperand());
                isBreak = true;
            }
            if (isBreak) break;
            if (scopeSrc == null || !scopeSrc.contains(dimSrc) || isRecordScopeError || leftOper == null) continue;
            this.recordException(BizCalcParseException.ERROR_SCOPE, leftOper.getOperand());
            isRecordScopeError = true;
        }
        String leftOrgNumber = null;
        String rightOrgNumber = null;
        HashSet<String> leftNoOrg = new HashSet<String>();
        HashSet<String> rightNoOrg = new HashSet<String>();
        for (String leftMember : leftMemberSet) {
            String[] member = leftMember.split(":");
            if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(member[0])) {
                leftOrgNumber = this.getMemberNumber(member);
                continue;
            }
            leftNoOrg.add(leftMember);
        }
        for (int i = 0; i < rightMemberList.size(); ++i) {
            Set<String> rightMemberSet = rightMemberList.get(i);
            rightNoOrg.clear();
            rightOrgNumber = null;
            if (rightMemberSet == null || rightMemberSet.isEmpty()) continue;
            for (String rightMember : rightMemberSet) {
                String[] member = rightMember.split(":");
                if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(member[0])) {
                    rightOrgNumber = this.getMemberNumber(member);
                    continue;
                }
                rightNoOrg.add(rightMember);
            }
            if (!leftNoOrg.equals(rightNoOrg) || StringUtils.isEmpty(rightOrgNumber)) continue;
            if (StringUtils.isEmpty((String)leftOrgNumber)) {
                if (!this.childOrgMap.containsKey(rightOrgNumber)) continue;
                this.recordException(BizCalcParseException.ERROR_ORG_NOLEAF, ((Operand)rightOperList.get(i)).getOperand());
                continue;
            }
            if (!this.checkIsChild(leftOrgNumber, rightOrgNumber)) continue;
            this.recordException(BizCalcParseException.ERROR_ORG_PARENT, ((Operand)rightOperList.get(i)).getOperand());
        }
        if (rightMemberList.size() == constantsCount && constantsCount == 1) {
            this.recordException(BizCalcParseException.ONLY_CONSTANT, expr.toString());
        }
        return lineMembers;
    }

    private boolean checkIsChild(String leftOrgNumber, String rightOrgNumber) {
        if (this.childOrgMap.containsKey(rightOrgNumber)) {
            Set<String> childSet = this.childOrgMap.get(rightOrgNumber);
            if (childSet.contains(leftOrgNumber)) {
                return true;
            }
            for (String child : childSet) {
                if (!this.checkIsChild(leftOrgNumber, child)) continue;
                return true;
            }
        }
        return false;
    }

    public void queryBgOrgUnit() throws EASBizException, BOSException {
        if (this.childOrgMap.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("longNumber");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)this.schemeHelper.getBgOrgViewId(), CompareType.EQUALS));
            IBgOrgUnit iorg = null;
            iorg = this.schemeHelper.getContext() == null ? BgOrgUnitFactory.getRemoteInstance() : BgOrgUnitFactory.getLocalInstance((Context)this.schemeHelper.getContext());
            BgOrgUnitCollection col = iorg.getBgOrgUnitCollection(evi);
            String[] lns = null;
            for (int i = 0; i < col.size(); ++i) {
                lns = col.get(i).getLongNumber().split("!");
                if (lns.length <= 1) continue;
                if (!this.childOrgMap.containsKey(lns[lns.length - 2])) {
                    this.childOrgMap.put(lns[lns.length - 2], new HashSet());
                }
                this.childOrgMap.get(lns[lns.length - 2]).add(lns[lns.length - 1]);
            }
        }
    }

    public void queryBgVariate() throws EASBizException, BOSException {
        if (!this.bizBgVariateMap.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("dimNumber");
            evi.getSelector().add("memberNumber");
            evi.getSelector().add("bgVariateClass");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)this.schemeHelper.getBgSchemeId(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(this.bizBgVariateMap.keySet()), CompareType.INCLUDE));
            IBgVariate iVar = null;
            iVar = this.schemeHelper.getContext() == null ? BgVariateFactory.getRemoteInstance() : BgVariateFactory.getLocalInstance((Context)this.schemeHelper.getContext());
            BgVariateCollection col = iVar.getBgVariateCollection(evi);
            BgVariateInfo variate = null;
            Object srcNumber = null;
            Object sourceNumber = null;
            for (int i = 0; i < col.size(); ++i) {
                variate = col.get(i);
                String value = null;
                value = variate.getBgVariateClass().getValue() == 0 ? this.schemeHelper.getSrcNumber(variate.getDimNumber()) + ":" + variate.getMemberNumber() : variate.getMemberNumber();
                this.bizBgVariateMap.put(variate.getNumber(), value);
            }
            this.bizBgVariateMap.put("NULL", "0");
        }
    }

    private void parseScopeVariate() {
        if (this.bizScopeMap == null) {
            return;
        }
        for (String bizName : this.bizScopeMap.keySet()) {
            Map<String, BizScopeCollection> subsetScope = this.bizScopeMap.get(bizName);
            if (subsetScope == null) {
                return;
            }
            for (String subsetName : subsetScope.keySet()) {
                BizScopeCollection scopes = subsetScope.get(subsetName);
                if (scopes == null || scopes.isEmpty()) {
                    return;
                }
                BizScopeInfo scope = null;
                String src = null;
                for (int i = 0; i < scopes.size(); ++i) {
                    scope = scopes.get(i);
                    src = this.schemeHelper.getSrcNumberByRefField(scope.getRefField());
                    if (BgMemberSelectTypeEnum.Variate.equals((Object)scope.getBizDataType())) {
                        this.addToVirateMap(scope.getBgMemberNum(), src);
                        continue;
                    }
                    if (!BgMemberSelectTypeEnum.Function.equals((Object)scope.getBizDataType())) continue;
                    Set numbers = MbgFunctionHelper.getMemNumByScopeMemFunction((String)scope.getBgMemberNum());
                    for (String number : numbers) {
                        if (number.indexOf(":") >= 0) continue;
                        this.addToVirateMap(number, src);
                    }
                }
            }
        }
    }

    private void parseExprVariate() {
        for (String bizName : this.exprMap.keySet()) {
            Map<String, Map<Integer, List<IBizExpr>>> subsetMap = this.exprMap.get(bizName);
            if (subsetMap == null) continue;
            for (String subsetName : subsetMap.keySet()) {
                Map<Integer, List<IBizExpr>> lineMap = subsetMap.get(subsetName);
                if (lineMap == null) continue;
                for (Integer line : lineMap.keySet()) {
                    List<IBizExpr> exprList = lineMap.get(line);
                    if (exprList == null) continue;
                    for (IBizExpr expr : exprList) {
                        Stack exprStack = expr.getExpr();
                        for (Object obj : exprStack) {
                            Stack absStack;
                            String subFormula;
                            if (!(obj instanceof Operand)) continue;
                            Operand operand = (Operand)obj;
                            String formula = operand.getOperand();
                            if (BizParseHelper.isVAR(formula)) {
                                String member = formula.substring(formula.indexOf("\"") + 1, formula.lastIndexOf("\""));
                                this.addToVirateMap(member, "");
                                continue;
                            }
                            if (!BizParseHelper.isMathFX(formula) && !BizParseHelper.isBoolFX(formula)) continue;
                            String formulaName = BizCalcCommonHelper.getFunctionName(formula);
                            if (formulaName.equals("@MAX") || formulaName.equals("@MIN") || formulaName.equals("@AVG") || formulaName.equals("@IsMember")) {
                                subFormula = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
                                if (!subFormula.startsWith("VAR:")) continue;
                                String[] members = formula.substring(formula.indexOf("\"") + 1, formula.lastIndexOf("\"")).split(",");
                                for (int i = 0; i < members.length; ++i) {
                                    this.addToVirateMap(members[i], null);
                                }
                                continue;
                            }
                            subFormula = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
                            BizParseParam param = new BizParseParam();
                            param.setText(subFormula);
                            BizExprParser parser = new BizExprParser(param);
                            parser.setRecordExc(false);
                            if (!parser.parse() || (absStack = parser.getExprStack()) == null) continue;
                            for (Object absOper : absStack) {
                                if (!(absOper instanceof Operand) || !BizParseHelper.isVAR(((Operand)absOper).getOperand())) continue;
                                String member = formula.substring(formula.indexOf("\"") + 1, formula.lastIndexOf("\""));
                                this.addToVirateMap(member, "");
                            }
                        }
                    }
                }
            }
        }
    }

    private String getMemberNumber(String[] member) {
        if (member.length == 1) {
            return member[0];
        }
        String number = member[1];
        if (member.length == 3 && "VAR".equals(number)) {
            number = this.bizBgVariateMap.get(member[2]);
        }
        return number;
    }

    private String getSrcMemberNumber(String[] member) {
        if (member.length == 1) {
            return member[0];
        }
        String src = member[0];
        String number = member[1];
        if ("VAR".equals(src)) {
            return number;
        }
        return src + ":" + number;
    }

    public List<String> replaceVAR2MBR(List<String> members, boolean isRecordVar) {
        ArrayList<String> mbrList = new ArrayList<String>();
        for (int i = 0; i < members.size(); ++i) {
            String number = members.get(i);
            mbrList.add(this.bizBgVariateMap.get(number));
        }
        return mbrList;
    }

    public void addToVirateMap(String number, String src) {
        this.bizBgVariateMap.put(number, "VAR:" + number);
    }

    public List<Set<String>> getDimMemberList(List<Operand> rightOperList, boolean isRecordVar) {
        ArrayList<Set<String>> memberList = new ArrayList<Set<String>>();
        Set<String> memberSet = null;
        if (rightOperList != null) {
            for (Operand obj : rightOperList) {
                Operand leftOper = obj;
                memberSet = this.getDimMemberSet(leftOper, false, isRecordVar);
                if (memberSet == null) continue;
                memberList.add(memberSet);
            }
        }
        return memberList;
    }

    public Set<String> getDimMemberSet(Operand leftOper, boolean multiMem, boolean isRecordVar) {
        Set<String> memberSet = new HashSet<String>();
        HashSet<String> funMemberSet = new HashSet<String>();
        if (leftOper != null && (BizParseHelper.isMBRExpr(leftOper.getOperand()) || BizParseHelper.isPTO(leftOper.getOperand()))) {
            if (leftOper.getOperand().indexOf("Lead") != -1) {
                String tempMember = leftOper.getOperand().substring(leftOper.getOperand().indexOf("[") + 1, leftOper.getOperand().length() - 1);
                String[] tmpStrs = MemberProxy.splitMemberString(tempMember);
                String dimMem = null;
                int length = tmpStrs.length;
                for (int i = 0; i < length; ++i) {
                    if (tmpStrs[i] == null) continue;
                    int len = tmpStrs[i].length();
                    dimMem = tmpStrs[i].substring(1, len - 1);
                    if (dimMem.indexOf("FX:[") == -1) {
                        funMemberSet.add(dimMem);
                        continue;
                    }
                    if (dimMem.indexOf("BgP") != -1) {
                        dimMem = dimMem.split(",")[1].substring(1, dimMem.split(",")[1].length() - 3);
                        funMemberSet.add(dimMem);
                        continue;
                    }
                    funMemberSet.add("BgP");
                }
            } else if (leftOper.getOperand().indexOf("ParallelPeriod") != -1) {
                String tempMember = leftOper.getOperand().substring(leftOper.getOperand().indexOf("[") + 1, leftOper.getOperand().length() - 1);
                String[] tmpStrs = MemberProxy.splitMemberString(tempMember);
                String dimMem = null;
                int length = tmpStrs.length;
                for (int i = 0; i < length; ++i) {
                    if (tmpStrs[i] == null) continue;
                    int len = tmpStrs[i].length();
                    dimMem = tmpStrs[i].substring(1, len - 1);
                    if (dimMem.indexOf("FX") == -1) {
                        funMemberSet.add(dimMem);
                        continue;
                    }
                    if (dimMem.indexOf("BgP") != -1) {
                        dimMem = dimMem.split(",")[2].substring(1, dimMem.split(",")[2].length() - 3);
                        funMemberSet.add(dimMem);
                        continue;
                    }
                    funMemberSet.add("BgP");
                }
            } else if (!multiMem) {
                String[] members = leftOper.getOperand().split("\\[")[1].split("\\]")[0].split(",");
                memberSet = new HashSet<String>(BizParseDimMemHelper.trimQuotation(members));
            } else {
                memberSet = new HashSet<String>(BizParseDimMemHelper.processMultiMem(leftOper.getOperand().split("\"")[1].split("\"")[0]));
            }
            memberSet.addAll(funMemberSet);
        } else if (leftOper != null && MemberProxy.isMultiMember(leftOper.getOperand())) {
            String tempMember = leftOper.getOperand().substring(leftOper.getOperand().indexOf("[") + 2, leftOper.getOperand().length() - 2);
            memberSet.add(tempMember);
        } else if (leftOper != null && leftOper.getOperand().startsWith("VAR")) {
            if (!multiMem) {
                String operand = leftOper.getOperand();
                String[] members = operand.substring(operand.indexOf("\"") + 1, operand.lastIndexOf("\"")).split(",");
                List<String> memberList = this.replaceVAR2MBR(Arrays.asList(members), isRecordVar);
                memberSet = new HashSet<String>(memberList);
            } else {
                String operand = leftOper.getOperand();
                String[] members = operand.substring(operand.indexOf("\"") + 1, operand.lastIndexOf("\"")).split(",");
                List<String> memberList = this.replaceVAR2MBR(Arrays.asList(members), isRecordVar);
                if (!this.checkVarHasSameSrc(memberList)) {
                    this.recordException(BizCalcParseException.ERROR_EXPR_SAMESRC, leftOper.getOperand());
                }
                memberSet = new HashSet<String>(memberList);
            }
        } else if (leftOper != null && BizParseDimMemHelper.isFX(leftOper.getOperand())) {
            if (BizParseDimMemHelper.isBoolFX(leftOper.getOperand()) && !BizCalcCommonHelper.getFunctionName(leftOper.getOperand()).equals("@IsMember")) {
                memberSet = new HashSet<String>(BizParseDimMemHelper.trimQuotation(leftOper.getOperand().split("\\(")[1].split("\\)")[0].split(",")));
            } else if (BizParseDimMemHelper.isMathFX(leftOper.getOperand()) && !BizCalcCommonHelper.getFunctionName(leftOper.getOperand()).equals("@ABS") || BizParseDimMemHelper.isBoolFX(leftOper.getOperand()) && BizCalcCommonHelper.getFunctionName(leftOper.getOperand()).equals("@IsMember")) {
                if (org.apache.commons.lang.StringUtils.countMatches((String)leftOper.getOperand(), (String)"@") == 1) {
                    String subFormula = leftOper.getOperand().split("\\(")[1].split("\\)")[0];
                    if (subFormula.startsWith("MBR")) {
                        memberSet = this.getDimMemberSet(new Operand(subFormula), true, isRecordVar);
                    } else if (subFormula.startsWith("VAR")) {
                        memberSet = this.getDimMemberSet(new Operand(subFormula), true, isRecordVar);
                    }
                } else {
                    String fxStr = leftOper.getOperand();
                    memberSet = new HashSet<String>(BizParseDimMemHelper.trimQuotation(leftOper.getOperand().substring(fxStr.indexOf("(") + 1, fxStr.lastIndexOf(")")).split(",")));
                }
            } else {
                String operand = leftOper.getOperand();
                String subFormula = leftOper.getOperand().substring(operand.indexOf("(") + 1, operand.lastIndexOf(")"));
                BizParseParam param = new BizParseParam();
                param.setText(subFormula);
                BizExprParser parser = new BizExprParser(param);
                parser.setRecordExc(false);
                if (parser.parse()) {
                    ArrayList<Operand> rightOper = new ArrayList<Operand>();
                    Stack exprStack = parser.getExprStack();
                    if (exprStack != null) {
                        for (Object obj : exprStack) {
                            if (!(obj instanceof Operand)) continue;
                            rightOper.add((Operand)obj);
                        }
                        List<Set<String>> memberList = this.getDimMemberList(rightOper, isRecordVar);
                        for (Set<String> member : memberList) {
                            memberSet.addAll(member);
                        }
                    }
                }
            }
        } else if (BizParseHelper.isNum(leftOper.getOperand())) {
            memberSet.add(leftOper.getOperand());
        }
        return memberSet;
    }

    public static List<String> trimQuotation(String[] members) {
        ArrayList<String> mbrList = new ArrayList<String>();
        for (int i = 0; i < members.length; ++i) {
            String member;
            if ("\"\"".equals(members[i]) || !(member = members[i].split("\"")[1]).contains(":")) continue;
            mbrList.add(member);
        }
        return mbrList;
    }

    public static List<String> processMultiMem(String multiMemStr) {
        ArrayList<String> mbrList = new ArrayList<String>();
        String[] srcMembers = multiMemStr.split(":");
        String srcNum = srcMembers[0];
        String[] membersNum = srcMembers[1].split(",");
        for (int i = 0; i < membersNum.length; ++i) {
            mbrList.add(srcNum + ":" + membersNum[i]);
        }
        return mbrList;
    }

    protected static boolean isFX(String currExpr) {
        return BizParseHelper.isFX(currExpr);
    }

    protected static boolean isBoolFX(String currExpr) {
        return BizParseHelper.isBoolFX(currExpr);
    }

    protected static boolean isMathFX(String currExpr) {
        return BizParseHelper.isMathFX(currExpr);
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(this.bizName, this.subsetName, this.line));
    }

    private void recordException(NumericExceptionSubItem excSubItem, String charSeq, String bizName, String subsetName, Integer currLine) {
        BizParseExceptionHandler.recordException(excSubItem, charSeq, this.createParam(bizName, subsetName, currLine));
    }

    private void recordException(NumericExceptionSubItem excSubItem, Object[] exceptionParam, String bizName, String subsetName, Integer currLine) {
        BizParseExceptionHandler.recordException(excSubItem, exceptionParam, this.createParam(bizName, subsetName, currLine));
    }

    private BizParseParam createParam(String bizName, String subsetName, Integer currLine) {
        BizParseParam param = new BizParseParam();
        param.setCurrLine(currLine);
        param.setBizName(bizName);
        param.setSubsetName(subsetName);
        param.setAllExceptions(this.allExceptions);
        return param;
    }
}

