/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.eas.ma.biz.BizCalcParseException;
import com.kingdee.eas.ma.biz.parse.BizParseParam;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BizParseExceptionHandler {
    public static void recordException(NumericExceptionSubItem excSubItem, String charSeq, BizParseParam param) {
        Integer currLine = param.getCurrLine();
        String bizName = param.getBizName();
        String subsetName = param.getSubsetName();
        Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = param.getAllExceptions();
        BizCalcParseException exc = BizParseExceptionHandler.createException(excSubItem, charSeq, currLine, bizName, subsetName);
        List<Exception> lineList = allExceptions.get(bizName).get(subsetName).get(currLine);
        if (lineList == null) {
            lineList = new ArrayList<Exception>();
            allExceptions.get(bizName).get(subsetName).put(currLine, lineList);
        }
        String exprMsg = exc.getMessage();
        for (Exception e : allExceptions.get(bizName).get(subsetName).get(currLine)) {
            if (!exprMsg.equals(e.getMessage())) continue;
            return;
        }
        allExceptions.get(bizName).get(subsetName).get(currLine).add((Exception)((Object)exc));
    }

    private static BizCalcParseException createException(NumericExceptionSubItem excSubItem, String charSeq, Integer currLine, String bizName, String subsetName) {
        Object[] parmas = null;
        parmas = !StringUtils.isEmpty((String)charSeq) ? new Object[]{subsetName, currLine, charSeq} : new Object[]{subsetName, currLine};
        BizCalcParseException exc = new BizCalcParseException(excSubItem, parmas);
        return exc;
    }

    public static void recordException(NumericExceptionSubItem excSubItem, Object[] exceptionParam, BizParseParam param) {
        Integer currLine = param.getCurrLine();
        String bizName = param.getBizName();
        String subsetName = param.getSubsetName();
        Map<String, Map<String, Map<Integer, List<Exception>>>> allExceptions = param.getAllExceptions();
        BizCalcParseException exc = new BizCalcParseException(excSubItem, exceptionParam);
        List<Exception> lineList = allExceptions.get(bizName).get(subsetName).get(currLine);
        if (lineList == null) {
            lineList = new ArrayList<Exception>();
            allExceptions.get(bizName).get(subsetName).put(currLine, lineList);
        }
        String exprMsg = exc.getMessage();
        for (Exception e : allExceptions.get(bizName).get(subsetName).get(currLine)) {
            if (!exprMsg.equals(e.getMessage())) continue;
            return;
        }
        allExceptions.get(bizName).get(subsetName).get(currLine).add((Exception)((Object)exc));
    }
}

