/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.parse;

import com.kingdee.eas.ma.biz.utils.BizCalcCommonHelper;
import com.kingdee.eas.ma.mbg.BizFunctionType;
import com.kingdee.eas.ma.mbg.function.define.MbgFunctionSourceFactory;
import java.util.List;
import java.util.Map;

public class BizParseHelper {
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char ENTER = '\r';
    private static final char LINE_FEED = '\n';
    private static Map<String, List<String>> fnMap = null;
    private static List<String> memberFn = null;
    private static List<String> mathFn = null;
    private static List<String> boolFn = null;
    private static List<String> aggFn = null;

    public static boolean isBlank(char currChar) {
        return currChar == '\t' || currChar == '\r' || currChar == '\n' || currChar == ' ';
    }

    public static boolean isAnnotation(String script) {
        return script.trim().matches("\\/\\*[\\s\\S]*\\*\\/");
    }

    public static void initFunction() {
        if (fnMap != null) {
            return;
        }
        fnMap = MbgFunctionSourceFactory.getInstance().getFunctionNameMap();
        memberFn = fnMap.get(BizFunctionType.MEMBER.getName());
        mathFn = fnMap.get(BizFunctionType.MATH.getName());
        boolFn = fnMap.get(BizFunctionType.BOOLEAN.getName());
        aggFn = fnMap.get(BizFunctionType.AGG.getName());
    }

    public static boolean isMBR(String currExpr) {
        if (!currExpr.startsWith("MBR")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("MBR", currExpr);
    }

    public static boolean isLEAFMBR(String currExpr) {
        if (!currExpr.startsWith("LEAF_MBR")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("LEAF_MBR", currExpr);
    }

    public static boolean isNLEAFMBR(String currExpr) {
        if (!currExpr.startsWith("NLEAF_MBR")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("NLEAF_MBR", currExpr);
    }

    public static boolean isMBRExpr(String currExpr) {
        return BizParseHelper.isMBR(currExpr) || BizParseHelper.isLEAFMBR(currExpr) || BizParseHelper.isNLEAFMBR(currExpr);
    }

    public static boolean isVAR(String currExpr) {
        if (!currExpr.startsWith("VAR")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("VAR", currExpr);
    }

    public static boolean isGVF(String currExpr) {
        if (!currExpr.startsWith("GVF")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("GVF", currExpr);
    }

    public static boolean isAggFX(String currExpr) {
        if (aggFn != null && BizParseHelper.isFX(currExpr)) {
            String fnName = BizCalcCommonHelper.getFunctionName(currExpr);
            return aggFn.contains(fnName);
        }
        return false;
    }

    public static boolean isFX(String currExpr) {
        if (!currExpr.startsWith("FX")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("FX", currExpr);
    }

    public static boolean isBoolFX(String currExpr) {
        if (boolFn != null && BizParseHelper.isFX(currExpr)) {
            String fnName = BizCalcCommonHelper.getFunctionName(currExpr);
            return boolFn.contains(fnName);
        }
        return false;
    }

    public static boolean isMathFX(String currExpr) {
        if (mathFn != null && BizParseHelper.isFX(currExpr)) {
            String fnName = BizCalcCommonHelper.getFunctionName(currExpr);
            return mathFn.contains(fnName);
        }
        return false;
    }

    public static boolean isNum(String currExpr) {
        return currExpr.matches("\\-?([\\d]+\\.)?[\\d]+%?");
    }

    public static boolean isIf(String currExpr) {
        return currExpr.startsWith("IF");
    }

    public static boolean isPTO(String currExpr) {
        if (!currExpr.startsWith("PTO")) {
            return false;
        }
        return BizCalcCommonHelper.verifyFormula("PTO", currExpr);
    }

    static {
        BizParseHelper.initFunction();
    }
}

