/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.biz.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BizMemberQuery {
    private static Logger logger = Logger.getLogger((String)BizMemberQuery.class.getName());
    public static int SUPERIOR_MEMBER = 100;
    public static int SUPERIOR_INCLUDESELF_MEMBER = 101;
    public static int REMOVE_MEMBER = 102;
    public static int QUERY_ALL = 900;
    public static int QUERY_LEAF = 901;
    public static int QUERY_NOT_LEAF = 902;
    private Context ctx = null;
    private String bgSchemeId = null;
    private BgSchemeInfo schemeInfo = null;
    private Map<String, Map<String, Set<String>>> querys = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, Set<String>> queryProps = new HashMap<String, Set<String>>();
    private MbgDimCollection mbgDims = null;
    private Map<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
    private Map<String, MbgDimInfo> srcDimMap = new HashMap<String, MbgDimInfo>();
    private Map<String, List<IMember>> memberMap = new HashMap<String, List<IMember>>();

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    protected void setBgSchemeId(String bgSchemeId) {
        this.bgSchemeId = bgSchemeId;
    }

    protected String getBgSchemeId() {
        return this.bgSchemeId;
    }

    public void setSchemeInfo(BgSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    public BgSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    protected Map<String, Map<String, Set<String>>> getQuerys() {
        return this.querys;
    }

    public void setMbgColls(MbgDimCollection mbgDims) {
        this.mbgDims = mbgDims;
    }

    public MbgDimCollection getMbgColls() {
        return this.mbgDims;
    }

    protected Map<String, MbgDimInfo> getMbgDimMap() {
        return this.mbgDimMap;
    }

    protected Map<String, MbgDimInfo> getSrcDimMap() {
        return this.srcDimMap;
    }

    public static BizMemberQuery getInstance(Context ctx, String bgSchemeId) {
        return new BizMemberQuery(ctx, bgSchemeId);
    }

    private BizMemberQuery(Context ctx, String bgSchemeId) {
        this.setCtx(ctx);
        this.setBgSchemeId(bgSchemeId);
    }

    public static String getMemberKey(int memberType, String field) {
        return memberType + "_" + field;
    }

    public void addQueryMember(String field, String number, int memberType, int queryType) {
        if (StringUtils.isEmpty((String)field) || StringUtils.isEmpty((String)number)) {
            return;
        }
        Map<Object, Object> fieldMap = null;
        Set<String> numberSet = null;
        String queryKey = memberType + "_" + queryType;
        if (this.getQuerys().containsKey(queryKey)) {
            fieldMap = this.getQuerys().get(queryKey);
        } else {
            fieldMap = new HashMap();
            this.getQuerys().put(queryKey, fieldMap);
        }
        if (fieldMap.containsKey(field)) {
            numberSet = (Set)fieldMap.get(field);
        } else {
            numberSet = new HashSet();
            fieldMap.put(field, numberSet);
        }
        numberSet.add(number);
    }

    public void addQueryProp(String field, String number) {
        if (!this.queryProps.containsKey(field)) {
            this.queryProps.put(field, new HashSet());
        }
        this.queryProps.get(field).add(number);
    }

    public void addQueryFunction(String field, String functionStr, Map<String, String> variateMap) throws Exception {
        if (StringUtils.isEmpty((String)field) || StringUtils.isEmpty((String)functionStr) || variateMap == null) {
            return;
        }
        Object param = null;
        String dimNumber = null;
        String isLeaf = null;
        try {
            IExpress expr = MbgExprParseHelper.parse(functionStr);
            if (expr instanceof FunctionExpr) {
                FunctionExpr functionExpr = (FunctionExpr)expr;
                if (functionExpr.functionName.equalsIgnoreCase("Ancestors") || functionExpr.functionName.equalsIgnoreCase("iAscendants") || functionExpr.functionName.equalsIgnoreCase("IAncestors")) {
                    if (functionExpr.params.size() > 0) {
                        param = functionExpr.params.get(0);
                        if (param instanceof String) {
                            dimNumber = (String)param;
                        } else if (param instanceof MemberExpr) {
                            MemberExpr memberExpr = (MemberExpr)param;
                            dimNumber = memberExpr.getDimNumber();
                        }
                        dimNumber = DimUtils.getNumber((String)dimNumber);
                        if (functionExpr.functionName.equalsIgnoreCase("Ancestors")) {
                            this.addQueryMember(field, dimNumber, SUPERIOR_MEMBER, QUERY_ALL);
                        } else if (functionExpr.functionName.equalsIgnoreCase("iAscendants") || functionExpr.functionName.equalsIgnoreCase("IAncestors")) {
                            this.addQueryMember(field, dimNumber, SUPERIOR_INCLUDESELF_MEMBER, QUERY_ALL);
                        }
                    }
                } else if (functionExpr.functionName.equalsIgnoreCase("Descendants") || functionExpr.functionName.equalsIgnoreCase("iDescendants")) {
                    if (functionExpr.params.size() > 0) {
                        param = functionExpr.params.get(0);
                        if (param instanceof String) {
                            dimNumber = (String)param;
                        } else if (param instanceof MemberExpr) {
                            MemberExpr memberExpr = (MemberExpr)param;
                            dimNumber = memberExpr.getDimNumber();
                        }
                        dimNumber = DimUtils.getNumber((String)dimNumber);
                        int queryType = QUERY_ALL;
                        if (functionExpr.params.size() > 1 && (param = functionExpr.params.get(1)) instanceof String && !StringUtils.isEmpty((String)(isLeaf = (String)param))) {
                            queryType = Boolean.valueOf(isLeaf) != false ? QUERY_LEAF : QUERY_NOT_LEAF;
                        }
                        if (functionExpr.functionName.equalsIgnoreCase("Descendants")) {
                            this.addQueryMember(field, dimNumber, 2, queryType);
                        } else if (functionExpr.functionName.equalsIgnoreCase("iDescendants")) {
                            this.addQueryMember(field, dimNumber, 5, queryType);
                        }
                    }
                } else if (functionExpr.functionName.equalsIgnoreCase("Children") || functionExpr.functionName.equalsIgnoreCase("iChildrens")) {
                    if (functionExpr.params.size() > 0) {
                        param = functionExpr.params.get(0);
                        if (param instanceof String) {
                            dimNumber = (String)param;
                        } else if (param instanceof MemberExpr) {
                            MemberExpr memberExpr = (MemberExpr)param;
                            dimNumber = memberExpr.getDimNumber();
                        }
                        dimNumber = DimUtils.getNumber((String)dimNumber);
                        int queryType = QUERY_ALL;
                        if (functionExpr.params.size() > 1 && (param = functionExpr.params.get(1)) instanceof String && !StringUtils.isEmpty((String)(isLeaf = (String)param))) {
                            queryType = Boolean.valueOf(isLeaf) != false ? QUERY_LEAF : QUERY_NOT_LEAF;
                        }
                        if (functionExpr.functionName.equalsIgnoreCase("Children")) {
                            this.addQueryMember(field, dimNumber, 1, queryType);
                        } else if (functionExpr.functionName.equalsIgnoreCase("iChildrens")) {
                            this.addQueryMember(field, dimNumber, 4, queryType);
                        }
                    }
                } else if (functionExpr.functionName.equalsIgnoreCase("Siblings") || functionExpr.functionName.equalsIgnoreCase("iSiblings")) {
                    if (functionExpr.params.size() > 0) {
                        param = functionExpr.params.get(0);
                        if (param instanceof String) {
                            dimNumber = (String)param;
                        } else if (param instanceof MemberExpr) {
                            MemberExpr memberExpr = (MemberExpr)param;
                            dimNumber = memberExpr.getDimNumber();
                        }
                        dimNumber = DimUtils.getNumber((String)dimNumber);
                        if (functionExpr.functionName.equalsIgnoreCase("Siblings")) {
                            this.addQueryMember(field, dimNumber, 3, QUERY_ALL);
                        } else if (functionExpr.functionName.equalsIgnoreCase("iSiblings")) {
                            this.addQueryMember(field, dimNumber, 6, QUERY_ALL);
                        }
                    }
                } else if (functionExpr.functionName.equalsIgnoreCase("Remove") && functionExpr.params.size() == 2) {
                    Object obj = null;
                    int in = functionExpr.params.size();
                    for (int i = 0; i < in; ++i) {
                        obj = functionExpr.params.get(i);
                        if (!(obj instanceof FunctionExpr) && !(obj instanceof MemberExpr) && !(obj instanceof VariateExpr)) continue;
                    }
                    List<IMember> members = this.queryRemoveFcuntion(field, functionExpr, variateMap);
                    if (members != null) {
                        this.getMemberMap().put(field, members);
                    }
                }
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"expr parse error:", (Throwable)ex);
        }
    }

    public List<IMember> queryRemoveFcuntion(String field, FunctionExpr functionExpr, Map<String, String> variateMap) throws Exception {
        ArrayList<IMember> members = new ArrayList<IMember>();
        if (this.getCtx() == null || StringUtils.isEmpty((String)field) || functionExpr == null) {
            return null;
        }
        IMember member = null;
        List<IMember> colls1 = null;
        List<IMember> colls2 = null;
        HashSet<String> dimNumSet = new HashSet<String>();
        Connection conn = null;
        try {
            int i;
            int in;
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            this.initSchemeInfo(conn);
            this.initMbgDimInfo(conn);
            Object obj = functionExpr.params.get(0);
            if (obj instanceof FunctionExpr) {
                colls1 = this.queryFcuntion(conn, field, (FunctionExpr)obj);
            } else if (obj instanceof MdxMemberExpr) {
                colls1 = this.queryMdxMember(conn, field, (MdxMemberExpr)obj);
            } else if (obj instanceof VariateExpr) {
                colls1 = this.queryVarMember(conn, field, (VariateExpr)obj, variateMap);
            }
            if (colls1 != null) {
                in = colls1.size();
                for (i = 0; i < in; ++i) {
                    dimNumSet.add(colls1.get(i).getNumber());
                }
            }
            if ((obj = functionExpr.params.get(1)) instanceof FunctionExpr) {
                colls2 = this.queryFcuntion(conn, field, (FunctionExpr)obj);
            } else if (obj instanceof MdxMemberExpr) {
                colls2 = this.queryMdxMember(conn, field, (MdxMemberExpr)obj);
            } else if (obj instanceof VariateExpr) {
                colls2 = this.queryVarMember(conn, field, (VariateExpr)obj, variateMap);
            }
            if (colls2 != null) {
                in = colls2.size();
                for (i = 0; i < in; ++i) {
                    member = colls2.get(i);
                    if (dimNumSet.contains(member.getNumber())) continue;
                    members.add(member);
                }
            }
        }
        catch (SQLDataException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return members;
    }

    private List<IMember> queryVarMember(Connection conn, String field, VariateExpr variateExpr, Map<String, String> variateMap) throws Exception {
        String dimNumber;
        String[] tmpStrs;
        ArrayList<IMember> members = new ArrayList<IMember>();
        if (conn == null || field == null || variateExpr == null || variateExpr.expr == null) {
            return members;
        }
        if (variateMap.containsKey(variateExpr.name) && (tmpStrs = (dimNumber = variateMap.get(variateExpr.name)).split(":")) != null) {
            Member member = new Member();
            member.setSrcNumber(tmpStrs[0]);
            member.setNumber(tmpStrs[1]);
            members.add((IMember)member);
        }
        return members;
    }

    public List<IMember> queryMdxMember(Connection conn, String field, MdxMemberExpr mdxMemberExpr) throws Exception {
        ArrayList<IMember> members = new ArrayList<IMember>();
        if (conn == null || field == null || mdxMemberExpr == null) {
            return members;
        }
        IExpress expr = null;
        Member member = null;
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>();
        int in = mdxMemberExpr.params.size();
        for (int i = 0; i < in; ++i) {
            expr = mdxMemberExpr.params.get(i);
            if (!(expr instanceof MemberExpr)) continue;
            MemberExpr memberExpr = (MemberExpr)expr;
            if (((MemberExpr)expr).srcNumber == null) {
                String[] tmpStrs = ((MemberExpr)expr).getDimNumber().split(":");
                ((MemberExpr)expr).srcNumber = tmpStrs[0];
                ((MemberExpr)expr).number = tmpStrs[1];
            }
            if (((MemberExpr)expr).field == null) {
                ((MemberExpr)expr).field = this.getSrcDimMap().get(((MemberExpr)expr).srcNumber).getRefField();
            }
            if (!field.equals(((MemberExpr)expr).field)) continue;
            int fillType = MbgFunctionHelper.getFillType((String)memberExpr.number);
            if (0 == fillType) {
                member = new Member();
                member.setSrcNumber(((MemberExpr)expr).srcNumber);
                member.setNumber(((MemberExpr)expr).number);
                members.add((IMember)member);
                continue;
            }
            fieldMap.clear();
            HashSet<String> subSet = new HashSet<String>();
            subSet.add(MbgFunctionHelper.getMemberNumber((String)memberExpr.number));
            fieldMap.put(memberExpr.field, subSet);
            fieldMap.get(memberExpr.number);
            Map<String, List<IMember>> result = this.queryMember(conn, fillType + "_" + QUERY_ALL, fieldMap);
            if (members == null || !result.containsKey(memberExpr.field)) continue;
            members.addAll((Collection<IMember>)result.get(memberExpr.field));
        }
        return members;
    }

    public List<IMember> queryFcuntion(Connection conn, String field, FunctionExpr functionExpr) throws Exception {
        List<IMember> members = new ArrayList<IMember>();
        if (conn == null || field == null || functionExpr == null) {
            return members;
        }
        Object param = null;
        String dimNumber = null;
        String isLeaf = null;
        HashSet<String> dimNumSet = new HashSet<String>();
        if (functionExpr.functionName.equalsIgnoreCase("Ancestors") || functionExpr.functionName.equalsIgnoreCase("iAscendants")) {
            if (functionExpr.params.size() > 0) {
                param = functionExpr.params.get(0);
                if (param instanceof String) {
                    dimNumber = (String)param;
                } else if (param instanceof MemberExpr) {
                    MemberExpr memberExpr = (MemberExpr)param;
                    dimNumber = memberExpr.getDimNumber();
                }
                dimNumSet.add(DimUtils.getNumber((String)dimNumber));
                if (functionExpr.functionName.equalsIgnoreCase("Ancestors")) {
                    members = this.querySuperiorMember(conn, field, dimNumSet, false);
                } else if (functionExpr.functionName.equalsIgnoreCase("iAscendants")) {
                    members = this.querySuperiorMember(conn, field, dimNumSet, true);
                }
            }
        } else if (functionExpr.functionName.equalsIgnoreCase("Descendants") || functionExpr.functionName.equalsIgnoreCase("iDescendants")) {
            if (functionExpr.params.size() > 0) {
                param = functionExpr.params.get(0);
                if (param instanceof String) {
                    dimNumber = (String)param;
                } else if (param instanceof MemberExpr) {
                    MemberExpr memberExpr = (MemberExpr)param;
                    dimNumber = memberExpr.getDimNumber();
                }
                dimNumSet.add(DimUtils.getNumber((String)dimNumber));
                int queryType = QUERY_ALL;
                if (functionExpr.params.size() > 1 && (param = functionExpr.params.get(1)) instanceof String && !StringUtils.isEmpty((String)(isLeaf = (String)param))) {
                    queryType = Boolean.valueOf(isLeaf) != false ? QUERY_LEAF : QUERY_NOT_LEAF;
                }
                if (functionExpr.functionName.equalsIgnoreCase("Descendants")) {
                    members = this.querySubMember(conn, field, dimNumSet, false, false, queryType);
                } else if (functionExpr.functionName.equalsIgnoreCase("iDescendants")) {
                    members = this.querySubMember(conn, field, dimNumSet, true, false, queryType);
                }
            }
        } else if (functionExpr.functionName.equalsIgnoreCase("Children") || functionExpr.functionName.equalsIgnoreCase("iChildrens")) {
            if (functionExpr.params.size() > 0) {
                param = functionExpr.params.get(0);
                if (param instanceof String) {
                    dimNumber = (String)param;
                } else if (param instanceof MemberExpr) {
                    MemberExpr memberExpr = (MemberExpr)param;
                    dimNumber = memberExpr.getDimNumber();
                }
                dimNumSet.add(DimUtils.getNumber((String)dimNumber));
                int queryType = QUERY_ALL;
                if (functionExpr.params.size() > 1 && (param = functionExpr.params.get(1)) instanceof String && !StringUtils.isEmpty((String)(isLeaf = (String)param))) {
                    queryType = Boolean.valueOf(isLeaf) != false ? QUERY_LEAF : QUERY_NOT_LEAF;
                }
                if (functionExpr.functionName.equalsIgnoreCase("Descendants")) {
                    members = this.querySubMember(conn, field, dimNumSet, false, true, queryType);
                } else if (functionExpr.functionName.equalsIgnoreCase("iDescendants")) {
                    members = this.querySubMember(conn, field, dimNumSet, true, true, queryType);
                }
            }
        } else if ((functionExpr.functionName.equalsIgnoreCase("Siblings") || functionExpr.functionName.equalsIgnoreCase("iSiblings")) && functionExpr.params.size() > 0) {
            param = functionExpr.params.get(0);
            if (param instanceof String) {
                dimNumber = (String)param;
            } else if (param instanceof MemberExpr) {
                MemberExpr memberExpr = (MemberExpr)param;
                dimNumber = memberExpr.getDimNumber();
            }
            dimNumSet.add(DimUtils.getNumber((String)dimNumber));
            if (functionExpr.functionName.equalsIgnoreCase("Siblings")) {
                members = this.queryBrotherMember(conn, field, dimNumSet, false);
            } else if (functionExpr.functionName.equalsIgnoreCase("iSiblings")) {
                members = this.queryBrotherMember(conn, field, dimNumSet, true);
            }
        }
        return members;
    }

    public Map<String, List<IMember>> getMemberMap() {
        return this.memberMap;
    }

    public Map<String, List<IMember>> queryMember() throws Exception {
        if (this.getCtx() == null || StringUtils.isEmpty((String)this.getBgSchemeId()) || this.getQuerys().isEmpty() && this.queryProps.isEmpty()) {
            return this.getMemberMap();
        }
        Connection conn = null;
        Map<String, List<IMember>> tmpMap = null;
        Map.Entry<String, Map<String, Set<String>>> entry2 = null;
        Map<String, Set<String>> fieldMap = null;
        String queryType = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getCtx());
            this.initSchemeInfo(conn);
            this.initMbgDimInfo(conn);
            for (Map.Entry<String, Map<String, Set<String>>> entry2 : this.getQuerys().entrySet()) {
                queryType = entry2.getKey();
                tmpMap = this.queryMember(conn, queryType, fieldMap = entry2.getValue());
                if (tmpMap == null) continue;
                this.mergeMemberData(this.getMemberMap(), tmpMap);
            }
            Map<String, List<IMember>> propMembers = this.queryPropMembers(conn);
            if (propMembers != null) {
                this.mergeMemberData(this.getMemberMap(), propMembers);
            }
        }
        catch (SQLDataException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return this.getMemberMap();
    }

    private Map<String, List<IMember>> queryPropMembers(Connection conn) throws Exception {
        HashMap<String, List<IMember>> result = new HashMap<String, List<IMember>>();
        if (this.queryProps.isEmpty()) {
            return result;
        }
        Object sourceType = null;
        Object mbgDimId = null;
        HashSet propIds = new HashSet();
        Object subMap = null;
        for (String field : this.queryProps.keySet()) {
            propIds.addAll(this.queryProps.get(field));
        }
        Map mbgMembers = ViewListMemberCacheHelper.queryPropertyMember((Context)this.getCtx(), (Connection)conn, null, propIds, (String)this.getSchemeInfo().getViewId(DimensionConstants.DEF_ACCOUNT_NUMBER).toString(), new ArrayList(this.getSchemeInfo().getExtDimViewIdSet()), (String)this.getSchemeInfo().getEditOrgViewId().toString());
        if (mbgMembers == null) {
            return result;
        }
        HashSet<String> memberSet = new HashSet<String>();
        String field = null;
        Member _member = null;
        for (List members : mbgMembers.values()) {
            for (BgDimensionMember member : members) {
                if (memberSet.contains(member.getCombNumber())) continue;
                memberSet.add(member.getCombNumber());
                field = DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(member.getSrcNumber()) ? DimensionConstants.DEF_ORGUNIT_FIELD : (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(member.getSrcNumber()) ? DimensionConstants.DEF_BGINDEX_FIELD : this.srcDimMap.get(member.getSrcNumber()).getRefField());
                if (!result.containsKey(field)) {
                    result.put(field, new ArrayList());
                }
                _member = new Member();
                _member.setNumber(member.getNumber());
                _member.setSrcNumber(member.getSrcNumber());
                _member.setName(member.getName());
                ((List)result.get(field)).add(_member);
            }
        }
        return result;
    }

    private String getPropKey(String sourceType, String mbgDimId) {
        return sourceType + "_" + StringUtils.cnulls((String)mbgDimId);
    }

    public void initSchemeInfo(Connection conn) throws EASBizException {
        if (this.getSchemeInfo() == null) {
            this.setSchemeInfo(MbgDataHelper.getBgSchemeInfo((Connection)conn, (Locale)this.getCtx().getLocale(), (BOSUuid)BOSUuid.read((String)this.getBgSchemeId())));
        }
    }

    public void initMbgDimInfo(Connection conn) throws BOSException {
        if (this.getMbgColls() == null || this.getMbgColls().isEmpty()) {
            this.setMbgColls(DimUtils.getDimensionColls((Connection)conn, (Locale)this.getCtx().getLocale()));
        }
        if (this.getMbgDimMap().isEmpty()) {
            MbgDimInfo mbgDim = null;
            int in = this.getMbgColls().size();
            for (int i = 0; i < in; ++i) {
                mbgDim = this.getMbgColls().get(i);
                this.getMbgDimMap().put(mbgDim.getRefField(), mbgDim);
                this.getSrcDimMap().put(mbgDim.getSrcNumber(), mbgDim);
            }
        }
    }

    protected Map<String, List<IMember>> queryMember(Connection conn, String queryKey, Map<String, Set<String>> fieldMap) throws Exception {
        HashMap<String, List<IMember>> memberMap = new HashMap<String, List<IMember>>();
        if (conn == null || StringUtils.isEmpty((String)queryKey) || fieldMap == null || fieldMap.isEmpty()) {
            return memberMap;
        }
        List<IMember> colls = null;
        Map.Entry<String, Set<String>> entry2 = null;
        String field = null;
        Set<String> numberSet = null;
        String[] tmpStrs = queryKey.split("_");
        int memberType = Integer.valueOf(tmpStrs[0]);
        int queryType = Integer.valueOf(tmpStrs[1]);
        for (Map.Entry<String, Set<String>> entry2 : fieldMap.entrySet()) {
            field = entry2.getKey();
            numberSet = entry2.getValue();
            if (memberType == 1 || memberType == 4) {
                colls = this.querySubMember(conn, field, numberSet, memberType == 4, true, queryType);
            } else if (memberType == 2 || memberType == 5) {
                colls = this.querySubMember(conn, field, numberSet, memberType == 5, false, queryType);
            } else if (memberType == 3 || memberType == 6) {
                colls = this.queryBrotherMember(conn, field, numberSet, memberType == 6);
            } else if (memberType == SUPERIOR_MEMBER || memberType == SUPERIOR_INCLUDESELF_MEMBER) {
                colls = this.querySuperiorMember(conn, field, numberSet, memberType == SUPERIOR_INCLUDESELF_MEMBER);
            } else if (memberType == REMOVE_MEMBER) {
                colls = this.queryRemoveMember(conn, field, numberSet);
            }
            if (colls == null || colls.isEmpty()) continue;
            memberMap.put(field, colls);
        }
        return memberMap;
    }

    protected List<IMember> querySubMember(Connection conn, String field, Collection<String> numbers, boolean isIncludeSelf, boolean isOnlySub, int queryType) throws Exception {
        ArrayList<IMember> members = new ArrayList<IMember>();
        if (conn == null || StringUtils.isEmpty((String)field) || numbers == null || numbers.isEmpty()) {
            return members;
        }
        if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(field)) {
            return members;
        }
        StringBuffer sql = new StringBuffer();
        String srcNumber = this.getMbgDimMap().get(field).getSrcNumber();
        ArrayList<String> firstParams = new ArrayList<String>();
        List results = null;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        Object[] param = null;
        HashSet<String> tmpSet = new HashSet<String>();
        Member member = null;
        try {
            if (DimUtils.checkBaseDimensionByField((String)field)) {
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                    firstParams.add(this.getSchemeInfo().getEditOrgViewId().toString());
                }
            } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                firstParams.add(this.getSchemeInfo().getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString());
            } else {
                firstParams.add(this.getSchemeInfo().getViewId(this.getMbgDimMap().get(field).getNumber()).toString());
            }
            if (isOnlySub) {
                for (String number : numbers) {
                    param = new Object[]{number};
                    sqlParams.add(param);
                }
            } else {
                ArrayList<String> queryParams = new ArrayList<String>();
                queryParams.addAll(numbers);
                StringBuffer query = new StringBuffer();
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                    query.append("select FLongNumber from T_MBG_BgOrgUnit where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
                    query.append("select FLongNumber from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                    query.append("select FLongNumber from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
                    query.append("select FLongNumber from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
                    query.append("select FLongNumber from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                    query.append("select FLongNumber from T_MBG_BgAccount where FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else {
                    query.append("select FLongNumber from T_MBG_MbgMember where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                }
                results = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), firstParams, queryParams);
                if (isIncludeSelf) {
                    for (Object[] result : results) {
                        param = new Object[]{result[0], result[0] + "!%"};
                        sqlParams.add(param);
                    }
                } else {
                    for (Object[] result : results) {
                        param = new Object[]{result[0] + "!%"};
                        sqlParams.add(param);
                    }
                }
            }
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                if (isOnlySub) {
                    sql.append("select sub.FNumber from T_MBG_BgOrgUnit sub where sub.FParentId IN (select FID from T_MBG_BgOrgUnit where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                } else {
                    sql.append("select FNumber from T_MBG_BgOrgUnit where FViewId = ? and " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
                }
            } else if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
                if (isOnlySub) {
                    sql.append("select sub.FNumber from T_MBG_BgElement sub where sub.FParentId IN (select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                } else {
                    sql.append("select FNumber from T_MBG_BgElement where " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
                    if (queryType == QUERY_LEAF || queryType == QUERY_NOT_LEAF) {
                        sql.append(" and FIsLeaf = " + (queryType == QUERY_LEAF ? 1 : 0));
                    }
                }
            } else if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                if (isOnlySub) {
                    sql.append("select sub.FNumber from T_MBG_BgPeriod sub where sub.FParentId IN (select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                } else {
                    sql.append("select FNumber from T_MBG_BgPeriod where " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
                }
            } else if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
                if (isOnlySub) {
                    sql.append("select sub.FNumber from T_MBG_BgScenario sub where sub.FParentId IN (select FID from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                } else {
                    sql.append("select FNumber from T_MBG_BgScenario where " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
                }
            } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
                if (isOnlySub) {
                    sql.append("select sub.FNumber from T_MBG_BgVersion sub where sub.FParentId IN (select FID from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                } else {
                    sql.append("select FNumber from T_MBG_BgVersion where " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
                }
            } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                if (isOnlySub) {
                    sql.append("select sub.FNumber from T_MBG_BgAccount sub where sub.FParentId IN (select FID from T_MBG_BgAccount where FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                } else {
                    sql.append("select FNumber from T_MBG_BgAccount where FBgAccountViewId = ? and " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
                }
            } else if (isOnlySub) {
                sql.append("select sub.FNumber from T_MBG_MbgMember sub where sub.FParentId IN (select FID from T_MBG_MbgMember where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else {
                sql.append("select FNumber from T_MBG_MbgMember where FViewId = ? and " + BgDBUtils.getLongNumSqlParam((int)50, (boolean)isIncludeSelf));
            }
            if (queryType == QUERY_LEAF || queryType == QUERY_NOT_LEAF) {
                if (isOnlySub) {
                    sql.append(" and sub.FIsLeaf = " + (queryType == QUERY_LEAF ? 1 : 0));
                } else {
                    sql.append(" and FIsLeaf = " + (queryType == QUERY_LEAF ? 1 : 0));
                }
            }
            results = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), firstParams, sqlParams, (int)(isOnlySub ? 1 : (isIncludeSelf ? 2 : 1)));
            for (Object[] result : results) {
                if (result[0] == null) continue;
                member = new Member();
                member.setSrcNumber(srcNumber);
                member.setNumber(result[0].toString());
                members.add((IMember)member);
                tmpSet.add(member.getNumber());
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"querySubMember sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        if (isIncludeSelf) {
            for (String number : numbers) {
                if (tmpSet.contains(number)) continue;
                member = new Member();
                member.setSrcNumber(srcNumber);
                member.setNumber(number);
                members.add((IMember)member);
                tmpSet.add(member.getNumber());
            }
        } else {
            tmpSet.clear();
            tmpSet.addAll(numbers);
            ArrayList<Member> removes = new ArrayList<Member>();
            int in = members.size();
            for (int i = 0; i < in; ++i) {
                member = (IMember)members.get(i);
                if (!tmpSet.contains(member.getNumber())) continue;
                removes.add(member);
            }
            if (!removes.isEmpty()) {
                members.removeAll(removes);
            }
        }
        return members;
    }

    protected List<IMember> queryBrotherMember(Connection conn, String field, Collection<String> numbers, boolean isIncludeSelf) throws Exception {
        ArrayList<IMember> members = new ArrayList<IMember>();
        if (conn == null || StringUtils.isEmpty((String)field) || numbers == null || numbers.isEmpty()) {
            return members;
        }
        ArrayList<String> firstParams = new ArrayList<String>();
        ArrayList<String> sqlParams = new ArrayList<String>();
        List results = null;
        StringBuffer query = new StringBuffer();
        StringBuffer queryTop = new StringBuffer();
        String srcNumber = this.getMbgDimMap().get(field).getSrcNumber();
        Member member = null;
        try {
            if (DimUtils.checkBaseDimensionByField((String)field)) {
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                    firstParams.add(this.getSchemeInfo().getEditOrgViewId().toString());
                }
            } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                firstParams.add(this.getSchemeInfo().getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString());
            } else {
                firstParams.add(this.getSchemeInfo().getViewId(this.getMbgDimMap().get(field).getNumber()).toString());
            }
            sqlParams.addAll(numbers);
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                query.append("select bro.FNumber from T_MBG_BgOrgUnit bro where bro.FParentId IN (select FParentId from T_MBG_BgOrgUnit where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
                query.append("select bro.FNumber from T_MBG_BgElement bro where bro.FParentId IN (select FParentId from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                query.append("select bro.FNumber from T_MBG_BgPeriod bro where bro.FParentId IN (select FParentId from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(field)) {
                query.append("select FNumber from T_BD_Currency");
            } else if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
                query.append("select bro.FNumber from T_MBG_BgScenario bro where bro.FParentId IN (select FParentId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
                query.append("select bro.FNumber from T_MBG_BgVersion bro where bro.FParentId IN (select FParentId from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                query.append("select bro.FNumber from T_MBG_BgAccount bro where bro.FParentId IN (select FParentId from T_MBG_BgAccount where FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
                queryTop.append("select bro.FNumber from T_MBG_BgAccount bro where bro.FParentId IS NULL AND Exists (select FParentId from T_MBG_BgAccount where FParentId IS NULL AND FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            } else {
                query.append("select bro.FNumber from T_MBG_MbgMember bro where bro.FParentId IN (select FParentId from T_MBG_MbgMember where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + "))");
            }
            HashSet<String> membersNumbers = new HashSet<String>();
            results = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), firstParams, sqlParams);
            for (Object[] result : results) {
                member = new Member();
                member.setSrcNumber(srcNumber);
                member.setNumber(result[0].toString());
                if (membersNumbers.contains(member.getNumber())) continue;
                members.add((IMember)member);
                membersNumbers.add(member.getNumber());
            }
            if (queryTop.length() > 0) {
                results = BgDBUtils.executeBatchQuery((Connection)conn, (String)queryTop.toString(), firstParams, sqlParams);
                for (Object[] result : results) {
                    member = new Member();
                    member.setSrcNumber(srcNumber);
                    member.setNumber(result[0].toString());
                    if (membersNumbers.contains(member.getNumber())) continue;
                    members.add((IMember)member);
                    membersNumbers.add(member.getNumber());
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"querySubMember sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        if (!isIncludeSelf) {
            HashSet<String> tmpSet = new HashSet<String>();
            tmpSet.addAll(numbers);
            ArrayList<Member> removes = new ArrayList<Member>();
            int in = members.size();
            for (int i = 0; i < in; ++i) {
                member = (IMember)members.get(i);
                if (!tmpSet.contains(member.getNumber())) continue;
                removes.add(member);
            }
            if (!removes.isEmpty()) {
                members.removeAll(removes);
            }
        }
        return members;
    }

    protected List<IMember> querySuperiorMember(Connection conn, String field, Collection<String> numbers, boolean isIncludeSelf) throws Exception {
        ArrayList<IMember> members = new ArrayList<IMember>();
        if (conn == null || StringUtils.isEmpty((String)field) || numbers == null || numbers.isEmpty()) {
            return members;
        }
        String srcNumber = this.getMbgDimMap().get(field).getSrcNumber();
        String number = null;
        String longNumber = null;
        String[] tmpNums = null;
        Map.Entry<String, String> entry2 = null;
        Member member = null;
        HashSet<String> filterSet = new HashSet<String>();
        Map<String, String> memberMap = BizMemberQuery.querySuperiorMember(conn, this.getSchemeInfo(), field, numbers, this.getMbgDimMap());
        for (Map.Entry<String, String> entry2 : memberMap.entrySet()) {
            int in;
            number = entry2.getKey();
            longNumber = entry2.getValue();
            tmpNums = longNumber.split("!");
            if (tmpNums == null) continue;
            int n = in = isIncludeSelf ? tmpNums.length : tmpNums.length - 1;
            for (int i = 0; i < in; ++i) {
                number = tmpNums[i];
                if (filterSet.contains(number)) continue;
                filterSet.add(number);
                member = new Member();
                member.setSrcNumber(srcNumber);
                member.setNumber(number);
                members.add((IMember)member);
            }
        }
        return members;
    }

    public static Map<String, String> querySuperiorMember(Connection conn, BgSchemeInfo schemeInfo, String field, Collection<String> numbers, Map<String, MbgDimInfo> mbgDimMap) throws EASBizException {
        HashMap<String, String> memberMap = new HashMap<String, String>();
        if (conn == null || schemeInfo == null || StringUtils.isEmpty((String)field) || numbers == null || numbers.isEmpty()) {
            return memberMap;
        }
        ArrayList<String> firstParams = new ArrayList<String>();
        ArrayList<String> sqlParams = new ArrayList<String>();
        List results = null;
        String number = null;
        String longNumber = null;
        try {
            if (DimUtils.checkBaseDimensionByField((String)field)) {
                if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                    firstParams.add(schemeInfo.getEditOrgViewId().toString());
                }
            } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                firstParams.add(schemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString());
            } else {
                firstParams.add(schemeInfo.getViewId(mbgDimMap.get(field).getNumber()).toString());
            }
            sqlParams.addAll(numbers);
            StringBuffer query = new StringBuffer();
            if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(field)) {
                query.append("select FNumber, FLongNumber from T_MBG_BgOrgUnit where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
            } else if (DimensionBaseConstants.DEF_ELEMENT_FIELD.equals(field)) {
                query.append("select FNumber, FLongNumber from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
            } else if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(field)) {
                query.append("select FNumber, FLongNumber from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
            } else if (!DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(field)) {
                if (DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(field)) {
                    query.append("select FNumber, FLongNumber from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_VERSION_FIELD.equals(field)) {
                    query.append("select FNumber, FLongNumber from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(field)) {
                    query.append("select FNumber, FLongNumber from T_MBG_BgAccount where FBgAccountViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                } else {
                    query.append("select FNumber, FLongNumber from T_MBG_MbgMember where FViewId = ? and FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")");
                }
            }
            if (DimensionBaseConstants.DEF_CURRENCY_FIELD.equals(field)) {
                for (String _number : numbers) {
                    memberMap.put(_number, _number);
                }
            } else {
                results = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), firstParams, sqlParams);
                for (Object[] result : results) {
                    number = (String)result[0];
                    longNumber = (String)result[1];
                    memberMap.put(number, longNumber);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"querySubMember sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return memberMap;
    }

    protected List<IMember> queryRemoveMember(Connection conn, String field, Collection<String> numbers) throws Exception {
        return null;
    }

    private void mergeMemberData(Map<String, List<IMember>> targetMap, Map<String, List<IMember>> sourceMap) {
        if (targetMap == null || sourceMap == null) {
            return;
        }
        Map.Entry<String, List<IMember>> entry2 = null;
        List<IMember> members = null;
        for (Map.Entry<String, List<IMember>> entry2 : sourceMap.entrySet()) {
            if (targetMap.containsKey(entry2.getKey())) {
                members = targetMap.get(entry2.getKey());
                if (members == null) continue;
                members.addAll((Collection<IMember>)entry2.getValue());
                continue;
            }
            targetMap.put(entry2.getKey(), entry2.getValue());
        }
    }
}

