/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.ma.control.client.AbstractBgControlBillBizSystemUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgControlBillBizSystemUI
extends AbstractBgControlBillBizSystemUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlBillBizSystemUI.class);
    private boolean isCancel = true;
    private List<MetaDataBriefInfo> data;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() throws EASBizException, BOSException {
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_botp", (BOSObjectType)MetaDataTypeList.ENTITY)));
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeLeft.setModel((TreeModel)model);
        this.treeLeft.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BgControlBillBizSystemUI.this.treeLeftClick(e);
            }
        });
        this.treeRight.setModel(null);
        this.treeRight.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BgControlBillBizSystemUI.this.treeRightClick(e);
            }
        });
    }

    protected void treeLeftClick(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        if (e.getSource() instanceof KDTree) {
            this.toNodeRight();
        }
    }

    protected void toNodeRight() {
        TreePath[] paths = this.treeLeft.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        for (TreePath treePath : paths) {
            if (treePath == null) continue;
            if (this.treeRight.getModel() == null) {
                this.createNewRigthTreeModel(treePath);
                continue;
            }
            this.addNewNodeToRightTree(treePath);
        }
    }

    protected void treeRightClick(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        this.deleteRightTreeNode();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.toNodeRight();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        this.deleteRightTreeNode();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        if (this.treeRight.getModel() == null || this.treeRight.getModel().getRoot() == null) {
            this.btnCancel_actionPerformed(e);
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeRight.getModel().getRoot();
        this.data = new ArrayList<MetaDataBriefInfo>();
        this.setData(root);
        this.setCancel(false);
        this.getUIWindow().close();
    }

    protected void setData(DefaultKingdeeTreeNode node) {
        MetaDataBriefInfo info;
        if (node == null) {
            return;
        }
        if (node.getUserObject() instanceof MetaDataBriefInfo && "enty".equals((info = (MetaDataBriefInfo)node.getUserObject()).getMetaDataType().toString())) {
            this.data.add(info);
        }
        if (node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                this.setData((DefaultKingdeeTreeNode)e.nextElement());
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    protected void deleteRightTreeNode() {
        if (this.treeRight == null || this.treeRight.getModel() == null) {
            return;
        }
        TreePath[] paths = this.treeRight.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeRight.getModel().getRoot();
        for (TreePath treePath : paths) {
            if (treePath == null) continue;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            DefaultKingdeeTreeNode parnetNode = (DefaultKingdeeTreeNode)node.getParent();
            if (this.isEquesNode(root, node)) {
                this.treeRight.setModel(null);
                return;
            }
            this.deleteNode(root, node);
            if (parnetNode == null || !this.deleteParentNode(root, parnetNode)) continue;
            this.treeRight.setModel(null);
            return;
        }
        this.treeRight.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        this.treeRight.expandAllNodes(true, (TreeNode)root);
    }

    protected boolean deleteParentNode(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode node) {
        if (root == null || node == null) {
            return false;
        }
        DefaultKingdeeTreeNode pNode = null;
        if (node.getParent() instanceof DefaultKingdeeTreeNode) {
            pNode = (DefaultKingdeeTreeNode)node.getParent();
        }
        if (node == root && node.getChildCount() == 0) {
            return true;
        }
        if (node.getChildCount() > 0) {
            return false;
        }
        node.removeFromParent();
        if (pNode != null) {
            return this.deleteParentNode(root, pNode);
        }
        return false;
    }

    protected boolean deleteNode(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode node) {
        if (node == null || root == null) {
            return false;
        }
        if (this.isEquesNode(root, node)) {
            if (root.getParent() == null) {
                root = null;
                return true;
            }
            root.removeFromParent();
            return true;
        }
        if (root.getChildCount() == 0) {
            return false;
        }
        Enumeration e = root.children();
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode tmpnode = (DefaultKingdeeTreeNode)e.nextElement();
            if (!this.deleteNode(tmpnode, node)) continue;
            return true;
        }
        return false;
    }

    protected void createNewRigthTreeModel(TreePath path) {
        DefaultKingdeeTreeNode node = this.createTreeNodeByPath(path, (DefaultKingdeeTreeNode)path.getLastPathComponent());
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)node);
        this.treeRight.setModel((TreeModel)model);
        this.treeRight.expandAllNodes(true, (TreeNode)node);
    }

    protected DefaultKingdeeTreeNode createTreeNodeByPath(TreePath path, DefaultKingdeeTreeNode node) {
        if (path == null || node == null || path.getParentPath() == null) {
            return node;
        }
        if (path.getParentPath().getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
            TreePath pPath = path.getParentPath();
            if (pPath != null) {
                DefaultKingdeeTreeNode pNode = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)pPath.getLastPathComponent()).clone();
                pNode.add((MutableTreeNode)node);
                return this.createTreeNodeByPath(pPath, pNode);
            }
            return node;
        }
        return node;
    }

    protected void addTreeNodeByPath(TreePath path, DefaultKingdeeTreeNode node) {
        if (path == null || node == null || path.getParentPath() == null) {
            return;
        }
        if (path.getParentPath().getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
            TreePath pPath = path.getParentPath();
            if (pPath != null) {
                DefaultKingdeeTreeNode pNode = (DefaultKingdeeTreeNode)pPath.getLastPathComponent();
                if ((pNode = this.queryParentNodeFromRight(pNode)) != null) {
                    boolean isHasCurrentChildNode = false;
                    if (pNode.getChildCount() > 0) {
                        Enumeration e = pNode.children();
                        while (e.hasMoreElements()) {
                            if (!this.isEquesNode((DefaultKingdeeTreeNode)e.nextElement(), node)) continue;
                            isHasCurrentChildNode = true;
                            break;
                        }
                    }
                    if (!isHasCurrentChildNode) {
                        pNode.add((MutableTreeNode)node);
                    }
                } else {
                    pNode = (DefaultKingdeeTreeNode)((DefaultKingdeeTreeNode)pPath.getLastPathComponent()).clone();
                    pNode.add((MutableTreeNode)node);
                    this.addTreeNodeByPath(pPath, pNode);
                }
            } else {
                return;
            }
        }
    }

    protected DefaultKingdeeTreeNode queryParentNodeFromRight(DefaultKingdeeTreeNode node) {
        if (this.treeRight.getModel() == null || node == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeRight.getModel().getRoot();
        return this.getNode(rootNode, node);
    }

    protected DefaultKingdeeTreeNode getNode(DefaultKingdeeTreeNode rootNode, DefaultKingdeeTreeNode currNode) {
        if (rootNode == null || currNode == null) {
            return null;
        }
        if (this.isEquesNode(rootNode, currNode)) {
            return rootNode;
        }
        if (rootNode.getChildCount() == 0) {
            return null;
        }
        Enumeration e = rootNode.children();
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode tmpNode = this.getNode((DefaultKingdeeTreeNode)e.nextElement(), currNode);
            if (tmpNode == null) continue;
            return tmpNode;
        }
        return null;
    }

    protected boolean isEquesNode(DefaultKingdeeTreeNode node1, DefaultKingdeeTreeNode node2) {
        if (node1.getUserObject() instanceof MetaDataBriefInfo && node2.getUserObject() instanceof MetaDataBriefInfo) {
            MetaDataBriefInfo info1 = (MetaDataBriefInfo)node1.getUserObject();
            MetaDataBriefInfo info2 = (MetaDataBriefInfo)node2.getUserObject();
            if (info1.getRealName().equals(info2.getRealName())) {
                return true;
            }
        }
        return false;
    }

    protected void addNewNodeToRightTree(TreePath path) {
        if (this.treeRight.getModel() == null || path == null) {
            return;
        }
        this.addTreeNodeByPath(path, (DefaultKingdeeTreeNode)path.getLastPathComponent());
        DefaultKingdeeTreeNode newNode = (DefaultKingdeeTreeNode)this.treeRight.getModel().getRoot();
        this.treeRight.setModel((TreeModel)new DefaultTreeModel((TreeNode)newNode));
        this.treeRight.expandAllNodes(true, (TreeNode)newNode);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public List<MetaDataBriefInfo> getData() {
        return this.data;
    }

    public void setData(List<MetaDataBriefInfo> data) {
        this.data = data;
    }
}

