/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.AbstractBgControlDataInfo;
import com.kingdee.eas.ma.control.BgControlDataCollection;
import com.kingdee.eas.ma.control.BgControlDataFactory;
import com.kingdee.eas.ma.control.BgControlDataInfo;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlSetFacadeFactory;
import com.kingdee.eas.ma.control.IBgControlSetFacade;
import com.kingdee.eas.ma.control.client.AbstractBgControlBillSetListUI;
import com.kingdee.eas.ma.control.client.BgControlBillBizFieldUI;
import com.kingdee.eas.ma.control.client.BgControlBillBizSystemUI;
import com.kingdee.eas.ma.control.client.BgControlIsomerBillFieldUI;
import com.kingdee.eas.ma.control.client.BgControlIsomerBillUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgControlBillSetListUI
extends AbstractBgControlBillSetListUI {
    private static final long serialVersionUID = -8879477991368911134L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlBillSetListUI.class);
    private Color colorEdit = new Color(252, 251, 223);
    protected static final String RES = "com.kingdee.eas.ma.control.BgControlMsgResource";
    protected static final String TEXT_DEFAULT = EASResource.getString((String)"com.kingdee.eas.ma.control.BgControlMsgResource", (String)"textTitle");
    private boolean loadMeta = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.textSearch.setText(TEXT_DEFAULT);
        BgCommHelper.removeEditHelper((KDTable)this.tableLeft);
        BgCommHelper.removeEditHelper((KDTable)this.tableRight);
    }

    protected void init() throws EASBizException, BOSException {
        MetaThread thread = new MetaThread();
        thread.start();
        this.loadBizSystem();
    }

    protected void loadBizSystem() throws EASBizException, BOSException {
        this.textSearch.setText(TEXT_DEFAULT);
        this.tableLeft.checkParsed();
        this.tableLeft.removeRows();
        this.tableLeft.setEditable(false);
        this.tableLeft.getSelectManager().setSelectMode(2);
        KDTDefaultCellEditor edit = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
        this.tableLeft.getColumn("default").setEditor((ICellEditor)edit);
        this.tableLeft.getColumn("isomer").setEditor((ICellEditor)edit);
        Object ob = this.getInstance().getBizSystem();
        if (ob instanceof BgControlDataCollection) {
            BgControlDataCollection colls = (BgControlDataCollection)((Object)ob);
            if (colls.size() == 0) {
                return;
            }
            colls = this.filterBgControlDataCollection(colls);
            int size = colls.size();
            for (int index = 0; index < size; ++index) {
                BgControlDataInfo info = colls.get(index);
                IRow row = this.tableLeft.addRow();
                row.setUserObject((Object)info);
                row.getCell("bizSystem").setValue((Object)info.getBizSystemAlias());
                row.getCell("bizBill").setValue((Object)info.getBizUnitAlias());
                row.getCell("default").setValue((Object)info.isIsSystemDefault());
                row.getCell("isomer").setValue((Object)info.isIsomer());
            }
            this.tableLeft.getSelectManager().select(0, 0, 2);
        }
    }

    @Override
    protected void textSearch_focusLost(FocusEvent e) throws Exception {
        String text = this.textSearch.getText();
        if (StringUtils.isEmpty((String)text) || TEXT_DEFAULT.equals(text)) {
            text = null;
        }
        if (!StringUtils.equals((String)text, (String)((String)this.textSearch.getUserObject()))) {
            this.filterRight();
        }
    }

    @Override
    protected void btnFilter_actionPerformed(ActionEvent e) throws Exception {
        this.filterRight();
    }

    protected void filterRight() {
        String text = this.textSearch.getText();
        if (StringUtils.isEmpty((String)text) || TEXT_DEFAULT.equals(text)) {
            this.filterRightTable(null);
            this.textSearch.setText(TEXT_DEFAULT);
        } else {
            this.filterRightTable(text);
        }
    }

    protected void filterRightTable(String filter) {
        this.textSearch.setUserObject((Object)filter);
        int rowSize = this.tableRight.getRowCount();
        if (rowSize == 0) {
            return;
        }
        for (int index = 0; index < rowSize; ++index) {
            if (StringUtils.isEmpty((String)filter)) {
                this.tableRight.getRow(index).getStyleAttributes().setHided(false);
                continue;
            }
            if (this.tableRight.getCell(index, "billField").getValue().toString().indexOf(filter) > -1) {
                this.tableRight.getRow(index).getStyleAttributes().setHided(false);
                continue;
            }
            this.tableRight.getRow(index).getStyleAttributes().setHided(true);
        }
    }

    protected BgControlDataCollection filterBgControlDataCollection(BgControlDataCollection colls) {
        return colls;
    }

    protected void loadBizBillField(String bizBillNumber) throws EASBizException, BOSException {
        this.textSearch.setUserObject(null);
        this.tableRight.checkParsed();
        this.tableRight.removeRows();
        this.tableRight.setEditable(false);
        this.tableRight.getSelectManager().setSelectMode(10);
        KDTDefaultCellEditor edit = new KDTDefaultCellEditor((JCheckBox)new KDCheckBox());
        this.tableRight.getColumn("default").setEditor((ICellEditor)edit);
        this.tableRight.getColumn("isSystem").setEditor((ICellEditor)edit);
        if (StringUtils.isEmpty((String)bizBillNumber)) {
            return;
        }
        Object ob = this.getInstance().getBizUnitBill(bizBillNumber);
        if (ob instanceof BgControlDataCollection) {
            BgControlDataCollection colls = (BgControlDataCollection)((Object)ob);
            for (int index = 0; index < colls.size(); ++index) {
                BgControlDataInfo info = colls.get(index);
                IRow row = this.tableRight.addRow();
                row.setUserObject((Object)info);
                row.getCell("billProperty").setValue((Object)info.getBizType());
                row.getCell("billField").setValue((Object)info.getBizAlias());
                row.getCell("default").setValue((Object)info.isIsDefault());
                row.getCell("isSystem").setValue((Object)info.isIsSystemDefault());
            }
        }
        this.tableRight.getColumn("billProperty").setGroup(true);
        this.tableRight.getGroupManager().setGroup(true);
        this.tableRight.getMergeManager().setMergeMode(5);
        this.tableRight.getGroupManager().group();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBillSet.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnFieldSet.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnDateDefault.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setVisible(false);
        this.btnSave.setEnabled(false);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.btnFilter.setEnabled(true);
        this.btnFilter.setVisible(true);
        this.btnDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine.setEnabled(true);
        this.btnDelLine.setVisible(true);
        this.btnSearch.setEnabled(false);
        this.btnSearch.setVisible(false);
        this.btnBillSet.setVisible(false);
        this.btnDelete.setVisible(false);
        this.btnFieldSet.setVisible(false);
        this.btnDateDefault.setVisible(false);
        this.btnIsomerBillAdd.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnLeftBillAdd.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnLeftdel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRightFieldSet.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnRightDefault.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.menuItemIsomerBiz.setEnabled(true);
        this.menuItemBizAdd.setEnabled(true);
        this.menuItemFieldSet.setEnabled(true);
        this.menuItemDefault.setEnabled(true);
        this.menuItemDel.setEnabled(true);
        this.menuReflush.setEnabled(true);
        this.menuItemDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuReflush.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemIsomerBiz.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuItemBizAdd.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuItemFieldSet.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.menuItemDefault.setIcon(EASResource.getIcon((String)"imgTbtn_scvoucher"));
    }

    @Override
    protected void btnLeftBillAdd_actionPerformed(ActionEvent e) throws Exception {
        this.btnBillSet_actionPerformed(e);
    }

    @Override
    protected void btnLeftdel_actionPerformed(ActionEvent e) throws Exception {
        this.btnDelete_actionPerformed(e);
    }

    @Override
    protected void btnRightFieldSet_actionPerformed(ActionEvent e) throws Exception {
        this.btnFieldSet_actionPerformed(e);
    }

    @Override
    protected void btnRightDefault_actionPerformed(ActionEvent e) throws Exception {
        this.btnDateDefault_actionPerformed(e);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.actionDeleteBill_actionPerformed(e);
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.loadBizSystem();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
    }

    @Override
    protected void btnDelLine_actionPerformed(ActionEvent e) throws Exception {
        BgControlDataCollection c;
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCostUnit().getId()), (String)this.getEditPermissionItem());
        int rowSize = this.tableRight.getRowCount();
        if (rowSize <= 0) {
            return;
        }
        ArrayList block = this.tableRight.getSelectManager().getBlocks();
        if (block == null || block.isEmpty()) {
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            return;
        }
        BgControlDataCollection colls = new BgControlDataCollection();
        int size = block.size();
        for (int index = 0; index < size; ++index) {
            KDTSelectBlock selectBlock = (KDTSelectBlock)block.get(index);
            for (int rowIndex = selectBlock.getTop(); rowIndex <= selectBlock.getBottom(); ++rowIndex) {
                IRow row = this.tableRight.getRow(rowIndex);
                if (row.getStyleAttributes().isHided() || !(row.getUserObject() instanceof BgControlDataInfo)) continue;
                colls.add((BgControlDataInfo)row.getUserObject());
            }
        }
        if (colls.isEmpty()) {
            return;
        }
        Object ob = BgControlSetFacadeFactory.getRemoteInstance().deleteBatch((Object)colls);
        if (ob instanceof BgControlDataCollection && (c = (BgControlDataCollection)((Object)ob)).size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (int index = 0; index < c.size(); ++index) {
                msg.append(EASResource.getString((String)RES, (String)"fieldCantDel", (Object[])new String[]{c.get(index).getBizType().getAlias(), c.get(index).getBizAlias()})).append("\n");
            }
            Object[] p = new Object[]{colls.size(), c.size()};
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"deleteFiledFail", (Object[])p), (String)msg.toString(), (int)1);
        }
        this.reflushRightTable();
    }

    protected String getEditPermissionItem() {
        return "mbg_control_billRegedit03_edit";
    }

    protected void reflushRightTable() throws EASBizException, BOSException {
        int rowIndex = this.tableLeft.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        Object ob = this.tableLeft.getRow(rowIndex).getUserObject();
        if (ob instanceof BgControlDataInfo) {
            BgControlDataInfo info = (BgControlDataInfo)ob;
            this.loadBizBillField(info.getBizUnit());
        }
        this.textSearch.setText(TEXT_DEFAULT);
    }

    @Override
    protected void btnBillSet_actionPerformed(ActionEvent e) throws Exception {
        this.actionBillAdd_actionPerformed(e);
    }

    private boolean isExistSystemBill(EntityObjectInfo entityInfo) {
        if (entityInfo == null) {
            return false;
        }
        int rowCount = this.tableLeft.getRowCount();
        if (rowCount == 0) {
            return false;
        }
        for (int index = 0; index < rowCount; ++index) {
            BgControlDataInfo info = (BgControlDataInfo)this.tableLeft.getRow(index).getUserObject();
            if (!info.getBizUnit().equals(entityInfo.getFullName())) continue;
            return true;
        }
        return false;
    }

    public boolean destroyWindow() {
        int rowCount = this.tableLeft.getRowCount();
        if (rowCount > 0) {
            for (int index = 0; index < rowCount; ++index) {
                if (this.tableLeft.getRow(index).getStyleAttributes().getBackground() != this.colorEdit) continue;
                return MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"isExist")) != 1;
            }
        }
        return super.destroyWindow();
    }

    private String getParentFullName(String name) {
        name = name.indexOf(".app.") >= 0 ? name.substring(0, name.indexOf(".app.")) : (name.indexOf(".client.") >= 0 ? name.substring(0, name.indexOf(".client.")) : name.substring(0, name.lastIndexOf(".")));
        return name;
    }

    @Override
    protected void btnFieldSet_actionPerformed(ActionEvent e) throws Exception {
        this.actionFieldSet_actionPerformed(e);
    }

    protected String getMessageText() {
        return EASResource.getString((String)RES, (String)"saveSuccess");
    }

    @Override
    protected void btnDateDefault_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCostUnit().getId()), (String)this.getEditPermissionItem());
        int rowIndex = this.tableRight.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        Object ob = this.tableRight.getRow(rowIndex).getUserObject();
        if (ob instanceof BgControlDataInfo) {
            BgControlDataInfo info = (BgControlDataInfo)ob;
            if (info.getBizType().getValue() == 1 || info.getBizType().getValue() == 4) {
                if (!this.isCanSetDefault(info.getBizType().getValue(), info.getBiz())) {
                    return;
                }
                BgControlSetFacadeFactory.getRemoteInstance().setDefault(info);
                this.reflushRightTable();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"cantSetDefault"));
            }
        }
    }

    private boolean isCanSetDefault(int type, String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        if (type == 1 && name.split("\\.").length > 2) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"notEmptyOrg"));
            return false;
        }
        if (type == 4 && name.split("\\.").length > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"notEntryPeriodProperty"));
            return false;
        }
        return true;
    }

    @Override
    protected void tableLeft_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.tableLeft.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        Object ob = this.tableLeft.getRow(rowIndex).getUserObject();
        if (ob instanceof BgControlDataInfo) {
            BgControlDataInfo info = (BgControlDataInfo)ob;
            this.loadBizBillField(info.getBizUnit());
        }
    }

    @Override
    protected void tableRight_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tableRight_tableSelectChanged(e);
    }

    protected IBgControlSetFacade getInstance() throws BOSException {
        return BgControlSetFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionDeleteBill_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCostUnit().getId()), (String)this.getDeletePermissionItem());
        int rowIndex = this.tableLeft.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        if (this.tableLeft.getRow(rowIndex).getUserObject() instanceof BgControlDataInfo) {
            int confirm;
            BgControlDataInfo info = (BgControlDataInfo)this.tableLeft.getRow(rowIndex).getUserObject();
            if (info.isIsSystemDefault()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"systemField"));
                return;
            }
            if (MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"confirmDel")) != 0) {
                return;
            }
            boolean isCanDel = BgControlSetFacadeFactory.getRemoteInstance().checkCanDelete(info);
            if (!isCanDel) {
                Object[] params = new String[]{info.getBizUnitAlias()};
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"canDeleteBill", (Object[])params));
                return;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bizUnit", (Object)info.getBizUnit(), CompareType.EQUALS));
            IObjectPK[] delete = BgControlDataFactory.getRemoteInstance().delete(filter);
            if ((delete == null || delete.length == 0) && (confirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"deleteAllNotRegister"))) == 2) {
                return;
            }
            this.btnRefresh_actionPerformed(null);
        }
    }

    protected String getDeletePermissionItem() {
        return "mbg_control_billRegedit04_del";
    }

    @Override
    public void actionReflush_actionPerformed(ActionEvent e) throws Exception {
        this.btnRefresh_actionPerformed(null);
    }

    @Override
    public void actionBillAdd_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCostUnit().getId()), (String)this.getPermissionItem());
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlBillBizSystemUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        BgControlBillBizSystemUI ui = (BgControlBillBizSystemUI)uiWindow.getUIObject();
        if (ui.isCancel()) {
            return;
        }
        final List<MetaDataBriefInfo> data = ui.getData();
        if (data == null || data.size() == 0) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                while (!BgControlBillSetListUI.this.loadMeta) {
                    Thread.sleep(500L);
                }
                for (int index = 0; index < data.size(); ++index) {
                    MetaDataBriefInfo info = (MetaDataBriefInfo)data.get(index);
                    EntityObjectInfo entityInfo = BgEntityUtil.getEntity((BOSObjectType)info.getBOType());
                    if (BgControlBillSetListUI.this.isExistSystemBill(entityInfo)) continue;
                    MetaDataBriefInfo subSystemInfo = SubSystemUtils.getMetaDataBriefInfoByFullName((String)BgControlBillSetListUI.this.getParentFullName(info.getParent()), (String)"eas_base_subsystem");
                    BgControlDataInfo dataInfo = new BgControlDataInfo();
                    dataInfo.setBizSystem(subSystemInfo.getPackgeName());
                    dataInfo.setBizSystemAlias(subSystemInfo.getAlias(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    dataInfo.setBizSystemAlias(subSystemInfo.getAlias(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    dataInfo.setBizSystemAlias(subSystemInfo.getAlias(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                    dataInfo.setBizUnit(entityInfo.getRealFullName());
                    dataInfo.setBizUnitAlias(BgEntityUtil.getEntityAlias((EntityObjectInfo)entityInfo, (Locale)LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    dataInfo.setBizUnitAlias(BgEntityUtil.getEntityAlias((EntityObjectInfo)entityInfo, (Locale)LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    dataInfo.setBizUnitAlias(BgEntityUtil.getEntityAlias((EntityObjectInfo)entityInfo, (Locale)LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                    dataInfo.setIsomer(false);
                    IRow row = BgControlBillSetListUI.this.tableLeft.addRow();
                    row.setUserObject((Object)dataInfo);
                    row.getCell("bizSystem").setValue((Object)dataInfo.getBizSystemAlias());
                    row.getCell("bizBill").setValue((Object)dataInfo.getBizUnitAlias());
                    row.getCell("default").setValue((Object)Boolean.FALSE);
                    row.getStyleAttributes().setBackground(BgControlBillSetListUI.this.colorEdit);
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    protected String getPermissionItem() {
        return "mbg_control_billRegedit02_add";
    }

    @Override
    public void actionFieldSet_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCostUnit().getId()), (String)this.getEditPermissionItem());
        int rowIndex = this.tableLeft.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        AbstractBgControlDataInfo info = null;
        if (this.tableLeft.getRow(rowIndex).getUserObject() instanceof BgControlDataInfo) {
            info = (BgControlDataInfo)this.tableLeft.getRow(rowIndex).getUserObject();
            uiContext.put((Object)"info", (Object)info);
        }
        if (info != null && !info.isIsomer()) {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlBillBizFieldUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            BgControlBillBizFieldUI ui = (BgControlBillBizFieldUI)uiWindow.getUIObject();
            if (ui.isCancel()) {
                return;
            }
            this.loadBizBillField(info == null ? null : info.getBizUnit());
            if (info.getId() == null) {
                this.showMessage();
            }
            this.tableLeft.getRow(rowIndex).getStyleAttributes().setBackground(Color.WHITE);
        } else {
            uiContext.put((Object)"info", (Object)info);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlIsomerBillFieldUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            BgControlIsomerBillFieldUI ui = (BgControlIsomerBillFieldUI)uiWindow.getUIObject();
            if (ui.isCancel()) {
                return;
            }
            if (info != null) {
                this.loadBizBillField(info.getBizUnit());
            }
            if (info != null && info.getId() == null) {
                this.showMessage();
            }
            this.tableLeft.getRow(rowIndex).getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    @Override
    public void actionDefultSet_actionPerformed(ActionEvent e) throws Exception {
        this.btnDateDefault_actionPerformed(null);
    }

    @Override
    protected void btnIsomerBillAdd_actionPerformed(ActionEvent e) throws Exception {
        this.actionIsomerBillAdd_actionPerformed(e);
    }

    private boolean isExistSystemBill(BgControlIsomerInfo entityInfo) {
        if (entityInfo == null) {
            return false;
        }
        int rowCount = this.tableLeft.getRowCount();
        if (rowCount == 0) {
            return false;
        }
        for (int index = 0; index < rowCount; ++index) {
            BgControlDataInfo info = (BgControlDataInfo)this.tableLeft.getRow(index).getUserObject();
            if (!info.getBizUnit().equals(entityInfo.getId().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionIsomerBillAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlIsomerBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        BgControlIsomerBillUI ui = (BgControlIsomerBillUI)uiWindow.getUIObject();
        if (ui.isCancel()) {
            return;
        }
        final List<BgControlIsomerInfo> data = ui.getData();
        if (data == null || data.size() == 0) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                for (int index = 0; index < data.size(); ++index) {
                    BgControlIsomerInfo info = (BgControlIsomerInfo)data.get(index);
                    if (BgControlBillSetListUI.this.isExistSystemBill(info)) continue;
                    BgControlDataInfo dataInfo = new BgControlDataInfo();
                    dataInfo.setBizSystem(info.getConnection().getId().toString());
                    dataInfo.setBizSystemAlias(info.getConnection().getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    dataInfo.setBizSystemAlias(info.getConnection().getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    dataInfo.setBizSystemAlias(info.getConnection().getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                    dataInfo.setBizUnit(info.getId().toString());
                    dataInfo.setBizUnitAlias(info.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                    dataInfo.setBizUnitAlias(info.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                    dataInfo.setBizUnitAlias(info.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                    dataInfo.setIsomer(true);
                    IRow row = BgControlBillSetListUI.this.tableLeft.addRow();
                    row.setUserObject((Object)dataInfo);
                    row.getCell("bizSystem").setValue((Object)dataInfo.getBizSystemAlias());
                    row.getCell("bizBill").setValue((Object)dataInfo.getBizUnitAlias());
                    row.getCell("default").setValue((Object)Boolean.FALSE);
                    row.getCell("isomer").setValue((Object)Boolean.TRUE);
                    row.getStyleAttributes().setBackground(BgControlBillSetListUI.this.colorEdit);
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    class MetaThread
    extends Thread {
        MetaThread() {
        }

        @Override
        public void run() {
            super.run();
            SubSystemUtils.getMetaDataBriefInfoByFullName((String)"", (String)"eas_base_subsystem");
            BgControlBillSetListUI.this.loadMeta = true;
        }
    }
}

