/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.BgControlIsomerBaseCollection;
import com.kingdee.eas.ma.control.BgControlIsomerBaseFactory;
import com.kingdee.eas.ma.control.BgControlIsomerBaseInfo;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgCtrlIsomerBaseEnum;
import com.kingdee.eas.ma.control.IBgControlIsomerBase;
import com.kingdee.eas.ma.control.client.AbstractBgControlIsomerBaseSetUI;
import com.kingdee.eas.ma.control.client.utils.BgControlIsomerCHelper;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgControlIsomerBaseSetUI
extends AbstractBgControlIsomerBaseSetUI {
    private static final long serialVersionUID = 8867462694932760965L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlIsomerBaseSetUI.class);
    protected static final String COL_NUMBER = "number";
    protected static final String COL_EASNUMBER = "easNumber";
    protected static final String COL_ID = "id";
    private static BgControlIsomerConnectionInfo cInfo = null;
    private boolean isModify = false;
    private BgControlIsomerBaseCollection baseInfoColl = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        cInfo = (BgControlIsomerConnectionInfo)this.getUIContext().get("cinfo");
        this.initBaseData();
    }

    protected void initBaseData() throws Exception {
        this.getBgControlIsomerBaseCollection();
        this.loadTable();
    }

    private void loadTable() {
        this.tblOrg.checkParsed();
        this.tblCur.checkParsed();
        this.tblOrg.refresh();
        this.tblCur.refresh();
        this.baseInfoColl.sort(COL_NUMBER);
        if (this.baseInfoColl != null && this.baseInfoColl.size() > 0) {
            IRow row = null;
            for (int i = 0; i < this.baseInfoColl.size(); ++i) {
                if (this.baseInfoColl.get(i).getType().getValue() == 0) {
                    row = this.tblOrg.addRow();
                    row.getCell(COL_NUMBER).setValue((Object)this.baseInfoColl.get(i).getNumber());
                    row.getCell(COL_EASNUMBER).setValue((Object)this.baseInfoColl.get(i).getEasNumber());
                    row.getCell(COL_ID).setValue((Object)this.baseInfoColl.get(i).getId());
                    row.setUserObject((Object)this.baseInfoColl.get(i));
                    continue;
                }
                if (this.baseInfoColl.get(i).getType().getValue() != 1) continue;
                row = this.tblCur.addRow();
                row.getCell(COL_NUMBER).setValue((Object)this.baseInfoColl.get(i).getNumber());
                row.getCell(COL_EASNUMBER).setValue((Object)this.baseInfoColl.get(i).getEasNumber());
                row.getCell(COL_ID).setValue((Object)this.baseInfoColl.get(i).getId());
                row.setUserObject((Object)this.baseInfoColl.get(i));
            }
        }
    }

    private void getBgControlIsomerBaseCollection() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("connection.id", (Object)cInfo.getId().toString(), CompareType.EQUALS));
        evi.setSelector(this.getSelect());
        this.baseInfoColl = this.getBizInterface().getBgControlIsomerBaseCollection(evi);
    }

    private SelectorItemCollection getSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("connection.*"));
        return sic;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.formateTable();
    }

    private void formateTable() {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectOrgUnit"));
        orgView.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        orgView.setMultiSelect(false);
        KDBizPromptBox prmtOrgUnit = new KDBizPromptBox();
        prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        prmtOrgUnit.setEditable(false);
        this.tblOrg.getColumn(COL_EASNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtOrgUnit));
        KDBizPromptBox prmtCur = new KDBizPromptBox();
        prmtCur.setDisplayFormat("$number$");
        prmtCur.setEditFormat("$name$");
        prmtCur.setCommitFormat("$number$");
        prmtCur.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        prmtCur.setEditable(false);
        this.tblCur.getColumn(COL_EASNUMBER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCur));
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdt = this.getTable();
        IRow row = kdt.addRow();
        kdt.setRowCount(kdt.getRowCount() + 1);
        this.isModify = true;
    }

    private KDTable getTable() {
        int index = this.tab.getSelectedIndex();
        KDTable kdt = null;
        if (index == 0) {
            kdt = this.tblOrg;
        } else if (index == 1) {
            kdt = this.tblCur;
        }
        return kdt;
    }

    @Override
    protected void btnCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTable kdtSets = this.getTable();
        int activeRow = kdtSets.getSelectManager().getActiveRowIndex();
        if (activeRow < 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        int colCounts = kdtSets.getColumnCount();
        IRow fromRow = kdtSets.getRow(activeRow);
        IRow toRow = kdtSets.addRow(activeRow);
        BgControlIsomerBaseInfo info = null;
        for (int i = 0; i < colCounts - 1; ++i) {
            toRow.getCell(i).setValue(fromRow.getCell(i).getValue());
            toRow.getCell(i).setEditor(fromRow.getCell(i).getEditor());
        }
        if (fromRow.getUserObject() instanceof BgControlIsomerBaseInfo) {
            info = (BgControlIsomerBaseInfo)fromRow.getUserObject();
            info = (BgControlIsomerBaseInfo)info.clone();
            info.setId(null);
            toRow.setUserObject((Object)info);
        }
        this.isModify = true;
    }

    protected void afterCreateNewRow(IRow row, int index) {
        row.getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        List<Integer> indexs = this.getSelectRowIndex();
        if (indexs == null || indexs.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int rowIndex = 0;
        KDTable kdtSets = this.getTable();
        for (int index = indexs.size() - 1; index >= 0; --index) {
            rowIndex = indexs.get(index);
            kdtSets.removeRow(rowIndex);
        }
        this.isModify = true;
    }

    protected List<Integer> getSelectRowIndex() {
        KDTRange range = this.getTable().getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    @Override
    protected void tblCur_editValueChanged(KDTEditEvent e) throws Exception {
        this.isModify = true;
        super.tblCur_editValueChanged(e);
    }

    @Override
    protected void tblOrg_editValueChanged(KDTEditEvent e) throws Exception {
        this.isModify = true;
        super.tblOrg_editValueChanged(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.save();
    }

    private void save() throws EASBizException, BOSException, Exception {
        int i;
        this.verify();
        BgControlIsomerBaseInfo info = null;
        BgControlIsomerBaseCollection addcoll = new BgControlIsomerBaseCollection();
        BgControlIsomerBaseCollection updatecoll = new BgControlIsomerBaseCollection();
        BgControlIsomerBaseCollection deletecoll = new BgControlIsomerBaseCollection();
        IRow row = null;
        HashSet<String> isEdit = new HashSet<String>();
        for (int j = 0; j < this.tab.getTabCount(); ++j) {
            KDTable tbl = (KDTable)this.tab.getComponentAt(j);
            for (i = 0; i < tbl.getRowCount(); ++i) {
                row = tbl.getRow(i);
                if (row.getCell(COL_NUMBER).getValue() == null && row.getCell(COL_EASNUMBER).getValue() == null) continue;
                info = new BgControlIsomerBaseInfo();
                info.setConnection(cInfo);
                info.setNumber(row.getCell(COL_NUMBER).getValue().toString());
                if (row.getCell(COL_EASNUMBER).getValue() instanceof FullOrgUnitInfo) {
                    info.setEasNumber(((FullOrgUnitInfo)row.getCell(COL_EASNUMBER).getValue()).getNumber());
                } else if (row.getCell(COL_EASNUMBER).getValue() instanceof CurrencyInfo) {
                    info.setEasNumber(((CurrencyInfo)row.getCell(COL_EASNUMBER).getValue()).getNumber());
                } else {
                    info.setEasNumber(row.getCell(COL_EASNUMBER).getValue().toString());
                }
                info.setType(BgCtrlIsomerBaseEnum.getEnum(j));
                if (row.getCell(COL_ID).getValue() != null) {
                    info.setId(BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()));
                    isEdit.add(row.getCell(COL_ID).getValue().toString());
                    updatecoll.add(info);
                    continue;
                }
                addcoll.add(info);
            }
        }
        if (this.baseInfoColl != null) {
            for (int i2 = 0; i2 < this.baseInfoColl.size(); ++i2) {
                if (isEdit.contains(this.baseInfoColl.get(i2).getId().toString())) continue;
                this.baseInfoColl.get(i2).setString("state", "delete");
                deletecoll.add(this.baseInfoColl.get(i2));
            }
        }
        CoreBaseCollection newcoll = null;
        if (!addcoll.isEmpty()) {
            newcoll = new CoreBaseCollection();
            newcoll.addObjectCollection((IObjectCollection)addcoll);
            this.getBizInterface().addnewBatchData(newcoll);
        }
        if (!updatecoll.isEmpty()) {
            newcoll = new CoreBaseCollection();
            newcoll.addObjectCollection((IObjectCollection)updatecoll);
            this.getBizInterface().updateBatchData(newcoll);
        }
        if (!deletecoll.isEmpty()) {
            IObjectPK[] pks = new IObjectPK[deletecoll.size()];
            for (i = 0; i < deletecoll.size(); ++i) {
                pks[i] = new ObjectUuidPK(deletecoll.get(i).getId());
            }
            this.getBizInterface().deleteBatchData(pks);
        }
        this.isModify = false;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.initBaseData();
    }

    private void verify() throws Exception {
        boolean isCheck = false;
        String msg = null;
        if (cInfo == null) {
            msg = EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectIsNull");
            isCheck = true;
        }
        if (!isCheck) {
            IRow row = null;
            String key = null;
            block0: for (int j = 0; j < this.tab.getTabCount(); ++j) {
                KDTable tbl = (KDTable)this.tab.getComponentAt(j);
                HashSet<String> keys = new HashSet<String>();
                for (int i = 0; i < tbl.getRowCount(); ++i) {
                    row = tbl.getRow(i);
                    if (row.getCell(0).getValue() == null && row.getCell(1).getValue() == null) continue;
                    if (row.getCell(0).getValue() == null) {
                        msg = EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseNumIsNull", (Object[])new Object[]{this.tab.getTitleAt(j), i + 1});
                        isCheck = true;
                        continue block0;
                    }
                    if (row.getCell(1).getValue() == null) {
                        msg = EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseEASNumIsNull", (Object[])new Object[]{this.tab.getTitleAt(j), i + 1});
                        isCheck = true;
                        continue block0;
                    }
                    key = row.getCell(0).getValue().toString();
                    if (keys.contains(key)) {
                        msg = EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseRepeat", (Object[])new Object[]{this.tab.getTitleAt(j), i + 1});
                        isCheck = true;
                        continue block0;
                    }
                    keys.add(key);
                }
            }
        }
        if (isCheck) {
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify) {
            int cotrim = MsgBox.showConfirm3((Component)((Object)this), (String)DimensionRelationClientHelper.getDimCommResource((String)"dataError3"));
            if (cotrim == 0) {
                try {
                    this.save();
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            } else if (cotrim == 2) {
                return false;
            }
        }
        return true;
    }

    protected IBgControlIsomerBase getBizInterface() throws Exception {
        return BgControlIsomerBaseFactory.getRemoteInstance();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (cInfo != null) {
            BgControlIsomerCHelper.importBase(this, this.getTable(), cInfo, this.tab);
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (cInfo != null) {
            BgControlIsomerCHelper.exportBase(this, this.getTable(), cInfo);
        }
    }
}

