/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlIsomerConnectF7UI;
import com.kingdee.eas.ma.control.client.BgControlIsomerConnectionEditUI;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgControlIsomerConnectF7UI
extends AbstractBgControlIsomerConnectF7UI {
    private static final long serialVersionUID = -1435096849935330242L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlIsomerConnectF7UI.class);
    BgControlIsomerConnectionInfo result = null;
    HashSet<String> existCols = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected BgControlIsomerConnectionInfo getResult() {
        return this.result;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.searchBtn.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgControlIsomerConnectF7UI.this.refreshList();
                    }
                    catch (Exception e1) {
                        logger.error((Object)("error" + e));
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgControlIsomerConnectF7UI.this.refreshList();
                    }
                    catch (Exception e1) {
                        logger.error((Object)("error" + e));
                    }
                }
            }
        });
        this.btnTestConn.setEnabled(true);
        this.btnQuery.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.getUIContext().get("isConnectSet") == null) {
            this.afterConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void afterConfirm() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        BgControlIsomerConnectionInfo connectionInfo = new BgControlIsomerConnectionInfo();
        connectionInfo.setId(BOSUuid.read(iRow.getCell("id").getValue() != null ? iRow.getCell("id").getValue().toString() : null));
        connectionInfo.setNumber(iRow.getCell("number").getValue() != null ? iRow.getCell("number").getValue().toString() : null);
        connectionInfo.setName(iRow.getCell("name").getValue() != null ? iRow.getCell("name").getValue().toString() : null);
        connectionInfo.setIP(iRow.getCell("IP").getValue() != null ? iRow.getCell("IP").getValue().toString() : null);
        connectionInfo.setPort(iRow.getCell("Port").getValue() != null ? Integer.valueOf(iRow.getCell("Port").getValue().toString()) : null);
        connectionInfo.setUsername(iRow.getCell("username").getValue() != null ? iRow.getCell("username").getValue().toString() : null);
        connectionInfo.setPassword(iRow.getCell("password").getValue() != null ? iRow.getCell("password").getValue().toString() : null);
        connectionInfo.setInstance(iRow.getCell("instance").getValue() != null ? iRow.getCell("instance").getValue().toString() : null);
        connectionInfo.setDescription(iRow.getCell("description").getValue() != null ? iRow.getCell("description").getValue().toString() : null);
        connectionInfo.setDBType(iRow.getCell("DBType").getValue() != null ? DBType.getEnum((String)iRow.getCell("DBType").getValue().toString()) : null);
        this.result = connectionInfo;
        this.getUIWindow().close();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
    }

    protected String getEditUIName() {
        return BgControlIsomerConnectionEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgControlIsomerConnectionFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        String filterText = this.kDTextField1.getText();
        viewInfo = (EntityViewInfo)viewInfo.clone();
        viewInfo.setFilter(new FilterInfo());
        if (!StringUtils.isEmpty((String)filterText)) {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("description", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().setMaskString(" #0 OR #1 OR #2  ");
            this.kDTextField1.setSelectAllOnFocus(true);
        }
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sortorNum = new SorterItemInfo("number");
        sortorNum.setSortType(SortType.ASCEND);
        sic.add(sortorNum);
        viewInfo.setSorter(sic);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        IRow row = null;
        this.existCols = new HashSet();
        for (int index = e.getFirstRow(); index <= e.getLastRow(); ++index) {
            row = this.tblMain.getRow(index);
            this.existCols.add(row.getCell("id").getValue().toString());
        }
    }

    @Override
    protected void searchBtn_mouseClicked(MouseEvent e) throws Exception {
        super.refreshList();
    }

    public void actionsearch_actionPerformed(ActionEvent e) throws Exception {
        super.refreshList();
    }

    @Override
    protected void bottonConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.afterConfirm();
    }

    @Override
    protected void bottonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionTestConn_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        BgControlIsomerConnectionInfo connectionInfo = new BgControlIsomerConnectionInfo();
        connectionInfo.setId(BOSUuid.read(iRow.getCell("id").getValue() != null ? iRow.getCell("id").getValue().toString() : null));
        connectionInfo.setNumber(iRow.getCell("number").getValue() != null ? iRow.getCell("number").getValue().toString() : null);
        connectionInfo.setName(iRow.getCell("name").getValue() != null ? iRow.getCell("name").getValue().toString() : null);
        connectionInfo.setIP(iRow.getCell("IP").getValue() != null ? iRow.getCell("IP").getValue().toString() : null);
        connectionInfo.setPort(iRow.getCell("Port").getValue() != null ? Integer.valueOf(iRow.getCell("Port").getValue().toString()) : null);
        connectionInfo.setUsername(iRow.getCell("username").getValue() != null ? iRow.getCell("username").getValue().toString() : null);
        connectionInfo.setPassword(iRow.getCell("password").getValue() != null ? iRow.getCell("password").getValue().toString() : null);
        connectionInfo.setInstance(iRow.getCell("instance").getValue() != null ? iRow.getCell("instance").getValue().toString() : null);
        connectionInfo.setDescription(iRow.getCell("description").getValue() != null ? iRow.getCell("description").getValue().toString() : null);
        connectionInfo.setDBType(iRow.getCell("DBType").getValue() != null ? DBType.getEnum((String)iRow.getCell("DBType").getValue().toString()) : null);
        try {
            boolean result = SQLFacadeFactory.getRemoteInstance().DBConnection(connectionInfo.getDBType().toString(), connectionInfo.getIP(), connectionInfo.getPort() + "", connectionInfo.getInstance(), connectionInfo.getUsername(), connectionInfo.getPassword());
            if (result) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectSuccess"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"));
            }
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"), (String)ex.getMessage(), (int)2);
        }
        super.actionTestConn_actionPerformed(e);
    }
}

