/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.NumberFormatterEx;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionFactory;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlIsomerConnectionEditUI;
import com.kingdee.eas.ma.control.client.BgControlIsomerConnectF7UI;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class BgControlIsomerConnectionEditUI
extends AbstractBgControlIsomerConnectionEditUI {
    private static final long serialVersionUID = -1638492445859294861L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlIsomerConnectionEditUI.class);
    private static final int ORACLEPORT = 1521;
    private static final int SQLSERVER = 1433;
    private static final int MYSQL = 3306;
    private static final int DB2 = 5000;
    private static final int PGSQL = 5432;
    private boolean isException = false;

    public BgControlIsomerConnectionEditUI() throws Exception {
        this.setCustComponentTabIndex();
        NumberFormatterEx f = (NumberFormatterEx)this.txtPort.getDispalyFormatter();
        f.setFormat(null);
    }

    private void setCustComponentTabIndex() {
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.txtNumber, this.txtName, this.comboDBType, this.txtIP, this.txtPort, this.txtinstance, this.txtusername, this.txtpassword, this.txtDescription}));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocusInWindow();
    }

    private char[] getDbInfo(String data, String errorInfo) {
        char[] chars = null;
        if (!StringUtils.isEmpty((String)data)) {
            chars = data.trim().toCharArray();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"filedValueIsNull", (Object[])new Object[]{errorInfo}));
            SysUtil.abort();
        }
        return chars;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
        BgCommCHelper.disableVisible((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew);
        BgCommCHelper.disableVisible((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        BgCommCHelper.disableVisible((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove);
        BgCommCHelper.disableVisible((JButton)this.btnAttachment, (JMenuItem)this.MenuItemAttachment);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState() == OprtState.EDIT) {
            boolean state = false;
            try {
                state = BgControlIsomerConnectionFactory.getRemoteInstance().canModifyConnection((IObjectValue)this.editData);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            this.setButtonState(state);
        } else if (this.getOprtState() == OprtState.VIEW) {
            this.txtpassword.setEditable(false);
        }
    }

    private void setButtonState(boolean enable) {
        this.txtIP.setEditable(enable);
        this.txtinstance.setEditable(enable);
        this.txtPort.setEditable(enable);
        this.comboDBType.setEnabled(enable);
        this.txtusername.setEnabled(enable);
        this.txtpassword.setEnabled(enable);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        BgControlIsomerConnectionInfo objectValue = new BgControlIsomerConnectionInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
    }

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        super.onLoad();
        this.txtpassword.setBackground(UIManager.getColor("TextField.requiredBackground"));
        if (this.txtPort.getValue() == null || this.txtPort.getValue().equals(0)) {
            this.txtPort.setValue((Object)1521);
        }
        if (this.comboDBType.getSelectedIndex() == -1) {
            this.comboDBType.setSelectedIndex(0);
        }
        this.comboDBType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.dbTypeChanged();
            }

            private void dbTypeChanged() {
                if (BgControlIsomerConnectionEditUI.this.comboDBType.getSelectedItem().equals(DBType.SQLServer)) {
                    BgControlIsomerConnectionEditUI.this.txtPort.setValue((Object)1433);
                } else if (BgControlIsomerConnectionEditUI.this.comboDBType.getSelectedItem().equals(DBType.Oracle)) {
                    BgControlIsomerConnectionEditUI.this.txtPort.setValue((Object)1521);
                } else if (BgControlIsomerConnectionEditUI.this.comboDBType.getSelectedItem().equals(DBType.DB2)) {
                    BgControlIsomerConnectionEditUI.this.txtPort.setValue((Object)5000);
                } else if (BgControlIsomerConnectionEditUI.this.comboDBType.getSelectedItem().equals(DBType.MySql)) {
                    BgControlIsomerConnectionEditUI.this.txtPort.setValue((Object)3306);
                } else if (BgControlIsomerConnectionEditUI.this.comboDBType.getSelectedItem().equals(DBType.PostgreSQL)) {
                    BgControlIsomerConnectionEditUI.this.txtPort.setValue((Object)5432);
                }
            }
        });
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.setButtonState(true);
        super.actionAddNew_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        char[] password;
        String username;
        String ipText;
        StringBuilder ipBuf;
        DBType dbType;
        String objName;
        LanguageInfo la = new LanguageInfo(this.getCurrentLocale());
        String operate = this.getOprtState();
        String oldName = this.editData.getName();
        String oldNumber = this.editData.getNumber();
        String strNumber = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)strNumber)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"conNumberIsNull"));
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", strNumber)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"conNumberHasBlank"));
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(la).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(la).getData().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"conNameIsNull"));
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", objName = this.txtName.getItemBy(la).getData().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"conNameHasBlank"));
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        if ((dbType = (DBType)this.comboDBType.getSelectedItem()) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbTypeIsNull"));
            this.comboDBType.requestFocusInWindow();
            SysUtil.abort();
        }
        this.editData.setNumber(strNumber);
        this.editData.setName(objName.toString());
        BgControlIsomerConnectionFactory.getRemoteInstance().checkNumberBlank(this.editData);
        BgControlIsomerConnectionFactory.getRemoteInstance().checkNameBlank(this.editData);
        if (OprtState.EDIT.equals(operate)) {
            if (!StringUtils.equals((String)oldNumber, (String)strNumber)) {
                BgControlIsomerConnectionFactory.getRemoteInstance().checkNumberDup(this.editData);
            }
            if (!StringUtils.equals((String)oldName, (String)objName.toString())) {
                BgControlIsomerConnectionFactory.getRemoteInstance().checkNameDup(this.editData);
            }
        }
        if (OprtState.ADDNEW.equals(operate)) {
            BgControlIsomerConnectionFactory.getRemoteInstance().checkNameDup(this.editData);
            BgControlIsomerConnectionFactory.getRemoteInstance().checkNumberDup(this.editData);
        }
        if ((ipBuf = new StringBuilder(ipText = this.txtIP.getText())).length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"ipIsNull"));
            this.txtIP.requestFocusInWindow();
            SysUtil.abort();
        }
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        String[] ipArr = ipText.split(",");
        for (int i = 0; i < ipArr.length; ++i) {
            String eachIP = ipArr[i];
            if (StringUtils.isEmpty((String)eachIP)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"illeglaIP"));
                this.txtIP.requestFocusInWindow();
                SysUtil.abort();
                continue;
            }
            Matcher matcher = pattern.matcher(eachIP);
            if (matcher.matches()) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"illeglaIP"));
            this.txtIP.requestFocusInWindow();
            SysUtil.abort();
        }
        String port = this.txtPort.getText();
        if (StringUtils.isEmpty((String)port)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"portIsNull"));
            this.txtPort.requestFocusInWindow();
            SysUtil.abort();
        } else if (StringUtils.equals((String)port, (String)"0")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"portIsZero"));
            this.txtPort.requestFocusInWindow();
            SysUtil.abort();
        }
        String instance = this.txtinstance.getText();
        if (StringUtils.isEmpty((String)instance)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbNameIsNull"));
            this.txtinstance.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[\u4e00-\u9fa5]", instance)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbNameHasChinese"));
            this.txtinstance.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", instance)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbNameHasBlank"));
            this.txtinstance.requestFocusInWindow();
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(username = this.txtusername.getText()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"nameIsNull"));
            this.txtusername.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainChar("[ ]", username)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"nameHasBlank"));
            this.txtusername.requestFocusInWindow();
            SysUtil.abort();
        }
        if (null == (password = this.txtpassword.getPassword()) || password.length == 0 || password.length > 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"plengthIsOver"));
            this.txtpassword.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.isContainNullChar(' ', password)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"pHasBlank"));
            this.txtpassword.requestFocusInWindow();
            SysUtil.abort();
        }
        try {
            this.chkMenuItemSubmitAndAddNew.setSelected(false);
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception ex) {
            Exception cause = ex;
            String errmsg = null;
            errmsg = ex instanceof BOSException ? ThrowableHelper.toString((Throwable)cause) : ExceptionMessageUtility.getMessage((Throwable)ex);
            if (this.getOprtState() == OprtState.EDIT) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"partNotEdit"), (String)errmsg, (int)8188);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"addFail"), (String)errmsg, (int)8188);
            }
            this.isException = true;
        }
        finally {
            this.getUIWindow().close();
            if (this.getUIContext().get("Owner") instanceof BgControlIsomerConnectF7UI) {
                ((BgControlIsomerConnectF7UI)((Object)this.getUIContext().get("Owner"))).actionRefresh_actionPerformed(e);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        boolean state = BgControlIsomerConnectionFactory.getRemoteInstance().canModifyConnection((IObjectValue)this.editData);
        this.setButtonState(state);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgControlIsomerConnectionFactory.getRemoteInstance();
    }

    public boolean isContainNullChar(char reg, char[] chars) {
        int in = chars.length;
        for (int i = 0; i < in; ++i) {
            if (chars[i] != reg) continue;
            return true;
        }
        return false;
    }

    public boolean isContainChar(String reg, String str) {
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.find();
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
    }

    public boolean destroyWindow() {
        if (this.isException) {
            return true;
        }
        return super.destroyWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionTestConn_actionPerformed(ActionEvent e) throws Exception {
        block7: {
            DBType dbType = (DBType)this.comboDBType.getSelectedItem();
            char[] ip = null;
            char[] port = null;
            char[] dbName = null;
            char[] userName = null;
            char[] password = null;
            try {
                boolean result;
                if (dbType == null) {
                    this.getDbInfo(null, EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbType"));
                }
                ip = this.getDbInfo(this.txtIP.getText(), EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"IP"));
                port = this.getDbInfo(this.txtPort.getIntegerValue() == null ? null : this.txtPort.getIntegerValue().toString(), EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"port"));
                dbName = this.getDbInfo(this.txtinstance.getText(), EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbName"));
                userName = this.getDbInfo(this.txtusername.getText(), EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dbUser"));
                password = this.txtpassword.getPassword();
                if (null == password || password.length == 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"passWordIsNull"));
                    SysUtil.abort();
                }
                if (result = SQLFacadeFactory.getRemoteInstance().DBConnection(dbType.toString(), String.copyValueOf(ip), String.copyValueOf(port), String.copyValueOf(dbName), String.copyValueOf(userName), String.copyValueOf(password))) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectSuccess"));
                    break block7;
                }
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"));
            }
            catch (Exception ex) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"), (String)ex.getMessage(), (int)2);
            }
        }
        super.actionTestConn_actionPerformed(e);
    }

    private void releaseChar(char[] ... privateMessages) {
        for (char[] privateMessage : privateMessages) {
            if (null == privateMessage || privateMessage.length == 0) continue;
            Arrays.fill((Object[])privateMessages, Character.valueOf(' '));
        }
    }
}

