/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgAccountSortCollection;
import com.kingdee.eas.ma.base.BgAccountSortFactory;
import com.kingdee.eas.ma.base.BgAccountSortInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.control.BgControlOrgEntrustFactory;
import com.kingdee.eas.ma.control.BgControlOrgEntrustInfo;
import com.kingdee.eas.ma.control.client.AbstractBgControlOrgEntrustImportUI;
import com.kingdee.eas.ma.control.client.BGControlReportUI;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgControlOrgEntrustImportUI
extends AbstractBgControlOrgEntrustImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgControlOrgEntrustImportUI.class);
    private static final long serialVersionUID = 1L;
    public static final String IMPORT_RES = "com.kingdee.eas.tools.datatask.DatataskResource";
    private static final String res = "com.kingdee.eas.ma.control.client.BgControlOrgEntrustResource";
    private HashMap<String, BgAccountSortInfo> numberPlusIndexSortMap = null;
    private ArrayList<String> allUnitNumLst = null;
    private HashMap<String, FullOrgUnitInfo> numPlusUnitInfoMap = null;
    private ArrayList<String> enUnitNumLst = null;
    private HashMap<String, CostCenterOrgUnitInfo> numPlusEnUnitMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOpenFile.setIcon((Icon)((ImageIcon)ResourceBase.getIcon((String)"com.kingdee.eas.tools.datatask.ui.ImageResource.tbtn_open", (Locale)new Locale("L1"))));
        this.panelProgress.setVisible(false);
        this.setBtnState(true);
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            this.kDLabelContainer2.setVisible(false);
            this.btnConfirm.setText(BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"export"));
            this.kDLabel1.setText(BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"exporting"));
        } else {
            this.comboError.removeAllItems();
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
            this.comboError.setSelectedItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        }
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
        this.chkUpdate.setEnabled(state);
        this.btnExportTemplate.setEnabled(state);
        this.btnExportTemplate.setVisible(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFile.getText())) {
            return;
        }
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            ProgressThread process = new ProgressThread(false);
            process.start();
        } else {
            ProgressThread process = new ProgressThread(true);
            process.start();
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fileChooser = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        fileChooser = (Boolean)this.getUIContext().get("isImport") == false ? bgFileUtil.getFileChooserForExp((Object)this.getUIContext()) : bgFileUtil.getFileChooserForImp((Object)this.getUIContext());
        fileChooser.setDialogTitle(this.getUIContext().get("uiTitle").toString());
        String filePath = this.fileSelect(fileChooser);
        if (!StringUtils.isEmpty((String)filePath)) {
            this.txtFile.setText(filePath.toString());
            this.txtFile.setUserObject((Object)fileChooser.getSelectedFile());
        }
    }

    private String fileSelect(KDFileChooser fileChooser) {
        String filePath = null;
        SimpleFileFilter txtFilter = new SimpleFileFilter("txt");
        SimpleFileFilter csvFilter = new SimpleFileFilter("csv");
        ExcelFile xlsFilter = new ExcelFile();
        Excel2007FileFilter xlsxFilter = new Excel2007FileFilter();
        fileChooser.setFileFilter((FileFilter)xlsxFilter);
        fileChooser.setFileFilter((FileFilter)txtFilter);
        fileChooser.setFileFilter((FileFilter)csvFilter);
        fileChooser.setFileFilter((FileFilter)xlsFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            FileFilter fileFilter = fileChooser.getFileFilter();
            if (filePath.lastIndexOf(".") != -1) {
                filePath = filePath.substring(0, filePath.lastIndexOf("."));
            }
            filePath = fileFilter == xlsxFilter ? filePath + ".xlsx" : (fileFilter == txtFilter ? filePath + ".txt" : (fileFilter == csvFilter ? filePath + ".csv" : filePath + ".xls"));
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        return filePath;
    }

    @Override
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess;
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForExp((Object)this.getUIContext());
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)res, (String)"orgEntrustTemplet"));
        fileChooser.setSelectedFile(new File(BgCommCHelper.getMessageStr((String)res, (String)"orgEntrustTemplet")));
        String filePath = this.fileSelect(fileChooser);
        KDTable tbl = (KDTable)this.getUIContext().get("template");
        if (!StringUtils.isEmpty((String)filePath) && (isSuccess = this.appendToExcel(filePath, tbl))) {
            new BgFileUtil().storeDefaultPathForEXP((Object)filePath, (Object)this.getUIContext());
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)res, (String)"templetExportSuccess"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean appendToExcel(String filePath, KDTable tbl) throws Exception {
        File file = new File(filePath);
        KDTIOManager ioManager = tbl.getIOManager();
        KDSBook book = null;
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(5);
        try {
            this.progressBar.setValue(1);
            if (file.exists()) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"fileHasExisted"));
                if (result != 0) return false;
                if (!file.delete()) {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)IMPORT_RES, (String)"openedfile"));
                    this.disableButtons();
                    return false;
                }
                file = new File(filePath);
                book = new KDSBook(file.getName());
            } else {
                book = new KDSBook(file.getName());
            }
            this.progressBar.setValue(2);
            book.addSheet(null, ioManager.saveToKDSSheet(book, true, false, BgCommCHelper.getMessageStr((String)res, (String)"orgEntrust")));
            this.progressBar.setValue(3);
            ExportManager man = new ExportManager();
            this.progressBar.setValue(4);
            try {
                String sen = GlobalFunction.getFileExtension((String)file.getName());
                if (sen == null) {
                    MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"753_BgControlOrgEntrustImportUI"));
                    SysUtil.abort();
                }
                Book temBook = null;
                if (sen.equals("xlsx")) {
                    temBook = KDSBookToBook.traslate((KDSBook)book);
                    BookDataWrapper bookDataWrapper = new BookDataWrapper(temBook);
                    SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                    booksc.write(filePath.replaceAll(" ", ""));
                } else {
                    man.exportToExcel(book, filePath);
                }
            }
            catch (POIExportException ex) {
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"183_BgControlRuleEditUI"));
            }
            this.progressBar.setValue(5);
            return true;
        }
        catch (Exception err) {
            logger.error((Object)" ", (Throwable)err);
            throw err;
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
    }

    protected void enableButtons() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.btnExportTemplate.setEnabled(true);
        this.panelProgress.setVisible(false);
    }

    protected void disableButtons() {
        this.btnConfirm.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpenFile.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.btnExportTemplate.setEnabled(false);
        this.panelProgress.setVisible(true);
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    private void importData(KDSSheet sheet, String fileName) throws ParseException {
        String num;
        Date endDate2;
        Date beginDate2;
        String[] periods2;
        String period2;
        String keyE;
        String sortEorg;
        String valueE;
        String sortOrg;
        String valueOrg;
        String keyOrg;
        String verifyStr1;
        String verifyStr;
        int i;
        if (!this.validateTemplate(sheet, fileName)) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)res, (String)"templetError"));
            return;
        }
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(sheet.getRowCount());
        int errorNum = ((ErrorHandleModeEnum)this.comboError.getSelectedItem()).getValue();
        KDTable tblMain = (KDTable)this.getUIContext().get("template");
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> errorLst = new ArrayList<HashMap<String, String>>();
        int row_0 = 0;
        int row_1 = 1;
        int row_2 = 2;
        int row_3 = 3;
        int row_4 = 4;
        int row_5 = 5;
        int row_6 = 6;
        int row_7 = 7;
        int row_8 = 8;
        Object indexSortNumber = null;
        Object indexSortName = null;
        Object orgUnitNumber = null;
        Object orgUnitName = null;
        Object entrustOrgUnitNumber = null;
        Object entrustOrgUnitName = null;
        Object beginTime = null;
        Object endTime = null;
        CoreBaseCollection bgControlOrgEntrustColl = new CoreBaseCollection();
        HashMap<String, String> indexAndOrg = new HashMap<String, String>();
        HashMap<String, String> indexAndEnt = new HashMap<String, String>();
        HashMap<String, BgControlOrgEntrustInfo> indexAndEnInfo = new HashMap<String, BgControlOrgEntrustInfo>();
        HashMap<String, String> indexAndOrgTable = new HashMap<String, String>();
        HashMap<String, String> indexAndEntTable = new HashMap<String, String>();
        BgControlOrgEntrustInfo entrustInfo = null;
        BgAccountSortInfo accountSortInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        CostCenterOrgUnitInfo entrustOrgInfo = null;
        ArrayList<String> verifySame = new ArrayList<String>();
        ArrayList<String> verifyIndexAndOrg = new ArrayList<String>();
        try {
            this.initDValue();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
            e1.printStackTrace();
        }
        Date begin = new Date();
        Date end = new Date();
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < tblMain.getRowCount(); ++i) {
            indexSortNumber = tblMain.getRow(i).getCell(row_0).getValue() == null ? "" : tblMain.getRow(i).getCell(row_0).getValue();
            indexSortName = tblMain.getRow(i).getCell(row_1).getValue();
            orgUnitNumber = tblMain.getRow(i).getCell(row_2).getValue();
            orgUnitName = tblMain.getRow(i).getCell(row_3).getValue();
            entrustOrgUnitNumber = tblMain.getRow(i).getCell(row_4).getValue();
            entrustOrgUnitName = tblMain.getRow(i).getCell(row_5).getValue();
            try {
                if (tblMain.getRow(i).getCell(row_6).getValue() instanceof Date) {
                    begin = (Date)tblMain.getRow(i).getCell(row_6).getValue();
                    begin = formate.parse(formate.format(begin));
                } else {
                    String beginTimes = (String)tblMain.getRow(i).getCell(row_6).getValue();
                    begin = formate.parse(beginTimes);
                }
            }
            catch (ParseException e) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"beginTimeError"));
                SysUtil.abort();
            }
            try {
                if (tblMain.getRow(i).getCell(row_7) instanceof Date) {
                    end = (Date)tblMain.getRow(i).getCell(row_7).getValue();
                    end = formate.parse(formate.format(end));
                } else {
                    String endTimes = (String)tblMain.getRow(i).getCell(row_7).getValue();
                    end = formate.parse(endTimes);
                }
            }
            catch (ParseException e) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"endTimeError"));
                SysUtil.abort();
            }
            verifyStr = indexSortNumber + "!" + orgUnitNumber + ":" + formate.format(begin) + "!" + formate.format(end);
            verifyStr1 = indexSortNumber + "!" + entrustOrgUnitNumber + ":" + formate.format(begin) + "!" + formate.format(end);
            verifySame.add(verifyStr);
            verifyIndexAndOrg.add(verifyStr1);
            indexAndOrgTable.put(String.valueOf(i + 1), indexSortNumber + "!" + orgUnitNumber + ":" + formate.format(begin) + "!" + formate.format(end));
            indexAndEntTable.put(String.valueOf(i + 1), indexSortNumber + "!" + entrustOrgUnitNumber + ":" + formate.format(begin) + "!" + formate.format(end));
        }
        block18: for (i = 1; i < sheet.getRowCount(); ++i) {
            this.progressBar.setValue(i);
            indexSortNumber = sheet.getCell(i, row_0, false).getValue();
            indexSortName = sheet.getCell(i, row_1, false).getValue();
            orgUnitNumber = sheet.getCell(i, row_2, false).getValue();
            orgUnitName = sheet.getCell(i, row_3, false).getValue();
            entrustOrgUnitNumber = sheet.getCell(i, row_4, false).getValue();
            entrustOrgUnitName = sheet.getCell(i, row_5, false).getValue();
            beginTime = sheet.getCell(i, row_6, false).getValue();
            endTime = sheet.getCell(i, row_7, false).getValue();
            entrustInfo = new BgControlOrgEntrustInfo();
            entrustInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            entrustInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            entrustInfo.setId(BOSUuid.create((BOSObjectType)entrustInfo.getBOSType()));
            if (!this.numberPlusIndexSortMap.containsKey(indexSortNumber) && !indexSortNumber.toString().isEmpty()) {
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"indexSortImporteErr", (Object[])new Object[]{i + 1}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                break;
            }
            accountSortInfo = this.numberPlusIndexSortMap.get(indexSortNumber);
            entrustInfo.setBgIndexSort(accountSortInfo);
            if (!this.allUnitNumLst.contains(orgUnitNumber)) {
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"orgUnitImporteErr", (Object[])new Object[]{i + 1}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                break;
            }
            orgUnitInfo = this.numPlusUnitInfoMap.get(orgUnitNumber);
            entrustInfo.setBgOrgUnit(orgUnitInfo);
            if (!this.enUnitNumLst.contains(entrustOrgUnitNumber)) {
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"entrustUnitImporteErr", (Object[])new Object[]{i + 1}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                break;
            }
            entrustOrgInfo = this.numPlusEnUnitMap.get(entrustOrgUnitNumber);
            entrustInfo.setBgEntrustOrgUnit(entrustOrgInfo);
            if (beginTime instanceof Date) {
                entrustInfo.setBeginTime((Date)beginTime);
                begin = formate.parse(formate.format((Date)beginTime));
            } else if (beginTime instanceof String) {
                try {
                    begin = formate.parse((String)beginTime);
                    entrustInfo.setBeginTime(begin);
                }
                catch (ParseException e) {
                    map = new HashMap();
                    map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"beginTimeImporteErr", (Object[])new Object[]{i + 1}));
                    errorLst.add(map);
                    if (errorNum != 1) continue;
                    break;
                }
            }
            if (endTime instanceof Date) {
                entrustInfo.setEndTime((Date)endTime);
                end = formate.parse(formate.format((Date)endTime));
            } else if (endTime instanceof String) {
                try {
                    end = formate.parse((String)endTime);
                    entrustInfo.setEndTime(end);
                }
                catch (ParseException e) {
                    map = new HashMap();
                    map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"endTimeImporteErr", (Object[])new Object[]{i + 1}));
                    errorLst.add(map);
                    if (errorNum != 1) continue;
                    break;
                }
            }
            if (begin != null && end != null && begin.getTime() > end.getTime()) {
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"beginLargerEnd", (Object[])new Object[]{i + 1}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                break;
            }
            verifyStr = indexSortNumber + "!" + orgUnitNumber + ":" + formate.format(begin) + "!" + formate.format(end);
            verifyStr1 = indexSortNumber + "!" + entrustOrgUnitNumber + ":" + formate.format(begin) + "!" + formate.format(end);
            String indexAndOrgNumber = indexSortNumber + "!" + orgUnitNumber;
            if (verifySame.size() > 0) {
                for (String key : verifySame) {
                    String sortKey = key.split(":")[0];
                    if (!indexAndOrgNumber.equals(sortKey)) continue;
                    String period = key.split(":")[1];
                    String[] periods = period.split("!");
                    try {
                        Date beginDate = formate.parse(periods[0]);
                        Date endDate = formate.parse(periods[1]);
                        if (!(begin.getTime() >= beginDate.getTime() && begin.getTime() <= endDate.getTime() || begin.getTime() >= beginDate.getTime() && begin.getTime() <= endDate.getTime() || beginDate.getTime() >= begin.getTime() && beginDate.getTime() <= end.getTime()) && (beginDate.getTime() < begin.getTime() || beginDate.getTime() > end.getTime())) continue;
                        map = new HashMap();
                        String[] temp = indexAndOrgNumber.split("!");
                        if (StringUtils.isEmpty((String)temp[0])) {
                            map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"hasOrgUnit2", (Object[])new Object[]{i + 1, temp[1]}));
                        } else {
                            map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"hasOrgUnit3", (Object[])new Object[]{i + 1, temp[0], temp[1]}));
                        }
                        errorLst.add(map);
                        verifySame.add(verifyStr);
                        verifyIndexAndOrg.add(verifyStr1);
                        if (errorNum != 1) continue block18;
                        break block18;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            verifySame.add(verifyStr);
            verifyIndexAndOrg.add(verifyStr1);
            bgControlOrgEntrustColl.add((CoreBaseInfo)entrustInfo);
            indexAndEnInfo.put(String.valueOf(i + 1), entrustInfo);
            indexAndOrg.put(String.valueOf(i + 1), verifyStr);
            indexAndEnt.put(String.valueOf(i + 1), verifyStr1);
        }
        Iterator iteO = indexAndOrg.entrySet().iterator();
        ArrayList removeInfo = new ArrayList();
        block20: while (iteO.hasNext()) {
            Map.Entry entry1 = iteO.next();
            keyOrg = (String)entry1.getKey();
            valueOrg = (String)entry1.getValue();
            sortOrg = valueOrg.split(":")[0];
            String period1 = valueOrg.split(":")[1];
            String[] periods1 = period1.split("!");
            Date beginDate1 = formate.parse(periods1[0]);
            Date endDate1 = formate.parse(periods1[1]);
            for (Map.Entry entry2 : indexAndEnt.entrySet()) {
                valueE = (String)entry2.getValue();
                sortEorg = valueE.split(":")[0];
                if (!sortOrg.equals(sortEorg)) continue;
                String period22 = valueE.split(":")[1];
                String[] periods22 = period22.split("!");
                Date beginDate22 = formate.parse(periods22[0]);
                Date endDate22 = formate.parse(periods22[1]);
                if (!(beginDate1.getTime() >= beginDate22.getTime() && beginDate1.getTime() <= endDate22.getTime() || beginDate1.getTime() >= beginDate22.getTime() && beginDate1.getTime() <= endDate22.getTime() || beginDate22.getTime() >= beginDate1.getTime() && beginDate22.getTime() <= endDate1.getTime()) && (beginDate22.getTime() < beginDate1.getTime() || beginDate22.getTime() > endDate1.getTime())) continue;
                keyE = (String)entry2.getKey();
                if (removeInfo.contains(indexAndEnInfo.get(keyE))) break block20;
                removeInfo.add(indexAndEnInfo.get(keyE));
                String num2 = sortOrg.substring(sortOrg.indexOf("!") + 1);
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"sameOrgAndEntrustOrg", (Object[])new Object[]{keyOrg, keyE, num2}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                break;
            }
            for (Map.Entry entry2 : indexAndEntTable.entrySet()) {
                valueE = (String)entry2.getValue();
                sortEorg = valueE.split(":")[0];
                if (!sortOrg.equals(sortEorg)) continue;
                period2 = valueE.split(":")[1];
                periods2 = period2.split("!");
                beginDate2 = formate.parse(periods2[0]);
                endDate2 = formate.parse(periods2[1]);
                if (!(beginDate1.getTime() >= beginDate2.getTime() && beginDate1.getTime() <= endDate2.getTime() || beginDate1.getTime() >= beginDate2.getTime() && beginDate1.getTime() <= endDate2.getTime() || beginDate2.getTime() >= beginDate1.getTime() && beginDate2.getTime() <= endDate1.getTime()) && (beginDate2.getTime() < beginDate1.getTime() || beginDate2.getTime() > endDate1.getTime())) continue;
                keyE = (String)entry2.getKey();
                if (removeInfo.contains(indexAndEnInfo.get(keyOrg))) break block20;
                removeInfo.add(indexAndEnInfo.get(keyOrg));
                num = sortOrg.substring(sortOrg.indexOf("!") + 1);
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"orgAndEntVerify", (Object[])new Object[]{keyOrg, keyE, num}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                continue block20;
            }
        }
        block23: for (Map.Entry entry1 : indexAndEnt.entrySet()) {
            keyOrg = (String)entry1.getKey();
            valueOrg = (String)entry1.getValue();
            sortOrg = valueOrg.split(":")[0];
            String period1 = valueOrg.split(":")[1];
            String[] periods1 = period1.split("!");
            Date beginDate1 = formate.parse(periods1[0]);
            Date endDate1 = formate.parse(periods1[1]);
            for (Map.Entry entry2 : indexAndOrgTable.entrySet()) {
                valueE = (String)entry2.getValue();
                sortEorg = valueE.split(":")[0];
                if (!sortOrg.equals(sortEorg)) continue;
                period2 = valueE.split(":")[1];
                periods2 = period2.split("!");
                beginDate2 = formate.parse(periods2[0]);
                endDate2 = formate.parse(periods2[1]);
                if (!(beginDate1.getTime() >= beginDate2.getTime() && beginDate1.getTime() <= endDate2.getTime() || beginDate1.getTime() >= beginDate2.getTime() && beginDate1.getTime() <= endDate2.getTime() || beginDate2.getTime() >= beginDate1.getTime() && beginDate2.getTime() <= endDate1.getTime()) && (beginDate2.getTime() < beginDate1.getTime() || beginDate2.getTime() > endDate1.getTime())) continue;
                keyE = (String)entry2.getKey();
                if (removeInfo.contains(indexAndEnInfo.get(keyOrg))) break block23;
                removeInfo.add(indexAndEnInfo.get(keyOrg));
                num = sortOrg.substring(sortOrg.indexOf("!") + 1);
                map = new HashMap();
                map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"orgAndEntVerify", (Object[])new Object[]{keyOrg, keyE, num}));
                errorLst.add(map);
                if (errorNum != 1) continue;
                continue block23;
            }
        }
        if (removeInfo.size() > 0) {
            for (int i2 = 0; i2 < removeInfo.size(); ++i2) {
                bgControlOrgEntrustColl.remove((CoreBaseInfo)removeInfo.get(i2));
            }
        }
        ArrayList tempErr = this.checkBusyUnitAndUnitFormUnit(sheet);
        try {
            BgControlOrgEntrustFactory.getRemoteInstance().saveOrgEntrust((IObjectCollection)bgControlOrgEntrustColl);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        ArrayList<HashMap<String, String>> txtlst = new ArrayList<HashMap<String, String>>();
        map = new HashMap();
        map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr((String)res, (String)"importMsg_1"), bgControlOrgEntrustColl.size()));
        txtlst.add(map);
        if (sheet.getRowCount() - bgControlOrgEntrustColl.size() != 1) {
            map = new HashMap();
            map.put(" ", BgCommCHelper.getMessageStr((String)res, (String)"importMsg_2", (Object[])new String[]{String.valueOf(sheet.getRowCount() - bgControlOrgEntrustColl.size() - 1)}));
            txtlst.add(map);
        }
        txtlst.addAll(errorLst);
        ArrayList<String> listHeadTitle = new ArrayList<String>();
        listHeadTitle.add(" ");
        UIContext ctx = new UIContext((Object)this);
        ctx.put("LIST_CONTENT", txtlst);
        ctx.put("LIST_HEAD_TITLE", listHeadTitle);
        DateFormat format = BgNationalFormatUIUtil.getNationalDateTimeFormat();
        Date date = new Date();
        String invokeTime = format.format((Object)date);
        ctx.put("INVOKE_TIME", invokeTime);
        ctx.put("UI_OWNER_TITLE", BgCommCHelper.getMessageStr((String)res, (String)"orgEntrustImport"));
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGControlReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
        }
        catch (UIException e) {
            e.printStackTrace();
        }
    }

    private void initDValue() throws BOSException {
        this.getBgAccountSortColl();
        this.getAllOrgUnitColl();
        this.getCostCenterColl();
    }

    private void getBgAccountSortColl() throws BOSException {
        if (this.numberPlusIndexSortMap == null) {
            this.numberPlusIndexSortMap = new HashMap();
            BgAccountSortCollection coll = BgAccountSortFactory.getRemoteInstance().getBgAccountSortCollection();
            if (coll != null && coll.size() != 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    BgAccountSortInfo info = coll.get(i);
                    this.numberPlusIndexSortMap.put(info.getNumber(), info);
                }
            }
        }
    }

    private void getAllOrgUnitColl() throws BOSException {
        if (this.numPlusUnitInfoMap == null) {
            this.allUnitNumLst = new ArrayList();
            this.numPlusUnitInfoMap = new HashMap();
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            FullOrgUnitCollection col = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                FullOrgUnitInfo info = col.get(i);
                this.allUnitNumLst.add(info.getNumber());
                this.numPlusUnitInfoMap.put(info.getNumber(), info);
            }
        }
    }

    private void getCostCenterColl() throws BOSException {
        if (this.numPlusEnUnitMap == null) {
            this.enUnitNumLst = new ArrayList();
            this.numPlusEnUnitMap = new HashMap();
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                CostCenterOrgUnitInfo info = col.get(i);
                this.enUnitNumLst.add(info.getNumber());
                this.numPlusEnUnitMap.put(info.getNumber(), info);
            }
        }
    }

    private boolean validateTemplate(KDSSheet sheet, String fileName) {
        String format = GlobalFunction.getFileExtension((String)fileName);
        if (format.equalsIgnoreCase("xls") ? sheet.getColumnCount() < 6 : sheet.getExpandedColumns() < 6) {
            return false;
        }
        KDTable tbl = (KDTable)this.getUIContext().get("template");
        String cell = "";
        String tcell = "";
        for (int i = 0; i < tbl.getColumnCount(); ++i) {
            if (sheet.getCell(0, i, false).getValue() != null) {
                cell = tbl.getHeadRow(0).getCell(i).getValue().toString();
                if (cell.equals((tcell = sheet.getCell(0, i, false).getValue().toString()).trim())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private ArrayList checkBusyUnitAndUnitFormUnit(KDSSheet sheet) {
        int row_0 = 0;
        int row_1 = 1;
        int row_2 = 2;
        int row_3 = 3;
        int row_4 = 4;
        int row_5 = 5;
        int row_6 = 6;
        KDTable tblMain = (KDTable)this.getUIContext().get("template");
        HashMap<String, ArrayList> indexAndOrg = new HashMap<String, ArrayList>();
        HashMap<String, ArrayList> indexAndEnt = new HashMap<String, ArrayList>();
        String indexSortNumber = null;
        Object indexSortName = null;
        Object orgUnitNumber = null;
        Object orgUnitName = null;
        Object entrustOrgUnitNumber = null;
        Object entrustOrgUnitName = null;
        ArrayList errList = new ArrayList();
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            ArrayList tempList = new ArrayList();
            ArrayList tempList2 = new ArrayList();
            indexSortNumber = (String)tblMain.getRow(i).getCell(row_0).getValue();
            orgUnitNumber = (String)tblMain.getRow(i).getCell(row_2).getValue();
            entrustOrgUnitNumber = (String)tblMain.getRow(i).getCell(row_4).getValue();
            if (indexAndOrg.containsKey(indexSortNumber)) {
                tempList.clear();
                tempList = (ArrayList)indexAndOrg.get(indexSortNumber);
                tempList.add((String)orgUnitNumber);
                indexAndOrg.put(indexSortNumber, tempList);
            } else {
                tempList.clear();
                tempList.add(orgUnitNumber.toString());
                indexAndOrg.put(indexSortNumber, tempList);
            }
            if (indexAndEnt.containsKey(indexSortNumber)) {
                tempList2.clear();
                tempList2 = (ArrayList)indexAndEnt.get(indexSortNumber);
                tempList2.add((String)entrustOrgUnitNumber);
                indexAndEnt.put(indexSortNumber, tempList2);
                continue;
            }
            tempList2.clear();
            tempList2.add(entrustOrgUnitNumber.toString());
            indexAndEnt.put(indexSortNumber, tempList2);
        }
        ArrayList busyArrayList = new ArrayList();
        ArrayList unitArrayList = new ArrayList();
        for (int i = 1; i < sheet.getRowCount(); ++i) {
            indexSortNumber = (String)sheet.getCell(i, row_0, false).getValue();
            indexSortName = sheet.getCell(i, row_1, false).getValue();
            orgUnitNumber = sheet.getCell(i, row_2, false).getValue();
            orgUnitName = sheet.getCell(i, row_3, false).getValue();
            entrustOrgUnitNumber = sheet.getCell(i, row_4, false).getValue();
            entrustOrgUnitName = sheet.getCell(i, row_5, false).getValue();
            if (indexAndOrg.containsKey(indexSortNumber)) {
                busyArrayList = (ArrayList)indexAndOrg.get(indexSortNumber);
            }
            if (indexAndEnt.containsKey(indexSortNumber)) {
                unitArrayList = (ArrayList)indexAndEnt.get(indexSortNumber);
            }
            if (busyArrayList.isEmpty() || unitArrayList.isEmpty() || !busyArrayList.contains(entrustOrgUnitNumber) || !unitArrayList.contains(orgUnitNumber)) continue;
            HashMap<String, String> errMap = new HashMap<String, String>();
            String msg = EASResource.getString((String)res, (String)"verifyUnit", (Object[])new Object[]{i + 1, orgUnitNumber});
            errMap.put(" ", msg);
            errList.add(errMap);
        }
        return errList;
    }

    class ProgressThread
    extends Thread {
        private boolean isImport = false;

        public ProgressThread(boolean isImport) {
            this.isImport = isImport;
        }

        @Override
        public void run() {
            BgControlOrgEntrustImportUI.this.disableButtons();
            String fileName = BgControlOrgEntrustImportUI.this.txtFile.getText();
            BgFileUtil bgFileUtil = new BgFileUtil();
            if (this.isImport) {
                KDSBook book = null;
                try {
                    String format = GlobalFunction.getFileExtension((String)fileName);
                    book = format.equals("xlsx") ? POIXlsxReader.parse((String)fileName) : POIXlsReader.parse((String)fileName);
                    if (book == null) {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlOrgEntrustImportUI.res, (String)"noFile"));
                        SysUtil.abort();
                    } else {
                        KDSSheet sheet = book.getSheet((Object)new Integer(0));
                        BgControlOrgEntrustImportUI.this.importData(sheet, fileName);
                        bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)BgControlOrgEntrustImportUI.this.getUIContext());
                    }
                    BgControlOrgEntrustImportUI.this.getUIWindow().hide();
                }
                catch (Exception e1) {
                    MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlOrgEntrustImportUI.res, (String)"importFailed"));
                    SysUtil.abort();
                }
            } else {
                KDTable tbl = (KDTable)BgControlOrgEntrustImportUI.this.getUIContext().get("data");
                try {
                    boolean isSuccess = BgControlOrgEntrustImportUI.this.appendToExcel(fileName, tbl);
                    if (isSuccess) {
                        bgFileUtil.storeDefaultPathForEXP((Object)fileName, (Object)BgControlOrgEntrustImportUI.this.getUIContext());
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)BgControlOrgEntrustImportUI.IMPORT_RES, (String)"exportSucceeded"));
                        BgControlOrgEntrustImportUI.this.getUIWindow().hide();
                    }
                }
                catch (Exception e) {
                    BgControlOrgEntrustImportUI.this.handUIExceptionAndAbort(e);
                }
            }
            BgControlOrgEntrustImportUI.this.enableButtons();
        }
    }
}

