/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.IBgControlSchemeFacade;
import com.kingdee.eas.ma.control.client.AbstractBgControlRecordUI;
import com.kingdee.eas.ma.control.client.BgRuleConditionF7Dialog;
import com.kingdee.eas.ma.control.client.utils.BgControlRecordClientHelper;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgPropertyChooseUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNSchemeDispatchClientHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgControlRecordUI
extends AbstractBgControlRecordUI {
    private static final long serialVersionUID = 4105735501039267522L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlRecordUI.class);
    private TreeModel initTreeModel;
    private KDPopupMenu popMenu = new KDPopupMenu();
    private Set<BOSUuid> companyIds = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBizSystemData();
        String selectCtrlSchemeId = (String)this.getUIContext().get("ID");
        BgControlSchemeCollection col = null;
        if (!StringUtils.isEmpty((String)selectCtrlSchemeId)) {
            col = BgControlSchemeFactory.getRemoteInstance().getBgControlSchemeCollection("select bizSystem, bizUnit where id = '" + selectCtrlSchemeId + "'");
        }
        if (col != null && !col.isEmpty()) {
            BizDataObject.selected(this.cbxBizSystem, col.get(0).getBizSystem());
            BizDataObject.selected(this.cbxBizUnit, col.get(0).getBizUnit());
        }
        this.initOrgUnit();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initPoppMenu();
    }

    @Override
    protected void cbxBizSystem_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxBizSystem_itemStateChanged(e);
        BizDataObject bizSystem = (BizDataObject)this.cbxBizSystem.getSelectedItem();
        this.initBizUnitData(bizSystem.getValue());
    }

    @Override
    protected void cbxBizUnit_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxBizUnit_itemStateChanged(e);
        this.initRuleCondition();
        this.prmtCondition.setData(null);
        if (this.prmtCondition.getSelector() instanceof BgRuleConditionF7Dialog) {
            ((BgRuleConditionF7Dialog)this.prmtCondition.getSelector()).setData(null);
        }
    }

    protected void initBizSystemData() throws Exception {
        List bizSystems = this.getFacadeInterface().getBizSys();
        Collections.reverse(bizSystems);
        this.cbxBizSystem.addItems(BizDataObject.transData(bizSystems).toArray());
    }

    protected void initBizUnitData(String bizSystem) throws Exception {
        List bizUnits = this.getFacadeInterface().getBizUnit(bizSystem);
        this.cbxBizUnit.removeAllItems();
        this.cbxBizUnit.addItems(BizDataObject.transData(bizUnits).toArray());
    }

    protected void initOrgUnit() throws Exception {
        OrgUnitInfo curOrg = (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        this.initTreeModel = BgNFSHelper.getFullTreeModel((String)this.getOrgTreeRootId());
        this.treeOrgUnit.setModel(this.initTreeModel);
        this.treeOrgUnit.setShowCheckBox(true);
        if (this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.setSelectionRow(0);
        }
        if (curOrg != null) {
            HashSet<String> ids = new HashSet<String>();
            ids.add(curOrg.getId().toString());
            BgOrgUnitUtils.selectOrgUnit((KDTree)this.treeOrgUnit, ids);
        }
    }

    protected String getOrgTreeRootId() throws EASBizException, BOSException {
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        if (ccoui != null) {
            return TemplateFacadeFactory.getRemoteInstance().firstCostCenterAndCU(ccoui.getId()).toString();
        }
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }

    private void initRuleCondition() {
        if (!(this.cbxBizUnit.getSelectedItem() instanceof BizDataObject)) {
            this.prmtCondition.setEnabled(false);
            return;
        }
        this.prmtCondition.setEnabled(true);
        BizDataObject bizSystem = (BizDataObject)this.cbxBizSystem.getSelectedItem();
        BizDataObject bizUnit = (BizDataObject)this.cbxBizUnit.getSelectedItem();
        if (this.prmtCondition.getSelector() == null) {
            this.createNewRuleConditionEditor(bizSystem.isIsomer(), bizSystem.getValue(), bizUnit.getValue());
        } else {
            BgRuleConditionF7Dialog dialog = (BgRuleConditionF7Dialog)this.prmtCondition.getSelector();
            dialog.setBizUnit(bizUnit.getValue());
            dialog.setIsomer(bizSystem.isIsomer());
        }
    }

    private void createNewRuleConditionEditor(boolean isomer, String bizSystem, String bizUnit) {
        BgRuleConditionF7Dialog dialog = new BgRuleConditionF7Dialog((IUIObject)this);
        dialog.setBizUnit(bizUnit);
        dialog.setIsomer(isomer);
        this.prmtCondition.setEditable(false);
        this.prmtCondition.setSelector((KDPromptSelector)dialog);
    }

    protected IBgControlSchemeFacade getFacadeInterface() throws Exception {
        return BgControlSchemeFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)false, (DefaultKingdeeTreeNode)root, (boolean)true, (KDTree)this.treeOrgUnit);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        BgNSchemeDispatchClientHelper.setNodeSelect((boolean)true, (DefaultKingdeeTreeNode)root, (boolean)true, (KDTree)this.treeOrgUnit);
    }

    @Override
    public void actionControlRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionControlRecord_actionPerformed(e);
        this.runCtrl(true);
    }

    @Override
    public void actionClearRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearRecord_actionPerformed(e);
        this.runCtrl(false);
    }

    private void runCtrl(boolean isCtrl) throws Exception {
        this.verifyData();
        String uiTitle = isCtrl ? this.btnControlRecord.getText() : this.btnClearRecord.getText();
        BizDataObject bizUnit = (BizDataObject)this.cbxBizUnit.getSelectedItem();
        Date beginTime = (Date)this.pickBeginDate.getValue();
        Date endTime = (Date)this.pickEndDate.getValue();
        BizDataObject condition = (BizDataObject)this.prmtCondition.getData();
        List orgUnitIds = BgOrgUnitUtils.getSelectOrgUnitIds((KDTree)this.treeOrgUnit);
        BgControlRecordClientHelper.startControlRecord(this, bizUnit, beginTime, endTime, condition == null ? null : condition.getValue(), orgUnitIds, isCtrl, this.chkAllowAccess.isSelected(), uiTitle);
    }

    public void verifyData() throws Exception {
        boolean flag;
        super.verifyData();
        BizDataObject bizSystem = (BizDataObject)this.cbxBizSystem.getSelectedItem();
        BizDataObject bizUnit = (BizDataObject)this.cbxBizUnit.getSelectedItem();
        if (bizSystem == null || bizUnit == null) {
            return;
        }
        List<String> bgOrgUnitIds = this.getSelectedOrgUnitIds();
        if (bgOrgUnitIds == null || bgOrgUnitIds.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeResource", (String)"pleaseSelectOrg"));
            SysUtil.abort();
        }
        if (flag = this.checkBillState()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSchemeResource", (String)"stateNotNull"));
            SysUtil.abort();
        }
    }

    private boolean checkBillState() {
        boolean flag = false;
        ArrayList<String> billSystems = new ArrayList<String>(Arrays.asList("com.kingdee.eas.cp.bc", "com.kingdee.eas.fi.ap", "com.kingdee.eas.fi.cas", "com.kingdee.eas.fi.gl", "com.kingdee.eas.fm.invest.ft", "com.kingdee.eas.scm.sm.pur", "com.kingdee.eas.fm.nt.recAndPayBill", "com.kingdee.eas.fm.fin.loan"));
        BizDataObject bizSystem = (BizDataObject)this.cbxBizSystem.getSelectedItem();
        BizDataObject bizUnit = (BizDataObject)this.cbxBizUnit.getSelectedItem();
        if (!billSystems.contains(bizSystem.getValue())) {
            return false;
        }
        if (this.prmtCondition.getValue() == null) {
            flag = true;
        } else {
            BizDataObject value = (BizDataObject)this.prmtCondition.getValue();
            if (!(value.getValue().contains("state") || value.getValue().contains("bizStatus") || value.getValue().contains("billStatus") || value.getValue().contains("status") || value.getValue().contains("baseStatus") || value.getValue().contains("billState"))) {
                flag = true;
            }
        }
        return flag;
    }

    protected List<String> getSelectedOrgUnitIds() {
        return BgOrgUnitUtils.getSelectOrgUnitIds((KDTree)this.treeOrgUnit);
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void initPoppMenu() {
        KDMenuItem menu = null;
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        menu = new KDMenuItem();
        menu.setText(BgOrgUnitHelper.getBgOrgMsg((String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.getPopMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(BgOrgUnitHelper.getBgOrgMsg((String)"selectAllSubOrgUnit"));
        menu.addActionListener((ActionListener)new AllOrgMenuListener());
        this.getPopMenu().add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeUnAssignResource", (String)"finOrg"));
        menu.addActionListener((ActionListener)new FinmenuListener());
        this.getPopMenu().add((JMenuItem)menu);
    }

    public Set<BOSUuid> getCompanyIds() {
        if (this.companyIds == null) {
            this.companyIds = new HashSet<BOSUuid>();
            try {
                Set<BOSUuid> idSet = this.queryCompanyIds();
                for (BOSUuid id : idSet) {
                    this.companyIds.add(id);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return this.companyIds;
    }

    protected Set<BOSUuid> queryCompanyIds() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance().queryCompanyIds();
    }

    private Set<String> getOrgIdByFid(Set ids) {
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitCollection unitCol = null;
        HashSet<String> set = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("orgUnitID");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            iBgOrgUnit = BgOrgUnitFactory.getRemoteInstance();
            unitCol = iBgOrgUnit.getBgOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (unitCol == null || unitCol.isEmpty()) {
            return null;
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            set.add(unitCol.get(i).getOrgUnitID());
        }
        return set;
    }

    protected String getPropertyChooseUIName() {
        return BgPropertyChooseUI.class.getName();
    }

    class PropertyListener
    implements ActionListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIContext uiContext = new UIContext((Object)this);
            Set set = new HashSet();
            uiContext.put((Object)"selectOrg", set);
            uiContext.put((Object)BgSchemeDispatchConstants.SCHEME_DISPATCH_RESULT, (Object)Boolean.TRUE);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgControlRecordUI.this.getPropertyChooseUIName(), (Map)uiContext, null, OprtState.VIEW);
            }
            catch (UIException e1) {
                logger.error((Object)e1.getMessage());
            }
            uiWindow.show();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgControlRecordUI.this.treeOrgUnit.getModel().getRoot();
            if (set != null) {
                set = BgControlRecordUI.this.getOrgIdByFid(set);
                BgOrgUnitUtils.selectOrgUnitIds((DefaultKingdeeTreeNode)node, set);
            }
            BgControlRecordUI.this.treeOrgUnit.repaint();
        }
    }

    class FinmenuListener
    implements ActionListener {
        FinmenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)BgControlRecordUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnitByIds((DefaultKingdeeTreeNode)selectNode, BgControlRecordUI.this.getCompanyIds());
            BgControlRecordUI.this.treeOrgUnit.repaint();
        }
    }

    class AllOrgMenuListener
    implements ActionListener {
        AllOrgMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgControlRecordUI.this.treeOrgUnit.getLastSelectedPathComponent();
            BgOrgUnitUtils.selectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
            BgControlRecordUI.this.treeOrgUnit.repaint();
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)BgControlRecordUI.this.treeOrgUnit.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            BgOrgUnitUtils.selectDirectOrgUnit((DefaultKingdeeTreeNode)node, (boolean)true);
            BgControlRecordUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgControlRecordUI.this.getPopMenu().show((Component)BgControlRecordUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }
}

