/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.IBgControlScheme;
import com.kingdee.eas.ma.control.client.AbstractBgControlSchemeImportF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgControlSchemeImportF7UI
extends AbstractBgControlSchemeImportF7UI {
    private static final long serialVersionUID = -6124045144151704457L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlSchemeImportF7UI.class);
    private boolean isCancel = true;
    private BgControlSchemeCollection result = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.putDataToKDTable();
        this.colSetLocked();
    }

    private void colSetLocked() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("sysName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("billName").getStyleAttributes().setLocked(true);
    }

    private void putDataToKDTable() {
        try {
            BgControlSchemeInfo bgCtrlInfo = null;
            IBgControlScheme iBgCtrlScheme = BgControlSchemeFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isSysDefault", (Object)new Integer("1"), CompareType.EQUALS));
            this.afterSetFilter(filter);
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("bizUnitAlias");
            sic.add("bizSystemAlias");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            SorterItemInfo sore = new SorterItemInfo("number");
            sore.setSortType(SortType.ASCEND);
            view.getSorter().add(sore);
            BgControlSchemeCollection bgCtrlCol = null;
            try {
                bgCtrlCol = iBgCtrlScheme.getBgControlSchemeCollection(view);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (bgCtrlCol == null) {
                return;
            }
            this.tblMain.removeRows();
            Iterator iter = bgCtrlCol.iterator();
            while (iter.hasNext()) {
                bgCtrlInfo = (BgControlSchemeInfo)iter.next();
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)bgCtrlInfo);
                iRow.getCell("choose").setValue((Object)Boolean.FALSE);
                iRow.getCell("number").setValue((Object)bgCtrlInfo.getNumber());
                iRow.getCell("name").setValue((Object)bgCtrlInfo.getName());
                iRow.getCell("sysName").setValue((Object)bgCtrlInfo.getBizSystemAlias());
                iRow.getCell("billName").setValue((Object)bgCtrlInfo.getBizUnitAlias());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            this.handUIException(e);
        }
    }

    protected void afterSetFilter(FilterInfo filter) {
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        BgControlSchemeInfo info = null;
        this.result = new BgControlSchemeCollection();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.tblMain.getRow(i).getCell("choose").getValue().toString().equals("true")) continue;
            IRow iRow = this.tblMain.getRow(i);
            info = (BgControlSchemeInfo)iRow.getUserObject();
            this.result.add(info);
        }
        if (this.result.size() > 0) {
            this.setCancel(false);
            this.setResult(this.result);
            this.getUIWindow().close();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"validateCtlInput"));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.SelectOrClearAll(Boolean.TRUE);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.SelectOrClearAll(Boolean.FALSE);
    }

    private void SelectOrClearAll(Boolean value) {
        IRow row = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            row.getCell("choose").setValue((Object)value);
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public BgControlSchemeCollection getResult() {
        return this.result;
    }

    public void setResult(BgControlSchemeCollection result) {
        this.result = result;
    }
}

