/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.BgElementF7UI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.OrgUnitUtils;
import com.kingdee.eas.ma.control.BgControlSchemeCollection;
import com.kingdee.eas.ma.control.BgControlSchemeDistParameter;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeFactory;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.IBgControlSchemeFacade;
import com.kingdee.eas.ma.control.client.AbstractBgControlSchemeListUI;
import com.kingdee.eas.ma.control.client.BgControlRecordUI;
import com.kingdee.eas.ma.control.client.BgControlSchemeEditUI;
import com.kingdee.eas.ma.control.client.BgControlSchemeImportDialog;
import com.kingdee.eas.ma.control.client.BgControlSchemeImportReportUI;
import com.kingdee.eas.ma.control.client.BgControlUI;
import com.kingdee.eas.ma.control.client.BgCtrlSchemeAntiDisUI;
import com.kingdee.eas.ma.control.client.BgCtrlSchemeDisUI;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgControlSchemeListUI
extends AbstractBgControlSchemeListUI {
    private static final long serialVersionUID = 8489892872857325957L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlSchemeListUI.class);
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private OrgUnitInfo loginOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private ProgressDialog progressDialog;

    public CtrlUnitInfo getCU() {
        return this.CU;
    }

    public OrgUnitInfo getLoginOrgUnitInfo() {
        return this.loginOrgUnitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnClone.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemClone.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        MbgUpdateHelper.checkUpdate();
        this.initTree();
        this.initControlExtFacade();
        this.locateCurrentOrg();
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemDistribute.setEnabled(true);
        this.btnDistribute.setEnabled(true);
        this.btnDistribute.setVisible(true);
        this.btnDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemStart.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.btnImport.setEnabled(true);
        this.importMenuItem.setEnabled(true);
        this.importMenuItem.setVisible(true);
        this.importMenuItem.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.menuItemDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
    }

    protected void initTree() throws Exception {
        this.kdTree.setModel(OrgUnitUtils.getOrgTreeModel((KDTree)this.kdTree, (String)this.getOrgTreeRootId()));
    }

    protected void initControlExtFacade() throws Exception {
        AbstractAction controlAction = new AbstractAction(){
            private static final long serialVersionUID = 1700815282597564634L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UIContext uiContext = new UIContext((Object)this);
                    IUIWindow wnd = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgControlUI.class.getName(), (Map)uiContext);
                    wnd.show();
                }
                catch (UIException ex) {
                    BgControlSchemeListUI.this.handUIExceptionAndAbort((Exception)((Object)ex));
                }
            }
        };
        String strKey = "CTRL_SHIFT_A";
        KeyStroke ks = KeyStroke.getKeyStroke(65, 192, false);
        this.getActionMap().put(strKey, controlAction);
        this.getInputMap(2).put(ks, strKey);
    }

    protected String getOrgTreeRootId() throws EASBizException, BOSException {
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        if (ccoui != null) {
            return TemplateFacadeFactory.getRemoteInstance().firstCostCenterAndCU(ccoui.getId()).toString();
        }
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }

    @Override
    protected void kdTree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kdTree_valueChanged(e);
        this.execQuery();
        this.setSelectFirstRow(this.tblMain);
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        Object obj;
        IRow row;
        ObjectUuidPK groupPk = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null && (obj = row.getCell("orgUnit.id").getValue()) != null) {
            groupPk = new ObjectUuidPK(obj.toString());
        }
        return groupPk;
    }

    protected OrgUnitInfo getSelectedOrgUnitInfo() {
        OrgUnitInfo selOrgUnitInfo = this.getSelectedNodeInfo();
        if (selOrgUnitInfo == null) {
            selOrgUnitInfo = this.getLoginOrgUnitInfo();
        }
        return selOrgUnitInfo;
    }

    private void locateCurrentOrg() throws BOSException, EASBizException {
        CostCenterOrgUnitInfo currentOrg;
        block13: {
            IFullOrgUnit iou;
            block12: {
                iou = FullOrgUnitFactory.getRemoteInstance();
                currentOrg = SysContext.getSysContext().getCurrentCostUnit();
                if (currentOrg != null && currentOrg.getId() != null) break block12;
                if (this.kdTree.getRowCount() <= 0) break block13;
                this.kdTree.setSelectionRow(0);
                break block13;
            }
            if (this.kdTree.getRowCount() == 0) {
                this.tblMain.removeRows();
            }
            int height = this.kdTree.getRowCount();
            for (int i = 0; i < height; ++i) {
                TreePath tp = this.kdTree.getPathForRow(i);
                if (tp == null) continue;
                DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                if (tn == null) {
                    return;
                }
                OrgStructureInfo oui = null;
                if (height == 1) {
                    oui = new OrgStructureInfo();
                    FullOrgUnitInfo fullOrgUnit = null;
                    try {
                        fullOrgUnit = iou.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrg.getId()));
                    }
                    catch (Exception e) {
                        logger.error((Object)"BgOrgBasedListUI Init Locate OrgUnit Node Error:", (Throwable)e);
                    }
                    oui.setUnit(fullOrgUnit);
                    if (fullOrgUnit != null && fullOrgUnit.getLongNumber() != null) {
                        oui.setLongNumber(fullOrgUnit.getLongNumber());
                    }
                } else {
                    oui = (OrgStructureInfo)tn.getUserObject();
                }
                if (oui == null || oui.getUnit() == null) continue;
                FullOrgUnitInfo info = oui.getUnit();
                info.setLongNumber(oui.getLongNumber());
                if (!info.getId().toString().equals(currentOrg.getId().toString())) continue;
                this.kdTree.setSelectionRow(i);
                break;
            }
        }
        if (this.kdTree.getSelectionPath() == null && this.kdTree.getRowCount() > 0) {
            this.kdTree.setSelectionRow(0);
        }
        if (this.kdTree.getModel() != null && this.kdTree.getModel().getRoot() != null) {
            DefaultKingdeeTreeNode currNode;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.kdTree.getModel().getRoot();
            this.kdTree.expandOnLevel(1);
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            ArrayList list = new ArrayList();
            if (oui != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("parent.id"));
                this.getCurrentOrgTree(list, currentOrg, (OrgUnitInfo)oui.getUnit(), CostCenterOrgUnitFactory.getRemoteInstance(), selector);
            }
            if ((currNode = this.expandCurrentOrg(list, root)) != null) {
                this.kdTree.setSelectionPath(new TreePath(currNode.getPath()));
            }
        }
    }

    protected DefaultKingdeeTreeNode expandCurrentOrg(List currOrgTree, DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        DefaultKingdeeTreeNode sub = null;
        DefaultKingdeeTreeNode res = null;
        if (node != null && (oui = (OrgStructureInfo)node.getUserObject()) != null) {
            String id = oui.getUnit().getId().toString();
            if (id.equals(currOrgTree.get(0))) {
                res = node;
            } else if (currOrgTree.contains(id)) {
                this.kdTree.expandPath(new TreePath(node.getPath()));
                for (int i = 0; i < node.getChildCount() && (res = this.expandCurrentOrg(currOrgTree, sub = (DefaultKingdeeTreeNode)node.getChildAt(i))) == null; ++i) {
                }
            }
        }
        return res;
    }

    protected void getCurrentOrgTree(List list, CostCenterOrgUnitInfo currentOrg, OrgUnitInfo endOrg, ICostCenterOrgUnit iou, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (list == null || currentOrg == null || endOrg == null || iou == null) {
            return;
        }
        if (currentOrg.getId().equals((Object)endOrg.getId())) {
            list.add(endOrg.getId().toString());
        } else {
            list.add(currentOrg.getId().toString());
            if (currentOrg.getParent() != null && !currentOrg.getParent().getId().toString().equals(currentOrg.getId().toString())) {
                currentOrg = iou.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrg.getParent().getId()), selector);
                this.getCurrentOrgTree(list, currentOrg, endOrg, iou, selector);
            }
        }
    }

    protected OrgUnitInfo getSelectedNodeInfo() {
        OrgStructureInfo oui;
        FullOrgUnitInfo selOrgUnitInfo = null;
        DefaultKingdeeTreeNode node = this.getSelectedTreeNode();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && node.getUserObject() instanceof OrgStructureInfo && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            selOrgUnitInfo = oui.getUnit();
        }
        return selOrgUnitInfo;
    }

    protected DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.kdTree.getLastSelectedPathComponent();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgControlSchemeFactory.getRemoteInstance();
    }

    protected IBgControlSchemeFacade getFacadeInterface() throws Exception {
        return BgControlSchemeFacadeFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!e.getActionCommand().toString().contains("ActionClone")) {
            BgControlSchemeFactory.getRemoteInstance().verifyCanModifyScheme(BOSUuid.read((String)this.getSelectedKeyValue()));
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public RequestContext prepareActionClone(IItemAction itemAction) throws Exception {
        return super.prepareActionClone(itemAction);
    }

    @Override
    public void actionClone_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.handlePermissionForItemAction((ItemAction)this.actionEdit);
        this.actionEdit_actionPerformed(e);
    }

    public int getAfterCloneNewRowIndex(String id) {
        int rowIndex = -1;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (!this.tblMain.getRow(i).getCell("id").getValue().toString().equals(id)) continue;
            rowIndex = i;
        }
        return rowIndex;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        filter.getFilterItems().add(new FilterItemInfo(this.getFilterFieldName(), (Object)this.getSelectedOrgUnitInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSysDefault", (Object)Boolean.FALSE, CompareType.EQUALS));
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        logger.info((Object)BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date()));
        FilterInfo filter = viewInfo.getFilter();
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            int in = filter.getFilterItems().size();
            for (int i = 0; i < in; ++i) {
                if (!filter.getFilterItems().get(i).getPropertyName().equals(this.getFilterFieldName())) continue;
                filter.getFilterItems().get(i).setCompareValue((Object)this.getSelectedOrgUnitInfo().getId().toString());
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo(this.getFilterFieldName(), (Object)this.getSelectedOrgUnitInfo().getId().toString(), CompareType.EQUALS));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected String getFilterFieldName() {
        return "orgUnit.id";
    }

    protected String getEditUIName() {
        return BgControlSchemeEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        Object obj;
        super.tblMain_tableSelectChanged(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (obj = this.tblMain.getRow(rowIndex).getCell("isValid").getValue()) instanceof Boolean) {
            this.checkSchemeState((Boolean)obj);
        }
    }

    protected void checkSchemeState(boolean isValid) {
        if (isValid) {
            BgCommCHelper.disableAction((JButton)this.btnStart, null, (ItemAction)this.actionStart);
            BgCommCHelper.enableAction((JButton)this.btnDisable, null, (ItemAction)this.actionDisable);
            BgCommCHelper.disableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
            BgCommCHelper.disableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
        } else {
            BgCommCHelper.enableAction((JButton)this.btnStart, null, (ItemAction)this.actionStart);
            BgCommCHelper.disableAction((JButton)this.btnDisable, null, (ItemAction)this.actionDisable);
            BgCommCHelper.enableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
            BgCommCHelper.enableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"selectNode", (Object)this.getSelectedTreeNode());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getSelectedOrgUnitInfo());
        uiContext.put((Object)"action", (Object)e.getActionCommand());
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        super.actionStart_actionPerformed(e);
        this.checkSelected();
        this.checkSelectedIdValues(this.getSelectedIdValues());
        List list = this.getFacadeInterface().batchStartup(this.getSelectedIdValues());
        this.dealMsg(list);
        this.refreshList();
    }

    private void checkSelectedIdValues(ArrayList ids) throws BOSException {
        StringBuffer errorDetail = new StringBuffer();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setBaseOnSelector(true);
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("orgUnit.id");
        view.getSelector().add("bizUnit");
        view.getSelector().add("beginDate");
        view.getSelector().add("endDate");
        view.getSelector().add("bizUnitAlias");
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        BgControlSchemeCollection coll = BgControlSchemeFactory.getRemoteInstance().getBgControlSchemeCollection(view);
        for (int i = 0; i < coll.size() - 1; ++i) {
            BgControlSchemeInfo compareInfo = coll.get(i);
            for (int j = i + 1; j < coll.size(); ++j) {
                BgControlSchemeInfo info = coll.get(j);
                if (!compareInfo.getOrgUnit().getId().toString().equals(info.getOrgUnit().getId().toString()) || !compareInfo.getBizUnit().equals(info.getBizUnit())) continue;
                Timestamp compareBeginDate = compareInfo.getBeginDate();
                Timestamp compareEndDate = compareInfo.getEndDate();
                Timestamp beginDate = info.getBeginDate();
                Timestamp endDate = info.getEndDate();
                if (compareEndDate.compareTo(beginDate) == -1 || compareBeginDate.compareTo(endDate) == 1) continue;
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"selectDateError", (Object[])new Object[]{compareInfo.getBizUnitAlias(), compareInfo.getNumber(), info.getNumber()})).append("\n");
            }
        }
        if (errorDetail.toString().length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"selectedError"), (String)errorDetail.toString(), (int)0);
            SysUtil.abort();
        }
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisable_actionPerformed(e);
        this.checkSelected();
        List list = this.getFacadeInterface().batchDisable(this.getSelectedIdValues());
        this.dealMsg(list);
        this.refreshList();
    }

    private void dealMsg(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        for (int index = 0; index < list.size(); ++index) {
            msg.append(list.get(index)).append("\n");
        }
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"distributeFinash"), (String)msg.toString(), (int)1);
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String res = "com.kingdee.eas.ma.control.client.BgControlSchemeResource";
        DefaultKingdeeTreeNode node = this.getSelectedTreeNode();
        Enumeration en = node.children();
        if (en == null || !en.hasMoreElements()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"notChildOrg"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getSelectedOrgUnitInfo());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.control.client.BgCtrlSchemeDisUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        final BgCtrlSchemeDisUI ui = (BgCtrlSchemeDisUI)uiWindow.getUIObject();
        if (ui.isCancel()) {
            return;
        }
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        }
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            this.progressDialog.run(false, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) {
                    Object obj = null;
                    try {
                        monitor.beginTask(BgControlSchemeListUI.this.getUITitle(), -1);
                        monitor.subTaskBegin(BgControlSchemeListUI.this.getUITitle());
                        BgControlSchemeDistParameter param = new BgControlSchemeDistParameter();
                        param.setModifyState(ui.isModifyState());
                        param.setUpate(ui.isModifyScheme());
                        param.setDistOrgUnits(ui.getOrgList());
                        param.setBgControlSchemeList(BgControlSchemeListUI.this.getSelectedIdValues());
                        Map keyNumber = BgControlSchemeListUI.this.getSelectedIdNumber();
                        HashSet numbers = new HashSet();
                        Iterator it = keyNumber.keySet().iterator();
                        while (it.hasNext()) {
                            numbers.add(keyNumber.get(it.next()));
                        }
                        param.setNumbers(numbers);
                        boolean isNumberDup = BgControlSchemeFacadeFactory.getRemoteInstance().checkDistirbuteNumber(param);
                        if (isNumberDup) {
                            int rs = MsgBox.showConfirm2New((Component)((Object)BgControlSchemeListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSettingResource", (String)"distributeNumberDup"));
                            if (rs == 1 || rs == 2) {
                                param.setCoverage(false);
                            } else {
                                param.setCoverage(true);
                            }
                        }
                        HashMap<String, BgControlSchemeDistParameter> p = new HashMap<String, BgControlSchemeDistParameter>();
                        p.put("parameter", param);
                        Map rs = BgControlSchemeFactory.getRemoteInstance().distribute(p);
                        ArrayList ids = BgControlSchemeListUI.this.getSelectedIdValues();
                        StringBuffer msg = new StringBuffer();
                        if (rs != null && !rs.isEmpty()) {
                            Object[] mp = new String[2];
                            for (String key : rs.keySet()) {
                                List list;
                                if (!(rs.get(key) instanceof List) || (list = (List)rs.get(key)) == null || list.size() <= 0) continue;
                                for (int i = 0; i < list.size(); ++i) {
                                    if (!(list.get(i) instanceof Map)) continue;
                                    Map map = (Map)list.get(i);
                                    String number = (String)map.get("number");
                                    String orgName = (String)map.get("orgName");
                                    String reason = (String)map.get("reason");
                                    mp[0] = number;
                                    mp[1] = orgName;
                                    if ("dateError".equals(reason)) {
                                        reason = EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"dateError", (Object[])mp);
                                    } else if ("numberDup".equals(reason)) {
                                        reason = EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"numberError", (Object[])mp);
                                    }
                                    msg.append(reason).append("\n");
                                }
                            }
                            if (msg.length() == 0) {
                                MsgBox.showInfo((Component)((Object)BgControlSchemeListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"distributeSuccess"));
                            } else {
                                MsgBox.showDetailAndOK((Component)((Object)BgControlSchemeListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"distributeFinash"), (String)msg.toString(), (int)1);
                            }
                        }
                    }
                    catch (Exception e) {
                        BgControlSchemeListUI.this.handUIException(e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionAntiDistribute_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getSelectedOrgUnitInfo());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.control.client.BgCtrlSchemeAntiDisUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        final BgCtrlSchemeAntiDisUI ui = (BgCtrlSchemeAntiDisUI)uiWindow.getUIObject();
        if (ui.isCancel()) {
            return;
        }
        this.progressDialog = ProgressDialog.createProgressDialog((Component)((Object)this), (boolean)true);
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            this.progressDialog.run(false, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) {
                    Object obj = null;
                    try {
                        monitor.beginTask(BgControlSchemeListUI.this.getUITitle(), -1);
                        monitor.subTaskBegin(BgControlSchemeListUI.this.getUITitle());
                        BgControlSchemeDistParameter param = new BgControlSchemeDistParameter();
                        param.setDistOrgUnits(ui.getOrgList());
                        param.setBgControlSchemeList(BgControlSchemeListUI.this.getSelectedIdValues());
                        Map keyNumber = BgControlSchemeListUI.this.getSelectedIdNumber();
                        HashSet numbers = new HashSet();
                        Iterator it = keyNumber.keySet().iterator();
                        while (it.hasNext()) {
                            numbers.add(keyNumber.get(it.next()));
                        }
                        param.setNumbers(numbers);
                        HashMap<String, BgControlSchemeDistParameter> p = new HashMap<String, BgControlSchemeDistParameter>();
                        String message = null;
                        p.put("parameter", param);
                        message = BgControlSchemeFactory.getRemoteInstance().antiDistribute(p);
                        if (message != null) {
                            if (message.length() > 0) {
                                MsgBox.showDetailAndOK((Component)((Object)BgControlSchemeListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"antiDistributeend"), (String)message, (int)2);
                            } else {
                                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"antiDistributeSuccess"));
                            }
                        }
                    }
                    catch (Exception e) {
                        BgControlSchemeListUI.this.handUIException(e);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        Iterator it;
        if (this.getSelectedOrgUnitInfo() != null) {
            BgPermissionUtil.checkPermission((OrgUnitInfo)this.getSelectedOrgUnitInfo(), (String)this.getPermissionItem());
        }
        super.actionImport_actionPerformed(e);
        BgControlSchemeImportDialog dialog = this.createImportDialog();
        dialog.show();
        if (dialog.isCanceled()) {
            return;
        }
        Object obj = dialog.getData();
        BgControlSchemeCollection col = (BgControlSchemeCollection)((Object)obj);
        boolean hasElement = false;
        BgElementCollection bgElementCol = BgElementFactory.getRemoteInstance().getBgElementCollection();
        if (bgElementCol != null && bgElementCol.size() > 0) {
            hasElement = true;
        }
        BgElementInfo bgElementInfo = null;
        if (hasElement) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"isFilterText", (Object)new Boolean(true));
            uiContext.put((Object)"isChooseOne", (Object)new Boolean(true));
            uiContext.put((Object)"isCtrlRule", (Object)new Boolean(true));
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgElementF7UI", (Map)uiContext);
            }
            catch (UIException uie) {
                ExceptionHandler.handle((Throwable)uie);
                return;
            }
            uiWindow.show();
            BgElementF7UI f7ui = (BgElementF7UI)uiWindow.getUIObject();
            if (f7ui.isCancel()) {
                return;
            }
            bgElementInfo = f7ui.getResultOne();
        }
        if (col == null || col.size() == 0) {
            return;
        }
        int size = col.size();
        String[] numbers = new String[size];
        HashMap<String, Object> importMap = new HashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            BgControlSchemeInfo info = col.get(i);
            numbers[i] = info.getNumber();
            importMap.put(info.getNumber(), info.getId());
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kdTree.getLastSelectedPathComponent();
        String orgId = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            try {
                OrgStructureInfo _oui = (OrgStructureInfo)node.getUserObject();
                orgId = _oui.getUnit().getId().toString();
            }
            catch (Exception _oui) {
                // empty catch block
            }
        }
        if (orgId == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"getCostIdLost"));
            return;
        }
        Map repeatMap = this.getFacade().checkNumberRepeat(orgId, numbers);
        int j = 0;
        if (repeatMap != null && !repeatMap.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer();
            it = repeatMap.keySet().iterator();
            while (it.hasNext()) {
                errorMsg.append(it.next() + ", ");
            }
            errorMsg.delete(errorMsg.length() - 1, errorMsg.length());
            j = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"number") + errorMsg + EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"numberIsRepeatContinueOrNot")));
        }
        if (j != 0) {
            String repeatNumber = null;
            it = repeatMap.keySet().iterator();
            while (it.hasNext()) {
                repeatNumber = (String)it.next();
                importMap.remove(repeatNumber);
                it.remove();
            }
        }
        if (importMap == null || importMap.isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlSchemeResource", (String)"noImportData"));
            return;
        }
        if (bgElementInfo == null || bgElementInfo.getNumber() == null) {
            importMap.put("elementNumber", null);
        } else {
            importMap.put("elementNumber", bgElementInfo.getNumber());
        }
        final String orgUnitId = orgId;
        final HashMap<String, Object> impMap = importMap;
        final Map rptMap = repeatMap;
        LongTimeDialog processDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            processDialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            processDialog = new LongTimeDialog((Dialog)win);
        }
        if (processDialog == null) {
            return;
        }
        processDialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                return BgControlSchemeListUI.this.getFacade().importData(orgUnitId, impMap, rptMap, BgControlSchemeListUI.this.getDeFaultBgSchemeTypeId());
            }

            public void afterExec(Object result) throws Exception {
                BgControlSchemeListUI.this.showImportReport(result);
            }
        });
        processDialog.show();
        this.refreshList();
    }

    @Override
    public void actionControlRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionControlRecord_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getControlRecordUIClassName(), (Map)uiContext, null, OprtState.EDIT, 2);
        window.getUIObject().getUIMenuBar().setVisible(false);
        window.getUIObject().getStatusBar().setVisible(false);
        window.show();
    }

    protected String getControlRecordUIClassName() {
        return BgControlRecordUI.class.getName();
    }

    protected String getPermissionItem() {
        return "mbg_control_scheme02_addnew";
    }

    protected String getDeFaultBgSchemeTypeId() {
        return "lVIAAAAuzHqQxGui";
    }

    protected BgControlSchemeImportDialog createImportDialog() {
        return new BgControlSchemeImportDialog((IUIObject)this);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.actionOnLoad != action && this.getSelectedOrgUnitInfo() != null) {
            PermissionHelper.cleanCache();
            return new ObjectUuidPK(this.getSelectedOrgUnitInfo().getId());
        }
        return super.getOrgPK(action);
    }

    protected IBgControlSchemeFacade getFacade() throws BOSException {
        return BgControlSchemeFacadeFactory.getRemoteInstance();
    }

    private void showImportReport(Object report) throws UIException {
        String messageInfo = (String)report;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"result", (Object)messageInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgControlSchemeImportReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (SysContext.getSysContext().getCurrentCostUnit() != null) {
                request.put("ORGUNIT_ID", (Object)SysContext.getSysContext().getCurrentCostUnit().getId().toString());
            }
        }
        return handler;
    }
}

