/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.BgControlBlockSetFieldTypeEnum;
import com.kingdee.eas.ma.control.client.AbstractBgControlSetBlockSettingUI;
import com.kingdee.eas.ma.control.client.BgControlBlockProcessUI;
import com.kingdee.eas.ma.control.client.BgControlBlockSpecialProcessUI;
import com.kingdee.eas.ma.control.client.BgControlBlockViewProcessUI;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class BgControlSetBlockSettingUI
extends AbstractBgControlSetBlockSettingUI {
    private static final long serialVersionUID = -3765774414957555682L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlSetBlockSettingUI.class);
    protected OrgUnitInfo orgUnitInfo = null;
    private boolean isClickQuery = false;
    private List formulaList = null;
    private String curSchemeId = null;
    private RptSrcTypeEnum sourceType = null;

    public String getCurSchemeId() {
        return this.curSchemeId;
    }

    public void setCurSchemeId(String curSchemeId) {
        this.curSchemeId = curSchemeId;
    }

    public List getFormulaList() {
        return this.formulaList;
    }

    public void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.isClickQuery = true;
        this.putDataToKDTable();
    }

    protected void putDataToKDTable() throws Exception {
        BgFormInfo info2 = null;
        try {
            BgFormCollection coll = BgFormFactory.getRemoteInstance().getBgFormCollection(this.getQueryView());
            if (coll == null) {
                return;
            }
            this.tblMain.removeRows();
            for (BgFormInfo info2 : coll) {
                IRow iRow = this.tblMain.addRow();
                iRow.setUserObject((Object)info2);
                iRow.getCell("id").setValue(info2.get("id"));
                iRow.getCell("number").setValue(info2.get("number"));
                iRow.getCell("name").setValue(info2.get("name"));
                iRow.getCell("bgScheme.number").setValue((Object)info2.getBgScheme().getNumber());
                iRow.getCell("bgScheme.name").setValue((Object)info2.getBgScheme().getName());
                iRow.getCell("bgTemplate.name").setValue((Object)info2.getBgTemplate().getName());
                iRow.getCell("bgSpecialItems.memberDisplayName").setValue(info2.getBgSpecialItems() != null && !info2.getBgSpecialItems().isEmpty() ? info2.getBgSpecialItems().get(0).getMemberDisplayName() : null);
                iRow.getCell("bgPeriod.name").setValue((Object)info2.getBgPeriod().getName());
                iRow.getCell("processType").setValue((Object)info2.getProcessType());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            this.handUIException(e);
        }
    }

    protected EntityViewInfo getQueryView() throws Exception {
        Object obj;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null, CompareType.EQUALS));
        maskString.append("(#" + index++ + " OR #" + index++ + ")");
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", this.getOrgUnitIds(), CompareType.INCLUDE));
        maskString.append(" AND #" + index++);
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        filter.getFilterItems().add(new FilterItemInfo("state", state, CompareType.NOTINCLUDE));
        maskString.append(" AND #" + index++);
        filter.getFilterItems().add(new FilterItemInfo("processType", (Object)1, CompareType.EQUALS));
        maskString.append(" AND #" + index++);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        maskString.append(" AND #" + index++);
        BgControlBlockSetFieldTypeEnum queryType = (BgControlBlockSetFieldTypeEnum)((Object)this.prmtQueryType.getSelectedItem());
        String str = this.txtQueryField.getText();
        String queryStr = "%" + str + "%";
        if (!StringUtils.isEmpty((String)str)) {
            if (BgControlBlockSetFieldTypeEnum.bgFormNumberAndName.equals((Object)queryType)) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)queryStr, CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)queryStr, CompareType.LIKE));
                maskString.append(" AND (#" + index++ + " OR #" + index++ + ")");
            } else if (BgControlBlockSetFieldTypeEnum.bgTemplateNumberAndName.equals((Object)queryType)) {
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.number", (Object)queryStr, CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.name", (Object)queryStr, CompareType.LIKE));
                maskString.append(" AND (#" + index++ + " OR #" + index++ + ")");
            }
        }
        if ((obj = this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO)) instanceof BgSchemeInfo) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)obj;
            BgNFCHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
            maskString.append(" AND #" + index++);
        }
        filter.setMaskString(maskString.toString());
        this.afterSetFilter(filter);
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = this.getSelectors();
        viewInfo.setSelector(sic);
        SorterItemInfo sore = new SorterItemInfo("number");
        sore.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sore);
        MbgPermissionHelper.addFieldDataPermission((RptSrcTypeEnum)this.getSourceType(), (String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (FilterInfo)viewInfo.getFilter(), (MbgPermissionTypeEnum)MbgPermissionTypeEnum.TEMPLATE, (String)"bgTemplate.id", obj != null ? ((BgSchemeInfo)obj).getId().toString() : null, (boolean)true);
        this.addBgOrgUnitPremission(viewInfo.getFilter());
        return viewInfo;
    }

    protected void addBgOrgUnitPremission(FilterInfo filter) throws EASBizException, BOSException {
        Set bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(this.getSourceType(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString());
        if (!bgOrgUnitPer.isEmpty()) {
            HashSet<String> newOrgPerSet = new HashSet<String>();
            for (String orgunitid : this.getOrgUnitIds()) {
                if (!bgOrgUnitPer.contains(orgunitid)) continue;
                newOrgPerSet.add(orgunitid);
            }
            String mask = filter.getMaskString();
            int size = filter.getFilterItems().size();
            if (newOrgPerSet.isEmpty()) {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", newOrgPerSet, CompareType.INCLUDE));
            }
            mask = mask + " and #" + size;
            filter.setMaskString(mask);
        }
    }

    protected RptSrcTypeEnum getSourceType() {
        if (this.sourceType == null) {
            this.sourceType = BgNFCHelper.getSourceTypeFromBgScheme((Map)this.getUIContext());
        }
        if (this.sourceType == null) {
            this.sourceType = BgNFCHelper.getSourceType((IUIObject)((IUIObject)this.getUIContext().get("Owner")));
        }
        return this.sourceType;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnit.id");
        sic.add("bgTemplate.formType");
        return sic;
    }

    protected Set<String> getOrgUnitIds() {
        HashSet<String> orgUnitIds = new HashSet<String>();
        orgUnitIds.add(this.orgUnitInfo.getId().toString());
        return orgUnitIds;
    }

    protected void afterSetFilter(FilterInfo filter) {
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(index);
        BgFormInfo bgForm = (BgFormInfo)iRow.getUserObject();
        this.setCurSchemeId(bgForm.getBgScheme().getId().toString());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)bgForm.getOrgUnit());
        uiContext.put((Object)"ID", (Object)bgForm.getId());
        uiContext.put((Object)"type", (Object)bgForm.getBgTemplate().getFormType());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(bgForm), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        List resultList = new ArrayList();
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            BgControlBlockViewProcessUI f7UI = (BgControlBlockViewProcessUI)uiWindow.getUIObject();
            resultList = f7UI.getFormulaList();
        } else if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            BgControlBlockSpecialProcessUI f7UI = (BgControlBlockSpecialProcessUI)uiWindow.getUIObject();
            resultList = f7UI.getFormulaList();
        } else {
            BgControlBlockProcessUI f7UI = (BgControlBlockProcessUI)uiWindow.getUIObject();
            resultList = f7UI.getFormulaList();
        }
        this.setFormulaList(resultList);
        if (resultList != null) {
            this.getUIWindow().close();
        }
    }

    protected String getEditUIName(BgFormInfo bgForm) {
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return BgControlBlockViewProcessUI.class.getName();
        }
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return BgControlBlockSpecialProcessUI.class.getName();
        }
        return BgControlBlockProcessUI.class.getName();
    }

    private void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    @Override
    protected void prmptBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.isClickQuery = false;
        this.putDataToKDTable();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnQuery.setEnabled(true);
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_ID) != null) {
            this.orgUnitInfo = new OrgUnitInfo();
            this.orgUnitInfo.setId(BOSUuid.read((String)((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID))));
        } else {
            this.orgUnitInfo = SysContext.getSysContext().getCurrentCostUnit();
        }
        this.initBgSchemeSelect();
        this.initBgControlSetQueryType();
        this.colSetLocked();
        BgCommHelper.removePasteHelper((KDTable)this.tblMain);
        this.putDataToKDTable();
        this.txtQueryField.setFocusTraversalKeysEnabled(false);
        this.txtQueryField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        BgControlSetBlockSettingUI.this.actionQuery_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        BgControlSetBlockSettingUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() >= 2) {
            this.actionConfirm_actionPerformed(null);
        }
        super.tblMain_tableClicked(e);
    }

    private void colSetLocked() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bgScheme.number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bgScheme.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bgPeriod.name").getStyleAttributes().setLocked(true);
    }

    protected void initBgSchemeSelect() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        this.prmtBgScheme.setEntityViewInfo(this.getEntityViewInfo(view));
        this.prmtBgScheme.setEditable(false);
        Object obj = this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        this.prmtBgScheme.setData(obj);
    }

    protected EntityViewInfo getEntityViewInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        try {
            if (this.orgUnitInfo != null) {
                Set<String> tmpList = this.getBgSchemeIds(this.orgUnitInfo.getId());
                if (tmpList != null && !tmpList.isEmpty()) {
                    filter.getFilterItems().add(new FilterItemInfo("id", tmpList, CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"#", CompareType.EQUALS));
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"#", CompareType.EQUALS));
            }
        }
        catch (Exception ex) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"#", CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    protected Set<String> getBgSchemeIds(BOSUuid orgUnitId) throws Exception {
        return BgSchemeFactory.getRemoteInstance().getCollection4SchemeList(orgUnitId.toString(), true);
    }

    protected void initBgControlSetQueryType() throws Exception {
        DefaultComboBoxModel<BgControlBlockSetFieldTypeEnum> mol = new DefaultComboBoxModel<BgControlBlockSetFieldTypeEnum>();
        BgControlBlockSetFieldTypeEnum e = null;
        Iterator it = BgControlBlockSetFieldTypeEnum.iterator();
        while (it.hasNext()) {
            e = (BgControlBlockSetFieldTypeEnum)((Object)it.next());
            mol.addElement(e);
        }
        this.prmtQueryType.setModel(mol);
        this.prmtQueryType.setSelectedItem((Object)BgControlBlockSetFieldTypeEnum.bgFormNumberAndName);
    }
}

