/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.client.AbstractBgCtrlExpendRuleConditionUI;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgCtrlExpendRuleConditionUI
extends AbstractBgCtrlExpendRuleConditionUI {
    private static final long serialVersionUID = -6579439143776091240L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlExpendRuleConditionUI.class);
    protected static final String RES = "com.kingdee.eas.ma.control.client.BgControlSchemeResource";
    protected String oldValue;
    protected String newValue;
    protected FilterInfo filterInfo;
    protected String filterInfoDesc = null;
    private boolean isCancel = true;

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public String getFilterInfoDesc() {
        return this.filterInfoDesc;
    }

    public void setFilterInfoDesc(String filterInfoDesc) {
        this.filterInfoDesc = filterInfoDesc;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.formateTable();
        BgCommHelper.removeEditHelper((KDTable)this.mainTable);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        for (int i = this.mainTable.getRowCount() - 1; i >= 0; --i) {
            if (!this.isBlankRow(i)) continue;
            this.mainTable.removeRow(i);
        }
        this.verifyData();
        this.setCurrentFilterInfo();
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void verifyData() throws Exception {
        int rowCount = this.mainTable.getRowCount();
        IRow row = null;
        int loginsignCount = 0;
        int leftsignCount = 0;
        int rightsignCount = 0;
        int nullCount = 0;
        HashMap compareMsg = new HashMap();
        String leftTmp = null;
        String rightTmp = null;
        int emptyRowCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            row = this.mainTable.getRow(i);
            if (row.getCell("condition").getValue() == null && row.getCell("compareSign").getValue() == null && row.getCell("compareValue").getValue() == null) {
                ++emptyRowCount;
                continue;
            }
            if (row.getCell("loginSign").getValue() != null && row.getCell("loginSign").getValue() instanceof LogicSignEnum && row.getCell("loginSign").getValue() != null || row.getCell("loginSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("loginSign").getValue().toString())) {
                ++loginsignCount;
            }
            if (row.getCell("leftBracketSign").getValue() != null && row.getCell("leftBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("leftBracketSign").getValue().toString()) || row.getCell("leftBracketSign").getValue() instanceof LeftBracketSignEnum && !StringUtils.isEmpty((String)((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue())) {
                leftTmp = ((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue();
                leftsignCount += this.countToWord(leftTmp, "(");
            }
            if (row.getCell("rightBracketSign").getValue() != null && row.getCell("rightBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("rightBracketSign").getValue().toString()) || row.getCell("rightBracketSign").getValue() instanceof RightBracketSignEnum && !StringUtils.isEmpty((String)((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue())) {
                rightTmp = ((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue();
                rightsignCount += this.countToWord(rightTmp, ")");
            }
            if (row.getCell("condition").getValue() == null) {
                ++nullCount;
            }
            if (row.getCell("compareSign").getValue() == null) {
                ++nullCount;
            }
            if (row.getCell("compareValue").getValue() == null && !CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) && !CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) {
                ++nullCount;
            }
            if (!(row.getCell("compareValue").getValue() instanceof String) || StringUtils.isEmpty((String)((String)row.getCell("compareValue").getValue()))) continue;
            try {
                new BigDecimal((String)row.getCell("compareValue").getValue()).setScale(2, 4);
                continue;
            }
            catch (NumberFormatException e) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)RES, (String)"compareValueIsNotNumber", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
        }
        if (rowCount > 0) {
            if (rowCount - emptyRowCount - 1 < loginsignCount) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"logicSignException1"));
                SysUtil.abort();
            }
            if (rightsignCount != leftsignCount) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"bracketNotFit"));
                SysUtil.abort();
            }
            if (nullCount != 0 && !CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) && !CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"filterQuestion"));
                SysUtil.abort();
            }
        }
    }

    protected void verifyFilterInfo(FilterInfo filterInfo) {
        FilterItemCollection filters = filterInfo.getFilterItems();
        FilterItemInfo filter = null;
        CompareType compareType = null;
        String compareValue = null;
        StringBuffer msg = new StringBuffer();
        HashMap<Integer, String> lessMap = new HashMap<Integer, String>();
        HashMap<Integer, String> equalMap = new HashMap<Integer, String>();
        HashMap<Integer, String> greaterMap = new HashMap<Integer, String>();
        if (filters != null && !filters.isEmpty()) {
            for (int i = 0; i < filters.size(); ++i) {
                filter = filters.get(i);
                compareType = filter.getCompareType();
                compareValue = (String)filter.getCompareValue();
                if (compareType.equals((Object)CompareType.LESS)) {
                    lessMap.put(i, compareValue);
                    continue;
                }
                if (compareType.equals((Object)CompareType.LESS_EQUALS)) {
                    lessMap.put(i, compareValue);
                    equalMap.put(i, compareValue);
                    continue;
                }
                if (compareType.equals((Object)CompareType.GREATER)) {
                    greaterMap.put(i, compareValue);
                    continue;
                }
                if (compareType.equals((Object)CompareType.GREATER_EQUALS)) {
                    greaterMap.put(i, compareValue);
                    equalMap.put(i, compareValue);
                    continue;
                }
                if (!compareType.equals((Object)CompareType.EQUALS)) continue;
                equalMap.put(i, compareValue);
            }
            msg = this.checkLessGreater(lessMap, greaterMap);
            if (msg.length() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
                SysUtil.abort();
            } else {
                msg = this.checkEquals(lessMap, greaterMap, equalMap);
                if (msg.length() > 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
                    SysUtil.abort();
                }
            }
        }
    }

    protected StringBuffer checkLessGreater(Map<Integer, String> lessMap, Map<Integer, String> greaterMap) {
        ArrayList<Integer> lst;
        StringBuffer msg = new StringBuffer();
        if (lessMap.size() > 1) {
            lst = new ArrayList<Integer>(lessMap.keySet());
            Collections.sort(lst);
            msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf((Integer)lst.get(0) + 1), String.valueOf((Integer)lst.get(1) + 1)}));
        }
        if (msg.length() == 0 && greaterMap.size() > 1) {
            lst = new ArrayList<Integer>(greaterMap.keySet());
            Collections.sort(lst);
            msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf((Integer)lst.get(0) + 1), String.valueOf((Integer)lst.get(1) + 1)}));
        }
        if (msg.length() == 0 && !lessMap.isEmpty()) {
            for (Integer l : lessMap.keySet()) {
                String lv = lessMap.get(l);
                if (!greaterMap.isEmpty()) {
                    for (Integer g : greaterMap.keySet()) {
                        String gv = greaterMap.get(g);
                        if (new BigDecimal(lv).compareTo(new BigDecimal(gv)) > 0) continue;
                        if (l.compareTo(g) >= 0) {
                            msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf(g + 1), String.valueOf(l + 1)}));
                            break;
                        }
                        msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf(l + 1), String.valueOf(g + 1)}));
                        break;
                    }
                }
                if (msg.length() <= 0) continue;
                break;
            }
        }
        return msg;
    }

    protected StringBuffer checkEquals(Map<Integer, String> lessMap, Map<Integer, String> greaterMap, Map<Integer, String> equalMap) {
        StringBuffer msg = new StringBuffer();
        if (equalMap.size() > 1) {
            Object[] arr = new String[2];
            int countArr = 0;
            for (Integer e : equalMap.keySet()) {
                String ev = equalMap.get(e);
                if (lessMap.values().contains(ev)) continue;
                if (StringUtils.isEmpty((String)arr[0])) {
                    arr[0] = String.valueOf(e + 1);
                    ++countArr;
                    continue;
                }
                if (!StringUtils.isEmpty((String)arr[1])) break;
                arr[1] = String.valueOf(e + 1);
                ++countArr;
            }
            if (countArr == 2) {
                msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])arr));
            }
        }
        if (!equalMap.isEmpty()) {
            for (Integer e : equalMap.keySet()) {
                String ev = equalMap.get(e);
                if (!lessMap.isEmpty()) {
                    block2: for (Integer l : lessMap.keySet()) {
                        String lv = lessMap.get(l);
                        if (e.equals(l)) continue;
                        if (new BigDecimal(lv).compareTo(new BigDecimal(ev)) > 0) {
                            if (greaterMap.isEmpty()) continue;
                            Iterator<Integer> itg = greaterMap.keySet().iterator();
                            while (itg.hasNext()) {
                                String gv = greaterMap.get(itg.next());
                                if (new BigDecimal(gv).compareTo(new BigDecimal(ev)) <= 0) continue;
                                msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf(l + 1), String.valueOf(e + 1)}));
                                continue block2;
                            }
                            continue;
                        }
                        msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf(l + 1), String.valueOf(e + 1)}));
                        break;
                    }
                } else if (!greaterMap.isEmpty()) {
                    for (Integer g : greaterMap.keySet()) {
                        String gv = greaterMap.get(g);
                        if (e.equals(g) || new BigDecimal(gv).compareTo(new BigDecimal(ev)) < 0) continue;
                        msg.append(BgCommCHelper.getMessageStr((String)RES, (String)"bgCtrlRangeError1", (Object[])new String[]{String.valueOf(g + 1), String.valueOf(e + 1)}));
                        break;
                    }
                }
                if (msg.length() <= 0) continue;
                break;
            }
        }
        return msg;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.mainTable.addRow().getCell("condition").setValue((Object)EASResource.getString((String)RES, (String)"bgCtrlAccountRange"));
    }

    protected void formateTable() throws BOSException, EASBizException, ParserException {
        this.mainTable.checkParsed();
        this.formateColumn();
        Object data = this.getUIContext().get("data");
        if (data instanceof BizDataObject) {
            BizDataObject bizData = (BizDataObject)data;
            this.filterInfo = new FilterInfo(bizData.getValue());
            this.filterInfo.setMaskString(bizData.getMaskString());
            if (this.filterInfo != null && !this.filterInfo.getFilterItems().isEmpty()) {
                this.fillFilterTableBody();
            } else {
                this.mainTable.addRow().getCell("condition").setValue((Object)EASResource.getString((String)RES, (String)"bgCtrlAccountRange"));
            }
        } else {
            this.mainTable.addRow().getCell("condition").setValue((Object)EASResource.getString((String)RES, (String)"bgCtrlAccountRange"));
        }
    }

    @Override
    protected void formateCondition() throws BOSException, EASBizException {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(EASResource.getString((String)RES, (String)"bgCtrlAccountRange"));
        KDComboBox comboBox = new KDComboBox(model);
        this.mainTable.getColumn("condition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    @Override
    protected void formateCompareSing() {
        DefaultComboBoxModel<CompareSignEnum> model = new DefaultComboBoxModel<CompareSignEnum>();
        model.addElement(CompareSignEnum.EQUALSSIGN);
        model.addElement(CompareSignEnum.LARGESIGN);
        model.addElement(CompareSignEnum.LARGEEQUALSSIGN);
        model.addElement(CompareSignEnum.SMALLSIGN);
        model.addElement(CompareSignEnum.SMALLEQUALSSIGN);
        KDComboBox comboBox = new KDComboBox(model);
        this.mainTable.getColumn("compareSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    @Override
    protected void formateCompareValue() {
        this.mainTable.getColumn("compareValue").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)4));
        KDNumberTextField number = new KDNumberTextField();
        number.setDataType(6);
        number.setPrecision(4);
        number.setNegatived(false);
        number.setMinimumNumber((Number)0);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)number);
        this.mainTable.getColumn("compareValue").setEditor((ICellEditor)editor);
    }

    @Override
    protected void formateLoginSing() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        model.addElement((String)LogicSignEnum.AND);
        this.mainTable.getColumn("loginSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    protected void setCurrentFilterInfo() {
        this.mainTable.getEditManager().stopEditing();
        int rowCount = this.mainTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                CompareSignEnum compareSignEnum;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.mainTable.getRow(i);
                String leftBracket = BgEntityUtil.getValue((Object)iRow.getCell(0).getValue()).toString();
                String condition = "bgCtrlRange";
                String compare = BgEntityUtil.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
                Object compareValue = null;
                if (iRow.getCell(3).getEditor() != null && iRow.getCell(3).getEditor().getComponent() != null) {
                    Object f7Data;
                    KDBizPromptBox promptBox;
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (obj instanceof KDBizPromptBox) {
                        promptBox = (KDBizPromptBox)obj;
                        f7Data = promptBox.getData();
                        if (f7Data instanceof String) {
                            compareValue = (String)f7Data;
                        } else if (f7Data instanceof DataObject) {
                            compareValue = ((DataObject)f7Data).getValue();
                        } else if (f7Data instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)f7Data;
                            compareValue = BgEntityUtil.getValue((Object)objectValue.get(BgEntityUtil.getPropertyName((String)condition)));
                        } else if (f7Data instanceof Object[]) {
                            compareValue = promptBox.getEditFormatter().valueToString(f7Data);
                        } else if (f7Data instanceof Float) {
                            compareValue = f7Data;
                        } else if (f7Data instanceof Integer) {
                            compareValue = f7Data;
                        }
                    } else if (obj instanceof KDComboBox) {
                        promptBox = (KDComboBox)obj;
                        f7Data = promptBox.getSelectedItem();
                        if (f7Data != null && !"".equals(f7Data.toString())) {
                            BizEnumInfo _enum = BgEntityUtil.getEnum((String)f7Data.getClass().getName());
                            if (_enum.getDataType().equals((Object)BizEnumValueType.STRING)) {
                                compareValue = _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue().toString();
                            } else if (_enum.getDataType().equals((Object)BizEnumValueType.INTEGER) || _enum.getDataType().equals((Object)BizEnumValueType.FLOAT) || _enum.getDataType().equals((Object)BizEnumValueType.LONG) || _enum.getDataType().equals((Object)BizEnumValueType.DOUBLE)) {
                                compareValue = _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue();
                                compareValue = compareValue.toString().indexOf(".") >= 0 ? (Number)new Float(compareValue.toString()) : (Number)new Integer(compareValue.toString());
                            }
                        }
                    } else {
                        compareValue = BgEntityUtil.getValue((Object)iRow.getCell(3).getValue());
                    }
                } else {
                    compareValue = BgEntityUtil.getValue((Object)iRow.getCell(3).getValue());
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NULLSIGN) {
                    compareValue = null;
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NOTNULLSIGN) {
                    compareValue = null;
                }
                String rightBracket = BgEntityUtil.getValue((Object)iRow.getCell(4).getValue()).toString();
                String logic = BgEntityUtil.getValue((Object)iRow.getCell(5).getValue()).toString().toLowerCase();
                if (StringUtils.isEmpty((String)logic) && i != rowCount - 1) {
                    logic = "and";
                    iRow.getCell(5).setValue((Object)LogicSignEnum.AND);
                }
                if (BgEntityUtil.isIncludeCompare((CompareSignEnum)(compareSignEnum = CompareSignEnum.getEnum((String)compare.toUpperCase()))) && compareValue != null) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)BgEntityUtil.processIncludeValue((String)compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                } else if (condition != null && !"".equals(condition.trim())) {
                    if (compareValue != null && (CompareType.LIKE.toString().equalsIgnoreCase(compare) || CompareType.NOTLIKE.toString().equalsIgnoreCase(compare))) {
                        compareValue = "%" + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                    } else if (compareValue != null && "LEFT LIKE".equalsIgnoreCase(compare)) {
                        compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                        compare = CompareType.LIKE.toString();
                    } else if (compareValue != null && "RIGHT LIKE".equalsIgnoreCase(compare)) {
                        compareValue = "%" + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "");
                        compare = CompareType.LIKE.toString();
                    } else if (compareValue != null && "NOT LEFT LIKE".equalsIgnoreCase(compare)) {
                        compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                        compare = CompareType.NOTLIKE.toString();
                    } else if (compare.equalsIgnoreCase("IS")) {
                        compareValue = null;
                        compare = "=";
                    } else if (compare.equalsIgnoreCase("IS NOT")) {
                        compareValue = null;
                        compare = "<>";
                    }
                    FilterItemInfo filterItemInfo = compareValue instanceof String ? new FilterItemInfo(condition, (Object)this.setScale((String)compareValue), CompareType.getEnum((String)compare)) : new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                }
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.verifyFilterInfo(newFilterInfo);
        this.filterInfo = newFilterInfo;
        this.setCurrentFilterInfoDesc();
    }

    protected void setCurrentFilterInfoDesc() {
        int rowCount = this.mainTable.getRowCount();
        StringBuffer filterDesc = new StringBuffer();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.mainTable.getRow(i);
                String leftBracket = iRow.getCell(0).getValue() != null ? iRow.getCell(0).getValue().toString() : "";
                String condition = iRow.getCell(1).getValue() != null ? iRow.getCell(1).getValue().toString() + " " : "";
                String compare = iRow.getCell(2).getValue() != null ? iRow.getCell(2).getValue().toString() + " " : "";
                String compareValue = iRow.getCell(3).getValue() != null ? this.setScale(iRow.getCell(3).getValue().toString()) + " " : "";
                String rightBracket = iRow.getCell(4).getValue() != null ? iRow.getCell(4).getValue().toString() : "";
                String logic = iRow.getCell(5).getValue() != null ? iRow.getCell(5).getValue().toString() : "";
                filterDesc.append(leftBracket).append(condition).append(compare).append(compareValue).append(rightBracket).append(logic);
            }
        }
        this.filterInfoDesc = filterDesc.toString();
    }

    protected void fillFilterTableBody() throws BaseCommonQueryClientException {
        if (this.filterInfo != null && !this.filterInfo.getFilterItems().isEmpty()) {
            String express = this.filterInfo.getMaskString();
            if (express == null && this.filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < this.filterInfo.getFilterItems().size(); ++i) {
                    express = i == 0 ? "#" + i : express + " AND #" + i;
                }
            }
            int filterSize = this.filterInfo.getFilterItems().size();
            List<Map<String, String>> brachets = this.analysisEpress(express);
            if (filterSize > 0) {
                ArrayList rowInfos = BgEntityUtil.getRowInfos((FilterInfo)this.filterInfo);
                for (int i = 0; i < filterSize; ++i) {
                    RowObject rowObject = (RowObject)rowInfos.get(i);
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    this.mainTable.addRow(i);
                    rowObject.setLeftBracket(rowObject.getLeftBracket());
                    rowObject.setCondition(filterItemInfo.getPropertyName());
                    if (filterItemInfo.getCompareValue() != null) {
                        rowObject.setCompare(filterItemInfo.getCompareType().getName());
                        rowObject.setCompareValue(filterItemInfo.getCompareValue());
                    } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                        String compare = filterItemInfo.getCompareType().getName();
                        if (compare.equalsIgnoreCase("=")) {
                            compare = "IS";
                        }
                        if (compare.equalsIgnoreCase("<>")) {
                            compare = "IS NOT";
                        }
                        rowObject.setCompare(compare);
                        rowObject.setCompareValue(null);
                    }
                    rowObject.setRightBracket(brachets.get(i).get(")"));
                    rowObject.setLeftBracket(brachets.get(i).get("("));
                    rowObject.setLogic(rowObject.getLogic());
                    this.loadFilter(i, rowObject);
                }
            }
        }
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    protected void loadCompareValue(int rowIndex, RowObject rowObject) {
        this.mainTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        if (this.isNullSign(rowObject.getCompare())) {
            this.mainTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
    }

    @Override
    protected boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    @Override
    protected void loadLeftBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)0, (String)LeftBracketSignEnum.class.getName(), (String)rowObject.getLeftBracket());
    }

    protected void loadCondition(int rowIndex, RowObject rowObject) {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            this.mainTable.getRow(rowIndex).getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"bgCtrlAccountRange"));
        }
    }

    protected void loadCompareSign(int rowIndex, RowObject rowObject) {
        String compare = rowObject.getCompare();
        KDComboBox comboBox = BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)2, (String)CompareSignEnum.class.getName(), (String)compare);
        comboBox.removeItem((Object)"");
        comboBox.removeItem((Object)CompareSignEnum.NOTEQULASSIGN);
        comboBox.removeItem((Object)CompareSignEnum.NULLSIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTNULLSIGN);
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
        this.removeFieldCompare(comboBox);
        comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
        comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
    }

    @Override
    protected void loadLogicSign(int rowIndex, RowObject rowObject) {
        KDComboBox comboBox = BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)5, (String)LogicSignEnum.class.getName(), (String)rowObject.getLogic());
        comboBox.removeItem((Object)LogicSignEnum.OR);
    }

    protected String setScale(String compareValue) {
        BigDecimal value = null;
        if (!StringUtils.isEmpty((String)compareValue)) {
            try {
                value = new BigDecimal(compareValue);
                value = value.setScale(4, 4);
            }
            catch (Exception e) {
                return compareValue;
            }
        }
        if (value != null) {
            return value.toString();
        }
        return compareValue;
    }

    @Override
    protected void mainTable_editStopped(KDTEditEvent e) throws Exception {
        super.mainTable_editStopped(e);
        int rIndex = this.mainTable.getSelectManager().getActiveRowIndex();
        int cIndex = this.mainTable.getSelectManager().getActiveColumnIndex();
        if (cIndex == this.mainTable.getColumnIndex("compareValue") && this.mainTable.getCell(rIndex, "compareValue").getValue() instanceof String) {
            String param = (String)this.mainTable.getCell(rIndex, "compareValue").getValue();
            try {
                BigDecimal paramValue = new BigDecimal(param);
                paramValue = paramValue.setScale(4, 4);
                this.mainTable.getCell(rIndex, "compareValue").setValue((Object)paramValue);
            }
            catch (Exception e2) {
                this.mainTable.getCell(rIndex, "compareValue").setValue((Object)param);
            }
        }
    }
}

