/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IGeneralAsstActTypeGroup;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.control.BgBaseFacadeFactory;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlIsomerFactory;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlIsomerSetCollection;
import com.kingdee.eas.ma.control.BgRuleCondition;
import com.kingdee.eas.ma.control.IBgBaseFacade;
import com.kingdee.eas.ma.control.client.AbstractBgCtrlRuleConditionUI;
import com.kingdee.eas.ma.control.client.BgFilterInfoProducer;
import com.kingdee.eas.ma.control.client.utils.BgControlIsomerCHelper;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlIsomerKSQLUtils;
import com.kingdee.eas.ma.control.utils.BgControlIsomerUtils;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgCtrlRuleConditionUI
extends AbstractBgCtrlRuleConditionUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlRuleConditionUI.class);
    public static final String CU = "CU";
    public static final String COMPANY = "company";
    public static final String COMPANYID = "companyId";
    public static final String GLOBAL = "gloval";
    public static final String SPECIAL = "special";
    protected String[] filterProperties;
    protected String bizBill;
    protected String oldValue;
    protected String newValue;
    protected boolean isomer;
    protected static BgControlIsomerInfo isomerInfo = null;
    protected EntityObjectInfo entityObject;
    protected boolean isCancel = true;
    protected boolean extendCondition = true;
    protected FilterInfo filterInfo;
    protected String filterInfoDesc = null;
    private static BgControlIsomerKSQLUtils ksqlClient = null;
    private Map<String, Map<String, String>> tableMap = new HashMap<String, Map<String, String>>();
    private List<BgRuleCondition> bizBillObject = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void mainTable_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        switch (colIndex) {
            case 1: {
                Object ob = this.mainTable.getCell(rowIndex, colIndex).getValue();
                if (ob instanceof BgRuleCondition) {
                    BgRuleCondition rule = (BgRuleCondition)ob;
                    if (this.isomer) {
                        this.formateCompareCellEditorForIsomer(rowIndex, rule);
                    } else {
                        this.formateCompareCellEditor(rowIndex, rule);
                    }
                } else {
                    this.mainTable.getCell(rowIndex, 3).setEditor(null);
                }
                return;
            }
            case 2: {
                this.setNullSignLocked(rowIndex);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
        }
    }

    protected void setNullSignLocked(int rowIndex) {
        ICell iCell = this.mainTable.getRow(rowIndex).getCell(3);
        if (this.mainTable.getRow(rowIndex).getCell(2).getValue() != null) {
            String filter_compare_sign = this.mainTable.getRow(rowIndex).getCell(2).getValue().toString();
            if (filter_compare_sign.equals(CompareSignDateEnum.NULLSIGN.toString()) || filter_compare_sign.equals(CompareSignDateEnum.NOTNULLSIGN.toString())) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else {
                iCell.getStyleAttributes().setLocked(false);
            }
        }
    }

    protected void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        Object cellValue = this.mainTable.getRow(rowIndex).getCell(1).getValue();
        String conditonValue = null;
        if (!(cellValue instanceof BgRuleCondition)) {
            return;
        }
        conditonValue = ((BgRuleCondition)cellValue).getNumber();
        if (this.isomer) {
            String[] end = this.vaildProperty((BgRuleCondition)cellValue);
            String type = this.tableMap.get(end[0]).get(end[1]);
            if (type != null) {
                if (type.contains(DataType.DATE.getName()) || type.contains(DataType.TIME.getName()) || type.contains(DataType.TIMESTAMP.getName())) {
                    return;
                }
                if (type.contains(DataType.BOOLEAN.getName())) {
                    return;
                }
            } else {
                this.resetCell(this.mainTable.getCell(rowIndex, colIndex));
            }
        } else {
            String targetProperty;
            EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)conditonValue);
            DataObject dataType = BgEntityUtil.getRefMetaData((EntityObjectInfo)targetEntity, (String)(targetProperty = BgEntityUtil.getPropertyName((String)conditonValue)));
            if (dataType != null) {
                if (dataType.getName().equalsIgnoreCase(DataType.ENUM.getName())) {
                    return;
                }
                if (dataType.getName().equalsIgnoreCase(DataType.DATE.getName()) || dataType.getName().equalsIgnoreCase(DataType.TIME.getName()) || dataType.getName().equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
                    return;
                }
                if (dataType.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                    return;
                }
                if (dataType.getName().equalsIgnoreCase(DataType.SHORT.getName()) || dataType.getName().equalsIgnoreCase(DataType.INTEGER.getName()) || dataType.getName().equalsIgnoreCase(DataType.LONG.getName()) || dataType.getName().equalsIgnoreCase(DataType.FLOAT.getName()) || dataType.getName().equalsIgnoreCase(DataType.DOUBLE.getName()) || dataType.getName().equalsIgnoreCase(DataType.DECIMAL.getName())) {
                    String numberValue = null;
                    ICellEditor editor = this.mainTable.getRow(rowIndex).getCell(3).getEditor();
                    if (editor != null) {
                        KDBizPromptBox f7PromptBox = (KDBizPromptBox)editor.getComponent();
                        Object value = f7PromptBox.getData();
                        if (value == null) {
                            return;
                        }
                        if (value instanceof String) {
                            numberValue = (String)value;
                        } else if (value instanceof DataObject) {
                            numberValue = ((DataObject)value).getValue();
                        } else if (value instanceof IObjectValue) {
                            value = BgEntityUtil.getBizData((IObjectValue)((IObjectValue)value));
                            f7PromptBox.setData(value);
                            numberValue = f7PromptBox.getEditFormatter().valueToString(value);
                        } else if (value instanceof Float) {
                            numberValue = value.toString();
                        } else if (value instanceof Integer) {
                            numberValue = value.toString();
                        }
                        if (this.checkFilterData(numberValue, dataType.getName())) {
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"compareValueWarning"));
                            this.mainTable.getRow(rowIndex).getCell(3).setValue(null);
                            return;
                        }
                        dataObject.setValue(numberValue);
                        dataObject.setName(numberValue);
                        this.mainTable.getRow(rowIndex).getCell(colIndex).setValue((Object)numberValue);
                    }
                } else {
                    ICellEditor editor = this.mainTable.getRow(rowIndex).getCell(3).getEditor();
                    if (editor != null) {
                        KDBizPromptBox promptBox = (KDBizPromptBox)this.mainTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                        Object objData = promptBox.getData();
                        if (objData instanceof Object[] && ((Object[])objData).length == 1) {
                            objData = ((Object[])objData)[0];
                        }
                        if (objData == null) {
                            return;
                        }
                        if (objData instanceof String) {
                            this.mainTable.getRow(rowIndex).getCell(colIndex).setValue((Object)((String)objData));
                            return;
                        }
                        if (objData instanceof DataObject) {
                            this.mainTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                        } else if (objData instanceof IObjectValue) {
                            IObjectValue bizObject = (IObjectValue)objData;
                            bizObject = BgEntityUtil.getBizData((IObjectValue)bizObject);
                            promptBox.setData((Object)bizObject);
                            this.mainTable.getRow(rowIndex).getCell(colIndex).setValue((Object)promptBox.getEditFormatter().valueToString((Object)bizObject));
                            return;
                        }
                    }
                }
            } else {
                this.resetCell(this.mainTable.getCell(rowIndex, colIndex));
            }
        }
    }

    protected boolean checkFilterData(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private static BgControlIsomerKSQLUtils getKSQLCilent() throws EASBizException, BOSException {
        if (ksqlClient == null) {
            ksqlClient = BgControlIsomerCHelper.getKSQLClient(isomerInfo.getConnection());
        }
        return ksqlClient;
    }

    protected void formateCompareCellEditorForIsomer(int rowIndex, BgRuleCondition rule) throws EASBizException, BOSException {
        String[] end = this.vaildProperty(rule);
        ICell iCell = this.mainTable.getCell(rowIndex, 3);
        String type = this.tableMap.get(end[0]).get(end[1]);
        if (type.equalsIgnoreCase(DataType.BOOLEAN.getName())) {
            Object[] _enum = EnumUtils.getEnumList((String)"com.kingdee.eas.base.commonquery.BooleanEnum").toArray();
            KDComboBox kdComboBox = new KDComboBox(this.addObjectToArray(_enum, null));
            kdComboBox.setMaximumRowCount(10);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
            iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
            iCell.setValue(null);
        } else if (type.contains(DataType.DATE.getName()) || type.contains(DataType.TIME.getName()) || type.contains(DataType.TIMESTAMP.getName())) {
            String format = "%{" + this.getTimeFormat(type) + "}t";
            Date initDate = this.getDate(new Date(), type);
            KDDatePicker datePicker = new KDDatePicker();
            if (initDate instanceof Timestamp) {
                datePicker.setTimeEnabled(true);
            } else if (initDate instanceof Time) {
                datePicker.setTimeEnabled(true);
            }
            datePicker.setValue((Object)initDate);
            KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
            iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
            iCell.getStyleAttributes().setNumberFormat(format);
            iCell.setValue(null);
        } else {
            this.resetCell(iCell);
        }
    }

    private String[] vaildProperty(BgRuleCondition rule) throws BgControlException {
        String endTable = null;
        String endField = null;
        String[] keys = rule.getNumber().split("\\.");
        if (keys.length == 1) {
            endTable = isomerInfo.getNumber();
            endField = keys[0];
        } else {
            BgControlIsomerSetCollection colls = isomerInfo.getSets();
            block0: for (int i = 0; i < keys.length; ++i) {
                if (!colls.isEmpty()) {
                    int j;
                    if (i == 0) {
                        for (j = 0; j < colls.size(); ++j) {
                            if (!colls.get(j).getCnumber().equals(isomerInfo.getNumber()) || !colls.get(j).getCField().equals(keys[0])) continue;
                            endTable = colls.get(j).getNumber();
                            continue block0;
                        }
                        continue;
                    }
                    if (i == keys.length - 1) {
                        endField = keys[keys.length - 1];
                        continue;
                    }
                    for (j = 0; j < colls.size(); ++j) {
                        if (!colls.get(j).getCnumber().equals(endTable) || !colls.get(j).getCField().equals(keys[i])) continue;
                        endTable = colls.get(j).getNumber();
                        continue block0;
                    }
                    continue;
                }
                throw new BgControlException(BgControlException.BIZOROUIDERROR);
            }
        }
        return new String[]{endTable, endField};
    }

    protected void formateCompareCellEditor(int rowIndex, BgRuleCondition rule) {
        EntityObjectInfo mainEntity = this.getMainEntytyObject();
        EntityObjectInfo targetEntity = this.getEntity(mainEntity, rule.getNumber());
        String targetProperty = this.getPropertyName(rule.getNumber());
        DataObject dataObject = this.getRefMetaData(targetEntity, targetProperty);
        ICell iCell = this.mainTable.getCell(rowIndex, 3);
        String propertyValue = rule.getNumber();
        if (dataObject == null) {
            this.resetCell(iCell);
        } else {
            String type = dataObject.getName();
            if (type.equalsIgnoreCase(DataType.ENUM.getName())) {
                String enumClassName = dataObject.getValue();
                Object[] _enum = EnumUtils.getEnumList((String)enumClassName).toArray();
                KDComboBox kdComboBox = new KDComboBox(this.addObjectToArray(_enum, null));
                kdComboBox.setMaximumRowCount(10);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                iCell.setValue(null);
            } else if (type.equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                String enumClassName = dataObject.getValue();
                Object[] _enum = EnumUtils.getEnumList((String)enumClassName).toArray();
                KDComboBox kdComboBox = new KDComboBox(this.addObjectToArray(_enum, null));
                kdComboBox.setMaximumRowCount(10);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
                iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                iCell.setValue(null);
            } else if (type.equalsIgnoreCase(DataType.DATE.getName()) || type.equalsIgnoreCase(DataType.TIME.getName()) || type.equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
                String format = "%{" + this.getTimeFormat(type) + "}t";
                Date initDate = this.getDate(new Date(), type);
                KDDatePicker datePicker = new KDDatePicker();
                if (initDate instanceof Timestamp) {
                    datePicker.setTimeEnabled(true);
                } else if (initDate instanceof Time) {
                    datePicker.setTimeEnabled(true);
                }
                datePicker.setValue((Object)initDate);
                KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
                iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.setValue(null);
            } else if (propertyValue.indexOf(".") == -1) {
                this.resetCell(iCell);
            } else {
                String display = "name";
                if (propertyValue.indexOf("number") == propertyValue.length() - 6) {
                    display = "number";
                }
                if (propertyValue.equals("bank.number") && targetEntity.getFullName().equals("com.kingdee.eas.basedata.assistant.app.Bank")) {
                    KDBizPromptBox prmtBox = new KDBizPromptBox();
                    prmtBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.BankQuery");
                    prmtBox.setCommitFormat("$number$");
                    prmtBox.setEditFormat("$number$");
                    prmtBox.setDisplayFormat("$" + display + "$");
                    prmtBox.setEnabledMultiSelection(false);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
                    prmtBox.setEntityViewInfo(view);
                    iCell.getStyleAttributes().setNumberFormat("");
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.getStyleAttributes().setNumberFormat("");
                    return;
                }
                if (propertyValue.equals("entries.assistRecords.assGrp.adminOrg.number") && targetEntity.getFullName().equals("com.kingdee.eas.basedata.org.app.AdminOrgUnit")) {
                    KDBizPromptBox prmtBox = new KDBizPromptBox();
                    prmtBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminItemQuery");
                    prmtBox.setCommitFormat("$number$");
                    prmtBox.setEditFormat("$number$");
                    prmtBox.setDisplayFormat("$" + display + "$");
                    prmtBox.setEnabledMultiSelection(false);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    this.getOrgViewInfo(view, "com.kingdee.eas.basedata.org.app.AdminItemQuery", "entries.assistRecords.assGrp.adminOrg.number");
                    prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
                    prmtBox.setEntityViewInfo(view);
                    iCell.getStyleAttributes().setNumberFormat("");
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.getStyleAttributes().setNumberFormat("");
                    return;
                }
                if (propertyValue.equals("entries.assistRecords.assGrp.costOrg.number") && targetEntity.getFullName().equals("com.kingdee.eas.basedata.org.app.CostCenterOrgUnit")) {
                    KDBizPromptBox prmtBox = new KDBizPromptBox();
                    prmtBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
                    prmtBox.setCommitFormat("$number$");
                    prmtBox.setEditFormat("$number$");
                    prmtBox.setDisplayFormat("$" + display + "$");
                    prmtBox.setEnabledMultiSelection(false);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    view.setFilter(filter);
                    this.getOrgViewInfo(view, "com.kingdee.eas.basedata.org.app.CostCenterItemQuery", "entries.assistRecords.assGrp.costOrg.number");
                    prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterInfoProducer(view.getFilter()));
                    prmtBox.setEntityViewInfo(view);
                    iCell.getStyleAttributes().setNumberFormat("");
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    iCell.getStyleAttributes().setNumberFormat("");
                    return;
                }
                EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity((String)dataObject.getValue());
                KDPromptBox f7 = BgEntityUtil.getF7((String)BgEntityUtil.getPropertyName((String)propertyValue), (EntityObjectInfo)entityObjectInfo, null);
                if (f7 == null) {
                    this.resetCell(iCell);
                } else {
                    DataObject _value;
                    FilterInfo filter;
                    EntityViewInfo view = ((KDBizPromptBox)f7).getEntityViewInfo();
                    if (view == null) {
                        view = new EntityViewInfo();
                    }
                    if ((filter = view.getFilter()) == null) {
                        filter = new FilterInfo();
                    }
                    view.setFilter(filter);
                    this.getOrgViewInfo(view, targetEntity.getFullName(), propertyValue);
                    ((KDBizPromptBox)f7).setEntityViewInfo(view);
                    this.resetCell(iCell);
                    if (((KDBizPromptBox)f7).getQueryInfo() == null || "".equals(((KDBizPromptBox)f7).getQueryInfo())) {
                        return;
                    }
                    this.resetCell(iCell);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)f7);
                    iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
                    ICell _BgCell = this.mainTable.getRow(rowIndex).getCell(1);
                    Object value = _BgCell.getValue();
                    if (value != null && value instanceof DataObject && (_value = (DataObject)value).getValue() != null && (_value.getValue().equalsIgnoreCase("entries.assistRecords.maCtrlAmount") || _value.getValue().equalsIgnoreCase("entries.assistRecords.originalAmount"))) {
                        iCell.setEditor(null);
                    }
                }
            }
        }
    }

    protected EntityViewInfo getOrgViewInfo(EntityViewInfo view, String name, String property) {
        String type;
        if (view == null) {
            view = new EntityViewInfo();
        }
        if ((type = this.getOrgFilterType(name)) == null) {
            return view;
        }
        String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        if (CU.equals(type)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        } else if (COMPANY.equals(type)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        } else if (COMPANYID.equals(type)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyId.id", (Object)companyId));
        } else {
            if (GLOBAL.equals(type)) {
                return view;
            }
            if (SPECIAL.equals(type)) {
                if ("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery".equals(name) || "com.kingdee.eas.cp.bc.app.ExpenseType".equals(name)) {
                    view.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                    CompanyOrgUnitInfo cui = SysContext.getSysContext().getCurrentFIUnit();
                    String ln = cui.getLongNumber();
                    String[] lnSecs = ln.split("!");
                    int size = lnSecs.length;
                    HashSet<String> lnUps = new HashSet<String>();
                    for (int i = 0; i < size; ++i) {
                        lnUps.add(lnSecs[i]);
                    }
                    if (lnUps.size() != 0) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
                        view.getFilter().setMaskString("#0 or #1");
                    }
                }
                if (property != null && ("com.kingdee.eas.basedata.master.auxacct.app.F7GeneralAsstActTypeQuery".equals(name) || "com.kingdee.eas.basedata.master.auxacct.app.GeneralAsstActType".equals(name))) {
                    Map assActTypeGroupIdMap = null;
                    try {
                        assActTypeGroupIdMap = MetaDataFacadeFactory.getRemoteInstance().getGeneralAssActTypeId();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((Throwable)ex);
                    }
                    String[] tmps = property.split("\\.");
                    if (tmps != null && tmps.length == 5 && tmps[3] != null && tmps[3].startsWith("generalAssActType")) {
                        String groupId = null;
                        for (String key : assActTypeGroupIdMap.keySet()) {
                            if (!key.equalsIgnoreCase(tmps[3])) continue;
                            groupId = (String)assActTypeGroupIdMap.get(key);
                            break;
                        }
                        view.getFilter().getFilterItems().add(new FilterItemInfo("group.id", groupId));
                        FilterInfo filter = this.getFilterForGeneral(groupId);
                        try {
                            view.getFilter().mergeFilter(filter, "AND");
                        }
                        catch (Exception ex) {
                            logger.error((Object)"budget error:", (Throwable)ex);
                        }
                    }
                    if (tmps != null && tmps.length == 5 && tmps[3] != null && tmps[3].startsWith("generalAssActType")) {
                        BgCommCHelper.replaceFilterItems((FilterInfo)view.getFilter(), (FilterItemInfo)new FilterItemInfo("CU.id", (Object)cuId));
                    }
                }
                if ("com.kingdee.eas.basedata.org.app.AdminItemQuery".equals(name)) {
                    boolean isAdmin = false;
                    if (SysContext.getSysContext().getCurrentCostUnit() != null && SysContext.getSysContext().getCurrentCostUnit().isIsAdminOrgUnit()) {
                        isAdmin = true;
                    }
                    if (isAdmin) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(SysContext.getSysContext().getCurrentAdminUnit().get("longNumber").toString() + "%"), CompareType.LIKE));
                    } else {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"###############"));
                    }
                }
                if ("com.kingdee.eas.basedata.org.app.CostCenterItemQuery".equals(name) || "com.kingdee.eas.basedata.org.app.CostCenterOrgUnit".equals(name)) {
                    boolean isCc = false;
                    if (SysContext.getSysContext().getCurrentCostUnit() != null) {
                        isCc = true;
                    }
                    if (isCc) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(SysContext.getSysContext().getCurrentCostUnit().get("longNumber").toString() + "%"), CompareType.LIKE));
                    } else {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"###############"));
                    }
                }
                return view;
            }
            return view;
        }
        return view;
    }

    protected String getOrgFilterType(String name) {
        if ("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery".equals(name) || "com.kingdee.eas.basedata.master.account.app.AccountView".equals(name)) {
            return COMPANYID;
        }
        if ("com.kingdee.eas.fi.lcm.LCMLcmCatQuery".equals(name) || "com.kingdee.eas.fi.lcm.app.LCMLcmCat".equals(name)) {
            return COMPANY;
        }
        if ("com.kingdee.eas.fm.fpl.FpItemQuery".equals(name) || "com.kingdee.eas.fm.fpl.app.FpItem".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.basedata.assistant.app.F7CashFlowQuery".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.fi.fa.basedata.FaCatQuery".equals(name) || "com.kingdee.eas.fi.fa.basedata.app.FaCat".equals(name)) {
            return COMPANY;
        }
        if ("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery".equals(name) || "com.kingdee.eas.cp.bc.app.ExpenseType".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.basedata.master.auxacct.app.F7GeneralAsstActTypeQuery".equals(name) || "com.kingdee.eas.basedata.master.auxacct.app.GeneralAsstActType".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.basedata.org.app.AdminItemQuery".equals(name) || "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.basedata.org.app.CostCenterItemQuery".equals(name) || "com.kingdee.eas.basedata.org.app.CostCenterOrgUnit".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.ma.nbudget.app.F7MaterialGroupQuery".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.fi.cas.ReceivingBillTypeQuery".equals(name) || "com.kingdee.eas.fi.cas.app.ReceivingBillType".equals(name) || "com.kingdee.eas.fi.cas.app.PaymentBillType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.basedata.assistant.app.BankQuery".equals(name) || "com.kingdee.eas.basedata.assistant.app.Bank".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.basedata.assistant.app.SettlementTypeQuery".equals(name) || "com.kingdee.eas.basedata.assistant.app.SettlementType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.fi.cas.app.FeeTypeQuery".equals(name) || "com.kingdee.eas.fi.cas.app.FeeType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.ma.budget.CustomerProjectQuery".equals(name)) {
            if (this.isProjectlsolate(null)) {
                return COMPANY;
            }
            return GLOBAL;
        }
        if ("com.kingdee.eas.fdc.basedata.app.F7PaymentTypeQuery".equals(name) || "com.kingdee.eas.fdc.basedata.app.PaymentType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.fdc.contract.app.ContractBaseDataQuery".equals(name) || "com.kingdee.eas.fdc.contract.app.ContractBaseData".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.fi.cas.app.FundFlowItem".equalsIgnoreCase(name) || "com.kingdee.eas.fi.cas.app.FundFlowItemQuery".equals(name)) {
            return GLOBAL;
        }
        if (name.startsWith("com.kingdee.eas.fi.")) {
            return COMPANY;
        }
        return CU;
    }

    protected FilterInfo getFilterForGeneral(String groupID) {
        CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
        if (CU == null) {
            return null;
        }
        String currentCUID = CU.getId().toString();
        String currentCULongNumber = CU.getLongNumber();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)currentCUID));
        if (groupID != null) {
            try {
                IGeneralAsstActTypeGroup IGenAsstActTypeGroup = GeneralAsstActTypeGroupFactory.getRemoteInstance();
                GeneralAsstActTypeGroupInfo info = IGenAsstActTypeGroup.getGeneralAsstActTypeGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)groupID)));
                if (info.getShareTactic().equals((Object)ShareTacticEnum.S3)) {
                    fi.setMaskString("#0 ");
                } else {
                    String ln = currentCULongNumber;
                    String[] lnSecs = ln.split("!");
                    int size = lnSecs.length;
                    HashSet<String> lnUps = new HashSet<String>();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < size - 1; ++i) {
                        if (i != 0) {
                            sb.append("!");
                        }
                        sb.append(lnSecs[i]);
                        lnUps.add(sb.toString());
                    }
                    if (lnUps.size() != 0) {
                        fic.add(new FilterItemInfo("CU.longNumber", lnUps, CompareType.INCLUDE));
                        fi.setMaskString("#0 or #1");
                    }
                }
            }
            catch (Exception e) {
                fi.setMaskString("#0 ");
            }
        } else {
            fi.setMaskString("#0 ");
        }
        return fi;
    }

    protected boolean isProjectlsolate(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"ProjectIsolate") : ParamManager.getParamValue((Context)ctx, null, (String)"ProjectIsolate");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return StringUtils.isEmpty((String)paramValue) ? false : Boolean.valueOf(paramValue);
    }

    protected void resetCell(ICell cell) {
        cell.setEditor(null);
        cell.setValue(null);
        if (cell.getStyleAttributes() != null) {
            cell.getStyleAttributes().setNumberFormat("");
        }
    }

    protected Date getDate(Date date, String type) {
        Date initDate = date;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (DataType.TIMESTAMP.getName().equalsIgnoreCase(type)) {
            initDate = new Timestamp(cal.getTime().getTime());
        } else if (DataType.TIME.getName().equalsIgnoreCase(type)) {
            cal.set(13, 0);
            initDate = new Time(cal.getTime().getTime());
        } else if (DataType.DATE.getName().equalsIgnoreCase(type)) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            initDate = cal.getTime();
        }
        return initDate;
    }

    protected String getTimeFormat(String dateType) {
        String format = "yyyy-MM-dd";
        if (dateType.equalsIgnoreCase(DataType.DATE.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIME.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateTimeFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateTimeFormatString();
        }
        return format;
    }

    public String getPropertyName(String str) {
        int index = str.lastIndexOf(".");
        if (index != 0) {
            str = str.substring(index + 1);
        }
        return str;
    }

    @Override
    protected void mainTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.mainTable_tableClicked(e);
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.mainTable.addRow();
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.mainTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        KDTSelectBlock selectBlock = null;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (this.mainTable.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            for (int i = top; i <= bottom; ++i) {
                indexSet.add(new Integer(i));
            }
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            this.mainTable.removeRow(rowIndex);
        }
    }

    @Override
    public void actionClearRow_actionPerformed(ActionEvent e) throws Exception {
        this.mainTable.removeRows();
    }

    @Override
    protected int countToWord(String str, String key) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(key, index)) != -1) {
            index += key.length();
            ++count;
        }
        return count;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        for (int i = this.mainTable.getRowCount() - 1; i >= 0; --i) {
            if (!this.isBlankRow(i)) continue;
            this.mainTable.removeRow(i);
        }
        this.verifyData();
        this.setCurrentFilterInfo();
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.bizBill = (String)this.getUIContext().get("bizUnit");
        this.isomer = (Boolean)this.getUIContext().get("isomer");
        if (this.isomer) {
            isomerInfo = BgControlIsomerFactory.getRemoteInstance().getBgControlIsomerInfo("Select id,number,sets.*,maps.*,connection.*,name,pfiled where id='" + this.bizBill + "'");
            this.initIsomerTableInfo();
        }
        this.formateTable();
        BgCommHelper.removeEditHelper((KDTable)this.mainTable);
    }

    private void initIsomerTableInfo() throws EASBizException, BOSException, SQLException {
        BgControlIsomerSetCollection colls = isomerInfo.getSets();
        colls.sort("cnumber");
        HashSet<String> tableName = new HashSet<String>();
        tableName.add(isomerInfo.getNumber());
        if (colls != null && colls.size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                if (!this.tableMap.containsKey(colls.get(i).getNumber())) {
                    tableName.add(colls.get(i).getNumber());
                }
                if (this.tableMap.containsKey(colls.get(i).getCnumber())) continue;
                tableName.add(colls.get(i).getCnumber());
            }
        }
        this.getTableColMap(tableName);
    }

    private void getTableColMap(Set<String> tableName) throws EASBizException, BOSException, SQLException {
        if (BgCtrlRuleConditionUI.getKSQLCilent() != null) {
            String table = null;
            Iterator<String> iterator = tableName.iterator();
            while (iterator.hasNext()) {
                table = iterator.next();
                if (!this.tableMap.containsKey(table)) continue;
                iterator.remove();
            }
            if (!tableName.isEmpty()) {
                String newsql = BgControlIsomerCHelper.queryColumnSQL(tableName, isomerInfo.getConnection());
                IRowSet rowset = BgCtrlRuleConditionUI.getKSQLCilent().getTargetRowset(newsql);
                while (rowset.next()) {
                    if (this.tableMap.containsKey(rowset.getString(2))) {
                        this.tableMap.get(rowset.getString(2)).put(rowset.getString(1), rowset.getString(3));
                        continue;
                    }
                    HashMap<String, String> col = new HashMap<String, String>();
                    col.put(rowset.getString(1), rowset.getString(3));
                    this.tableMap.put(rowset.getString(2), col);
                }
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"));
            SysUtil.abort();
        }
    }

    protected EntityObjectInfo getMainEntytyObject() {
        if (StringUtils.isEmpty((String)this.bizBill)) {
            return this.entityObject;
        }
        if (this.entityObject == null) {
            this.entityObject = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)this.bizBill));
        }
        return this.entityObject;
    }

    protected EntityObjectInfo getEntity(EntityObjectInfo mainEntity, String propertyValue) {
        EntityObjectInfo entity = mainEntity;
        PropertyCollection propertyCollection = this.getAllEntityProperties(entity);
        int size = propertyCollection.size();
        Object propertyInfos = null;
        StringTokenizer stringTokenizer = new StringTokenizer(propertyValue, ".");
        String temp = stringTokenizer.nextToken();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(temp)) continue;
            if (stringTokenizer.hasMoreTokens()) {
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                entity = this.getEntity(BgCtrlRuleConditionUI.getEntity(mainEntity.getFullName(), linkPropertyInfo), propertyValue.substring(propertyValue.indexOf(".") + 1));
            }
            return entity;
        }
        return entity;
    }

    protected PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    public static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo) {
        String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (!tempEntityName.equalsIgnoreCase(mainEntityName)) {
            return linkPropertyInfo.getRelationship().getSupplierObject();
        }
        return linkPropertyInfo.getRelationship().getClientObject();
    }

    protected DataObject getRefMetaData(EntityObjectInfo entity, String propertiyName) {
        DataObject dataObject = null;
        PropertyCollection propertyCollection = this.getAllEntityProperties(entity);
        int size = propertyCollection.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            String propName = propertyInfo.getName();
            if (!propName.toLowerCase().equalsIgnoreCase(propertiyName.toLowerCase())) continue;
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    String enumName = ownPropertyInfo.getMetaDataRef();
                    BizEnumInfo _enum = this.getEnum(enumName);
                    if (enumName.indexOf("com.kingdee.eas.custom") >= 0 && !StringUtils.isEmpty((String)_enum.getFullName())) {
                        dataObject.setValue(_enum.getFullName());
                    } else {
                        dataObject.setValue(_enum.getClassName());
                    }
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(BooleanEnum.class.getName());
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.DATE) || ownPropertyInfo.getDataType().equals((Object)DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals((Object)DataType.TIME)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(null);
                    return dataObject;
                }
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(entity.getFullName());
                return dataObject;
            }
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo refEntity = BgCtrlRuleConditionUI.getEntity(entity.getFullName(), linkPropertyInfo);
            String refEntityName = refEntity.getFullName();
            dataObject = new DataObject();
            if (this.isSimpleEntity(refEntity)) {
                dataObject.setName("SIMPLE_ENTITY");
                dataObject.setValue(refEntityName);
                return dataObject;
            }
            return this.getRefMetaData(refEntity, propertiyName);
        }
        return dataObject;
    }

    protected boolean isSimpleEntity(EntityObjectInfo entity) {
        Map extendProperty = entity.getExtendedProperties();
        Object objIsSimple = entity.getExtendedProperties().get("isSimpleEntity");
        String isSimple = "false";
        if (objIsSimple != null) {
            isSimple = objIsSimple.toString();
        }
        return Boolean.valueOf(isSimple);
    }

    public BizEnumInfo getEnum(String enumName) {
        MetaDataPK enumPK = new MetaDataPK(enumName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEnum((IMetaDataPK)enumPK);
    }

    protected void formateTable() throws BOSException, EASBizException, ParserException {
        this.mainTable.checkParsed();
        this.formateColumn();
        Object data = this.getUIContext().get("data");
        if (data instanceof BizDataObject) {
            BizDataObject bizData = (BizDataObject)data;
            this.filterInfo = new FilterInfo(bizData.getValue(), true);
            if (bizData.getMaskString() != null) {
                this.filterInfo.setMaskString(bizData.getMaskString());
            }
            if (this.filterInfo != null && !this.filterInfo.getFilterItems().isEmpty()) {
                this.fillFilterTableBody();
            } else {
                this.mainTable.addRow();
            }
        } else {
            this.mainTable.addRow();
        }
    }

    protected void fillFilterTableBody() throws BaseCommonQueryClientException {
        if (this.filterInfo != null && !this.filterInfo.getFilterItems().isEmpty()) {
            String express = this.filterInfo.getMaskString();
            if (express == null && this.filterInfo.getFilterItems().size() > 0) {
                for (int i = 0; i < this.filterInfo.getFilterItems().size(); ++i) {
                    express = i == 0 ? "#" + i : express + " AND #" + i;
                }
            }
            int filterSize = this.filterInfo.getFilterItems().size();
            List<Map<String, String>> brachets = this.analysisEpress(express);
            if (filterSize > 0) {
                if (!this.extendCondition) {
                    this.checkFilters();
                }
                ArrayList rowInfos = BgEntityUtil.getRowInfos((FilterInfo)this.filterInfo);
                for (int i = 0; i < filterSize; ++i) {
                    RowObject rowObject = (RowObject)rowInfos.get(i);
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    this.mainTable.addRow(i);
                    rowObject.setLeftBracket(rowObject.getLeftBracket());
                    rowObject.setCondition(filterItemInfo.getPropertyName());
                    if (filterItemInfo.getCompareValue() != null) {
                        rowObject.setCompare(filterItemInfo.getCompareType().getName());
                        EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)filterItemInfo.getPropertyName());
                        if (BgEntityUtil.isDate((EntityObjectInfo)targetEntity, (String)BgEntityUtil.getPropertyName((String)filterItemInfo.getPropertyName()))) {
                            if (filterItemInfo.getCompareValue() instanceof Date) {
                                rowObject.setCompareValue(filterItemInfo.getCompareValue());
                            } else {
                                try {
                                    rowObject.setCompareValue((Object)DateTimeUtils.parseDate((String)filterItemInfo.getCompareValue().toString()));
                                }
                                catch (ParseException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                            }
                        } else {
                            rowObject.setCompareValue(filterItemInfo.getCompareValue());
                        }
                    } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                        String compare = filterItemInfo.getCompareType().getName();
                        if (compare.equalsIgnoreCase("=")) {
                            compare = "IS";
                        }
                        if (compare.equalsIgnoreCase("<>")) {
                            compare = "IS NOT";
                        }
                        rowObject.setCompare(compare);
                        rowObject.setCompareValue(null);
                    }
                    rowObject.setRightBracket(brachets.get(i).get(")"));
                    rowObject.setLeftBracket(brachets.get(i).get("("));
                    rowObject.setLogic(rowObject.getLogic());
                    this.loadFilter(i, rowObject);
                }
            }
        }
    }

    @Override
    protected List<Map<String, String>> analysisEpress(String express) {
        if (express == null) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<String> logicSet = new ArrayList<String>();
        logicSet.add("AND");
        logicSet.add("OR");
        String upperExp = express.toUpperCase();
        ArrayList<String> expressList = new ArrayList<String>();
        expressList.add(upperExp);
        List<String> expressItems = null;
        for (int i = 0; i < logicSet.size(); ++i) {
            String logic = (String)logicSet.get(i);
            if (logic == null) continue;
            expressItems = this.parseExpress(expressList, logic);
        }
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>();
        if (expressItems == null || expressItems.isEmpty()) {
            return returnList;
        }
        for (int i = 0; i < expressItems.size(); ++i) {
            StringBuilder right = new StringBuilder();
            StringBuilder left = new StringBuilder();
            String expressItem = expressItems.get(i).trim();
            ArrayList<String> list = new ArrayList<String>();
            char[] chars = expressItem.toCharArray();
            for (int k = 0; k < chars.length; ++k) {
                list.add(String.valueOf(chars[k]));
            }
            for (String s : list) {
                if (s.contains(")")) {
                    right.insert(0, s);
                    continue;
                }
                if (!s.contains("(")) continue;
                left.insert(0, s);
            }
            HashMap<String, String> bracketItemMap = new HashMap<String, String>();
            bracketItemMap.put(")", right.toString());
            bracketItemMap.put("(", left.toString());
            returnList.add(bracketItemMap);
        }
        return returnList;
    }

    @Override
    protected List<String> parseExpress(List<String> expressList, String logic) {
        if (expressList.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((String)expressList.get(0))) {
            return null;
        }
        if (StringUtils.isEmpty((String)logic)) {
            return expressList;
        }
        String expressItem = null;
        String[] splitItems = null;
        ArrayList arrayListTmp = null;
        for (int i = 0; i < expressList.size(); ++i) {
            expressItem = expressList.get(i);
            if (expressItem == null || expressItem.indexOf(logic) == -1) continue;
            splitItems = expressItem.split(logic);
            arrayListTmp = new ArrayList(splitItems.length);
            Collections.addAll(arrayListTmp, splitItems);
            expressList.remove(i);
            expressList.addAll(i, arrayListTmp);
            --i;
        }
        return expressList;
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BaseCommonQueryClientException {
        int length = FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    protected void loadCompareValue(int rowIndex, RowObject rowObject) {
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)rowObject.getCondition());
        String targetProperty = BgEntityUtil.getPropertyName((String)rowObject.getCondition());
        DataObject dataInfo = BgEntityUtil.getRefMetaData((EntityObjectInfo)targetEntity, (String)targetProperty);
        this.setNullSignLocked(rowIndex);
        if (dataInfo != null) {
            if (dataInfo.getName().equalsIgnoreCase(DataType.ENUM.getName())) {
                BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)3, (String)dataInfo.getValue(), (String)BgEntityUtil.getValue((Object)rowObject.getCompareValue()).toString());
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)3, (String)dataInfo.getValue(), (String)BgEntityUtil.getValue((Object)rowObject.getCompareValue()).toString());
            } else if (dataInfo.getName().equals(DataType.DATE.getName()) || dataInfo.getName().equals(DataType.TIMESTAMP.getName()) || dataInfo.getName().equals(DataType.TIME.getName())) {
                Date dateValue = BgEntityUtil.getDate((Date)((Date)rowObject.getCompareValue()), (String)dataInfo.getName());
                BgEntityUtil.setDateCtrlField((KDTable)this.mainTable, (int)rowIndex, (int)3, (Date)dateValue);
                this.mainTable.getRow(rowIndex).getCell(3).setValue((Object)dateValue);
                String format = BgEntityUtil.getTimeFormatForTable((String)dataInfo.getName());
                this.mainTable.getRow(rowIndex).getCell(3).getStyleAttributes().setNumberFormat(format);
            } else {
                KDBizPromptBox promptBox = (KDBizPromptBox)BgEntityUtil.getF7((String)targetProperty, (EntityObjectInfo)targetEntity, null);
                if (promptBox != null) {
                    FilterInfo filter;
                    EntityViewInfo view = promptBox.getEntityViewInfo();
                    if (view == null) {
                        view = new EntityViewInfo();
                    }
                    if ((filter = view.getFilter()) == null) {
                        filter = new FilterInfo();
                    }
                    view.setFilter(filter);
                    this.getOrgViewInfo(view, targetEntity.getFullName(), null);
                    promptBox.setEntityViewInfo(view);
                    KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    Object f7Data = rowObject.getCompareValue();
                    promptBox.setData(f7Data);
                    this.mainTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    if (promptBox.getQueryInfo() != null && !StringUtils.isEmpty((String)promptBox.getQueryInfo())) {
                        this.mainTable.getRow(rowIndex).getCell(3).setEditor((ICellEditor)kdtDefaultCellEditor);
                    }
                    this.mainTable.getRow(rowIndex).getCell(3).setValue(f7Data);
                } else {
                    Object compareValue = rowObject.getCompareValue();
                    Object sign = this.mainTable.getRow(rowIndex).getCell(2).getValue();
                    if (CompareSignEnum.LIKESIGN.equals(sign)) {
                        compareValue = compareValue.toString().substring(1, compareValue.toString().length() - 1);
                    } else if (CompareSignEnum.LEFTLIKESIGN.equals(sign)) {
                        compareValue = compareValue.toString().substring(0, compareValue.toString().length() - 1);
                    } else if (CompareSignEnum.RIGHTLIKESIGN.equals(sign)) {
                        compareValue = compareValue.toString().substring(1, compareValue.toString().length());
                    }
                    this.mainTable.getRow(rowIndex).getCell(3).setValue(compareValue);
                }
            }
        } else {
            this.mainTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
        if (this.isNullSign(rowObject.getCompare())) {
            this.mainTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
        }
    }

    @Override
    protected boolean isNullSign(String compare) {
        return compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS NOT");
    }

    @Override
    protected void loadLeftBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)0, (String)LeftBracketSignEnum.class.getName(), (String)rowObject.getLeftBracket());
    }

    protected void loadCondition(int rowIndex, RowObject rowObject) {
        String conditon = rowObject.getCondition();
        if (conditon != null) {
            String strCondition = conditon.toString();
            if (strCondition.indexOf("%") != -1) {
                this.mainTable.getRow(rowIndex).getCell(1).setValue((Object)strCondition);
            } else {
                for (int index = 0; index < this.bizBillObject.size(); ++index) {
                    if (!this.bizBillObject.get(index).getNumber().equals(rowObject.getCondition())) continue;
                    this.mainTable.getRow(rowIndex).getCell(1).setValue((Object)this.bizBillObject.get(index));
                }
            }
        }
    }

    protected void loadCompareSign(int rowIndex, RowObject rowObject) {
        EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)rowObject.getCondition());
        String targetProperty = BgEntityUtil.getPropertyName((String)rowObject.getCondition());
        String compare = rowObject.getCompare();
        if (compare.equalsIgnoreCase(CompareType.NOTLIKE.toString())) {
            if (!rowObject.getCompareValue().toString().startsWith("%") && rowObject.getCompareValue().toString().endsWith("%")) {
                compare = "NOT LEFT LIKE";
            }
        } else if (compare.equalsIgnoreCase(CompareType.LIKE.toString())) {
            if (rowObject.getCompareValue().toString().startsWith("%") && !rowObject.getCompareValue().toString().endsWith("%")) {
                compare = "RIGHT LIKE";
            } else if (!rowObject.getCompareValue().toString().startsWith("%") && rowObject.getCompareValue().toString().endsWith("%")) {
                compare = "LEFT LIKE";
            }
        }
        KDComboBox comboBox = BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)2, (String)CompareSignEnum.class.getName(), (String)compare);
        comboBox.removeItem((Object)"");
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
        this.removeFieldCompare(comboBox);
        PropertyInfo propertyInfo = BgEntityUtil.getEntityPropertyByName((EntityObjectInfo)targetEntity, (String)targetProperty);
        if (propertyInfo != null && !BgEntityUtil.isString((OwnPropertyInfo)((OwnPropertyInfo)propertyInfo))) {
            comboBox.removeItem((Object)CompareSignEnum.LIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.NOTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.NOTLEFTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
            comboBox.removeItem((Object)CompareSignEnum.TODAY);
            comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
            comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
            comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
            comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
            comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
            comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
            comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
            comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
            comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
            comboBox.removeItem((Object)CompareSignEnum.LEFTLIKESIGN);
            comboBox.removeItem((Object)CompareSignEnum.RIGHTLIKESIGN);
        }
    }

    @Override
    protected void removeFieldCompare(KDComboBox comboBox) {
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
    }

    protected void checkFilters() {
        int filterSize = this.filterInfo.getFilterItems().size();
        if (this.filterProperties != null && this.filterProperties.length > 0) {
            for (int i = 0; i < filterSize; ++i) {
                int length = this.filterProperties.length;
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                boolean flag = true;
                for (int j = 0; j < length; ++j) {
                    if (!this.filterProperties[j].toLowerCase().equalsIgnoreCase(currentField.toLowerCase())) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < filterSize; ++i) {
                String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
                if (BgEntityUtil.getEntityPropertyAlias((EntityObjectInfo)this.getMainEntytyObject(), (String)currentField, null) != null) continue;
                MsgBox.showError((String)(currentField + EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"checkFilterWarning")));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void loadRightBracket(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)4, (String)RightBracketSignEnum.class.getName(), (String)rowObject.getRightBracket());
    }

    @Override
    protected void loadLogicSign(int rowIndex, RowObject rowObject) {
        BgEntityUtil.setEnumComboBoxField((KDTable)this.mainTable, (int)rowIndex, (int)5, (String)LogicSignEnum.class.getName(), (String)rowObject.getLogic());
    }

    @Override
    protected void formateColumn() throws BOSException, EASBizException {
        this.formateLeftSign();
        this.formateCondition();
        this.formateCompareSing();
        this.formateCompareValue();
        this.formateRightSing();
        this.formateLoginSing();
    }

    @Override
    protected void formateLeftSign() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = LeftBracketSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.mainTable.getColumn("leftBracketSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    @Override
    protected void formateCondition() throws BOSException, EASBizException {
        IBgBaseFacade facade = BgBaseFacadeFactory.getRemoteInstance();
        Object o = facade.getRuleCondition(this.bizBill);
        if (!(o instanceof List)) {
            return;
        }
        DefaultComboBoxModel<BgRuleCondition> model = new DefaultComboBoxModel<BgRuleCondition>();
        this.bizBillObject = (List)o;
        for (int index = 0; index < this.bizBillObject.size(); ++index) {
            model.addElement(this.bizBillObject.get(index));
        }
        this.mainTable.getColumn("condition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    @Override
    protected void formateCompareSing() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator it = CompareSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        KDComboBox comboBox = new KDComboBox(model);
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.YESTERDAY);
        comboBox.removeItem((Object)CompareSignEnum.TODAY);
        comboBox.removeItem((Object)CompareSignEnum.TOMORROW);
        comboBox.removeItem((Object)CompareSignEnum.LASTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.THISWEEK);
        comboBox.removeItem((Object)CompareSignEnum.NEXTWEEK);
        comboBox.removeItem((Object)CompareSignEnum.LASTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.THISMONTH);
        comboBox.removeItem((Object)CompareSignEnum.NEXTMONTH);
        comboBox.removeItem((Object)CompareSignEnum.BEFORETODAY);
        comboBox.removeItem((Object)CompareSignEnum.AFTERTODAY);
        comboBox.removeItem((Object)CompareSignEnum.FIELDEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGE);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLARGEEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESS);
        comboBox.removeItem((Object)CompareSignEnum.FIELDLESSEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.FIELDNOTEQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VAREQUAL);
        comboBox.removeItem((Object)CompareSignEnum.VARNOTEQUAL);
        this.mainTable.getColumn("compareSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    @Override
    protected void formateCompareValue() {
    }

    @Override
    protected void formateRightSing() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = RightBracketSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.mainTable.getColumn("rightBracketSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    @Override
    protected void formateLoginSing() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(" ");
        Iterator it = LogicSignEnum.iterator();
        while (it.hasNext()) {
            model.addElement((String)it.next());
        }
        this.mainTable.getColumn("loginSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(model)));
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddRow.setEnabled(true);
        this.btnDelRow.setEnabled(true);
        this.btnClearRow.setEnabled(true);
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnClearRow.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
    }

    protected Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    protected void setCurrentFilterInfo() throws BgControlException {
        this.mainTable.getEditManager().stopEditing();
        int rowCount = this.mainTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.mainTable.getRow(i);
                String leftBracket = BgEntityUtil.getValue((Object)iRow.getCell(0).getValue()).toString();
                BgRuleCondition bgRuleCondition = (BgRuleCondition)iRow.getCell(1).getValue();
                String condition = bgRuleCondition.getNumber();
                String compare = BgEntityUtil.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
                Object compareValue = null;
                if (iRow.getCell(3).getEditor() != null && iRow.getCell(3).getEditor().getComponent() != null) {
                    Object f7Data;
                    KDBizPromptBox promptBox;
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (obj instanceof KDBizPromptBox) {
                        promptBox = (KDBizPromptBox)obj;
                        f7Data = promptBox.getData();
                        if (f7Data instanceof String) {
                            compareValue = (String)f7Data;
                        } else if (f7Data instanceof DataObject) {
                            compareValue = ((DataObject)f7Data).getValue();
                        } else if (f7Data instanceof IObjectValue) {
                            IObjectValue objectValue = (IObjectValue)f7Data;
                            compareValue = BgEntityUtil.getValue((Object)objectValue.get(BgEntityUtil.getPropertyName((String)condition)));
                        } else if (f7Data instanceof Object[]) {
                            compareValue = promptBox.getEditFormatter().valueToString(f7Data);
                        } else if (f7Data instanceof Float) {
                            compareValue = f7Data;
                        } else if (f7Data instanceof Integer) {
                            compareValue = f7Data;
                        }
                    } else if (obj instanceof KDComboBox) {
                        promptBox = (KDComboBox)obj;
                        f7Data = promptBox.getSelectedItem();
                        if (f7Data != null && !"".equals(f7Data.toString())) {
                            List enumList;
                            BizEnumInfo _enum = BgEntityUtil.getEnum((String)f7Data.getClass().getName());
                            if (f7Data instanceof DynamicEnum && !StringUtils.isEmpty((String)((DynamicEnum)f7Data).getPK())) {
                                _enum = BgEntityUtil.getEnum((String)((DynamicEnum)f7Data).getPK());
                            }
                            if (_enum.getDataType().equals((Object)BizEnumValueType.STRING)) {
                                enumList = EnumUtils.getEnumList((String)f7Data.getClass().getName());
                                compareValue = enumList != null && !enumList.isEmpty() ? (enumList.get(0) instanceof IntEnum ? Integer.valueOf(((IntEnum)enumList.get(promptBox.getSelectedIndex() - 1)).getValue()) : _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue()) : _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue();
                            } else if (_enum.getDataType().equals((Object)BizEnumValueType.INTEGER) || _enum.getDataType().equals((Object)BizEnumValueType.FLOAT) || _enum.getDataType().equals((Object)BizEnumValueType.LONG) || _enum.getDataType().equals((Object)BizEnumValueType.DOUBLE)) {
                                enumList = EnumUtils.getEnumList((String)f7Data.getClass().getName());
                                compareValue = enumList != null && !enumList.isEmpty() ? (enumList.get(0) instanceof IntEnum ? Integer.valueOf(((IntEnum)enumList.get(promptBox.getSelectedIndex() - 1)).getValue()) : _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue()) : _enum.getEnumValue().get(promptBox.getSelectedIndex() - 1).getValue();
                                compareValue = compareValue.toString().indexOf(".") >= 0 ? (Number)new Float(compareValue.toString()) : (Number)new Integer(compareValue.toString());
                            }
                        }
                    } else {
                        compareValue = BgEntityUtil.getValue((Object)iRow.getCell(3).getValue());
                        if (compareValue instanceof Date) {
                            if (this.isomer) {
                                String[] end = this.vaildProperty(bgRuleCondition);
                                String type = this.tableMap.get(end[0]).get(end[1]);
                                compareValue = BgControlIsomerUtils.getDate((Date)compareValue, type);
                            } else {
                                EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)condition);
                                String targetProperty = BgEntityUtil.getPropertyName((String)condition);
                                String dateType = BgEntityUtil.getRefMetaData((EntityObjectInfo)targetEntity, (String)targetProperty).getName();
                                compareValue = BgEntityUtil.getDate((Date)((Date)compareValue), (String)dateType);
                            }
                        }
                    }
                } else {
                    compareValue = BgEntityUtil.getValue((Object)iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        if (this.isomer) {
                            String[] end = this.vaildProperty(bgRuleCondition);
                            String type = this.tableMap.get(end[0]).get(end[1]);
                            compareValue = BgControlIsomerUtils.getDate((Date)compareValue, type);
                        } else {
                            EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)condition);
                            String targetProperty = BgEntityUtil.getPropertyName((String)condition);
                            String dateType = BgEntityUtil.getRefMetaData((EntityObjectInfo)targetEntity, (String)targetProperty).getName();
                            compareValue = BgEntityUtil.getDate((Date)((Date)compareValue), (String)dateType);
                        }
                    }
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NULLSIGN) {
                    compareValue = null;
                }
                if (iRow.getCell(2).getValue() == CompareSignStringEnum.NOTNULLSIGN) {
                    compareValue = null;
                }
                String rightBracket = BgEntityUtil.getValue((Object)iRow.getCell(4).getValue()).toString();
                String logic = BgEntityUtil.getValue((Object)iRow.getCell(5).getValue()).toString().toLowerCase();
                if (StringUtils.isEmpty((String)logic) && i != rowCount - 1) {
                    logic = "and";
                    iRow.getCell(5).setValue((Object)LogicSignEnum.AND);
                }
                CompareSignEnum compareSignEnum = CompareSignEnum.getEnum((String)compare);
                if (compareValue != null && BgEntityUtil.isIncludeCompare((CompareSignEnum)compareSignEnum)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)BgEntityUtil.processIncludeValue((String)compareValue.toString()), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                } else if (condition != null && !"".equals(condition.trim().toString())) {
                    String dataInfoName = null;
                    String targetProperty = null;
                    if (this.isomer) {
                        String type;
                        String[] end = this.vaildProperty(bgRuleCondition);
                        dataInfoName = type = this.tableMap.get(end[0]).get(end[1]);
                    } else {
                        EntityObjectInfo targetEntity = BgEntityUtil.getEntity((EntityObjectInfo)this.getMainEntytyObject(), (String)condition);
                        DataObject dataInfo = BgEntityUtil.getRefMetaData((EntityObjectInfo)targetEntity, (String)(targetProperty = BgEntityUtil.getPropertyName((String)condition)));
                        if (dataInfo != null) {
                            dataInfoName = dataInfo.getName();
                        }
                    }
                    if (dataInfoName == null) {
                        String filterCond = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"filterCond");
                        String notExsit = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"notExsit");
                        MsgBox.showError((Component)((Object)this), (String)(filterCond + "\"" + targetProperty + "\"" + notExsit));
                        SysUtil.abort();
                    }
                    FilterItemInfo filterItemInfo = null;
                    if (dataInfoName.equals(DataType.SHORT.getName()) || dataInfoName.equals(DataType.INTEGER.getName()) || dataInfoName.equals(DataType.LONG.getName()) || dataInfoName.equals(DataType.FLOAT.getName()) || dataInfoName.equals(DataType.DOUBLE.getName()) || dataInfoName.equals(DataType.DECIMAL.getName())) {
                        if (compare.equalsIgnoreCase("IS")) {
                            compareValue = null;
                            compare = "=";
                        } else if (compare.equalsIgnoreCase("IS NOT")) {
                            compareValue = null;
                            compare = "<>";
                        } else if (compareValue != null && compareValue.toString().indexOf(".") >= 0) {
                            compareValue = new Float(compareValue.toString());
                        } else {
                            try {
                                BigInteger maxInteger;
                                if (compareValue != null && !StringUtils.isEmpty((String)compareValue.toString()) && ((BigInteger)(compareValue = new BigInteger(compareValue.toString()))).compareTo(maxInteger = new BigInteger(String.valueOf(Integer.MAX_VALUE))) == 1) {
                                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"noIntMax"));
                                    SysUtil.abort();
                                }
                            }
                            catch (NumberFormatException e) {
                                this.mainTable.requestFocusInWindow();
                                throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonQueryPanel", (String)"SolutionDefineError"));
                            }
                        }
                        filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    } else {
                        if (CompareType.LIKE.toString().equalsIgnoreCase(compare) || CompareType.NOTLIKE.toString().equalsIgnoreCase(compare)) {
                            if (null != compareValue) {
                                compareValue = "%" + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                            }
                        } else if ("LEFT LIKE".equalsIgnoreCase(compare)) {
                            if (null != compareValue) {
                                compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                                compare = CompareType.LIKE.toString();
                            }
                        } else if ("RIGHT LIKE".equalsIgnoreCase(compare)) {
                            if (null != compareValue) {
                                compareValue = "%" + compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "");
                                compare = CompareType.LIKE.toString();
                            }
                        } else if ("NOT LEFT LIKE".equalsIgnoreCase(compare)) {
                            if (null != compareValue) {
                                compareValue = compareValue.toString().replaceFirst("^%*", "").replaceFirst("%*$", "") + "%";
                                compare = CompareType.NOTLIKE.toString();
                            }
                        } else if (compare.equalsIgnoreCase("IS")) {
                            compareValue = null;
                            compare = "=";
                        } else if (compare.equalsIgnoreCase("IS NOT")) {
                            compareValue = null;
                            compare = "<>";
                        }
                        filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    }
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                }
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
        this.setCurrentFilterInfoDesc();
    }

    protected void setCurrentFilterInfoDesc() {
        int rowCount = this.mainTable.getRowCount();
        StringBuffer filterDesc = new StringBuffer();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.mainTable.getRow(i);
                String leftBracket = iRow.getCell(0).getValue() != null ? iRow.getCell(0).getValue().toString() : "";
                String condition = iRow.getCell(1).getValue() != null ? iRow.getCell(1).getValue().toString() + " " : "";
                String compare = iRow.getCell(2).getValue() != null ? iRow.getCell(2).getValue().toString() + " " : "";
                String compareValue = iRow.getCell(3).getValue() != null ? iRow.getCell(3).getValue().toString() + " " : "";
                String rightBracket = iRow.getCell(4).getValue() != null ? iRow.getCell(4).getValue().toString() : "";
                String logic = iRow.getCell(5).getValue() != null ? iRow.getCell(5).getValue().toString() : "";
                filterDesc.append(leftBracket).append(condition).append(compare).append(compareValue).append(rightBracket).append(logic);
            }
        }
        this.filterInfoDesc = filterDesc.toString();
    }

    @Override
    protected boolean isBlankRow(int rowIndex) {
        int columnSize = FILTER_COLUMN_CODEs.length;
        if (this.mainTable.getRow(rowIndex).getCell(1).getValue() == null) {
            return true;
        }
        for (int i = 0; i < columnSize; ++i) {
            if (BgEntityUtil.getValue((Object)this.mainTable.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    public String getBizBill() {
        return this.bizBill;
    }

    public void setBizBill(String bizBill) {
        this.bizBill = bizBill;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public String getFilterInfoDesc() {
        return this.filterInfoDesc;
    }

    public void setFilterInfoDesc(String filterInfoDesc) {
        this.filterInfoDesc = filterInfoDesc;
    }

    @Override
    public void verifyData() throws Exception {
        super.verifyData();
        int rowCount = this.mainTable.getRowCount();
        IRow row = null;
        String leftTmp = null;
        String rightTmp = null;
        Stack stack = new Stack();
        StringBuffer bracket = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            DataObject dao;
            row = this.mainTable.getRow(i);
            if (row.getCell("condition").getValue() == null && row.getCell("compareSign").getValue() == null && row.getCell("compareValue").getValue() == null) continue;
            if (row.getCell("condition").getValue() == null || row.getCell("compareSign").getValue() == null || row.getCell("compareValue").getValue() == null && !CompareSignEnum.NOTNULLSIGN.equals(row.getCell(2).getValue()) && !CompareSignEnum.NULLSIGN.equals(row.getCell(2).getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"conditionCompareNull", (Object[])new Object[]{new Integer(i + 1)}));
                SysUtil.abort();
            }
            if (row.getCell("leftBracketSign").getValue() != null && row.getCell("leftBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("leftBracketSign").getValue().toString()) || row.getCell("leftBracketSign").getValue() instanceof LeftBracketSignEnum && !StringUtils.isEmpty((String)((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue())) {
                leftTmp = ((LeftBracketSignEnum)row.getCell("leftBracketSign").getValue()).getValue();
                bracket.append(leftTmp);
            }
            if (row.getCell("rightBracketSign").getValue() != null && row.getCell("rightBracketSign").getValue() instanceof String && !StringUtils.isEmpty((String)row.getCell("rightBracketSign").getValue().toString()) || row.getCell("rightBracketSign").getValue() instanceof RightBracketSignEnum && !StringUtils.isEmpty((String)((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue())) {
                rightTmp = ((RightBracketSignEnum)row.getCell("rightBracketSign").getValue()).getValue();
                bracket.append(rightTmp);
            }
            if (row.getCell("compareValue").getValue() != null && row.getCell("compareValue").getUserObject() != null && row.getCell("compareValue").getUserObject() instanceof DataObject && (dao = (DataObject)row.getCell("compareValue").getUserObject()).getName().equalsIgnoreCase("bigDecimal")) {
                BigDecimal value = new BigDecimal(row.getCell("compareValue").getValue().toString());
                int compareValue = value.compareTo(BgNConstants.ZERO);
                if (compareValue > 0) {
                    if (BgNFSHelper.checkHasOverstepMax((BigDecimal)value)) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"dataMax", (Object[])new Object[]{new Integer(i + 1)}));
                        SysUtil.abort();
                    }
                } else if (compareValue < 0 && BgNFSHelper.checkHasOverstepMin((BigDecimal)value)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"dataMin", (Object[])new Object[]{new Integer(i + 1)}));
                    SysUtil.abort();
                }
            }
            if (i == rowCount - 1) {
                if (row.getCell(5).getValue() == null || row.getCell(5).getValue().toString().isEmpty()) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"logicSignException", (Object[])new Object[]{new Integer(i + 1)}));
                SysUtil.abort();
                continue;
            }
            if (row.getCell(5).getValue() != null && !row.getCell(5).getValue().toString().isEmpty()) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"logicSignException", (Object[])new Object[]{new Integer(i + 1)}));
            SysUtil.abort();
        }
        if (rowCount > 0 && !this.isValid(bracket.toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.control.client.BgControlResource", (String)"bracketNotFit"));
            SysUtil.abort();
        }
    }

    public boolean isValid(String s) {
        Stack<Character> stack = new Stack<Character>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '(') {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (stack.isEmpty()) {
                return false;
            }
            char topChar = ((Character)stack.pop()).charValue();
            if (c != ')' || topChar == '(') continue;
            return false;
        }
        return stack.isEmpty();
    }
}

