/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.control.BgCurrencyMappingFactory;
import com.kingdee.eas.ma.control.BgCurrencyMappingInfo;
import com.kingdee.eas.ma.control.BgExchangeRateSourceEnum;
import com.kingdee.eas.ma.control.client.AbstractBgCurrencyMappingEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgCurrencyMappingEditUI
extends AbstractBgCurrencyMappingEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgCurrencyMappingEditUI.class);
    public static final String RES = "com.kingdee.eas.ma.control.BgCurrencyMappingResource";
    private OrgUnitInfo orgUnitInfo = null;

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void onLoad() throws Exception {
        if (this.getOrgUnitInfo() == null) {
            this.setOrgUnitInfo((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        }
        super.onLoad();
        this.txtBgExchangeRate.setNegatived(false);
        this.txtBgExchangeRate.setMinimumValue((Comparable)Double.valueOf(1.0E-10));
        this.txtBgExchangeRate.setPrecision(10);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.comboBgExchangeRateSource.setSelectedItem((Object)BgExchangeRateSourceEnum.ExchangeRateTable);
        }
        this.setTxtBgExchangeRateEnable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew);
        BgCommCHelper.disableVisible((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
        BgCommCHelper.disableVisible((JButton)this.btnFirst, (JMenuItem)this.menuItemFirst);
        BgCommCHelper.disableVisible((JButton)this.btnPre, (JMenuItem)this.menuItemPre);
        BgCommCHelper.disableVisible((JButton)this.btnNext, (JMenuItem)this.menuItemNext);
        BgCommCHelper.disableVisible((JButton)this.btnLast, (JMenuItem)this.menuItemLast);
        BgCommCHelper.disableVisible((JButton)this.btnPageSetup, null);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.menuFile);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.menuEdit);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.MenuService);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.menuView);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.menuBiz);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.menuTool);
        BgCommCHelper.disableVisible(null, (JMenuItem)this.menuHelp);
    }

    public void verifyData() throws Exception {
        super.verifyData();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String checkStr;
        Object obj;
        super.verifyInput(e);
        String msg = null;
        Object billCurrency = this.prmtBillCurrency.getData();
        Object bgCurrency = this.prmtBgCurrency.getData();
        if (billCurrency == null) {
            msg = BgCommCHelper.getMessageStr((String)RES, (String)"billCurrency_null");
        } else if (bgCurrency == null) {
            msg = BgCommCHelper.getMessageStr((String)RES, (String)"bgCurrency_null");
        } else if (billCurrency instanceof CurrencyInfo && bgCurrency instanceof CurrencyInfo && ((CurrencyInfo)billCurrency).getId().equals((Object)((CurrencyInfo)bgCurrency).getId())) {
            msg = BgCommCHelper.getMessageStr((String)RES, (String)"billCurrency_bgCurrency_equals");
        }
        if (StringUtils.isEmpty((String)msg) && (obj = this.comboBgExchangeRateSource.getSelectedItem()) != null && ((BgExchangeRateSourceEnum)((Object)obj)).getValue() == 2 && this.txtBgExchangeRate.getNumberValue() == null) {
            msg = BgCommCHelper.getMessageStr((String)RES, (String)"rate_null");
        }
        if (StringUtils.isEmpty((String)msg) && this.pkEnabledDate.getValue() == null) {
            msg = BgCommCHelper.getMessageStr((String)RES, (String)"enabledDate_null");
        }
        if (StringUtils.isEmpty((String)msg) && !StringUtils.isEmpty((String)(checkStr = BgCurrencyMappingFactory.getRemoteInstance().check(this.editData)))) {
            msg = checkStr;
        }
        if (!StringUtils.isEmpty((String)msg)) {
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
    }

    @Override
    protected void comboBgExchangeRateSource_actionPerformed(ActionEvent e) throws Exception {
        super.comboBgExchangeRateSource_actionPerformed(e);
    }

    @Override
    protected void comboBgExchangeRateSource_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgExchangeRateSource_itemStateChanged(e);
        this.setTxtBgExchangeRateEnable();
    }

    private void setTxtBgExchangeRateEnable() {
        if (this.comboBgExchangeRateSource.getSelectedItem() != null && this.comboBgExchangeRateSource.getSelectedItem().equals((Object)BgExchangeRateSourceEnum.ExchangeRateTable)) {
            this.txtBgExchangeRate.setEnabled(false);
            this.txtBgExchangeRate.setNumberValue(null);
        } else {
            this.txtBgExchangeRate.setEnabled(true);
        }
    }

    protected IObjectValue createNewData() {
        BgCurrencyMappingInfo info = new BgCurrencyMappingInfo();
        info.setEnabledDate(new Date());
        if (this.getOrgUnitInfo() != null) {
            info.setOrgUnit(this.getOrgUnitInfo().castToFullOrgUnitInfo());
            info.setCreateOrgUnit(info.getOrgUnit());
        }
        info.setRoot(info);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCurrencyMappingFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        return sic;
    }
}

