/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.DivSpanPanel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.client.AbstractBgDataAnalyseLayoutUI;
import com.kingdee.eas.ma.control.client.MBgDataAnalyseFilter1UI;
import com.kingdee.eas.ma.control.client.MBgDataAnalyseListUI;
import com.kingdee.eas.ma.control.client.MbgBackGroudTipsText;
import com.kingdee.eas.ma.mbg.BgDataAnalyseLayoutSettingCollection;
import com.kingdee.eas.ma.mbg.BgDataAnalyseLayoutSettingFactory;
import com.kingdee.eas.ma.mbg.BgDataAnalyseLayoutSettingInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.client.common.ComponentDragSourceForMBGView;
import com.kingdee.eas.ma.mbg.client.common.DimensionTargetSubject;
import com.kingdee.eas.ma.mbg.client.common.MbgBackgroupTextBorder;
import com.kingdee.eas.ma.mbg.client.common.PanelDropTargetForViewList;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class BgDataAnalyseLayoutUI
extends AbstractBgDataAnalyseLayoutUI
implements PanelDropTargetForViewList.IGetComponent {
    private static final Logger logger = CoreUIObject.getLogger(BgDataAnalyseLayoutUI.class);
    private Map<String, MbgViewListDimensionInfo> dimComponentMap = new HashMap<String, MbgViewListDimensionInfo>();
    private Map<String, KDWorkButton> componentMap = new HashMap<String, KDWorkButton>();
    private DivSpanPanel dsp = new DivSpanPanel();
    private DimensionTargetSubject layoutSubject = new DimensionTargetSubject();
    ContainerListener cl = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        private void fireSpanChanged() {
            int r = BgDataAnalyseLayoutUI.this.pnlLeftBottom.getComponentCount();
            int c = BgDataAnalyseLayoutUI.this.pnlRightTop.getComponentCount();
            String[] rows = new String[r];
            String[] cols = new String[c];
            BgDataAnalyseLayoutUI.this.dsp.setDiv(rows, cols);
            BgDataAnalyseLayoutUI.this.dsp.updateUI();
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.enableEvents(64L);
        this.setTextBorder((JComponent)this.pnlLeftBottom, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"rowDimensionDes"));
        this.setTextBorder((JComponent)this.pnlRightTop, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"colDimensionDes"));
        this.setTextBorder((JComponent)this.pnlRightBottom, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"dataField"));
        String tips = EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"tips");
        this.kdTips.setText(tips);
        this.kdTips.setEditable(false);
        this.kdTips.setFocusable(false);
        this.pnlLeftBottom.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlLeftBottom.setName(Integer.toString(3));
        this.pnlRightTop.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlRightTop.setName(Integer.toString(4));
        new PanelDropTargetForViewList((PanelDropTargetForViewList.IGetComponent)this, (JPanel)this.pnlLeftBottom, 4, null, false);
        new PanelDropTargetForViewList((PanelDropTargetForViewList.IGetComponent)this, (JPanel)this.pnlRightTop, 3, null, false);
        this.pnlLeftBottom.addContainerListener(this.cl);
        this.pnlRightTop.addContainerListener(this.cl);
    }

    protected void setTextBorder(JComponent comp, String text) {
        if (comp != null && !(comp.getBorder() instanceof MbgBackgroupTextBorder)) {
            comp.setBorder((Border)new MbgBackgroupTextBorder(comp, text));
        }
    }

    protected void setTextBorder4Tips(JComponent comp, String text) {
        if (comp != null && !(comp.getBorder() instanceof MbgBackGroudTipsText)) {
            comp.setBorder(new MbgBackGroudTipsText(comp, text));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            MbgViewListDimensionManager iDimensionManager = this.getDimensionManager();
            HashSet usedDiemnsionNum = new HashSet();
            this.loadDimensionsToUI(iDimensionManager, usedDiemnsionNum);
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"layoutError"));
            e.printStackTrace();
        }
    }

    protected void loadDimensionsToUI(MbgViewListDimensionManager iDimensionManager, Set usedDiemnsionNum) {
        this.loadLayout(iDimensionManager.getRowDimension(), this.pnlLeftBottom, usedDiemnsionNum);
        this.loadLayout(iDimensionManager.getColDimension(), this.pnlRightTop, usedDiemnsionNum);
    }

    protected void loadLayout(List viewDimensions, KDPanel pnl, Set usedDiemnsionNum) {
        MbgViewListDimensionInfo bgDimensionInfo = null;
        for (int i = 0; i < viewDimensions.size(); ++i) {
            bgDimensionInfo = (MbgViewListDimensionInfo)viewDimensions.get(i);
            KDWorkButton btn = new KDWorkButton();
            btn.setText(bgDimensionInfo.getName());
            btn.setName(bgDimensionInfo.getNumber());
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(bgDimensionInfo.getNumber())) {
                btn.setVisible(false);
            }
            int type = 2;
            ComponentDragSourceForMBGView.createDragSource((Component)btn, (Object)bgDimensionInfo, (int)type);
            pnl.add((Component)btn, null);
            usedDiemnsionNum.add(bgDimensionInfo.getNumber());
            this.dimComponentMap.put(bgDimensionInfo.getNumber(), bgDimensionInfo);
            this.componentMap.put(bgDimensionInfo.getNumber(), btn);
        }
    }

    private void addDimension(MbgViewListDimensionManager iDimensionManager, MbgViewListDimensionInfo bgDimensionInfo, String layout) {
        bgDimensionInfo = bgDimensionInfo.clone();
        bgDimensionInfo.setDimensionManager((IBgDimensionManagerBase)iDimensionManager);
        bgDimensionInfo.getMember().clear();
        bgDimensionInfo.setLayout(layout);
        iDimensionManager.addDimensionInfo((BgDimensionBaseInfo)bgDimensionInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private List<MbgViewListDimensionInfo> getRowDimensions(boolean isContainCurrency) {
        return this.getDimension(this.pnlLeftBottom, isContainCurrency);
    }

    private List<MbgViewListDimensionInfo> getColDimensions() {
        return this.getDimension(this.pnlRightTop, true);
    }

    private List<MbgViewListDimensionInfo> getAllDimensions() {
        ArrayList<MbgViewListDimensionInfo> list = new ArrayList<MbgViewListDimensionInfo>();
        list.addAll(this.getRowDimensions(true));
        list.addAll(this.getColDimensions());
        return list;
    }

    private List<MbgViewListDimensionInfo> getDimension(KDPanel parent, boolean isContainCurrency) {
        ArrayList<MbgViewListDimensionInfo> hList = new ArrayList<MbgViewListDimensionInfo>();
        int currencyIndex = -1;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            if (!isContainCurrency && DimensionConstants.DEF_CURRENCY_NUMBER.equals(c.getName())) continue;
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(c.getName())) {
                currencyIndex = i;
            }
            if (!this.dimComponentMap.containsKey(c.getName())) continue;
            hList.add(this.dimComponentMap.get(c.getName()));
        }
        if (currencyIndex != -1) {
            MbgViewListDimensionInfo remove = (MbgViewListDimensionInfo)hList.remove(currencyIndex);
            hList.add(remove);
        }
        return hList;
    }

    public void verifyData() throws Exception {
        List<MbgViewListDimensionInfo> rowDimensions = this.getRowDimensions(false);
        if (rowDimensions == null || rowDimensions.size() == 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
        List<MbgViewListDimensionInfo> colDimensions = this.getColDimensions();
        if (colDimensions == null || colDimensions.size() == 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
        boolean isExistsScen = false;
        for (int i = 0; i < colDimensions.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo = colDimensions.get(i);
            String dimNumber = mbgViewListDimensionInfo.getNumber();
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimNumber)) continue;
            isExistsScen = true;
        }
        if (!isExistsScen) {
            throw new TemplateException(TemplateException.SCENONCOL);
        }
    }

    public MbgViewListDimensionManager getDimensionManager() throws Exception {
        return ((MbgViewListSheetManager)this.getOwnerUI().getCurDimensionManager().getSheetManagers().get(0)).getDimensionManager();
    }

    private MBgDataAnalyseListUI getOwnerUI() {
        return (MBgDataAnalyseListUI)((Object)this.getUIContext().get("Owner"));
    }

    public DimensionTargetSubject getLayoutSubject() {
        return this.layoutSubject;
    }

    private String getBgSchemeId() {
        MBgDataAnalyseFilter1UI filterUI = (MBgDataAnalyseFilter1UI)this.getOwnerUI().getFilterUI();
        return filterUI.getBgScehemeId();
    }

    private BgSchemeInfo getBgSceheme() throws EASBizException, BOSException {
        MBgDataAnalyseFilter1UI filterUI = (MBgDataAnalyseFilter1UI)this.getOwnerUI().getFilterUI();
        return filterUI.getBgScheme();
    }

    public JComponent getDimensionComponent(Object dimension) {
        if (dimension instanceof MbgViewListDimensionInfo) {
            return (JComponent)this.componentMap.get(((MbgViewListDimensionInfo)dimension).getNumber());
        }
        return null;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        boolean isCheck = ((MBgDataAnalyseFilter1UI)this.getOwnerUI().getFilterUI()).check();
        if (!isCheck) {
            return;
        }
        this.verifyData();
        BgDataAnalyseLayoutSettingInfo layoutInfo = this.getLayoutInfo();
        if (layoutInfo == null) {
            layoutInfo = this.createLayoutInfo();
        } else {
            this.resetRowCol(layoutInfo);
        }
        this.saveLayoutInfo(layoutInfo);
        this.getOwnerUI().executeQuery();
        this.uiWindow.close();
    }

    private void saveLayoutInfo(BgDataAnalyseLayoutSettingInfo layoutInfo) throws BOSException, EASBizException {
        layoutInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
        BgDataAnalyseLayoutSettingFactory.getRemoteInstance().submit((CoreBaseInfo)layoutInfo);
    }

    private BgDataAnalyseLayoutSettingInfo getLayoutInfo() throws BOSException, EASBizException {
        BgDataAnalyseLayoutSettingCollection bgDataAnalyseLayoutSettingCollection = BgDataAnalyseLayoutSettingFactory.getRemoteInstance().getBgDataAnalyseLayoutSettingCollection("select rows, cols where user.id = '" + this.getUserId() + "' and bgScheme.id = '" + this.getBgSchemeId() + "'");
        if (bgDataAnalyseLayoutSettingCollection != null && bgDataAnalyseLayoutSettingCollection.isEmpty()) {
            return null;
        }
        return bgDataAnalyseLayoutSettingCollection.get(0);
    }

    private String getUserId() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        return user.getId().toString();
    }

    private BgDataAnalyseLayoutSettingInfo createLayoutInfo() throws EASBizException, BOSException {
        BgDataAnalyseLayoutSettingInfo layoutInfo = new BgDataAnalyseLayoutSettingInfo();
        this.resetRowCol(layoutInfo);
        return layoutInfo;
    }

    private void resetRowCol(BgDataAnalyseLayoutSettingInfo layoutInfo) throws EASBizException, BOSException {
        layoutInfo.setBgScheme(this.getBgSceheme());
        List<MbgViewListDimensionInfo> rowDimensions = this.getRowDimensions(true);
        StringBuilder numebers = new StringBuilder();
        if (rowDimensions != null && rowDimensions.size() != 0) {
            for (int i = 0; i < rowDimensions.size(); ++i) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = rowDimensions.get(i);
                if (i == rowDimensions.size() - 1) {
                    numebers.append(mbgViewListDimensionInfo.getNumber());
                    continue;
                }
                numebers.append(mbgViewListDimensionInfo.getNumber());
                numebers.append("!");
            }
        }
        layoutInfo.setRows(numebers.toString());
        numebers = new StringBuilder();
        List<MbgViewListDimensionInfo> colDimensions = this.getColDimensions();
        if (colDimensions != null && colDimensions.size() != 0) {
            for (int i = 0; i < colDimensions.size(); ++i) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = colDimensions.get(i);
                if (i == colDimensions.size() - 1) {
                    numebers.append(mbgViewListDimensionInfo.getNumber());
                    continue;
                }
                numebers.append(mbgViewListDimensionInfo.getNumber());
                numebers.append("!");
            }
        }
        layoutInfo.setCols(numebers.toString());
    }
}

