/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.client.utils.BgKDComboBox;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.IBgControlSchemeFacade;
import com.kingdee.eas.ma.control.client.AbstractBgDimItemSetUI;
import com.kingdee.eas.ma.control.client.BgDimSelectDialog;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgDimItemSetUI
extends AbstractBgDimItemSetUI {
    private static final long serialVersionUID = 5216294092868272445L;
    private static final Logger logger = CoreUIObject.getLogger(BgDimItemSetUI.class);
    private OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private Map<String, MbgDimInfo> mbgDims = null;
    private DefaultBizUnitPorp defaultPorp = new DefaultBizUnitPorp();
    private boolean isCanceled = false;
    private String bizSystem = null;
    private String bizUnit = null;
    private BizDataObject bizData = null;
    private Set<String> filterData = null;
    private Set<String> inCludeData = null;

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public Map<String, MbgDimInfo> getMbgDims() {
        if (this.mbgDims == null) {
            try {
                this.mbgDims = DimUtils.getDimInfoMap(null);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.mbgDims = new HashMap<String, MbgDimInfo>();
            }
        }
        return this.mbgDims;
    }

    public DefaultBizUnitPorp getDefaultPorp() {
        return this.defaultPorp;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setBizSystem(String bizSystem) {
        this.bizSystem = bizSystem;
    }

    public String getBizSystem() {
        return this.bizSystem;
    }

    public void setBizUnit(String bizUnit) {
        this.bizUnit = bizUnit;
    }

    public String getBizUnit() {
        return this.bizUnit;
    }

    public BizDataObject getBizData() {
        return this.bizData;
    }

    public void setBizData(BizDataObject bizData) {
        this.bizData = bizData;
    }

    public void setFilterData(Set<String> filterData) {
        this.filterData = filterData;
    }

    public Set<String> getFilterData() {
        return this.filterData;
    }

    public void setInCludeData(Set<String> inCludeData) {
        this.inCludeData = inCludeData;
    }

    public Set<String> getInCludeData() {
        return this.inCludeData;
    }

    public void onLoad() throws Exception {
        this.tblDimItem.checkParsed();
        super.onLoad();
        this.tblDimItem.getColumn("dimItem").setRequired(true);
        this.initData();
        this.showBizData();
        this.btnClearAllRows.setEnabled(true);
        this.btnClearAllRows.setVisible(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddnew.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnClearAllRows.setEnabled(true);
        this.btnAddnew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnClearAllRows.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void initData() throws Exception {
        this.tblDimItem.checkParsed();
        this.setBizSystem((String)this.getUIContext().get(BgControlConstants.bizSystem));
        this.setBizUnit((String)this.getUIContext().get(BgControlConstants.bizUnit));
        this.setBizData((BizDataObject)this.getUIContext().get(BgControlConstants.bizData));
        this.setFilterData((Set)this.getUIContext().get(BgControlConstants.filterSrc));
        this.setInCludeData((Set)this.getUIContext().get(BgControlConstants.inCludeSrc));
        this.initBizItem(this.getBizSystem(), this.getBizUnit());
        this.initBizDim();
    }

    public void reShow() throws Exception {
        this.initBizItem(this.getBizSystem(), this.getBizUnit());
        this.initBizDim();
        this.showBizData();
    }

    protected void initBizItem(String bizSystem, String bizUnit) throws Exception {
        BgKDComboBox combox = new BgKDComboBox();
        if (!StringUtils.isEmpty((String)bizSystem) && !StringUtils.isEmpty((String)bizUnit)) {
            List<BizDataObject> bizProps = BizDataObject.transData(this.getFacadeInterface().getBiz(bizSystem, bizUnit, 2));
            combox.addItems(bizProps.toArray());
            if (bizProps.size() > 0) {
                this.getDefaultPorp().setDefItem(bizProps.get(0));
            }
        }
        this.tblDimItem.getColumn("billFields").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combox));
    }

    protected void initBizDim() throws Exception {
        BizDataObject defaultProp = null;
        ArrayList<BizDataObject> showBizProps = new ArrayList<BizDataObject>();
        List bizProps = this.getFacadeInterface().getMbgDim(false, this.getOrgUnitInfo().getId());
        if (bizProps != null) {
            BizDataObject obj = null;
            Iterator it = bizProps.iterator();
            while (it.hasNext()) {
                obj = (BizDataObject)it.next();
                if (!DimensionConstants.DEF_CSL_SRCNUMBER.equals(obj.getValue())) continue;
                it.remove();
            }
        }
        bizProps.add(this.getBgDimItemBizData());
        if (this.getInCludeData() != null && !this.getInCludeData().isEmpty()) {
            int in = bizProps.size();
            for (int i = 0; i < in; ++i) {
                if (!this.getInCludeData().contains(((BizDataObject)bizProps.get(i)).getValue())) continue;
                showBizProps.add((BizDataObject)bizProps.get(i));
                if (defaultProp != null) continue;
                defaultProp = (BizDataObject)bizProps.get(i);
            }
        } else if (this.getFilterData() != null && !this.getFilterData().isEmpty()) {
            int in = bizProps.size();
            for (int i = 0; i < in; ++i) {
                if (this.getFilterData().contains(((BizDataObject)bizProps.get(i)).getValue())) continue;
                showBizProps.add((BizDataObject)bizProps.get(i));
                if (defaultProp != null) continue;
                defaultProp = (BizDataObject)bizProps.get(i);
            }
        } else {
            showBizProps.addAll(bizProps);
            defaultProp = (BizDataObject)bizProps.get(0);
        }
        if (bizProps.size() > 0) {
            this.getDefaultPorp().setDefDim(defaultProp);
        }
        BgDimSelectDialog dialog = new BgDimSelectDialog((IUIObject)this, showBizProps);
        KDBizPromptBox bizBox = new KDBizPromptBox();
        bizBox.setSelector((KDPromptSelector)dialog);
        bizBox.setEditable(false);
        this.tblDimItem.getColumn("dimItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBox));
        this.tblDimItem.getColumn("dimItem").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object instanceof BizDataObject) {
                    BizDataObject obj = (BizDataObject)object;
                    if (obj != null && obj.getValue() != null) {
                        if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(obj.getValue())) {
                            TextRender.sharedInstance().draw(graphics, clip, DimensionConstants.DEF_ACCOUNT_MAME + "(" + DimensionConstants.DEF_ACCOUNT_NUMBER + ")", cellStyle);
                        } else if (BgDimItemSetUI.this.getMbgDims().containsKey(obj.getValue())) {
                            TextRender.sharedInstance().draw(graphics, clip, BgDimItemSetUI.this.getMbgDims().get(obj.getValue()).getName() + "(" + BgDimItemSetUI.this.getMbgDims().get(obj.getValue()).getNumber() + ")", cellStyle);
                        } else if (object != null) {
                            TextRender.sharedInstance().draw(graphics, clip, object.toString(), cellStyle);
                        }
                    } else if (object != null) {
                        TextRender.sharedInstance().draw(graphics, clip, object.toString(), cellStyle);
                    }
                } else if (object != null) {
                    TextRender.sharedInstance().draw(graphics, clip, object.toString(), cellStyle);
                }
            }
        });
    }

    protected IBgControlSchemeFacade getFacadeInterface() throws Exception {
        return BgControlSchemeFacadeFactory.getRemoteInstance();
    }

    protected BizDataObject getBgDimItemBizData() {
        BizDataObject dimBizData = new BizDataObject();
        dimBizData.setValue("bgDimNum");
        dimBizData.setDisplay(EASResource.getString((String)BgControlConstants.CONTROL_RES, (String)"bgDimNum"));
        return dimBizData;
    }

    public BizDataObject getData() {
        return this.getBizData();
    }

    public void showBizData() {
        this.tblDimItem.removeRows();
        if (this.getBizData() == null) {
            this.addDefaultBizData();
        } else {
            this.parseBizData(this.getBizData());
        }
    }

    @Override
    protected void btnAddnew_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddnew_actionPerformed(e);
        this.addDefaultBizData();
    }

    protected void addDefaultBizData() {
        IRow row = this.tblDimItem.addRow();
        if (row != null) {
            if (this.getDefaultPorp().getDefItem() != null) {
                row.getCell("billFields").setValue((Object)this.getDefaultPorp().getDefItem());
            }
            if (this.getDefaultPorp().getDefDim() != null) {
                row.getCell("dimItem").setValue((Object)this.getDefaultPorp().getDefDim());
            }
        }
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
        BgCommCHelper.removeRows((KDTable)this.tblDimItem, (List)BgCommCHelper.getSelectRowIndexes((KDTable)this.tblDimItem));
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        this.verifyData();
        this.setBizData(this.getBizDimItemInfo());
        this.getUIWindow().close();
    }

    public void verifyData() throws Exception {
        HashSet<String> ZJCheckSet = new HashSet<String>();
        ZJCheckSet.add("mbgNumber");
        ZJCheckSet.add("mbgnumber");
        ZJCheckSet.add("mbgNumberIn");
        ZJCheckSet.add("mbgNumberOut");
        IRow row = null;
        BizDataObject srcProp = null;
        BizDataObject distProp = null;
        HashSet<String> fields = new HashSet<String>();
        HashSet<String> dims = new HashSet<String>();
        boolean hasIndex = false;
        int in = this.tblDimItem.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblDimItem.getRow(i);
            if (row.getCell("billFields").getValue() instanceof BizDataObject) {
                srcProp = (BizDataObject)row.getCell("billFields").getValue();
                if (fields.contains(srcProp.getValue())) {
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"RepeatItem"), srcProp.getDisplay()));
                    SysUtil.abort();
                } else {
                    fields.add(srcProp.getValue());
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"ItemIsNull"));
                SysUtil.abort();
            }
            if (row.getCell("dimItem").getValue() instanceof BizDataObject) {
                distProp = (BizDataObject)row.getCell("dimItem").getValue();
                if (distProp.getValue().equals(DimensionBaseConstants.DEF_INDEX_SRCNUMBER)) {
                    hasIndex = true;
                } else if (distProp.getValue().equals("bgDimNum")) {
                    if (null == srcProp || srcProp.getValue() != null && (srcProp.getValue().endsWith("mbgNumber") || srcProp.getValue().endsWith("mbgnumber") || srcProp.getValue().endsWith("mbgNumberIn") || srcProp.getValue().endsWith("mbgNumberOut") || srcProp.getValue().endsWith(".mbgNumber"))) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"checkZJDimItem"));
                    SysUtil.abort();
                } else {
                    if (null == srcProp || null == srcProp.getValue()) continue;
                    if (ZJCheckSet.contains(srcProp.getValue()) || srcProp.getValue().endsWith(".mbgNumber")) {
                        MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"checkZJDimItem"));
                        SysUtil.abort();
                    }
                }
                MbgDimInfo mbgDim = this.getMbgDims().get(distProp.getValue());
                if (mbgDim == null) continue;
                if (dims.contains(mbgDim.getNumber())) {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"ReportDim", (Object[])new Object[]{mbgDim.getName()}));
                    SysUtil.abort();
                    continue;
                }
                dims.add(mbgDim.getNumber());
                continue;
            }
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"DimIsNull"));
            SysUtil.abort();
        }
        if (!hasIndex) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"selectIndexDim"));
            SysUtil.abort();
        }
    }

    public BizDataObject getBizDimItemInfo() {
        IRow row = null;
        BizDataObject bizField = null;
        BizDataObject bizDim = null;
        BizDataObject bizData = new BizDataObject();
        int in = this.tblDimItem.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblDimItem.getRow(i);
            bizField = (BizDataObject)row.getCell("billFields").getValue();
            bizDim = (BizDataObject)row.getCell("dimItem").getValue();
            if (bizData.getValue() == null) {
                bizData.setDisplay(bizField.getDisplay() + "|" + bizDim.getDisplay());
                bizData.setValue(bizField.getValue() + "|" + bizDim.getValue());
                continue;
            }
            bizData.setDisplay(bizData.getDisplay() + "@" + bizField.getDisplay() + "|" + bizDim.getDisplay());
            bizData.setValue(bizData.getValue() + "@" + bizField.getValue() + "|" + bizDim.getValue());
        }
        return bizData;
    }

    protected void parseBizData(BizDataObject bizData) {
        if (bizData == null) {
            return;
        }
        String[] bizShow = bizData.getDisplay().split("@");
        String[] bizVals = bizData.getValue().split("@");
        if (bizShow != null && bizVals != null && bizShow.length == bizVals.length) {
            IRow row = null;
            String[] tmpStrs = null;
            BizDataObject bizField = null;
            BizDataObject bizDim = null;
            int in = bizShow.length;
            for (int i = 0; i < in; ++i) {
                bizField = new BizDataObject();
                bizDim = new BizDataObject();
                tmpStrs = bizShow[i].split("\\|");
                bizField.setDisplay(tmpStrs[0]);
                bizDim.setDisplay(tmpStrs[1]);
                tmpStrs = bizVals[i].split("\\|");
                bizField.setValue(tmpStrs[0]);
                bizDim.setValue(tmpStrs[1]);
                row = this.tblDimItem.addRow();
                if (row == null) continue;
                row.getCell("billFields").setValue((Object)this.getItem(bizField, row, "billFields"));
                row.getCell("dimItem").setValue((Object)this.getItem(bizDim, row, "dimItem"));
            }
        }
    }

    private BizDataObject getItem(BizDataObject bizDim, IRow row, String key) {
        ICellEditor editor = this.tblDimItem.getColumn(key).getEditor();
        if (editor == null) {
            row.getCell(key).setValue((Object)bizDim);
        } else {
            KDBizPromptBox bizBox;
            Component component = editor.getComponent();
            if (component != null && component instanceof KDComboBox) {
                KDComboBox kdComboBox = (KDComboBox)component;
                for (int i = 0; i < kdComboBox.getItemCount(); ++i) {
                    BizDataObject itemAt = (BizDataObject)kdComboBox.getItemAt(i);
                    if (itemAt == null || !bizDim.getValue().equals(itemAt.getValue())) continue;
                    return itemAt;
                }
            } else if (component != null && component instanceof KDBizPromptBox && (bizBox = (KDBizPromptBox)component).getData() == null) {
                bizBox.setDataNoNotify((Object)bizDim);
            }
        }
        return bizDim;
    }

    @Override
    public void actionDelAllRows_actionPerformed(ActionEvent e) throws Exception {
        this.tblDimItem.removeRows();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (this.getBizSystem() == null) {
                this.setBizSystem((String)this.getUIContext().get(BgControlConstants.bizSystem));
            }
            if (this.getBizUnit() == null) {
                this.setBizUnit((String)this.getUIContext().get(BgControlConstants.bizUnit));
            }
            request.put(BgControlConstants.bizSystem, (Object)this.getBizSystem());
            request.put(BgControlConstants.bizUnit, (Object)this.getBizUnit());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getOrgUnitInfo().getId().toString());
        }
        return handler;
    }

    class DefaultBizUnitPorp {
        private BizDataObject defItem = null;
        private BizDataObject defDim = null;

        DefaultBizUnitPorp() {
        }

        public void setDefItem(BizDataObject defItem) {
            this.defItem = defItem;
        }

        public BizDataObject getDefItem() {
            return this.defItem;
        }

        public void setDefDim(BizDataObject defDim) {
            this.defDim = defDim;
        }

        public BizDataObject getDefDim() {
            return this.defDim;
        }
    }
}

