/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MbgBackGroudTipsText
implements Border {
    private JComponent source;
    private String text;
    private Border border;

    public MbgBackGroudTipsText(JComponent source, String text) {
        this.source = source;
        this.text = text;
        this.border = source.getBorder();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.source != null) {
            if (this.text != null && this.text.length() > 0) {
                Rectangle2D textRect = g.getFontMetrics().getStringBounds(this.text, g);
                g.drawString(this.text, x + width / 2 - (int)textRect.getCenterX(), y + height / 2 - (int)textRect.getCenterY());
            }
            if (this.border != null) {
                this.border.paintBorder(c, g, x, y, width, height);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.border != null) {
            return this.border.getBorderInsets(c);
        }
        return this.source.insets();
    }

    @Override
    public boolean isBorderOpaque() {
        if (this.border != null) {
            return this.border.isBorderOpaque();
        }
        return false;
    }
}

