/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.control.BgCtrlSetRuleEnum;
import com.kingdee.eas.ma.control.BgCtrlValueEnum;
import com.kingdee.eas.ma.control.client.AbstractMbgExpandDetialUI;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgExpandDetialUI
extends AbstractMbgExpandDetialUI {
    private static final long serialVersionUID = 6227723390385120382L;
    private static final Logger logger = CoreUIObject.getLogger(MbgExpandDetialUI.class);
    private static final String COL_account = "account";
    private static final String COL_mbgDim = "mbgDim";
    private static final String COL_bgPeriod = "bgPeriod";
    private static final String COL_budgetValue = "budgetValue";
    private static final String COL_transitBudgetValue = "transitBudget";
    private static final String COL_flexTransitBudgetValue = "flexTransitBudget";
    private static final String COL_flexParam = "flexParam";
    private static final String COL_actualValue = "actualValue";
    private static final String COL_CtrlParam_ctrlType = "ctrlType";
    private static final String COL_CtrlParam_ctrlParam = "ctrlParam";
    private static final String COL_CtrlParam_ctrlFormula = "ctrlFormula";
    private BgCellRenderHelper cellHelper = new BgCellRenderHelper();
    private boolean isLoadTransitBudget;
    private String accountViewId = null;

    public String getAccountViewId() {
        return this.accountViewId;
    }

    public BgCellRenderHelper getCellHelper() {
        return this.cellHelper;
    }

    @Override
    protected void txtClose_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.isLoadTransitBudget = BgParamCHelper.isLoadTransitBudget();
        super.onLoad();
        this.getCellHelper().init();
        this.loadExpandInfo();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblCtrlData.checkParsed();
        this.tblCtrlData.setEditable(false);
        this.tblCtrlData.getColumn(COL_flexTransitBudgetValue).getStyleAttributes().setHided(!this.isLoadTransitBudget);
        this.tblCtrlData.getColumn(COL_transitBudgetValue).getStyleAttributes().setHided(!this.isLoadTransitBudget);
        this.tblReqData.checkParsed();
        this.tblReqData.setEditable(false);
        this.tblReqData.getColumn(COL_flexTransitBudgetValue).getStyleAttributes().setHided(!this.isLoadTransitBudget);
        this.tblReqData.getColumn(COL_transitBudgetValue).getStyleAttributes().setHided(!this.isLoadTransitBudget);
        this.tblCtrlParam.checkParsed();
        this.tblCtrlParam.setEditable(false);
        this.tblCtrlParam.setAutoscrolls(false);
        this.tblCtrlParam.setScrollStateHorizon(1);
        this.tblCtrlParam.setScrollStateVertical(1);
        this.tblCtrlParam.getIndexColumn().getStyleAttributes().setHided(true);
    }

    private void loadExpandInfo() throws EASBizException, BOSException {
        BgControlParam param = (BgControlParam)this.getUIContext().get(BgControlParam.class);
        this.accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((BgSchemeInfo)param.getBgSchemeInfo());
        this.txtCtrlValue.setText(param.getExpandInfo().getBgCtrlValue().toString());
        this.txtCtrlRule.setText(param.getExpandInfo().getBgReqRule().toString());
        if (param.getExpandInfo().isIsGroup()) {
            this.txtCtrlRule.setText(this.txtCtrlRule.getText() + ", " + EASResource.getString((String)BgControlConstants.CONTROL_SOURCE, (String)"expandGroup"));
        }
        this.setControlSetting(param, this.txtReqDimenCtrlSet);
        this.setControlSetting(param.getExpandCtrlParam(), this.txtCtrlDimenCtrlSet);
        int precision = 2;
        if (param.getCurrency() != null) {
            precision = param.getCurrency().getPrecision();
        }
        DecimalFormat bigDecimalFormula = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
        if (param.getExpandBalance() != null) {
            this.txtBalance.setText(bigDecimalFormula.format(param.getExpandBalance()));
        }
        this.tblReqData.getColumn(COL_budgetValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblReqData.getColumn(COL_flexParam).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblReqData.getColumn(COL_actualValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblReqData.getColumn(COL_transitBudgetValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblReqData.getColumn(COL_flexTransitBudgetValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblCtrlData.getColumn(COL_actualValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblCtrlData.getColumn(COL_flexParam).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblCtrlData.getColumn(COL_budgetValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblCtrlData.getColumn(COL_transitBudgetValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        this.tblCtrlData.getColumn(COL_flexTransitBudgetValue).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getFormatStringForTable((int)precision));
        HashMap<String, BgControlParam> reqParams = new HashMap<String, BgControlParam>();
        HashMap<String, BgControlParam> ctrlParams = new HashMap<String, BgControlParam>();
        if (param.getExpandInfo().isIsGroup()) {
            reqParams.putAll(param.getExpandGroupAccs());
        } else {
            reqParams.put(DimensionFormulaHelper.getMemberNumber((String)param.getBgIndexNumber()), param);
        }
        HashSet<String> detailSet = new HashSet<String>();
        String[] tmpStrs = null;
        HashSet<String> combinNumber = new HashSet<String>();
        combinNumber.add(param.getBgIndexNumber());
        combinNumber.add(param.getExpandCtrlParam().getBgIndexNumber());
        combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)param.getDimItemNumber())));
        combinNumber.add(param.getExpandCtrlParam().getDimItemNumber());
        for (BgControlParam p : reqParams.values()) {
            combinNumber.add(p.getBgIndexNumber());
            combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)p.getDimItemNumber())));
            detailSet.clear();
            detailSet.addAll(p.getBudgetDetail().keySet());
            detailSet.addAll(p.getActualDetail().keySet());
            for (String string : detailSet) {
                tmpStrs = string.split("!");
                combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)tmpStrs[0])));
            }
            if (p.getBgGroupMap() == null) continue;
            for (List list : p.getBgGroupMap().values()) {
                for (BgGroupData groupData : list) {
                    combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)groupData.getBgDimNumber())));
                }
            }
        }
        Map comNames = DimensionFormulaFacadeFactory.getRemoteInstance().getDimensionCombName(param.getBgSchemeInfo().getId().toString(), combinNumber, param.getOrgUnit().getId().toString());
        Object[] accNumbers = reqParams.keySet().toArray(new String[0]);
        Arrays.sort(accNumbers);
        IRow row = null;
        ArrayList arrayList = new ArrayList();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        ArrayList dimNumbers = new ArrayList();
        HashSet<String> dimNumberSet = new HashSet<String>();
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal totalBudgetValue = BgNConstants.ZERO;
        BigDecimal totalActualValue = BgNConstants.ZERO;
        BigDecimal flexParam = null;
        BigDecimal totalFlexBudget = null;
        BigDecimal transitBudgetValue = null;
        BigDecimal flexTransitBudgetValue = null;
        BigDecimal totalTransitBudgetValue = null;
        BigDecimal totalFlexTransitBudgetValue = null;
        int startIndex = 0;
        String bgIndexNumber = null;
        String otherNumber = null;
        int splitIndex = -1;
        String tmpKey = null;
        HashMap<String, BgGroupData> groupDataMap = new HashMap<String, BgGroupData>();
        BgGroupData tmpData = null;
        for (Object accNumber : accNumbers) {
            BgControlParam p = (BgControlParam)reqParams.get(accNumber);
            groupDataMap.clear();
            detailSet.clear();
            detailSet.addAll(p.getBudgetDetail().keySet());
            detailSet.addAll(p.getActualDetail().keySet());
            for (String string : detailSet) {
                tmpStrs = string.split("!");
                dimNumberSet.add(tmpStrs[0]);
                bgPeriodSet.add(tmpStrs[1]);
            }
            if (p.getBgGroupMap() != null) {
                for (List list : p.getBgGroupMap().values()) {
                    for (BgGroupData groupData : list) {
                        dimNumberSet.add(groupData.getBgDimNumber());
                        bgPeriodSet.add(groupData.getBgPeriodNumber());
                        tmpKey = groupData.getBgDimNumber() + "!" + groupData.getBgPeriodNumber();
                        if (!groupDataMap.containsKey(tmpKey)) {
                            groupDataMap.put(tmpKey, new BgGroupData());
                        }
                        tmpData = (BgGroupData)groupDataMap.get(tmpKey);
                        tmpData.setBudgetValue(BgNFSHelper.addBigDecimal((BigDecimal)tmpData.getBudgetValue(), (BigDecimal)groupData.getBudgetValue()));
                        tmpData.setActualValue(BgNFSHelper.addBigDecimal((BigDecimal)tmpData.getActualValue(), (BigDecimal)groupData.getActualValue()));
                        tmpData.setTransitBudgetValue(BgNFSHelper.addBigDecimal((BigDecimal)tmpData.getTransitBudgetValue(), (BigDecimal)groupData.getTransitBudgetValue()));
                        if (groupData.getSetting() == null) continue;
                        tmpData.setSetting(groupData.getSetting());
                    }
                }
            }
            arrayList.clear();
            arrayList.addAll(bgPeriodSet);
            Collections.sort(arrayList);
            dimNumbers.clear();
            dimNumbers.addAll(dimNumberSet);
            Collections.sort(dimNumbers);
            for (String string : dimNumbers) {
                totalBudgetValue = BgNConstants.ZERO;
                totalActualValue = BgNConstants.ZERO;
                totalTransitBudgetValue = BgNConstants.ZERO;
                totalFlexTransitBudgetValue = BgNConstants.ZERO;
                totalFlexBudget = null;
                startIndex = -1;
                splitIndex = string.indexOf(",");
                if (splitIndex > 0) {
                    bgIndexNumber = string.substring(0, splitIndex);
                    otherNumber = string.substring(splitIndex + 1);
                } else {
                    bgIndexNumber = string;
                    otherNumber = null;
                }
                for (String bgPeriodNumber : arrayList) {
                    tmpKey = string + "!" + bgPeriodNumber;
                    if (groupDataMap.containsKey(tmpKey)) {
                        budgetValue = ((BgGroupData)groupDataMap.get(tmpKey)).getBudgetValue();
                        transitBudgetValue = ((BgGroupData)groupDataMap.get(tmpKey)).getTransitBudgetValue();
                        actualValue = ((BgGroupData)groupDataMap.get(tmpKey)).getActualValue();
                        flexParam = ((BgGroupData)groupDataMap.get(tmpKey)).getSetting().getFlexParam();
                        flexTransitBudgetValue = ((BgGroupData)groupDataMap.get(tmpKey)).getTransitBudgetValue().multiply(flexParam);
                    } else {
                        flexParam = p.getControlSetting().getFlexParam();
                        if (p.getBudgetDetail().containsKey(tmpKey)) {
                            budgetValue = p.getBudgetDetail().get(tmpKey).getBudgetValue();
                            transitBudgetValue = p.getBudgetDetail().get(tmpKey).getTransitBudgetValue();
                            flexTransitBudgetValue = p.getBudgetDetail().get(tmpKey).getTransitBudgetValue().multiply(flexParam);
                        } else {
                            budgetValue = null;
                            transitBudgetValue = BigDecimal.ZERO;
                            flexTransitBudgetValue = BigDecimal.ZERO;
                        }
                        actualValue = p.getActualDetail().containsKey(tmpKey) ? p.getActualDetail().get(tmpKey).getActualValue() : null;
                    }
                    totalBudgetValue = BgNFSHelper.addBigDecimal((BigDecimal)totalBudgetValue, (BigDecimal)budgetValue);
                    totalActualValue = BgNFSHelper.addBigDecimal((BigDecimal)totalActualValue, (BigDecimal)actualValue);
                    totalFlexBudget = BgNFSHelper.addBigDecimal(totalFlexBudget, (BigDecimal)BgNFSHelper.calFlexParam((BigDecimal)budgetValue, (BigDecimal)flexParam));
                    totalTransitBudgetValue = BgNFSHelper.addBigDecimal((BigDecimal)totalTransitBudgetValue, (BigDecimal)transitBudgetValue);
                    totalFlexTransitBudgetValue = BgNFSHelper.addBigDecimal((BigDecimal)totalFlexTransitBudgetValue, (BigDecimal)flexTransitBudgetValue);
                    if (budgetValue == null && actualValue == null) continue;
                    row = this.tblReqData.addRow();
                    if (startIndex == -1) {
                        startIndex = row.getRowIndex();
                    }
                    this.fillOneValue(row, bgIndexNumber, otherNumber, bgPeriodNumber.substring(bgPeriodNumber.lastIndexOf("!") + 1), budgetValue, flexParam, actualValue, transitBudgetValue, flexTransitBudgetValue, comNames);
                }
                if (row != null && startIndex != row.getRowIndex()) {
                    this.tblReqData.getMergeManager().mergeBlock(startIndex, 0, row.getRowIndex(), 0);
                    this.tblReqData.getMergeManager().mergeBlock(startIndex, 1, row.getRowIndex(), 1);
                }
                if (startIndex < 0) continue;
                this.addSumRow(this.tblReqData, p, totalBudgetValue, totalFlexBudget, totalActualValue, totalTransitBudgetValue, totalFlexTransitBudgetValue);
            }
        }
        ctrlParams.put(DimensionFormulaHelper.getMemberNumber((String)param.getExpandCtrlParam().getBgIndexNumber()), param.getExpandCtrlParam());
        this.showTable(this.tblCtrlData, ctrlParams, param);
        Object[] result = param.getCalculateFormula();
        Object ctrlValue = result[0];
        Object ctrlParam = result[1];
        Object formula = result[2];
        if (!BgCtrlValueEnum.ControlBudget.equals((Object)param.getExpandInfo().getBgCtrlValue())) {
            this.tblCtrlParam.getColumn(COL_CtrlParam_ctrlFormula).setWidth(this.tblCtrlParam.getColumn(COL_CtrlParam_ctrlFormula).getWidth() + this.tblCtrlParam.getColumn(COL_CtrlParam_ctrlType).getWidth());
            this.tblCtrlParam.getColumn(COL_CtrlParam_ctrlType).getStyleAttributes().setHided(true);
        }
        row = this.tblCtrlParam.addRow();
        row.getCell(COL_CtrlParam_ctrlType).setValue(ctrlValue);
        row.getCell(COL_CtrlParam_ctrlParam).setValue(ctrlParam);
        row.getCell(COL_CtrlParam_ctrlFormula).setValue(formula);
    }

    private IRow addSumRow(KDTable table, BgControlParam param, BigDecimal sumBgValue, BigDecimal flexBudgetValue, BigDecimal sumAcValue, BigDecimal sumTransitBudgetValue, BigDecimal sumFlexTransitBudgetValue) {
        if (table == null || sumBgValue == null || sumAcValue == null) {
            return null;
        }
        if (sumAcValue != null && sumAcValue.compareTo(BgControlConstants.ZERO) == 0) {
            sumAcValue = null;
        }
        IRow sumRow = table.addRow();
        sumRow.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
        this.fillOneValue(sumRow, "", "", "", sumBgValue, flexBudgetValue, sumAcValue, sumTransitBudgetValue, sumFlexTransitBudgetValue, new HashMap<String, String>());
        sumRow.getCell(COL_account).setValue((Object)BgCommCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"subtotal"));
        sumRow.getCell(COL_account).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        table.getMergeManager().mergeBlock(sumRow.getRowIndex(), 0, sumRow.getRowIndex(), 2);
        return sumRow;
    }

    private String getExtName(String[] bgDimNums, String[] dimNames) {
        if (bgDimNums == null || bgDimNums.length <= 0) {
            return null;
        }
        StringBuffer extName = new StringBuffer();
        int in = bgDimNums.length;
        for (int i = 0; i < in; ++i) {
            if (bgDimNums[i].contains(":")) {
                extName.append(bgDimNums[i].substring(bgDimNums[i].indexOf(":") + 1, bgDimNums[i].length()) + "(" + dimNames[i] + "),");
                continue;
            }
            extName.append(bgDimNums[i] + "(" + dimNames[i] + "),");
        }
        if (extName.length() > 0) {
            extName = extName.delete(extName.length() - 1, extName.length());
        }
        return extName.toString();
    }

    private void fillOneValue(IRow row, String bgIndexNumber, String dimItemNumber, String bgPeriodName, BigDecimal budgetValue, BigDecimal flexParam, BigDecimal actualValue, BigDecimal transitBudgetValue, BigDecimal flexTransitBudgetValue, Map<String, String> comNames) {
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)dimItemNumber)) {
            String[] combins;
            for (String c : combins = DimensionFormulaHelper.splitCombinations((String)dimItemNumber)) {
                if (c.startsWith(DimensionConstants.DEF_INDEX_SRCNUMBER + ":")) continue;
                numbers.add(DimensionFormulaHelper.getMemberNumber((String)c));
                names.add(comNames.get(c));
            }
        }
        row.getCell(COL_account).setValue((Object)this.getCellHelper().getIndexDisplayName(this.accountViewId, bgIndexNumber, comNames.get(bgIndexNumber)));
        if (!numbers.isEmpty()) {
            row.getCell(COL_mbgDim).setValue((Object)this.getExtName(numbers.toArray(new String[0]), names.toArray(new String[0])));
        }
        row.getCell(COL_bgPeriod).setValue((Object)bgPeriodName);
        row.getCell(COL_budgetValue).setValue((Object)budgetValue);
        row.getCell(COL_actualValue).setValue((Object)actualValue);
        if (transitBudgetValue != null && transitBudgetValue.compareTo(BigDecimal.ZERO) != 0) {
            row.getCell(COL_transitBudgetValue).setValue((Object)transitBudgetValue);
        }
        if (flexTransitBudgetValue != null && BigDecimal.ZERO.compareTo(flexTransitBudgetValue) != 0) {
            row.getCell(COL_flexTransitBudgetValue).setValue((Object)flexTransitBudgetValue);
        }
        if (flexParam != null) {
            row.getCell(COL_flexParam).setValue((Object)flexParam);
        }
    }

    private void showTable(KDTable table, Map<String, BgControlParam> reqParams, BgControlParam param) throws EASBizException, BOSException {
        HashSet<String> detailSet = new HashSet<String>();
        String[] tmpStrs = null;
        HashSet<String> combinNumber = new HashSet<String>();
        combinNumber.add(param.getBgIndexNumber());
        combinNumber.add(param.getExpandCtrlParam().getBgIndexNumber());
        combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)param.getDimItemNumber())));
        combinNumber.add(param.getExpandCtrlParam().getDimItemNumber());
        for (BgControlParam p : reqParams.values()) {
            combinNumber.add(p.getBgIndexNumber());
            combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)p.getDimItemNumber())));
            detailSet.clear();
            detailSet.addAll(p.getBudgetDetail().keySet());
            detailSet.addAll(p.getActualDetail().keySet());
            for (String string : detailSet) {
                tmpStrs = string.split("!");
                combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)tmpStrs[0])));
            }
            if (p.getBgGroupMap() == null) continue;
            for (List list : p.getBgGroupMap().values()) {
                for (BgGroupData groupData : list) {
                    combinNumber.addAll(Arrays.asList(DimensionFormulaHelper.splitCombinations((String)groupData.getBgDimNumber())));
                }
            }
        }
        Map comNames = DimensionFormulaFacadeFactory.getRemoteInstance().getDimensionCombName(param.getBgSchemeInfo().getId().toString(), combinNumber, param.getOrgUnit().getId().toString());
        Object[] accNumbers = reqParams.keySet().toArray(new String[0]);
        Arrays.sort(accNumbers);
        IRow row = null;
        ArrayList arrayList = new ArrayList();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        ArrayList dimNumbers = new ArrayList();
        HashSet<String> dimNumberSet = new HashSet<String>();
        BigDecimal budgetValue = null;
        BigDecimal actualValue = null;
        BigDecimal totalBudgetValue = BgNConstants.ZERO;
        BigDecimal totalActualValue = BgNConstants.ZERO;
        BigDecimal flexParam = null;
        BigDecimal totalFlexBudget = null;
        BigDecimal transitBudgetValue = null;
        BigDecimal flexTransitBudgetValue = null;
        BigDecimal totalTransitBudgetValue = null;
        BigDecimal totalFlexTransitBudgetValue = null;
        int startIndex = 0;
        String bgIndexNumber = null;
        String otherNumber = null;
        int splitIndex = -1;
        String tmpKey = null;
        HashMap<String, BgGroupData> groupDataMap = new HashMap<String, BgGroupData>();
        BgGroupData tmpData = null;
        for (Object accNumber : accNumbers) {
            BgControlParam p = reqParams.get(accNumber);
            groupDataMap.clear();
            detailSet.clear();
            detailSet.addAll(p.getBudgetDetail().keySet());
            detailSet.addAll(p.getActualDetail().keySet());
            for (String string : detailSet) {
                tmpStrs = string.split("!");
                dimNumberSet.add(tmpStrs[0]);
                bgPeriodSet.add(tmpStrs[1]);
            }
            if (p.getBgGroupMap() != null) {
                for (List list : p.getBgGroupMap().values()) {
                    for (BgGroupData groupData : list) {
                        if (groupData.getSetting() != null && groupData.getSetting().getCtrlType().getValue() == 11 && groupData.getBgPeriodNumber().compareTo(p.getBgPeriodNumber()) > 0) continue;
                        dimNumberSet.add(groupData.getBgDimNumber());
                        bgPeriodSet.add(groupData.getBgPeriodNumber());
                        tmpKey = groupData.getBgDimNumber() + "!" + groupData.getBgPeriodNumber();
                        if (!groupDataMap.containsKey(tmpKey)) {
                            groupDataMap.put(tmpKey, new BgGroupData());
                        }
                        tmpData = (BgGroupData)groupDataMap.get(tmpKey);
                        tmpData.setBudgetValue(BgNFSHelper.addBigDecimal((BigDecimal)tmpData.getBudgetValue(), (BigDecimal)groupData.getBudgetValue()));
                        tmpData.setActualValue(BgNFSHelper.addBigDecimal((BigDecimal)tmpData.getActualValue(), (BigDecimal)groupData.getActualValue()));
                        tmpData.setTransitBudgetValue(BgNFSHelper.addBigDecimal((BigDecimal)tmpData.getTransitBudgetValue(), (BigDecimal)groupData.getTransitBudgetValue()));
                        if (groupData.getSetting() == null) continue;
                        tmpData.setSetting(groupData.getSetting());
                    }
                }
            }
            arrayList.clear();
            arrayList.addAll(bgPeriodSet);
            Collections.sort(arrayList);
            dimNumbers.clear();
            dimNumbers.addAll(dimNumberSet);
            Collections.sort(dimNumbers);
            for (String string : dimNumbers) {
                totalBudgetValue = BgNConstants.ZERO;
                totalTransitBudgetValue = BgNConstants.ZERO;
                totalFlexTransitBudgetValue = BgNConstants.ZERO;
                totalActualValue = BgNConstants.ZERO;
                totalFlexBudget = null;
                startIndex = -1;
                splitIndex = string.indexOf(",");
                if (splitIndex > 0) {
                    bgIndexNumber = string.substring(0, splitIndex);
                    otherNumber = string.substring(splitIndex + 1);
                } else {
                    bgIndexNumber = string;
                    otherNumber = null;
                }
                for (String bgPeriodNumber : arrayList) {
                    tmpKey = string + "!" + bgPeriodNumber;
                    if (groupDataMap.containsKey(tmpKey)) {
                        budgetValue = ((BgGroupData)groupDataMap.get(tmpKey)).getBudgetValue();
                        actualValue = ((BgGroupData)groupDataMap.get(tmpKey)).getActualValue();
                        flexParam = ((BgGroupData)groupDataMap.get(tmpKey)).getSetting().getFlexParam();
                        transitBudgetValue = ((BgGroupData)groupDataMap.get(tmpKey)).getTransitBudgetValue();
                        flexTransitBudgetValue = transitBudgetValue.multiply(flexParam);
                    } else {
                        flexParam = p.getControlSetting().getFlexParam();
                        if (p.getBudgetDetail().containsKey(tmpKey)) {
                            budgetValue = p.getBudgetDetail().get(tmpKey).getBudgetValue();
                            transitBudgetValue = p.getBudgetDetail().get(tmpKey).getTransitBudgetValue();
                            flexTransitBudgetValue = transitBudgetValue.multiply(flexParam);
                        } else {
                            budgetValue = null;
                            transitBudgetValue = null;
                            flexTransitBudgetValue = null;
                        }
                        actualValue = p.getActualDetail().containsKey(tmpKey) ? p.getActualDetail().get(tmpKey).getActualValue() : null;
                    }
                    totalBudgetValue = BgNFSHelper.addBigDecimal((BigDecimal)totalBudgetValue, (BigDecimal)budgetValue);
                    totalTransitBudgetValue = BgNFSHelper.addBigDecimal((BigDecimal)totalTransitBudgetValue, (BigDecimal)transitBudgetValue);
                    totalFlexTransitBudgetValue = BgNFSHelper.addBigDecimal((BigDecimal)totalFlexTransitBudgetValue, (BigDecimal)flexTransitBudgetValue);
                    totalActualValue = BgNFSHelper.addBigDecimal((BigDecimal)totalActualValue, (BigDecimal)actualValue);
                    totalFlexBudget = BgNFSHelper.addBigDecimal(totalFlexBudget, (BigDecimal)BgNFSHelper.calFlexParam((BigDecimal)budgetValue, (BigDecimal)flexParam));
                    if (budgetValue == null && actualValue == null) continue;
                    row = table.addRow();
                    if (startIndex == -1) {
                        startIndex = row.getRowIndex();
                    }
                    this.fillOneValue(row, bgIndexNumber, otherNumber, bgPeriodNumber.substring(bgPeriodNumber.lastIndexOf("!") + 1), budgetValue, flexParam, actualValue, transitBudgetValue, flexTransitBudgetValue, comNames);
                }
                if (row != null && startIndex != row.getRowIndex()) {
                    table.getMergeManager().mergeBlock(startIndex, 0, row.getRowIndex(), 0);
                    table.getMergeManager().mergeBlock(startIndex, 1, row.getRowIndex(), 1);
                }
                if (startIndex < 0) continue;
                this.addSumRow(table, p, totalBudgetValue, totalFlexBudget, totalActualValue, totalTransitBudgetValue, totalFlexTransitBudgetValue);
            }
        }
    }

    private void setControlSetting(BgControlParam param, KDTextField compenont) {
        BgControlSettingInfo controlSetting = param.getControlSetting();
        StringBuffer ctrlType = new StringBuffer(controlSetting.getCtrlType().getAlias());
        if (controlSetting.isIsGroupCtrl()) {
            ctrlType.append(BgNFCHelper.getMessageStr((String)BgControlConstants.CONTROL_SOURCE, (String)"group"));
        }
        if (1 == controlSetting.getCtrlSetRule().getValue()) {
            ctrlType.append(", " + BgCtrlSetRuleEnum.Summary.getAlias());
        } else if (0 == controlSetting.getCtrlSetRule().getValue()) {
            ctrlType.append(", " + BgCtrlSetRuleEnum.Detail.getAlias());
        }
        compenont.setText(ctrlType.toString());
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof KDDialog) {
            ((KDDialog)this.getUIWindow()).setResizable(true);
        }
    }
}

