/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.control.BgControlIsomerBaseCollection;
import com.kingdee.eas.ma.control.BgControlIsomerBaseFactory;
import com.kingdee.eas.ma.control.BgControlIsomerBaseInfo;
import com.kingdee.eas.ma.control.BgControlIsomerConnectionInfo;
import com.kingdee.eas.ma.control.BgControlIsomerInfo;
import com.kingdee.eas.ma.control.BgControlIsomerMapCollection;
import com.kingdee.eas.ma.control.BgControlIsomerMapFactory;
import com.kingdee.eas.ma.control.BgControlIsomerMapInfo;
import com.kingdee.eas.ma.control.BgControlIsomerSetCollection;
import com.kingdee.eas.ma.control.BgControlIsomerSetFactory;
import com.kingdee.eas.ma.control.BgControlIsomerSetInfo;
import com.kingdee.eas.ma.control.BgCtrlIsomerBaseEnum;
import com.kingdee.eas.ma.control.BgCtrlIsomerConTypeEnum;
import com.kingdee.eas.ma.control.client.BgControlIsomerBaseSetUI;
import com.kingdee.eas.ma.control.client.BgControlIsomerListUI;
import com.kingdee.eas.ma.control.client.BgControlIsomerSetEdit;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlIsomerKSQLUtils;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgControlIsomerCHelper {
    private static Logger logger = Logger.getLogger((String)BgControlIsomerCHelper.class.getName());
    protected static final String COL_NUMBER = "number";
    protected static final String COL_NAME = "name";
    protected static final String COL_EASFIELD = "easField";
    protected static final String COL_IFIELD = "isomerField";
    protected static final String COL_ISSYSTEM = "isSystem";
    protected static final String COL_EASNUMBER = "easNumber";
    protected static final String COL_SETNUMBER = "sets.number";
    protected static final String COL_SETNAME = "sets.name";
    protected static final String COL_CNUMBER = "sets.cnumber";
    protected static final String COL_CNAME = "sets.cname";
    protected static final String COL_CFIELD = "sets.cField";
    protected static final String COL_MFIELD = "sets.mField";
    protected static final String COL_CONNECT = "sets.connectType";
    private static Map<String, BgControlIsomerKSQLUtils> ksqlClient = null;
    private static Map<String, Map<String, Set<String>>> tableMap = new HashMap<String, Map<String, Set<String>>>();

    public static BgControlIsomerKSQLUtils getKSQLClient(BgControlIsomerConnectionInfo conn) throws EASBizException, BOSException {
        DataBaseType dbType = DataBaseType.getInstance((String)conn.getDBType().getName());
        boolean result = SQLFacadeFactory.getRemoteInstance().DBConnection(dbType.toString(), conn.getIP(), conn.getPort() + "", conn.getInstance(), conn.getUsername(), conn.getPassword());
        if (!result) {
            return null;
        }
        BgControlIsomerKSQLUtils ksqlFacadeUtil = new BgControlIsomerKSQLUtils(null, dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword());
        return ksqlFacadeUtil;
    }

    public static void addRow(KDTable tblMain, BgControlIsomerInfo info, Locale locale, Map<String, Set<String>> tableMap) {
        BgControlIsomerMapInfo newInfo = BgControlIsomerCHelper.createNewShip(info);
        IRow row = tblMain.addRow();
        BgControlIsomerCHelper.addRowForSystemDef(tblMain, row, newInfo, locale);
        row.setUserObject((Object)newInfo);
        tblMain.getSelectManager().select(tblMain.getRowCount(), 0);
    }

    private static void addRowForSystemDef(KDTable tblMain, IRow row, BgControlIsomerMapInfo newInfo, Locale locale) {
        KDBizMultiLangBox textNumber = new KDBizMultiLangBox();
        textNumber.setSelectedLanguage(new LanguageInfo(locale));
        row.getCell(COL_EASFIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)textNumber));
        row.getCell(COL_ISSYSTEM).setValue((Object)0);
        newInfo.setIsSystem(false);
    }

    public static void copyRow(KDTable tblMain, Locale locale) {
        int activeRow = tblMain.getSelectManager().getActiveRowIndex();
        if (activeRow < 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        int colCounts = tblMain.getColumnCount();
        IRow fromRow = tblMain.getRow(activeRow);
        IRow toRow = tblMain.addRow(activeRow + 1);
        BgControlIsomerMapInfo info = null;
        for (int i = 0; i < colCounts - 2; ++i) {
            toRow.getCell(i).setValue(fromRow.getCell(i).getValue());
            toRow.getCell(i).setEditor(fromRow.getCell(i).getEditor());
        }
        if (fromRow.getUserObject() instanceof BgControlIsomerMapInfo) {
            info = (BgControlIsomerMapInfo)fromRow.getUserObject();
            info = (BgControlIsomerMapInfo)info.clone();
            info.setId(null);
            BgControlIsomerCHelper.addRowForSystemDef(tblMain, toRow, info, locale);
            toRow.setUserObject((Object)info);
        }
    }

    public static void store(CoreUI ownerUi, KDTable tblMain, BgControlIsomerInfo group) {
        IRow row = null;
        int j = tblMain.getBody().size();
        for (int i = 0; i < j; ++i) {
            row = tblMain.getRow(i);
            if (!(row.getUserObject() instanceof BgControlIsomerMapInfo)) {
                row.setUserObject((Object)BgControlIsomerCHelper.createNewShip(group));
            }
            BgControlIsomerMapInfo info = (BgControlIsomerMapInfo)row.getUserObject();
            info.setIsomerField(row.getCell(COL_IFIELD).getValue() != null ? row.getCell(COL_IFIELD).getValue().toString() : null);
            info.setEasField(row.getCell(COL_EASFIELD).getValue() != null ? row.getCell(COL_EASFIELD).getValue().toString() : null);
            info.setNumber(row.getCell(COL_NUMBER).getValue() != null ? row.getCell(COL_NUMBER).getValue().toString() : null);
            info.setName(row.getCell(COL_NAME).getValue() != null ? row.getCell(COL_NAME).getValue().toString() : null);
            if (row.getCell(DimensionConstants.DIMENSION_ID) == null || row.getCell(DimensionConstants.DIMENSION_ID).getValue() == null) continue;
            info.setId(BOSUuid.read((String)row.getCell(DimensionConstants.DIMENSION_ID).getValue().toString()));
        }
    }

    public static boolean isModify(KDTable tblMain, BgControlIsomerMapCollection colls) {
        HashSet<String> set = new HashSet<String>();
        if (colls != null) {
            for (int i = 0; i < colls.size(); ++i) {
                set.add(colls.get(i).getNumber() + "_" + colls.get(i).getIsomerField() + "_" + colls.get(i).getEasField());
            }
        }
        for (int i = 0; i < tblMain.getBody().size(); ++i) {
            BgControlIsomerMapInfo info = (BgControlIsomerMapInfo)tblMain.getRow(i).getUserObject();
            if (info == null || info.getId() == null) {
                return true;
            }
            if (set.isEmpty() || set.contains(info.getNumber() + "_" + info.getIsomerField() + "_" + info.getEasField())) continue;
            return true;
        }
        return false;
    }

    public static BgControlIsomerMapInfo createNewShip(BgControlIsomerInfo group) {
        BgControlIsomerMapInfo info = new BgControlIsomerMapInfo();
        info.setIsomer(group);
        return info;
    }

    public static void loadTempTable(CoreUI ownerUI, KDTable tblMain, BgControlIsomerInfo groupInfo, Map<String, Set<String>> tableMap, Locale locale) throws EASBizException, BOSException {
        IColumn column = null;
        IRow head = tblMain.getHeadRow(0);
        if (head == null) {
            head = tblMain.addHeadRow();
        }
        if (groupInfo != null && tableMap != null) {
            column = tblMain.getColumn(COL_NUMBER);
            column.setEditor((ICellEditor)BgControlIsomerCHelper.initCellEditor(ownerUI, COL_NUMBER, tableMap, groupInfo, locale));
            column.getStyleAttributes().setLocked(false);
            column = tblMain.getColumn(COL_NAME);
            column.getStyleAttributes().setLocked(true);
            column = tblMain.getColumn(COL_IFIELD);
            column.getStyleAttributes().setLocked(false);
            column = tblMain.getColumn(COL_EASFIELD);
            column.setEditor((ICellEditor)BgControlIsomerCHelper.initCellEditor(ownerUI, COL_EASFIELD, null, groupInfo, locale));
            column.getStyleAttributes().setLocked(false);
        }
        tblMain.repaint();
    }

    private static KDTDefaultCellEditor initCellEditor(CoreUI ownerUI, String colName, Map<String, Set<String>> tableMap, BgControlIsomerInfo groupInfo, Locale locale) {
        KDComboBox box = null;
        if (colName.equals(COL_NUMBER)) {
            box = new KDComboBox();
            HashSet<String> settables = new HashSet<String>();
            settables.add(groupInfo.getNumber());
            for (int i = 0; i < groupInfo.getSets().size(); ++i) {
                settables.add(groupInfo.getSets().get(i).getCnumber());
                settables.add(groupInfo.getSets().get(i).getNumber());
            }
            for (String key : settables) {
                box.addItem((Object)key);
            }
            final Map<String, Set<String>> map = tableMap;
            final BgControlIsomerInfo info = groupInfo;
            box.addItemListener(new ItemListener(){
                private Map<String, Set<String>> maps;
                private BgControlIsomerInfo infos;
                {
                    this.maps = map;
                    this.infos = info;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (((KDComboBox)e.getSource()).getParent() == null) {
                        return;
                    }
                    KDTable table = (KDTable)((KDComboBox)e.getSource()).getParent().getParent();
                    KDTSelectManager manage = ((KDTable)((KDComboBox)e.getSource()).getParent().getParent()).getSelectManager();
                    if (manage == null) {
                        return;
                    }
                    KDComboBox boxs = new KDComboBox();
                    String tableName = (String)e.getItem();
                    Set<String> set = this.maps.get(tableName);
                    for (String key : set) {
                        boxs.addItem((Object)key);
                    }
                    for (int i = 0; i < this.infos.getSets().size(); ++i) {
                        if (tableName.equals(this.infos.getSets().get(i).getCnumber())) {
                            table.getRow(manage.getActiveRowIndex()).getCell(BgControlIsomerCHelper.COL_NAME).setValue((Object)this.infos.getSets().get(i).getCname());
                            break;
                        }
                        if (!tableName.equals(this.infos.getSets().get(i).getNumber())) continue;
                        table.getRow(manage.getActiveRowIndex()).getCell(BgControlIsomerCHelper.COL_NAME).setValue((Object)this.infos.getSets().get(i).getName());
                        break;
                    }
                    if (tableName.equals(this.infos.getNumber())) {
                        table.getRow(manage.getActiveRowIndex()).getCell(BgControlIsomerCHelper.COL_NAME).setValue((Object)this.infos.getName());
                    }
                    table.getRow(manage.getActiveRowIndex()).getCell(BgControlIsomerCHelper.COL_IFIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxs));
                    table.getRow(manage.getActiveRowIndex()).getCell(BgControlIsomerCHelper.COL_IFIELD).setValue((Object)set.iterator().next());
                }
            });
        } else if (colName.equals(COL_EASFIELD)) {
            KDBizMultiLangBox textNumber = new KDBizMultiLangBox();
            textNumber.setSelectedLanguage(new LanguageInfo(locale));
            return new KDTDefaultCellEditor((JComboBox)textNumber);
        }
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    public static void initRowValue(CoreUI ownerUi, KDTDataRequestEvent e, KDTable tblMain, Map<String, Set<String>> tableMap, BgControlIsomerInfo group, Locale locale) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isomer.id", (Object)group.getId(), CompareType.EQUALS));
        BgControlIsomerMapCollection colls = BgControlIsomerMapFactory.getRemoteInstance().getBgControlIsomerMapCollection(viewInfo);
        HashMap<String, BgControlIsomerMapInfo> map = new HashMap<String, BgControlIsomerMapInfo>();
        for (int i = 0; i < colls.size(); ++i) {
            map.put(colls.get(i).getId().toString(), colls.get(i));
        }
        IRow row = null;
        BgControlIsomerMapInfo info = null;
        int rowCount = e.getLastRow();
        for (int i = e.getFirstRow(); i <= rowCount; ++i) {
            row = tblMain.getRow(i);
            String feild = row.getCell(COL_IFIELD).getValue().toString();
            KDComboBox boxs = new KDComboBox();
            Set<String> set = tableMap.get(row.getCell(COL_NUMBER).getValue().toString().toUpperCase());
            for (String key : set) {
                boxs.addItem((Object)key);
            }
            row.getCell(COL_IFIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxs));
            row.getCell(COL_IFIELD).setValue((Object)feild);
            info = new BgControlIsomerMapInfo();
            if (row.getCell(DimensionConstants.DIMENSION_ID) != null && row.getCell(DimensionConstants.DIMENSION_ID).getValue() != null) {
                info.setId(BOSUuid.read((String)row.getCell(DimensionConstants.DIMENSION_ID).getValue().toString()));
            }
            info.setIsomer(group);
            info.setIsSystem((Boolean)row.getCell(COL_ISSYSTEM).getValue());
            info.setIsomerField(feild);
            if (info.getId() != null && map.containsKey(info.getId().toString())) {
                KDBizMultiLangBox box;
                if (row.getCell(COL_EASFIELD).getEditor() != null && row.getCell(COL_EASFIELD).getEditor().getComponent() instanceof KDBizMultiLangBox) {
                    box = (KDBizMultiLangBox)row.getCell(COL_EASFIELD).getEditor().getComponent();
                    for (int j = 0; j < box.getItemCount(); ++j) {
                        MultiLangItem item = (MultiLangItem)box.getItemAt(j);
                        info.setEasField(item.getData() != null ? item.getData().toString() : null, item.getLang().getLocale());
                    }
                    box.setSelectedLanguage(new LanguageInfo(locale));
                } else {
                    box = new KDBizMultiLangBox();
                    for (int j = 0; j < box.getLanguageList().size(); ++j) {
                        LanguageInfo la = (LanguageInfo)box.getLanguageList().get(j);
                        box.setItemData(la, (Object)((BgControlIsomerMapInfo)map.get(info.getId().toString())).getEasField(la.getLocale()));
                    }
                    box.setSelectedLanguage(new LanguageInfo(locale));
                    row.getCell(COL_EASFIELD).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
                }
            } else {
                info.setEasField(row.getCell(COL_EASFIELD).getValue().toString());
            }
            info.setNumber(row.getCell(COL_NUMBER).getValue().toString());
            info.setName(row.getCell(COL_NAME).getValue().toString());
            row.setUserObject((Object)info);
        }
    }

    public static String queryColumnSQL(Set<String> tableName, BgControlIsomerConnectionInfo conn) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        if (conn.getDBType().getValue().equals("SQLServer")) {
            sql.append("select column_name,table_name,data_type from information_schema.columns where table_name in('");
        } else if (conn.getDBType().getValue().equals("Oracle")) {
            sql.append("select column_name,table_name,data_type from USER_TAB_COLUMNS where table_name in('");
        } else if (conn.getDBType().getValue().equals("DB2")) {
            sql.append("SELECT COLNAME,TABNAME,TYPENAME FROM SYSCAT.COLUMNS WHERE TABSCHEMA='" + conn.getInstance() + "' AND TABNAME in('");
        } else if (conn.getDBType().getValue().equals("MySql")) {
            sql.append("select column_name,table_name,data_type from information_schema.columns where table_schema='" + conn.getInstance() + "' and table_name in('");
        } else if (conn.getDBType().getValue().equals("PostgreSQL")) {
            sql.append("select a.attname,c.relname,format_type ( a.atttypid, a.atttypmod ) from pg_attribute a inner join pg_class c on a.attrelid = c.oid where  a.attnum > 0 and c.relname in('");
        }
        for (String table : tableName) {
            if (conn.getDBType().getValue().equals("Oracle")) {
                sql.append(table.toUpperCase()).append("','");
                continue;
            }
            sql.append(table).append("','");
        }
        String newsql = sql.substring(0, sql.length() - 2) + ")";
        return newsql;
    }

    private static Map<String, BgControlIsomerKSQLUtils> getKSQLCilent(BgControlIsomerConnectionInfo cInfo) throws EASBizException, BOSException {
        if (ksqlClient == null) {
            ksqlClient = new HashMap<String, BgControlIsomerKSQLUtils>();
            BgControlIsomerKSQLUtils client = BgControlIsomerCHelper.getKSQLClient(cInfo);
            ksqlClient.put(cInfo.getId().toString(), client);
        } else if (!ksqlClient.containsKey(cInfo.getId().toString())) {
            BgControlIsomerKSQLUtils client = BgControlIsomerCHelper.getKSQLClient(cInfo);
            ksqlClient.put(cInfo.getId().toString(), client);
        } else if (ksqlClient.get(cInfo.getId().toString()) == null) {
            BgControlIsomerKSQLUtils client = BgControlIsomerCHelper.getKSQLClient(cInfo);
            ksqlClient.put(cInfo.getId().toString(), client);
        }
        return ksqlClient;
    }

    private static String showExportDialog(CoreUI ownerUi, String title) throws BOSException {
        ExcelFile file = new ExcelFile();
        String filePath = null;
        KDFileChooser fileChooser = new BgFileUtil().getFileChooserForExp((Object)ownerUi);
        fileChooser.setDialogTitle(BgControlIsomerCHelper.getCtrlIsomerResource(title));
        fileChooser.setFileFilter((FileFilter)file);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)ownerUi) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        return filePath;
    }

    private static KDSBook showImportDialog(CoreUI ownerUI, String title) throws BOSException {
        String filePath = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForImp((Object)ownerUI);
        fileChooser.setDialogTitle(BgControlIsomerCHelper.getCtrlIsomerResource(title));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)ownerUI) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            kdsBook = POIXlsReader.parse((String)filePath);
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"excelBad"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"notFile"));
            SysUtil.abort();
        }
        bgFileUtil.storeDefaultPathForIMP((Object)filePath, (Object)ownerUI);
        return kdsBook;
    }

    public static String getCtrlIsomerResource(String resName) {
        return BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.control.BgCtrlIsomerResource", (String)resName);
    }

    public static void setSheetStyle(KDSSheet kdsSheet) {
        kdsSheet.getSheetStyleAttributes().setFont(new Font(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
    }

    public static void exportToExcel(CoreUI ownerUI, KDSBook kdsBook, String filePath) throws Exception {
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
            new BgFileUtil().storeDefaultPathForEXP((Object)filePath, (Object)ownerUI);
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"22_BgExportHelper"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"fileIsNotOpen"));
        }
    }

    public static void exportSet(CoreUI ownerUI, KDTable tblMain, BgControlIsomerInfo group) throws Exception {
        boolean hasConnect;
        String filePath = BgControlIsomerCHelper.showExportDialog(ownerUI, "setExport");
        String bookname = "A";
        if (group != null) {
            bookname = group.getName();
        }
        KDSBook kdsBook = new KDSBook(bookname);
        KDSSheet kdsSheet = new KDSSheet(kdsBook, bookname);
        BgControlIsomerCHelper.setSheetStyle(kdsSheet);
        boolean hasCNumber = tblMain.getColumn(COL_CNUMBER) != null && !tblMain.getColumn(COL_CNUMBER).getStyleAttributes().isHided();
        boolean hasCName = tblMain.getColumn(COL_CNAME) != null && !tblMain.getColumn(COL_CNAME).getStyleAttributes().isHided();
        boolean hasCfield = tblMain.getColumn(COL_CFIELD) != null && !tblMain.getColumn(COL_CFIELD).getStyleAttributes().isHided();
        boolean hasNumber = tblMain.getColumn(COL_SETNUMBER) != null && !tblMain.getColumn(COL_SETNUMBER).getStyleAttributes().isHided();
        boolean hasName = tblMain.getColumn(COL_SETNAME) != null && !tblMain.getColumn(COL_SETNAME).getStyleAttributes().isHided();
        boolean hasMField = tblMain.getColumn(COL_MFIELD) != null && !tblMain.getColumn(COL_MFIELD).getStyleAttributes().isHided();
        boolean bl = hasConnect = tblMain.getColumn(COL_CONNECT) != null && !tblMain.getColumn(COL_CONNECT).getStyleAttributes().isHided();
        if (hasCNumber && hasCName && hasNumber && hasName && hasCfield && hasMField && hasConnect) {
            kdsSheet.setCellValue(0, 0, tblMain.getHead().getRow(0).getCell(0).getValue());
            kdsSheet.setCellValue(0, 1, tblMain.getHead().getRow(0).getCell(1).getValue());
            kdsSheet.setCellValue(0, 2, tblMain.getHead().getRow(0).getCell(2).getValue());
            kdsSheet.setCellValue(0, 3, tblMain.getHead().getRow(0).getCell(3).getValue());
            kdsSheet.setCellValue(0, 4, tblMain.getHead().getRow(0).getCell(4).getValue());
            kdsSheet.setCellValue(0, 5, tblMain.getHead().getRow(0).getCell(5).getValue());
            kdsSheet.setCellValue(0, 6, tblMain.getHead().getRow(0).getCell(6).getValue());
        }
        IRow row = null;
        int n = tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = tblMain.getRow(i);
            if (!hasCNumber || !hasCName || !hasNumber || !hasName || !hasCfield || !hasMField || !hasConnect) continue;
            Object cnumber = row.getCell(COL_CNUMBER).getValue();
            Object cname = row.getCell(COL_CNAME).getValue();
            Object cfiled = row.getCell(COL_CFIELD).getValue();
            Object number = row.getCell(COL_SETNUMBER).getValue();
            Object name = row.getCell(COL_SETNAME).getValue();
            Object easField = row.getCell(COL_MFIELD).getValue();
            Object connect = row.getCell(COL_CONNECT).getValue();
            kdsSheet.setCellValue(i + 1, 0, (Object)StringUtils.cnulls((Object)cnumber));
            kdsSheet.setCellValue(i + 1, 1, (Object)StringUtils.cnulls((Object)cname));
            kdsSheet.setCellValue(i + 1, 2, (Object)StringUtils.cnulls((Object)cfiled));
            kdsSheet.setCellValue(i + 1, 3, (Object)StringUtils.cnulls((Object)number));
            kdsSheet.setCellValue(i + 1, 4, (Object)StringUtils.cnulls((Object)name));
            kdsSheet.setCellValue(i + 1, 5, (Object)StringUtils.cnulls((Object)easField));
            kdsSheet.setCellValue(i + 1, 6, (Object)StringUtils.cnulls((Object)connect));
        }
        kdsBook.addSheet(null, kdsSheet);
        BgControlIsomerCHelper.exportToExcel(ownerUI, kdsBook, filePath);
    }

    public static Map importSet(CoreUI ownerUI, KDTable tblMain, BgControlIsomerInfo group, BgControlIsomerConnectionInfo cinfo) throws EASBizException, BOSException {
        if (group == null) {
            return null;
        }
        KDSBook kdsBook = BgControlIsomerCHelper.showImportDialog(ownerUI, "setImport");
        boolean isTooLong = false;
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        if (!BgControlIsomerCHelper.checkColumsTiltle(tblMain, sheet, 7)) {
            MsgBox.showInfo((Component)ownerUI, (String)BgControlIsomerCHelper.getCtrlIsomerResource("importExcelDataError"));
            return null;
        }
        int rowCount = sheet.getRowCount();
        HashMap maps = new HashMap();
        HashSet<String> tableName = new HashSet<String>();
        HashSet<String> numbers = new HashSet<String>();
        String msg = "";
        try {
            for (int i = 1; i < rowCount; ++i) {
                if (sheet.getCell(i, 0, false).getValue() == null || StringUtils.isEmpty((String)sheet.getCell(i, 0, false).getValue().toString())) continue;
                tableName.add(StringUtils.cnulls((String)sheet.getCell(i, 0, false).getValue().toString()).trim());
                tableName.add(StringUtils.cnulls((String)sheet.getCell(i, 3, false).getValue().toString()).trim());
            }
            if (BgControlIsomerCHelper.getKSQLCilent(cinfo).get(cinfo.getId().toString()) != null) {
                String table = null;
                Iterator iterator = tableName.iterator();
                while (iterator.hasNext()) {
                    table = (String)iterator.next();
                    if (!tableMap.containsKey(group.getId().toString()) || !tableMap.get(group.getId().toString()).containsKey(table)) continue;
                    iterator.remove();
                }
                if (!tableName.isEmpty()) {
                    String sql = BgControlIsomerCHelper.queryColumnSQL(tableName, cinfo);
                    IRowSet rowset = BgControlIsomerCHelper.getKSQLCilent(cinfo).get(cinfo.getId().toString()).getTargetRowset(sql);
                    while (rowset.next()) {
                        HashSet<String> col;
                        Map<Object, Object> map;
                        if (tableMap.containsKey(group.getId().toString())) {
                            map = tableMap.get(group.getId().toString());
                            if (map.containsKey(rowset.getString(2))) {
                                ((Set)map.get(rowset.getString(2))).add(rowset.getString(1));
                                continue;
                            }
                            col = new HashSet();
                            col.add(rowset.getString(1));
                            map.put(rowset.getString(2), col);
                            continue;
                        }
                        map = new HashMap();
                        if (map.containsKey(rowset.getString(2))) {
                            ((Set)map.get(rowset.getString(2))).add(rowset.getString(1));
                        } else {
                            col = new HashSet<String>();
                            col.add(rowset.getString(1));
                            map.put(rowset.getString(2), col);
                        }
                        tableMap.put(group.getId().toString(), map);
                    }
                }
            } else {
                MsgBox.showInfo((Component)ownerUI, (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"));
                return null;
            }
            BgControlIsomerSetCollection colls = BgControlIsomerSetFactory.getRemoteInstance().getBgControlIsomerSetCollection("select number,cnumber,cField where isomer.id='" + group.getId() + "'");
            for (int i = 0; i < colls.size(); ++i) {
                numbers.add(colls.get(i).getNumber() + "_" + colls.get(i).getCnumber() + "_" + colls.get(i).getCField());
            }
            HashMap<String, BgCtrlIsomerConTypeEnum> alias = new HashMap<String, BgCtrlIsomerConTypeEnum>();
            for (Object key : BgCtrlIsomerConTypeEnum.getEnumMap().keySet()) {
                alias.put(((BgCtrlIsomerConTypeEnum)((Object)BgCtrlIsomerConTypeEnum.getEnumMap().get(key))).getAlias(), (BgCtrlIsomerConTypeEnum)((Object)BgCtrlIsomerConTypeEnum.getEnumMap().get(key)));
            }
            BgControlIsomerSetInfo info = null;
            BgControlIsomerSetCollection addcoll = new BgControlIsomerSetCollection();
            String number = null;
            String name = null;
            String cField = null;
            String mField = null;
            String key = null;
            String cnumber = null;
            String cname = null;
            String connectType = null;
            for (int i = 1; i < rowCount; ++i) {
                cnumber = StringUtils.cnulls((String)sheet.getCell(i, 0, false).getValue().toString()).trim();
                cname = StringUtils.cnulls((String)sheet.getCell(i, 1, false).getValue().toString()).trim();
                cField = StringUtils.cnulls((String)sheet.getCell(i, 2, false).getValue().toString()).trim();
                number = StringUtils.cnulls((String)sheet.getCell(i, 3, false).getValue().toString()).trim();
                name = StringUtils.cnulls((String)sheet.getCell(i, 4, false).getValue().toString()).trim();
                mField = StringUtils.cnulls((String)sheet.getCell(i, 5, false).getValue().toString()).trim();
                connectType = StringUtils.cnulls((String)sheet.getCell(i, 6, false).getValue().toString()).trim();
                if (cnumber.isEmpty() || !tableMap.get(group.getId().toString()).containsKey(cnumber)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"cNumberIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (cname.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"tcNameIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (cField.isEmpty() || !tableMap.get(group.getId().toString()).get(cnumber).contains(cField)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"tcFieldIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (number.isEmpty() || !tableMap.get(group.getId().toString()).containsKey(number)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"dNumberIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (name.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"tcNameIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (mField.isEmpty() || !tableMap.get(group.getId().toString()).get(number).contains(mField)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"tcFieldIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (connectType.isEmpty() || !alias.containsKey(connectType)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"notconnectType", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (cnumber.equals(number)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"cnumEqualsMnum", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                key = number + "_" + cnumber + "_" + cField;
                if (numbers.contains(key)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"cmGroupRepeat", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                numbers.add(key);
                info = new BgControlIsomerSetInfo();
                info.setIsomer(group);
                info.setNumber(number);
                info.setName(name);
                info.setMfield(mField);
                info.setCnumber(cnumber);
                info.setCname(cname);
                info.setCField(cField);
                info.setConnectType((BgCtrlIsomerConTypeEnum)((Object)alias.get(connectType)));
                addcoll.add(info);
            }
            if (!addcoll.isEmpty()) {
                CoreBaseCollection newcoll = new CoreBaseCollection();
                newcoll.addObjectCollection((IObjectCollection)addcoll);
                BgControlIsomerSetFactory.getRemoteInstance().addnewBatchData(newcoll);
                if (!msg.isEmpty()) {
                    MsgBox.showDetailAndOK((Component)ownerUI, (String)DimensionRelationClientHelper.getDimCommResource((String)"noAllSucess"), (String)msg, (int)0);
                } else {
                    MsgBox.showInfo((Component)ownerUI, (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                }
                ((BgControlIsomerSetEdit)ownerUI).onLoad();
            } else {
                MsgBox.showInfo((Component)ownerUI, (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"importLost"));
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception ee) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (isTooLong) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"tooLongNumAndName"));
            SysUtil.abort();
        }
        return maps;
    }

    public static void exportMap(CoreUI ownerUI, KDTable tblMain, BgControlIsomerInfo group) throws Exception {
        boolean hasEASField;
        String filePath = BgControlIsomerCHelper.showExportDialog(ownerUI, "mapExport");
        KDSBook kdsBook = new KDSBook(group.getName());
        KDSSheet kdsSheet = new KDSSheet(kdsBook, group.getName());
        BgControlIsomerCHelper.setSheetStyle(kdsSheet);
        boolean hasNumber = tblMain.getColumn(COL_NUMBER) != null && !tblMain.getColumn(COL_NUMBER).getStyleAttributes().isHided();
        boolean hasName = tblMain.getColumn(COL_NAME) != null && !tblMain.getColumn(COL_NAME).getStyleAttributes().isHided();
        boolean hasIfield = tblMain.getColumn(COL_IFIELD) != null && !tblMain.getColumn(COL_IFIELD).getStyleAttributes().isHided();
        boolean bl = hasEASField = tblMain.getColumn(COL_EASFIELD) != null && !tblMain.getColumn(COL_EASFIELD).getStyleAttributes().isHided();
        if (hasNumber && hasName && hasIfield && hasEASField) {
            kdsSheet.setCellValue(0, 0, tblMain.getHead().getRow(0).getCell(0).getValue());
            kdsSheet.setCellValue(0, 1, tblMain.getHead().getRow(0).getCell(1).getValue());
            kdsSheet.setCellValue(0, 2, tblMain.getHead().getRow(0).getCell(2).getValue());
            kdsSheet.setCellValue(0, 3, tblMain.getHead().getRow(0).getCell(3).getValue());
        }
        IRow row = null;
        int n = tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = tblMain.getRow(i);
            if (!hasNumber || !hasName || !hasIfield || !hasEASField) continue;
            Object number = row.getCell(COL_NUMBER).getValue();
            Object name = row.getCell(COL_NAME).getValue();
            Object ifiled = row.getCell(COL_IFIELD).getValue();
            Object easField = row.getCell(COL_EASFIELD).getValue();
            kdsSheet.setCellValue(i + 1, 0, (Object)StringUtils.cnulls((Object)number));
            kdsSheet.setCellValue(i + 1, 1, (Object)StringUtils.cnulls((Object)name));
            kdsSheet.setCellValue(i + 1, 2, (Object)StringUtils.cnulls((Object)ifiled));
            kdsSheet.setCellValue(i + 1, 3, (Object)StringUtils.cnulls((Object)easField));
        }
        kdsBook.addSheet(null, kdsSheet);
        BgControlIsomerCHelper.exportToExcel(ownerUI, kdsBook, filePath);
    }

    public static Map importMap(CoreUI ownerUI, KDTable tblMain, BgControlIsomerInfo group, BgControlIsomerConnectionInfo cinfo) throws EASBizException, BOSException {
        if (group == null) {
            return null;
        }
        KDSBook kdsBook = BgControlIsomerCHelper.showImportDialog(ownerUI, "mapImport");
        boolean isTooLong = false;
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        if (!BgControlIsomerCHelper.checkColumsTiltle(tblMain, sheet, 4)) {
            MsgBox.showInfo((Component)ownerUI, (String)BgControlIsomerCHelper.getCtrlIsomerResource("importExcelDataError"));
            return null;
        }
        int rowCount = sheet.getRowCount();
        HashMap maps = new HashMap();
        HashSet<String> tableName = new HashSet<String>();
        HashSet<String> numbers = new HashSet<String>();
        String msg = "";
        try {
            tableName.add(group.getNumber());
            for (int i = 0; i < group.getSets().size(); ++i) {
                tableName.add(group.getSets().get(i).getCnumber());
                tableName.add(group.getSets().get(i).getNumber());
            }
            if (BgControlIsomerCHelper.getKSQLCilent(cinfo).get(cinfo.getId().toString()) != null) {
                String table = null;
                Iterator iterator = tableName.iterator();
                while (iterator.hasNext()) {
                    table = (String)iterator.next();
                    if (!tableMap.containsKey(group.getId().toString()) || !tableMap.get(group.getId().toString()).containsKey(table)) continue;
                    iterator.remove();
                }
                if (!tableName.isEmpty()) {
                    String sql = BgControlIsomerCHelper.queryColumnSQL(tableName, cinfo);
                    IRowSet rowset = BgControlIsomerCHelper.getKSQLCilent(cinfo).get(cinfo.getId().toString()).getTargetRowset(sql);
                    while (rowset.next()) {
                        HashSet<String> col;
                        Map<Object, Object> map;
                        if (tableMap.containsKey(group.getId().toString())) {
                            map = tableMap.get(group.getId().toString());
                            if (map.containsKey(rowset.getString(2))) {
                                ((Set)map.get(rowset.getString(2))).add(rowset.getString(1));
                                continue;
                            }
                            col = new HashSet();
                            col.add(rowset.getString(1));
                            map.put(rowset.getString(2), col);
                            continue;
                        }
                        map = new HashMap();
                        if (map.containsKey(rowset.getString(2))) {
                            ((Set)map.get(rowset.getString(2))).add(rowset.getString(1));
                        } else {
                            col = new HashSet<String>();
                            col.add(rowset.getString(1));
                            map.put(rowset.getString(2), col);
                        }
                        tableMap.put(group.getId().toString(), map);
                    }
                }
            } else {
                MsgBox.showInfo((Component)ownerUI, (String)EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"connectFail"));
                return null;
            }
            BgControlIsomerMapCollection colls = BgControlIsomerMapFactory.getRemoteInstance().getBgControlIsomerMapCollection("select number,name,isomerField where isomer.id='" + group.getId() + "'");
            for (int i = 0; i < colls.size(); ++i) {
                numbers.add(colls.get(i).getNumber() + "_" + colls.get(i).getName() + "_" + colls.get(i).getIsomerField());
            }
            BgControlIsomerMapInfo info = null;
            BgControlIsomerMapCollection addcoll = new BgControlIsomerMapCollection();
            String number = null;
            String name = null;
            String isomerField = null;
            String easField = null;
            String key = null;
            for (int i = 1; i < rowCount; ++i) {
                number = StringUtils.cnulls((String)sheet.getCell(i, 0, false).getValue().toString()).trim();
                name = StringUtils.cnulls((String)sheet.getCell(i, 1, false).getValue().toString()).trim();
                isomerField = StringUtils.cnulls((String)sheet.getCell(i, 2, false).getValue().toString()).trim();
                easField = StringUtils.cnulls((String)sheet.getCell(i, 3, false).getValue().toString()).trim();
                if (number.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"numberIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (name.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"mapnameIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (isomerField.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"filedIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (tableMap.get(group.getId().toString()).containsKey(number)) {
                    if (!tableMap.get(group.getId().toString()).get(number).contains(isomerField)) {
                        msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"tablenotexistcol", (Object[])new Object[]{i + 1}) + " \n";
                        continue;
                    }
                } else {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"tablenotexist", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                if (easField.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"aliasIsNull", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                key = number + "_" + name + "_" + isomerField;
                if (numbers.contains(key)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"rowRepeat", (Object[])new Object[]{i + 1}) + " \n";
                    continue;
                }
                numbers.add(key);
                info = new BgControlIsomerMapInfo();
                info.setIsomer(group);
                info.setNumber(number);
                info.setName(name);
                info.setIsomerField(isomerField);
                info.setEasField(easField);
                addcoll.add(info);
            }
            if (!addcoll.isEmpty()) {
                CoreBaseCollection newcoll = new CoreBaseCollection();
                newcoll.addObjectCollection((IObjectCollection)addcoll);
                BgControlIsomerMapFactory.getRemoteInstance().addnewBatchData(newcoll);
                if (!msg.isEmpty()) {
                    MsgBox.showDetailAndOK((Component)ownerUI, (String)DimensionRelationClientHelper.getDimCommResource((String)"noAllSucess"), (String)msg, (int)0);
                } else {
                    MsgBox.showInfo((Component)ownerUI, (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                }
            } else {
                MsgBox.showInfo((Component)ownerUI, (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"importLost"));
            }
            ((BgControlIsomerListUI)ownerUI).newTypeID = group.getNumber();
            ((BgControlIsomerListUI)ownerUI).refreshList();
            ((BgControlIsomerListUI)ownerUI).setSelectTreeNode();
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception ee) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (isTooLong) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"tooLongNumAndName"));
            SysUtil.abort();
        }
        return maps;
    }

    public static void exportBase(CoreUI ownerUI, KDTable tblMain, BgControlIsomerConnectionInfo group) throws Exception {
        boolean hasEASNumber;
        String filePath = BgControlIsomerCHelper.showExportDialog(ownerUI, "baseExport");
        KDSBook kdsBook = new KDSBook(group.getName());
        KDSSheet kdsSheet = new KDSSheet(kdsBook, group.getName());
        BgControlIsomerCHelper.setSheetStyle(kdsSheet);
        boolean hasNumber = tblMain.getColumn(COL_NUMBER) != null && !tblMain.getColumn(COL_NUMBER).getStyleAttributes().isHided();
        boolean bl = hasEASNumber = tblMain.getColumn(COL_EASNUMBER) != null && !tblMain.getColumn(COL_NUMBER).getStyleAttributes().isHided();
        if (hasNumber && hasEASNumber) {
            kdsSheet.setCellValue(0, 0, tblMain.getHead().getRow(0).getCell(0).getValue());
            kdsSheet.setCellValue(0, 1, tblMain.getHead().getRow(0).getCell(1).getValue());
        }
        IRow row = null;
        int n = tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = tblMain.getRow(i);
            if (!hasNumber || !hasEASNumber) continue;
            Object number = row.getCell(COL_NUMBER).getValue();
            Object easNumber = row.getCell(COL_EASNUMBER).getValue();
            kdsSheet.setCellValue(i + 1, 0, (Object)StringUtils.cnulls((Object)number));
            if (easNumber instanceof FullOrgUnitInfo) {
                kdsSheet.setCellValue(i + 1, 1, (Object)StringUtils.cnulls((String)((FullOrgUnitInfo)easNumber).getNumber()));
                continue;
            }
            if (easNumber instanceof CurrencyInfo) {
                kdsSheet.setCellValue(i + 1, 1, (Object)StringUtils.cnulls((String)((CurrencyInfo)easNumber).getNumber()));
                continue;
            }
            kdsSheet.setCellValue(i + 1, 1, (Object)StringUtils.cnulls((Object)easNumber));
        }
        kdsBook.addSheet(null, kdsSheet);
        BgControlIsomerCHelper.exportToExcel(ownerUI, kdsBook, filePath);
    }

    public static Map importBase(CoreUI ownerUI, KDTable tblMain, BgControlIsomerConnectionInfo group, KDTabbedPane tab) throws EASBizException, BOSException {
        if (group == null) {
            return null;
        }
        int tabIndex = tab.getSelectedIndex();
        KDSBook kdsBook = BgControlIsomerCHelper.showImportDialog(ownerUI, "baseImport");
        boolean isTooLong = false;
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        if (!BgControlIsomerCHelper.checkColumsTiltle(tblMain, sheet, 2)) {
            MsgBox.showInfo((Component)ownerUI, (String)BgControlIsomerCHelper.getCtrlIsomerResource("importExcelDataError"));
            return null;
        }
        int rowCount = sheet.getRowCount();
        HashMap map = new HashMap();
        HashSet<String> easnumbers = new HashSet<String>();
        HashSet<String> numbers = new HashSet<String>();
        String msg = "";
        try {
            MetaDataPK mainQueryPK = null;
            for (int i = 1; i < rowCount; ++i) {
                easnumbers.add(StringUtils.cnulls((String)sheet.getCell(i, 1, false).getValue().toString()).trim());
            }
            if (tabIndex == 0) {
                mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app", (String)"NewOrgF7Query");
            } else if (tabIndex == 1) {
                mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.assistant.app", (String)"CurrencyAllQuery");
            }
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
            if (tabIndex == 0) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("unit.number", easnumbers, CompareType.INCLUDE));
            } else if (tabIndex == 1) {
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(COL_NUMBER, easnumbers, CompareType.INCLUDE));
            }
            exec.setObjectView(viewInfo);
            IRowSet rst = exec.executeQuery();
            easnumbers.clear();
            while (rst.next()) {
                if (tabIndex == 0) {
                    easnumbers.add(rst.getString(4));
                    continue;
                }
                if (tabIndex != 1) continue;
                easnumbers.add(rst.getString(3));
            }
            BgControlIsomerBaseCollection colls = BgControlIsomerBaseFactory.getRemoteInstance().getBgControlIsomerBaseCollection("select number where connection.id='" + group.getId() + "' and type = " + tabIndex);
            for (int i = 0; i < colls.size(); ++i) {
                numbers.add(colls.get(i).getNumber());
            }
            if (easnumbers.isEmpty()) {
                MsgBox.showInfo((Component)ownerUI, (String)BgControlIsomerCHelper.getCtrlIsomerResource("importEasNumber"));
                return null;
            }
            BgControlIsomerBaseInfo info = null;
            BgControlIsomerBaseCollection addcoll = new BgControlIsomerBaseCollection();
            String number = null;
            String easnumber = null;
            for (int i = 1; i < rowCount; ++i) {
                number = StringUtils.cnulls((String)sheet.getCell(i, 0, false).getValue().toString()).trim();
                easnumber = StringUtils.cnulls((String)sheet.getCell(i, 1, false).getValue().toString()).trim();
                if (number.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseNumIsNull", (Object[])new Object[]{tab.getTitleAt(tabIndex), i + 1}) + " \n";
                    continue;
                }
                if (numbers.contains(number)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseRepeat", (Object[])new Object[]{tab.getTitleAt(tabIndex), i + 1}) + " \n";
                    continue;
                }
                numbers.add(number);
                if (easnumber.isEmpty()) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseEASNumIsNull", (Object[])new Object[]{tab.getTitleAt(tabIndex), i + 1}) + " \n";
                    continue;
                }
                if (!easnumbers.contains(easnumber)) {
                    msg = msg + EASResource.getString((String)BgControlConstants.CTRLISOMER_SOURCE, (String)"baseEASNumIsNull", (Object[])new Object[]{tab.getTitleAt(tabIndex), i + 1}) + " \n";
                    continue;
                }
                info = new BgControlIsomerBaseInfo();
                info.setConnection(group);
                info.setNumber(number);
                info.setEasNumber(easnumber);
                info.setType(BgCtrlIsomerBaseEnum.getEnum(tabIndex));
                addcoll.add(info);
            }
            if (!addcoll.isEmpty()) {
                CoreBaseCollection newcoll = new CoreBaseCollection();
                newcoll.addObjectCollection((IObjectCollection)addcoll);
                BgControlIsomerBaseFactory.getRemoteInstance().addnewBatchData(newcoll);
                if (!msg.isEmpty()) {
                    MsgBox.showDetailAndOK((Component)ownerUI, (String)DimensionRelationClientHelper.getDimCommResource((String)"noAllSucess"), (String)msg, (int)0);
                } else {
                    MsgBox.showInfo((Component)ownerUI, (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                }
                BgControlIsomerBaseSetUI ui = (BgControlIsomerBaseSetUI)ownerUI;
                ui.onLoad();
            } else {
                MsgBox.showInfo((Component)ownerUI, (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"importLost"));
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception ee) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (isTooLong) {
            MsgBox.showWarning((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"tooLongNumAndName"));
            SysUtil.abort();
        }
        return map;
    }

    private static boolean checkColumsTiltle(KDTable tblMain, KDSSheet sheet, int dimCol) {
        IRow head = tblMain.getHeadRow(0);
        int colCount = BgControlIsomerCHelper.getColumnCount(sheet);
        if (colCount != dimCol) {
            return false;
        }
        for (int i = 0; i < colCount; ++i) {
            String excelColname;
            String colName = head.getCell(i).getValue().toString().trim();
            if (colName.equals(excelColname = StringUtils.cnulls((Object)sheet.getCell(0, i, false).getValue()).trim())) continue;
            return false;
        }
        return true;
    }

    private static int getColumnCount(KDSSheet sheet) {
        if (sheet != null) {
            for (int c = sheet.getColumnCount() - 1; c >= 0; --c) {
                for (int r = 0; r < sheet.getRowCount(); ++r) {
                    KDSCell cell = sheet.getCell(r, c, false);
                    if (cell == null || cell.getValue() == null || cell.getValue().toString().trim().length() <= 0) continue;
                    return c + 1;
                }
            }
        }
        return 0;
    }
}

