/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.Excel2007Reader;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.control.BgControlItemMapEntryInfo;
import com.kingdee.eas.ma.control.BgControlItemMapInfo;
import com.kingdee.eas.ma.control.BgControlSchemeException;
import com.kingdee.eas.ma.control.BgControlSchemeInfo;
import com.kingdee.eas.ma.control.client.utils.BgControlRelUtils;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BizDataObject;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileFilter;

public class BgControlRelImportUtils {
    private Component component = null;
    private BgControlSchemeInfo controlScheme = null;
    private BizDataObject bizUnit = null;
    private BizDataObject bizProp = null;
    private int dimensionGroup = 1;
    private KDTable relTable = null;
    boolean hasCover = true;
    private String filePath = null;
    private Comparator<Integer> comparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    };

    public BgControlRelImportUtils(Component component, BgControlSchemeInfo controlScheme, BizDataObject bizUnit, BizDataObject bizProp, int dimensionGroup, KDTable relTable) {
        this.component = component;
        this.controlScheme = controlScheme;
        this.bizUnit = bizUnit;
        this.bizProp = bizProp;
        this.relTable = relTable;
        this.dimensionGroup = dimensionGroup;
    }

    public void importRelaItems() throws Exception {
        if (this.component == null || this.controlScheme == null || this.relTable == null) {
            return;
        }
        KDSSheet sheet = this.showDialog();
        this.checkSheetStyle(sheet);
        this.importRelaItems(sheet);
    }

    private KDSSheet showDialog() throws Exception {
        KDSBook kdsBook = null;
        KDFileChooser fc = new BgFileUtil().getFileChooserForExp(this.component instanceof CoreUI ? (CoreUI)this.component : null);
        fc.setDialogTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"fileImport"));
        ExcelFile ef = new ExcelFile();
        fc.addChoosableFileFilter((FileFilter)ef);
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)ef);
        if (fc.showOpenDialog(this.component) == 0) {
            FileFilter filter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (file != null && file.isFile()) {
                String fileName = file.getPath();
                try {
                    if (filter instanceof Excel2007FileFilter) {
                        kdsBook = new Excel2007Reader().parse(fileName);
                    } else if (filter instanceof ExcelFile) {
                        kdsBook = POIXlsReader.parse((String)fileName);
                    }
                    this.filePath = fileName;
                }
                catch (FileNotFoundException ex) {
                    throw new BgControlSchemeException(BgControlSchemeException.ITEMIMPORTERROR_CASE, new String[]{ex.getMessage()});
                }
                catch (Exception ex) {
                    throw new BgControlSchemeException(BgControlSchemeException.ITEMIMPORTERROR);
                }
            }
        }
        KDSSheet kdsSheet = null;
        if (kdsBook != null) {
            kdsSheet = kdsBook.getSheet((Object)new Integer(0));
        }
        return kdsSheet;
    }

    private void checkSheetStyle(KDSSheet kdsSheet) throws Exception {
        if (kdsSheet == null) {
            return;
        }
        int rowCount = this.getRowCount(kdsSheet);
        int colCount = this.getColumnCount(kdsSheet);
        if (colCount < 4 || colCount < this.relTable.getColumnCount()) {
            MsgBox.showWarning((Component)this.component, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.importStyleError"));
            SysUtil.abort();
        }
        if (rowCount < 2) {
            MsgBox.showWarning((Component)this.component, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.importNoData"));
            SysUtil.abort();
        }
        Map.Entry<Integer, String[]> entry2 = null;
        int colIndex = 0;
        String sign = null;
        String[] colSign = null;
        KDSCell cell = null;
        Map<Integer, String[]> rulePops = this.getRuleProp();
        for (Map.Entry<Integer, String[]> entry2 : rulePops.entrySet()) {
            colIndex = entry2.getKey();
            colSign = entry2.getValue();
            cell = kdsSheet.getCell(1, colIndex, false);
            sign = (String)this.getValue(cell);
            if (this.checkPayee(sign, colSign[BgControlRelUtils.INDEX_COL_ALIAS]) || sign != null && sign.startsWith(colSign[BgControlRelUtils.INDEX_COL_ALIAS])) continue;
            MsgBox.showWarning((Component)this.component, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.importDimError"));
            SysUtil.abort();
        }
    }

    protected boolean checkPayee(String sign, String alias) {
        return BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"payee").equals(sign) && BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"payeeNumber").equals(alias);
    }

    private int getRowCount(KDSSheet kdsSheet) {
        return kdsSheet.getRowCount();
    }

    private int getColumnCount(KDSSheet kdsSheet) {
        if (kdsSheet.getColumnCount() > 0) {
            return kdsSheet.getColumnCount();
        }
        return kdsSheet.getExpandedColumns();
    }

    private Map<Integer, String[]> getRuleProp() {
        HashMap<Integer, String[]> propsMap = new HashMap<Integer, String[]>();
        if (this.relTable == null) {
            return propsMap;
        }
        IColumn column = null;
        String[] colSign = null;
        Map tmpMap = null;
        int in = this.relTable.getColumnCount();
        for (int i = 0; i < in; ++i) {
            column = this.relTable.getColumn(i);
            tmpMap = (Map)column.getUserObject();
            if (tmpMap == null) continue;
            colSign = new String[4];
            colSign[BgControlRelUtils.INDEX_COL_TYPE] = (String)tmpMap.get(BgControlConstants.PROP_TYPE);
            colSign[BgControlRelUtils.INDEX_COL_VALUE] = (String)tmpMap.get(BgControlConstants.PROP_VALUE);
            colSign[BgControlRelUtils.INDEX_COL_ALIAS] = (String)tmpMap.get(BgControlConstants.PROP_ALIAS);
            propsMap.put(i, colSign);
        }
        return propsMap;
    }

    private void importRelaItems(KDSSheet kdsSheet) throws BOSException {
        Map<Integer, Map<Integer, String[]>> importDatas;
        if (kdsSheet == null) {
            return;
        }
        if (this.relTable.getRowCount() > 0) {
            int re = MsgBox.showConfirm3((Component)this.component, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.importOver"));
            if (re == 2) {
                return;
            }
            if (re == 1) {
                this.hasCover = false;
            }
        }
        if ((importDatas = this.getImportData(kdsSheet)).isEmpty()) {
            MsgBox.showWarning((Component)this.component, (String)BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"bizItemMap.importNoData"));
            SysUtil.abort();
        } else {
            this.fillData(importDatas, this.getRuleProp());
            new BgFileUtil().storeDefaultPathForEXP((Object)this.filePath, this.component instanceof CoreUI ? (CoreUI)this.component : null);
        }
    }

    private Map<Integer, Map<Integer, String[]>> getImportData(KDSSheet kdsSheet) {
        TreeMap<Integer, Map<Integer, String[]>> dataMap = new TreeMap<Integer, Map<Integer, String[]>>(this.comparator);
        if (kdsSheet == null) {
            return dataMap;
        }
        TreeMap<Integer, String[]> colDataMap = null;
        String name = null;
        String number = null;
        String[] itemData = null;
        int rowCount = this.getRowCount(kdsSheet);
        int colCount = this.relTable.getColumnCount() / 2;
        for (int rowIndex = 2; rowIndex < rowCount; ++rowIndex) {
            if (this.checkHasEmptyRow(kdsSheet, rowIndex, colCount)) continue;
            colDataMap = new TreeMap<Integer, String[]>(this.comparator);
            dataMap.put(rowIndex, colDataMap);
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                number = (String)this.getValue(kdsSheet.getCell(rowIndex, colIndex * 2, false));
                name = (String)this.getValue(kdsSheet.getCell(rowIndex, colIndex * 2 + 1, false));
                if (StringUtils.isEmpty((String)number) && StringUtils.isEmpty((String)name)) continue;
                itemData = new String[]{number != null ? number.trim() : null, name != null ? name.trim() : null};
                colDataMap.put(colIndex, itemData);
            }
        }
        return dataMap;
    }

    private boolean checkHasEmptyRow(KDSSheet kdsSheet, int rowIndex, int colCount) {
        if (kdsSheet == null) {
            return true;
        }
        KDSCell cell = null;
        boolean hasCell = true;
        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
            cell = kdsSheet.getCell(rowIndex, colIndex, false);
            if (cell == null || this.getValue(cell) == null) continue;
            hasCell = false;
            break;
        }
        return hasCell;
    }

    private Object getValue(KDSCell cell) {
        if (cell != null && cell.getValue() != null) {
            return cell.getValue();
        }
        return null;
    }

    private Object getValue(ICell cell) {
        if (cell != null && cell.getValue() != null) {
            return cell.getValue();
        }
        return null;
    }

    private Map<String, Integer> getBizNums(StringBuffer message) {
        HashMap<String, Integer> bizNums = new HashMap<String, Integer>();
        int colCount = this.relTable.getColumnCount() / 2;
        int bizCount = colCount / 2;
        IRow row = null;
        String bizNumber = null;
        StringBuffer bizNumBuf = new StringBuffer();
        int rowCount = this.relTable.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = this.relTable.getRow(rowIndex);
            bizNumber = this.getBizNumber(row, bizCount, bizNumBuf);
            if (bizNums.containsKey(bizNumber)) {
                int _rowIndex = (Integer)bizNums.get(bizNumber);
                message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"import.error.numberrepeat", (Object[])new String[]{String.valueOf(rowIndex + 1), String.valueOf(_rowIndex + 1)}));
                message.append(";\n");
                continue;
            }
            bizNums.put(bizNumber, rowIndex);
        }
        return bizNums;
    }

    private String getBizNumber(IRow row, int colCount, StringBuffer buf) {
        if (row == null || buf == null) {
            return null;
        }
        String bizNumber = null;
        buf.setLength(0);
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            bizNumber = (String)this.getValue(row.getCell(colIndex * 2));
            if (StringUtils.isEmpty((String)bizNumber)) {
                bizNumber = BgNConstants.BLANK_STR;
            }
            buf.append(bizNumber).append("|");
        }
        return buf.toString();
    }

    private String getBizNumber(Map<Integer, String[]> rowData, int colCount, StringBuffer buf) {
        if (rowData == null || buf == null) {
            return null;
        }
        String bizNumber = null;
        String[] itemData = null;
        buf.setLength(0);
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            itemData = rowData.get(colIndex);
            bizNumber = itemData != null && !StringUtils.isEmpty((String)itemData[0]) ? itemData[0] : BgNConstants.BLANK_STR;
            buf.append(bizNumber).append("|");
        }
        return buf.toString();
    }

    private void fillData(Map<Integer, Map<Integer, String[]>> importDatas, Map<Integer, String[]> propsMap) {
        if (importDatas == null || this.relTable == null) {
            return;
        }
        this.relTable.getEditManager().stopEditing();
        StringBuffer message = new StringBuffer();
        Map<String, Integer> bizNums = this.getBizNums(message);
        Map.Entry<Integer, Map<Integer, String[]>> entry2 = null;
        Map.Entry<Integer, String[]> cEntry2 = null;
        Map<Integer, String[]> rowData = null;
        String bizNumber = null;
        String[] itemData = null;
        StringBuffer bizNumBuf = new StringBuffer();
        StringBuffer bizAliasBuf = new StringBuffer();
        StringBuffer mbgNumBuf = new StringBuffer();
        StringBuffer mbgAliasBuf = new StringBuffer();
        IRow row = null;
        boolean ignoreRow = false;
        int index = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int colCount = this.relTable.getColumnCount();
        int allCount = colCount / 2;
        int bizCount = allCount / 2;
        BgControlItemMapEntryInfo bizItem = null;
        BgControlItemMapInfo bizItemMap = this.controlScheme.getItemMap(this.bizProp.getValue(), this.dimensionGroup);
        if (bizItemMap == null) {
            bizItemMap = new BgControlItemMapInfo();
            bizItemMap.setControlScheme(this.controlScheme);
            bizItemMap.setBizProp(this.bizProp.getValue());
            bizItemMap.setDimensionGroup(this.dimensionGroup);
            this.controlScheme.getItemMaps().add(bizItemMap);
        }
        if (this.hasCover) {
            bizItemMap.getEntry().clear();
            this.relTable.removeRows();
            bizNums.clear();
            message.setLength(0);
        }
        int rowBegin = this.relTable.getRowCount();
        this.relTable.addRows(importDatas.size());
        for (Map.Entry<Integer, Map<Integer, String[]>> entry2 : importDatas.entrySet()) {
            rowIndex = entry2.getKey();
            rowData = entry2.getValue();
            ignoreRow = false;
            ignoreRow = this.checkRowData(rowIndex, rowData, propsMap, message);
            if (ignoreRow) continue;
            bizNumber = this.getBizNumber(rowData, bizCount, bizNumBuf);
            if (bizNums.containsKey(bizNumber)) {
                row = this.relTable.getRow(bizNums.get(bizNumber).intValue());
                bizItem = (BgControlItemMapEntryInfo)row.getUserObject();
                ignoreRow = true;
                message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"import.error.numberexistrepeat", (Object[])new String[]{String.valueOf(rowIndex - 1)}));
                message.append(";\n");
            } else {
                row = this.relTable.getRow(rowBegin + index++);
                bizItem = new BgControlItemMapEntryInfo();
                row.setUserObject((Object)bizItem);
                bizNums.put(bizNumber, row.getRowIndex());
                bizItemMap.getEntry().add(bizItem);
            }
            if (ignoreRow) continue;
            for (Map.Entry<Integer, String[]> cEntry2 : rowData.entrySet()) {
                colIndex = cEntry2.getKey();
                itemData = cEntry2.getValue();
                row.getCell(colIndex * 2).setValue((Object)itemData[0]);
                row.getCell(colIndex * 2 + 1).setValue((Object)itemData[1]);
            }
            this.fillItemData(bizItem, row, allCount, bizNumBuf, bizAliasBuf, mbgNumBuf, mbgAliasBuf);
        }
        for (rowIndex = this.relTable.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
            row = this.relTable.getRow(rowIndex);
            if (!BgControlRelUtils.checkHasEmptyRow(row, colCount)) continue;
            this.relTable.removeRow(rowIndex);
        }
        this.showMessage(message);
    }

    private boolean checkRowData(int rowIndex, Map<Integer, String[]> rowData, Map<Integer, String[]> propsMap, StringBuffer message) {
        if (rowData == null || rowData.isEmpty() || propsMap == null || message == null) {
            return true;
        }
        Map.Entry<Integer, String[]> entry2 = null;
        int colIndex = 0;
        String[] data = null;
        String[] colSign = null;
        boolean check = false;
        for (Map.Entry<Integer, String[]> entry2 : rowData.entrySet()) {
            colIndex = entry2.getKey();
            data = entry2.getValue();
            if (StringUtils.isEmpty((String)data[0])) {
                colSign = propsMap.get(colIndex * 2);
                message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"import.error.numberisnull", (Object[])new String[]{String.valueOf(rowIndex - 1), colSign[BgControlRelUtils.INDEX_COL_ALIAS]}));
                message.append(";\n");
                check = true;
            }
            if (!StringUtils.isEmpty((String)data[1])) continue;
            colSign = propsMap.get(colIndex * 2 + 1);
            message.append(BgCommCHelper.getMessageStr((String)BgControlConstants.SCHEMERESOURCE, (String)"import.error.nameisnull", (Object[])new String[]{String.valueOf(rowIndex - 1), colSign[BgControlRelUtils.INDEX_COL_ALIAS]}));
            message.append(";\n");
            check = true;
        }
        return check;
    }

    private void fillItemData(BgControlItemMapEntryInfo bizItem, IRow row, int allCount, StringBuffer bizNumBuf, StringBuffer bizAliasBuf, StringBuffer mbgNumBuf, StringBuffer mbgAliasBuf) {
        if (bizItem == null || row == null) {
            return;
        }
        String number = null;
        String name = null;
        int bizCount = allCount / 2;
        boolean matching = false;
        bizNumBuf.setLength(0);
        bizAliasBuf.setLength(0);
        mbgNumBuf.setLength(0);
        mbgAliasBuf.setLength(0);
        for (int colIndex = 0; colIndex < allCount; ++colIndex) {
            number = (String)this.getValue(row.getCell(colIndex * 2));
            name = (String)this.getValue(row.getCell(colIndex * 2 + 1));
            number = StringUtils.isEmpty((String)number) ? BgNConstants.BLANK_STR : number;
            String string = name = StringUtils.isEmpty((String)name) ? BgNConstants.BLANK_STR : name;
            if (number != null && number.endsWith("%")) {
                matching = true;
                number = number.substring(0, number.length() - 1);
            }
            if (colIndex < bizCount) {
                bizNumBuf.append(number).append("|");
                bizAliasBuf.append(name).append("|");
                continue;
            }
            mbgNumBuf.append(number).append("|");
            mbgAliasBuf.append(name).append("|");
        }
        bizNumBuf.setLength(bizNumBuf.length() - 1);
        bizAliasBuf.setLength(bizAliasBuf.length() - 1);
        mbgNumBuf.setLength(mbgNumBuf.length() - 1);
        mbgAliasBuf.setLength(mbgAliasBuf.length() - 1);
        bizItem.setBizItemValue(bizNumBuf.toString());
        bizItem.setBizItemAlias(bizAliasBuf.toString());
        bizItem.setMbgItemValue(mbgNumBuf.toString());
        bizItem.setMbgItemAlias(mbgAliasBuf.toString());
        bizItem.setMatching(matching);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessage(StringBuffer message) {
        Preferences pref;
        if (message == null || message.length() == 0) {
            return;
        }
        String[] messages = message.toString().split("\n");
        if (messages == null || messages.length == 0) {
            return;
        }
        String dir = System.getProperty("user.home");
        if ((dir == null || dir.trim().length() < 1) && (dir = (pref = Preferences.systemRoot().node("kingdee/eas")).get("easclienthome", null)) == null) {
            dir = "C:/kingdee/eas/client/";
        }
        File file = new File(dir + "/Report.txt");
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            int length = messages.length;
            for (int i = 0; i < length; ++i) {
                fw.write(messages[i]);
                fw.write(13);
                fw.write(10);
            }
            fw.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            Runtime.getRuntime().exec("notepad " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

