/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.client.utils;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgActualRecordFactory;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.client.BgNActualRecordProcessUI;
import com.kingdee.eas.ma.mbg.client.MBGAddActualFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListAddActualFormProcessUI;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgViewBillUtils {
    private static final Logger logger = CoreUIObject.getLogger(BgViewBillUtils.class);

    public static void viewBill(CoreUIObject owner, String billId) throws Exception {
        BgViewBillUtils.viewBill(owner, billId, null);
    }

    public static void viewBill(CoreUIObject owner, String billId, CompanyOrgUnitInfo company) throws Exception {
        if (StringUtils.isEmpty((String)billId)) {
            throw new Exception("idList is null or empty!");
        }
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType bosType = BOSUuid.read((String)billId).getType();
        EntityObjectInfo entity = loader.getEntity(bosType);
        String biz = entity.getBusinessInterface();
        Class<?> _class = Class.forName(biz);
        if (entity.getFullName().equals("com.kingdee.eas.ma.mbg.app.BgActualRecord")) {
            String editUi = null;
            BgActualRecordInfo bgActualRecord = BgActualRecordFactory.getRemoteInstance().getBgActualRecordInfo("select id, bgForm.orgUnit.*, bgForm.orgUnit.CU.*, bgForm.bgTemplate.formType where id = '" + billId + "'");
            if (bgActualRecord.getBgForm().getBgTemplate().getFormType().getValue() == 0) {
                editUi = BgNActualRecordProcessUI.class.getName();
            } else if (bgActualRecord.getBgForm().getBgTemplate().getFormType().getValue() == 4) {
                editUi = MBGAddActualFormProcessUI.class.getName();
            } else if (bgActualRecord.getBgForm().getBgTemplate().getFormType().getValue() == 2) {
                editUi = MbgViewListAddActualFormProcessUI.class.getName();
            }
            FullOrgUnitInfo orgUnitInfo = bgActualRecord.getBgForm().getOrgUnit();
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)"ID", (Object)billId);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)orgUnitInfo);
            uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, (Object)orgUnitInfo.getCU());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)BgViewBillUtils.getEditUIMode(owner)).create(editUi, (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            IBOSObject iBos = null;
            try {
                iBos = BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, _class);
                CoreBaseInfo info = ((ICoreBase)iBos).getValue("select company.* where id = '" + billId + "'");
                company = (CompanyOrgUnitInfo)info.get("company");
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
            String editUi = entity.getExtendedProperty("editUI");
            String oprtState = "FINDVIEW";
            if (editUi != null && editUi.startsWith("com.kingdee.eas.cp.bc.client")) {
                oprtState = OprtState.VIEW;
            }
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)"company", (Object)company);
            uiContext.put((Object)OrgType.Company, (Object)company);
            uiContext.put((Object)"canResize", (Object)"true");
            uiContext.put((Object)"ID", (Object)billId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)BgViewBillUtils.getEditUIMode(owner)).create(editUi, (Map)uiContext, null, oprtState);
            BgViewBillUtils.disableFunction(uiWindow);
            uiWindow.show();
        }
    }

    private static String getEditUIMode(CoreUIObject ui) {
        IUIWindow win = ui.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    private static void disableFunction(IUIWindow uiWindow) {
        if (uiWindow == null) {
            return;
        }
        Component comp = null;
        try {
            KDToolBar toolBar = uiWindow.getUIObject().getUIToolBar();
            int btnCount = toolBar.getComponentCount();
            for (int i = 0; i < btnCount; ++i) {
                comp = toolBar.getComponent(i);
                if (!BgViewBillUtils.isNotEnabled(comp)) continue;
                comp.setEnabled(false);
            }
            KDMenuBar menuBar = uiWindow.getUIObject().getUIMenuBar();
            int menuItemCount = menuBar.getComponentCount();
            for (int j = 0; j < menuItemCount; ++j) {
                menuBar.getComponent(j).setEnabled(false);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    private static boolean isNotEnabled(Component cp) {
        if (cp == null) {
            return false;
        }
        String name = cp.getName();
        String cpClass = cp.getClass().getName();
        return !"btnTraceUp".equalsIgnoreCase(name) && !"menuItemTraceUp".equalsIgnoreCase(name) && !"btnTraceDown".equalsIgnoreCase(name) && !"menuItemTraceDown".equalsIgnoreCase(name) && !"btnAttachment".equalsIgnoreCase(name) && !"menuItemAttachment".equalsIgnoreCase(name) && !"btnWorkFlowG".equalsIgnoreCase(name) && !"menuItemWFG".equalsIgnoreCase(name) && !"btnAuditResult".equalsIgnoreCase(name) && !"menuItemAuditResult".equalsIgnoreCase(name) && !"btnWFViewdoProccess".equalsIgnoreCase(name) && !"menuItemViewDoProccess".equalsIgnoreCase(name) && !"btnShowQtyAmnt".equalsIgnoreCase(name) && !"menuItemShowQtyAmnt".equalsIgnoreCase(name) && !"com.kingdee.bos.ctrl.swing.LittleArrowButton".equalsIgnoreCase(cpClass);
    }
}

