/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.ma.control.face.IBudgetSupportBill;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class BudgetSupportBillLoader {
    private static final IBudgetSupportBill supporter = new BudgetSupportBillLoaderImpl();

    public static IBudgetSupportBill getIntance() {
        return supporter;
    }

    private static class BudgetSupportBillLoaderImpl
    implements IBudgetSupportBill {
        private static final Logger logger = Logger.getLogger(BudgetSupportBillLoaderImpl.class);
        private static final String BASEFILE = "com/kingdee/eas/ma/control/impl/support/support_bill.xml";
        public static final String DEFAULT = "default";
        public static final String DEFAULT_ORG_FIELD = "company.id";
        private Map<String, String> supportBill = new HashMap<String, String>();
        private boolean isLoaded = false;

        private BudgetSupportBillLoaderImpl() {
        }

        public void load() throws BOSException {
            if (this.isLoaded) {
                return;
            }
            logger.info((Object)"----- begin load Support Bill Set File:com/kingdee/eas/ma/control/impl/support/support_bill.xml -----");
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.push((Object)this);
            digester.addCallMethod("bill_definition/bill", "innerAddInterface", 2);
            digester.addCallParam("bill_definition/bill/billname", 0);
            digester.addCallParam("bill_definition/bill/orgfield", 1);
            InputStream stream = null;
            try {
                stream = BudgetSupportBillLoader.class.getClassLoader().getResourceAsStream(BASEFILE);
                digester.parse(stream);
            }
            catch (IOException e) {
                logger.error((Object)"Load Budget Support Bill Error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Object)"Load Budget Support Bill Error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }
            logger.info((Object)"----- end load file ------");
            this.isLoaded = true;
        }

        @Override
        public void addInterface(String billName, String orgField) throws BOSException {
            this.load();
            this.innerAddInterface(billName, orgField);
        }

        public void innerAddInterface(String billName, String orgField) throws BOSException {
            if (!StringUtils.isEmpty((String)billName) && !StringUtils.isEmpty((String)orgField)) {
                this.getSupportBill().put(billName, orgField);
            } else {
                logger.error((Object)("budget support set file error:billname info - " + billName));
                logger.error((Object)("budget support set file error:orgid info - " + orgField));
            }
        }

        public Map<String, String> getSupportBill() {
            return this.supportBill;
        }

        @Override
        public String getBillOUFieldOQL(String boName) throws BOSException {
            this.load();
            if (StringUtils.isEmpty((String)boName)) {
                return DEFAULT_ORG_FIELD;
            }
            if (this.supportBill != null && !this.supportBill.isEmpty()) {
                if (this.supportBill.get(boName) instanceof String) {
                    return this.supportBill.get(boName);
                }
                if (this.supportBill.get(DEFAULT) instanceof String) {
                    return this.supportBill.get(DEFAULT);
                }
                return DEFAULT_ORG_FIELD;
            }
            return DEFAULT_ORG_FIELD;
        }
    }
}

