/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.IKSQLFacade;
import com.kingdee.eas.csinterface.utils.KSQLFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;

public class BgControlIsomerKSQLUtils {
    private DataBaseType dbType;
    private String ip;
    private int port;
    private String dbName;
    private String userName;
    private String pwd;
    private IKSQLFacade ksqlFacade;

    public BgControlIsomerKSQLUtils(Context ctx, DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd) throws BOSException {
        this.dbType = dbType;
        this.ip = ip;
        this.port = port;
        this.dbName = dbName;
        this.userName = userName;
        this.pwd = pwd;
        this.ksqlFacade = ctx == null ? KSQLFacadeFactory.getRemoteInstance() : KSQLFacadeFactory.getLocalInstance((Context)ctx);
    }

    public IRowSet getTargetRowset(String ksql) throws BOSException, EASBizException {
        return this.ksqlFacade.getTargetRowset(this.dbType, this.ip, this.port, this.dbName, this.userName, this.pwd, ksql);
    }

    public String executeUpdate(String[] ksqls, String[] toDropViewNames) throws BOSException, EASBizException {
        IKSQLFacade ksqlFacade = (IKSQLFacade)RpcProxy.wrapRequired(IKSQLFacade.class, (String)"com.kingdee.eas.csinterface.utils.KSQLFacade");
        return ksqlFacade.createView(this.dbType, this.ip, this.port, this.dbName, this.userName, this.pwd, ksqls, toDropViewNames);
    }

    public String[] existViews(String[] viewNames) throws BOSException, EASBizException {
        return this.ksqlFacade.existViews(this.dbType, this.ip, this.port, this.dbName, this.userName, this.pwd, viewNames);
    }

    public boolean exists(String tableName) throws EASBizException, BOSException {
        String ksql = "select * from ksql_usertables where ksql_tabname ='" + tableName.toUpperCase() + "'";
        if (this.dbType.getName().equals("SQLServer")) {
            ksql = "select table_name from information_schema.tables where table_name ='" + tableName.toUpperCase() + "'";
        } else if (this.dbType.getName().equals("Oracle")) {
            ksql = "select table_name from user_tables where table_name ='" + tableName.toUpperCase() + "'";
        } else if (this.dbType.getName().equals("DB2")) {
            ksql = "SELECT TABNAME FROM SYSCAT.TABLES WHERE TABSCHEMA='" + this.dbName + "' AND TABNAME ='" + tableName.toUpperCase() + "'";
        } else if (this.dbType.getName().equals("MySql")) {
            ksql = "select table_name from information_schema.tables where table_schema='" + this.dbName + "' and table_name ='" + tableName + "' AND table_type='BASE TABLE'";
        } else if (this.dbType.getName().equals("PostgreSQL")) {
            ksql = "select relname from  pg_class  where c.relname ='" + tableName.toUpperCase() + "'";
        }
        IRowSet rsReturn = this.getTargetRowset(ksql);
        return rsReturn.size() > 0;
    }
}

