/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.control.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlSchemeFacadeFactory;
import com.kingdee.eas.ma.control.face.IControlParameter;
import com.kingdee.eas.ma.control.impl.BudgetSupportBillLoader;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.impl.models.BgGroupData;
import com.kingdee.eas.ma.control.impl.models.BillOQLInfo;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class BgControlUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.utils.BgControlUtils");

    public static String getBizUnit(Context ctx, BOSUuid billId) {
        return MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSUuid.getBOSObjectType((String)billId.toString(), (boolean)false)).getFullName();
    }

    public static String getBizUnit(BOSUuid billId) {
        return MetaDataLoader.getEntity(null, (BOSObjectType)BOSUuid.getBOSObjectType((String)billId.toString(), (boolean)false)).getFullName();
    }

    public static String getBizUnit(Context ctx, IObjectValue model) {
        return MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)model.getBOSType()).getFullName();
    }

    public static String getBizUnit(IObjectValue model) {
        return MetaDataLoader.getEntity(null, (BOSObjectType)model.getBOSType()).getFullName();
    }

    public static String getBillOUID(Context ctx, String bizUnit, BOSUuid billId) throws BOSException, EASBizException {
        String queryOUOQL = BgControlUtils.getQueryOUOQL(ctx, bizUnit, billId);
        if (queryOUOQL == null) {
            throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
        }
        IDataProvider dataProvider = null;
        dataProvider = ctx != null ? EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)bizUnit)) : EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)bizUnit));
        dataProvider.setObjectView(queryOUOQL);
        String queryOUSQL = dataProvider.getSQL();
        String OUID = null;
        IRowSet rst = null;
        try {
            rst = ctx != null ? BgDBUtils.executeQuery((Context)ctx, (String)queryOUSQL) : SQLExecutorFactory.getRemoteInstance((String)queryOUSQL).executeSQL();
            if (!rst.next()) {
                throw new BgControlException(BgControlException.BIZOROUIDERROR);
            }
            OUID = rst.getString(1);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"query OUOQL Error:", (Throwable)ex);
                logger.error((Object)queryOUOQL);
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return OUID;
    }

    public static void fillOUInfo(Context ctx, IControlParameter parameter) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)parameter.getOUID())) {
            OrgUnitInfo orgUnit = MbgDataHelper.getOrgUnitInfo((Context)ctx, (BOSUuid)BOSUuid.read((String)parameter.getOUID()));
            if (orgUnit != null) {
                parameter.setOUInfo(orgUnit.castToFullOrgUnitInfo());
            } else {
                throw new BgControlException(BgControlException.NOFOUNDORGUNIT, new Object[]{parameter.getOUID()});
            }
        }
    }

    public static Object getBillBizValue(Context ctx, String bizUnit, String bizProp, BOSUuid billId) throws BOSException, EASBizException {
        Object bizValue;
        block8: {
            String queryBizOQL = BgControlUtils.getQueryBizOQL(bizProp, billId);
            if (queryBizOQL == null) {
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)bizUnit));
            dataProvider.setObjectView(queryBizOQL);
            String queryOUSQL = dataProvider.getSQL();
            bizValue = null;
            IRowSet rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)queryOUSQL);
                if (rst.next()) {
                    bizValue = rst.getObject(1);
                    break block8;
                }
                throw new BgControlException(BgControlException.BIZOROUIDERROR);
            }
            catch (SQLException ex) {
                logger.error((Object)"query OUOQL Error:", (Throwable)ex);
                logger.error((Object)queryBizOQL);
                throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
            }
            catch (BOSException ex) {
                logger.error((Object)"query OUOQL Error:", (Throwable)ex);
                logger.error((Object)queryBizOQL);
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        return bizValue;
    }

    public static String getBillOUID(Context ctx, String bizUnit, IObjectValue model) throws BOSException, EASBizException {
        String OUFieldOQL = BgControlUtils.getBizUnitOUFieldOQL(ctx, bizUnit);
        if (StringUtils.isEmpty((String)OUFieldOQL)) {
            throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
        }
        String OUID = null;
        List<Object> objs = BgControlUtils.getFieldValue(model, OUFieldOQL);
        if (objs.size() != 1 || !(objs.get(0) instanceof String) && !(objs.get(0) instanceof BOSUuid)) {
            throw new BgControlException(BgControlException.BIZOROUIDERROR);
        }
        OUID = String.valueOf(objs.get(0));
        return OUID;
    }

    public static Object getBillBizValue(Context ctx, String bizProp, IObjectValue model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bizProp) || model == null) {
            throw new BgControlException(BgControlException.OUOQLEXECUTEFIELDERROR);
        }
        Object bizValue = null;
        List<Object> objs = BgControlUtils.getFieldValue(model, bizProp);
        if (objs.size() != 1) {
            throw new BgControlException(BgControlException.BIZOROUIDERROR);
        }
        bizValue = objs.get(0);
        return bizValue;
    }

    public static String getQueryOUOQL(Context ctx, String bizUnit, BOSUuid billId) throws BOSException, EASBizException {
        String OUFieldOQL = BgControlUtils.getBizUnitOUFieldOQL(ctx, bizUnit);
        String queryOUOQL = "select " + OUFieldOQL + " where id = '" + billId + "'";
        if (logger.isInfoEnabled()) {
            logger.info((Object)("query OU OQL:" + queryOUOQL));
        }
        return queryOUOQL;
    }

    public static String getQueryBizOQL(String bizProp, BOSUuid billId) throws BOSException {
        String queryBizOQL = "select " + bizProp + " where id = '" + billId + "'";
        if (logger.isInfoEnabled()) {
            logger.info((Object)("query BIZ OQL:" + queryBizOQL));
        }
        return queryBizOQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBizUnitOUFieldOQL(Context ctx, String boName) throws BOSException, EASBizException {
        String OUField = BudgetSupportBillLoader.getIntance().getBillOUFieldOQL(boName);
        String bizOUField = null;
        if (ctx != null) {
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Context)ctx, (String)"select FBiz from T_MBG_BgControlData where FISDEFAULT = 1 and FBizType = ? and FBizUnit = ?", (Object[])new Object[]{1, boName});
                if (rst.next()) {
                    bizOUField = rst.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (SQLException ex) {
                logger.error((Object)"query bizUnit sql errror:", (Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst);
            }
        } else {
            bizOUField = BgControlSchemeFacadeFactory.getRemoteInstance().getDefaultBizUnit(boName, 1);
        }
        if (bizOUField != null) {
            if (bizOUField.endsWith(".number")) {
                OUField = bizOUField.replaceAll(".number", ".id");
            } else if (bizOUField.endsWith(".longnumber")) {
                OUField = bizOUField.replaceAll(".longnumber", ".id");
            }
        }
        return OUField;
    }

    public static List<Object> getFieldValue(IObjectValue model, String fieldStr) {
        if (model == null || StringUtils.isEmpty((String)fieldStr)) {
            return null;
        }
        Stack<String> fields = new Stack<String>();
        ArrayList<Object> objs = new ArrayList<Object>();
        String[] tmpStrs = fieldStr.split("\\.");
        if (tmpStrs != null) {
            for (int i = tmpStrs.length - 1; i >= 0; --i) {
                fields.push(tmpStrs[i]);
            }
            BgControlUtils.subFieldValue(model, objs, fields);
        }
        return objs;
    }

    private static void subFieldValue(Object object, List<Object> objs, Stack<String> fields) {
        if (object == null || objs == null || fields == null) {
            return;
        }
        if (!fields.isEmpty()) {
            Object obj = BindingUtility.getBeanProperty((Object)object, (String)fields.pop());
            if (obj instanceof IObjectCollection) {
                IObjectCollection colls = (IObjectCollection)obj;
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    Stack<String> tmpStack = new Stack<String>();
                    tmpStack.addAll(fields);
                    BgControlUtils.subFieldValue(colls.getObject(i), objs, tmpStack);
                }
            } else if (obj instanceof IObjectValue) {
                BgControlUtils.subFieldValue(obj, objs, fields);
            } else {
                BgControlUtils.subFieldValue(obj, objs, fields);
            }
        } else {
            objs.add(object);
        }
    }

    public static String checkFieldValue(String field) {
        return field;
    }

    public static String getFieldValue(Context ctx, String field, Map fieldValueMap) {
        return StringUtils.cnulls(fieldValueMap.get(field), null);
    }

    public static BillOQLInfo getQueryBillOQL(Context ctx, BOSUuid billId, Object[] ruleParam, IControlParameter parameter) {
        int i;
        String tmpStr = null;
        BillOQLInfo billOQL = new BillOQLInfo();
        billOQL.getField().setOrgUnit((String)ruleParam[0]);
        billOQL.getField().setOrgUnitName(billOQL.getField().getOrgUnit());
        if (billOQL.getField().getOrgUnit().endsWith(".number")) {
            billOQL.getField().setOrgUnitName(billOQL.getField().getOrgUnit().replaceAll(".number", ".name"));
        } else if (billOQL.getField().getOrgUnit().endsWith(".id")) {
            billOQL.getField().setOrgUnitName(billOQL.getField().getOrgUnit().replaceAll(".id", ".name"));
        }
        tmpStr = (String)ruleParam[2];
        String[] dimItems = BgControlUtils.splitCombin(tmpStr);
        String[] dimItemNames = new String[dimItems.length];
        int in = dimItems.length;
        for (int i2 = 0; i2 < in; ++i2) {
            dimItems[i2] = BgControlUtils.getField(BgControlUtils.splitField(dimItems[i2]));
            dimItemNames[i2] = BgControlUtils.getNameField(dimItems[i2]);
        }
        String currency = (String)ruleParam[4];
        String bizDate = (String)ruleParam[7];
        String request = null;
        String limit = null;
        String[] requests = null;
        String[] reqExFields = null;
        request = (String)ruleParam[10];
        requests = BgControlUtils.splitField(request);
        billOQL.getField().setRequest(requests[0]);
        if (requests.length > 1) {
            billOQL.getField().setRequestEx(requests[1]);
        }
        if (!StringUtils.isEmpty((String)(tmpStr = (String)ruleParam[12]))) {
            reqExFields = tmpStr.split("\\,");
        }
        billOQL.condition = (String)ruleParam[13];
        limit = (String)ruleParam[15];
        if (!"com.kingdee.eas.fi.gl.app.Voucher".equals(parameter.getBizUnit())) {
            limit = null;
        }
        int fieldIndex = 1;
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, BgControlConstants.PROP_ID, fieldIndex);
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, BgControlConstants.PROP_NUMBER, fieldIndex);
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, billOQL.getField().getOrgUnit(), fieldIndex);
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, billOQL.getField().getOrgUnitName(), fieldIndex);
        StringBuffer oql = new StringBuffer();
        oql.append("select " + BgControlConstants.PROP_ID + ", " + BgControlConstants.PROP_NUMBER + ", " + billOQL.getField().getOrgUnit() + "," + billOQL.getField().getOrgUnitName() + ",");
        int in2 = dimItems.length;
        for (i = 0; i < in2; ++i) {
            oql.append(dimItems[i] + "," + dimItemNames[i] + ",");
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, dimItems[i], fieldIndex);
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, dimItemNames[i], fieldIndex);
        }
        oql.append(currency + "," + bizDate + "," + requests[0]);
        if (limit != null) {
            oql.append("," + limit);
        }
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, currency, fieldIndex);
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, bizDate, fieldIndex);
        fieldIndex = BgControlUtils.pushFieldIndex(billOQL, requests[0], fieldIndex);
        if (limit != null) {
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, limit, fieldIndex);
        }
        if (reqExFields != null) {
            in2 = reqExFields.length;
            for (i = 0; i < in2; ++i) {
                oql.append("," + reqExFields[i]);
                fieldIndex = BgControlUtils.pushFieldIndex(billOQL, reqExFields[i], fieldIndex);
            }
        }
        if ("com.kingdee.eas.fi.gl.app.Voucher".equalsIgnoreCase(parameter.getBizUnit()) && !StringUtils.isEmpty((String)request)) {
            if (oql.toString().contains(",entries.")) {
                oql.append(", ").append("entries.id").append(" ");
                fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entries.id", fieldIndex);
            } else if (oql.toString().contains(",entrys.")) {
                oql.append(", ").append("entrys.id").append(" ");
                fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entrys.id", fieldIndex);
            }
            if (requests[0].indexOf("entries.assistRecords.") >= 0) {
                oql.append(", entries.assistRecords.id");
                fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entries.assistRecords.id", fieldIndex);
            } else if (requests[0].indexOf("entries.cashflowEntry.") >= 0) {
                oql.append(", entries.cashflowEntry.id");
            } else if (requests[0].indexOf("entries.") >= 0) {
                oql.append(", entries.id");
            }
        } else if (requests[0].indexOf("entries.") >= 0) {
            oql.append(", ").append("entries.id").append(" ");
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entries.id", fieldIndex);
        } else if (requests[0].indexOf("entrys.") >= 0) {
            oql.append(", ").append("entrys.id").append(" ");
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entrys.id", fieldIndex);
        } else if (oql.toString().contains(",entries.")) {
            oql.append(", ").append("entries.id").append(" ");
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entries.id", fieldIndex);
        } else if (oql.toString().contains(",entrys.")) {
            oql.append(", ").append("entrys.id").append(" ");
            fieldIndex = BgControlUtils.pushFieldIndex(billOQL, "entrys.id", fieldIndex);
        }
        oql.append(" where id = '" + billId + "'");
        if (!StringUtils.isEmpty((String)billOQL.condition)) {
            oql.append(" and (" + billOQL.condition + ")");
        }
        if ("com.kingdee.eas.fi.gl.app.Voucher".equals(parameter.getBizUnit())) {
            oql.append(" and isMgCtrl = 1 ");
        }
        billOQL.setBillOQL(oql.toString());
        billOQL.setItemFields(dimItems);
        billOQL.setReqExtFields(reqExFields);
        return billOQL;
    }

    private static String getNameField(String itemNumber) {
        if (itemNumber.endsWith(".number")) {
            return itemNumber.replaceAll(".number", ".name");
        }
        if (itemNumber.endsWith(".id")) {
            return itemNumber.replaceAll(".id", ".name");
        }
        if (itemNumber.endsWith(".longNumber")) {
            return itemNumber.replaceAll(".longNumber", ".name");
        }
        if (itemNumber.endsWith(".bgitemnumber")) {
            return itemNumber.replaceAll(".bgitemnumber", ".bgitemname");
        }
        if (itemNumber.endsWith(".outbgitemnumber")) {
            return itemNumber.replaceAll(".outbgitemnumber", ".outbgitemname");
        }
        if (itemNumber.endsWith(".mbgNumber")) {
            return itemNumber.replaceAll(".mbgNumber", ".mbgName");
        }
        if (itemNumber.endsWith("mbgNumber")) {
            return itemNumber.replaceAll("mbgNumber", "mbgName");
        }
        if (itemNumber.endsWith("mbgnumber")) {
            return itemNumber.replaceAll("mbgnumber", "mbgname");
        }
        if (itemNumber.endsWith("mbgNumberIn")) {
            return itemNumber.replaceAll("mbgNumberIn", "mbgNameIn");
        }
        if (itemNumber.endsWith("mbgNumberOut")) {
            return itemNumber.replaceAll("mbgNumberOut", "mbgNameOut");
        }
        return itemNumber;
    }

    public static String[] splitField(String combin) {
        if (!StringUtils.isEmpty((String)combin)) {
            return combin.split("\\|");
        }
        return null;
    }

    public static String[] splitCombin(String rule) {
        if (!StringUtils.isEmpty((String)rule)) {
            return rule.split("\\@");
        }
        return null;
    }

    public static String getField(String[] oneCombin) {
        if (oneCombin != null && oneCombin.length > 0) {
            return oneCombin[0];
        }
        return null;
    }

    public static String getFieldName(String field) {
        if (!StringUtils.isEmpty((String)field)) {
            return BgControlUtils.getNameField(field);
        }
        return null;
    }

    public static String getFieldNumber(String[] oneCombin) {
        if (oneCombin != null && oneCombin.length > 1) {
            return oneCombin[1];
        }
        return null;
    }

    private static int pushFieldIndex(BillOQLInfo billOQLInfo, String fieldStr, int fieldIndex) {
        if (!billOQLInfo.getFieldIndex().containsKey(fieldStr)) {
            billOQLInfo.getFieldIndex().put(fieldStr, fieldIndex);
            ++fieldIndex;
        }
        return fieldIndex;
    }

    public static String transBillSQL(Context ctx, String sql, Object[] ruleParam, IControlParameter parameter) {
        String condition = (String)ruleParam[13];
        if (!StringUtils.isEmpty((String)condition)) {
            sql = sql.replaceAll("INNER JOIN", "LEFT OUTER JOIN");
            if ("com.kingdee.eas.fi.gl.app.Voucher".equals(parameter.getBizUnit())) {
                sql = sql.replaceAll("SELECT ", "SELECT DISTINCT ");
            }
        }
        return sql;
    }

    public static IObjectValue transBillObject(Context ctx, IObjectValue model, String oql, IControlParameter parameter) throws EASBizException {
        if (ctx == null || model == null || StringUtils.isEmpty((String)oql) || parameter == null) {
            return null;
        }
        if ("com.kingdee.eas.fi.gl.app.Voucher".equals(parameter.getBizUnit())) {
            model = BgControlUtils.transFiGlValue(ctx, model, oql, parameter);
        }
        return model;
    }

    private static IObjectValue transFiGlValue(Context ctx, IObjectValue model, String oql, IControlParameter parameter) throws EASBizException {
        if (ctx == null || model == null || StringUtils.isEmpty((String)oql) || parameter == null) {
            return null;
        }
        return model;
    }

    public static BigDecimal getBudgetValue(BgControlParam param) {
        if (param.getExtBudget() != null) {
            return param.getExtBudget();
        }
        return param.getBudgetValue();
    }

    public static BigDecimal getTransitBudgetValue(BgControlParam param) {
        if (param.getExtTransitBudget().compareTo(BigDecimal.ZERO) != 0) {
            return BgControlUtils.getValue(param.getExtTransitBudget());
        }
        return BgControlUtils.getValue(param.getTransitBudgetValue());
    }

    private static BigDecimal getValue(BigDecimal value) {
        return null == value || BigDecimal.ZERO.compareTo(value) == 0 ? null : value;
    }

    public static BigDecimal getActualValue(BgControlParam param) {
        if (param.getExtActual() != null) {
            return param.getExtActual();
        }
        return param.getActualValue();
    }

    public static BigDecimal getRequestValue(BgControlParam param) {
        return param.getReqAmount();
    }

    public static CostCenterOrgUnitInfo getCostCenterOrgUnit(Context ctx, String orgUnitNumber) throws EASBizException {
        CostCenterOrgUnitInfo costCenter = null;
        if (ctx == null || StringUtils.isEmpty((String)orgUnitNumber)) {
            return costCenter;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer kSql = new StringBuffer();
        kSql.append("select FId,FNumber,FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FNumber = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(kSql.toString());
            pstmt.setString(1, orgUnitNumber);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                costCenter = new CostCenterOrgUnitInfo();
                costCenter.setId(BOSUuid.read((String)rst.getString(1)));
                costCenter.setNumber(rst.getString(2));
                costCenter.setName(rst.getString(3));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"query CostCenterOrgUnit Error:", (Throwable)ex);
                throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return costCenter;
    }

    public static BgPeriodInfo getBgPeriod(Context ctx, Timestamp bizDate, BgPeriodEnum bgPeriodEnum) throws EASBizException {
        return null;
    }

    public static String getControlKey(String dimItemNumber, String bgElementNum, String currencyNum, String bgScenarioNum) {
        return new StringBuffer(dimItemNumber + "_" + bgElementNum + "_" + currencyNum + "_" + bgScenarioNum).toString();
    }

    public static String getGroupKey(String dimItemNumber, String bgPeriodNum, String bgElementNum, String currencyNum, String bgScenarioNum) {
        return new StringBuffer(dimItemNumber + "_" + bgPeriodNum + "_" + bgElementNum + "_" + currencyNum + "_" + bgScenarioNum).toString();
    }

    public static String getGroupKey(BgGroupData bgGroupData) {
        return new StringBuffer(bgGroupData.getBgDimNumber() + "_" + bgGroupData.getBgPeriodNumber() + "_" + bgGroupData.getScenarioNum()).toString();
    }

    public static Map<String, String> toMap(BgControlParam param) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        if (param == null) {
            return paramMap;
        }
        if (param.getBgSchemeInfo() != null) {
            paramMap.put("bgScenario.id", param.getBgSchemeInfo().getId().toString());
            paramMap.put("bgScheme.name", param.getBgSchemeInfo().getName());
            paramMap.put("bgScheme.number", param.getBgSchemeInfo().getNumber());
            paramMap.put("bgScheme.cube", param.getBgSchemeInfo().getRefCube());
        }
        if (param.getBgSchemeType() != null) {
            paramMap.put("schemeType.id", param.getBgSchemeType().getId().toString());
            paramMap.put("schemeType.name", param.getBgSchemeType().getName());
            paramMap.put("schemeType.number", param.getBgSchemeType().getNumber());
        }
        if (param.getOrgUnit() != null) {
            paramMap.put("orgUnit.id", param.getOrgUnit().getId().toString());
            paramMap.put("orgUnit.name", param.getOrgUnit().getName());
            paramMap.put("orgUnit.number", param.getOrgUnit().getNumber());
        }
        if (param.getReqOrgUnit() != null) {
            paramMap.put("reqOrgUnit.id", param.getReqOrgUnit().getId().toString());
            paramMap.put("reqOrgUnit.name", param.getReqOrgUnit().getName());
            paramMap.put("reqOrgUnit.number", param.getReqOrgUnit().getNumber());
        }
        paramMap.put("bgIndexNum", param.getBgIndexNumber());
        paramMap.put("dimItemNum", param.getDimItemNumber());
        paramMap.put("dimItemName", param.getDimItemName());
        paramMap.put("dimNum", param.getDimNumber());
        if (param.getBgPeriodGroup() != null) {
            paramMap.put("bgPeriodGroup.id", param.getBgPeriodGroup().getId().toString());
            paramMap.put("bgPeriodGroup.name", param.getBgPeriodGroup().getName());
            paramMap.put("bgPeriodGroup.number", param.getBgPeriodGroup().getNumber());
        }
        paramMap.put("bgPeriodType", String.valueOf(param.getBgPeriodType()));
        paramMap.put("bgPeriod.id", param.getBgPeriodId());
        paramMap.put("bgPeriod.name", param.getBgPeriodName());
        paramMap.put("bgPeriod.number", param.getBgPeriodNumber());
        if (param.getBgElement() != null) {
            paramMap.put("bgElement.id", param.getBgElement().getId().toString());
            paramMap.put("bgElement.name", param.getBgElement().getName());
            paramMap.put("bgElement.number", param.getBgElement().getNumber());
        }
        if (param.getCurrency() != null) {
            paramMap.put("currency.id", param.getCurrency().getId().toString());
            paramMap.put("currency.name", param.getCurrency().getName());
            paramMap.put("currency.number", param.getCurrency().getNumber());
        }
        if (param.getBgScenario() != null) {
            paramMap.put("bgScenario.id", param.getBgScenario().getId().toString());
            paramMap.put("bgScenario.name", param.getBgScenario().getName());
            paramMap.put("bgScenario.number", param.getBgScenario().getNumber());
        }
        if (param.getAcScenario() != null) {
            paramMap.put("acScenario.id", param.getAcScenario().getId().toString());
            paramMap.put("acScenario.name", param.getAcScenario().getName());
            paramMap.put("acScenario.number", param.getAcScenario().getNumber());
        }
        if (param.getVersion() != null) {
            paramMap.put("bgVersion.id", param.getVersion().getId().toString());
            paramMap.put("bgVersion.name", param.getVersion().getName());
            paramMap.put("bgVersion.number", param.getVersion().getNumber());
        }
        paramMap.put("formula", param.getFormula());
        paramMap.put("bill.id", param.getBillId());
        paramMap.put("bill.number", param.getBillNumber());
        paramMap.put("reqAmount", param.getReqAmount().stripTrailingZeros().toPlainString());
        paramMap.put("budgetValue", param.getBudgetValue() != null ? param.getBudgetValue().stripTrailingZeros().toPlainString() : "NULL");
        paramMap.put("actualValue", param.getActualValue() != null ? param.getActualValue().stripTrailingZeros().toPlainString() : "NULL");
        paramMap.put("balance", param.getBalance() != null ? param.getBalance().stripTrailingZeros().toPlainString() : "NULL");
        paramMap.put("extBudget", param.getExtBudget() != null ? param.getExtBudget().stripTrailingZeros().toPlainString() : "NULL");
        paramMap.put("extActual", param.getExtActual() != null ? param.getExtActual().stripTrailingZeros().toPlainString() : "NULL");
        paramMap.put("extBalance", param.getExtBalance() != null ? param.getExtBalance().stripTrailingZeros().toPlainString() : "NULL");
        paramMap.put("allowAccess", String.valueOf(param.isAllowAccess()));
        paramMap.put("overBudget", String.valueOf(param.isOverBudget()));
        paramMap.put("notBudget", String.valueOf(param.isNotBudget()));
        paramMap.put("nullBudget", String.valueOf(param.getNullBudget().getValue()));
        paramMap.put("notNullBudget", String.valueOf(param.getNotNullBudget().getValue()));
        if (param.getControlSetting() != null) {
            paramMap.put("controlSet.id", param.getControlSetting().getId() != null ? param.getControlSetting().getId().toString() : null);
            paramMap.put("controlSet.bgIndexNumber", param.getControlSetting().getBgIndexNumber());
            paramMap.put("controlSet.bgIndexName", param.getControlSetting().getBgIndexName());
            paramMap.put("controlSet.bgDimNumber", param.getControlSetting().getBgDimNumber());
            paramMap.put("controlSet.bgDimName", param.getControlSetting().getBgDimName());
            paramMap.put("controlSet.ctrlType", param.getControlSetting().getCtrlType().getAlias());
            paramMap.put("controlSet.periodType", param.getControlSetting().getPeriodType().getAlias());
            paramMap.put("controlSet.isAllowAccess", String.valueOf(param.getControlSetting().isIsAllowAccess()));
            paramMap.put("controlSet.isFlexible", String.valueOf(param.getControlSetting().isIsFlexible()));
            paramMap.put("controlSet.flexParam", param.getControlSetting().getFlexParam().toPlainString());
            paramMap.put("controlSet.isGroupCtrl", String.valueOf(param.getControlSetting().isIsGroupCtrl()));
            paramMap.put("controlSet.groupNo", param.getControlSetting().getGroupNo());
            paramMap.put("controlSet.ctrlSetRule", param.getControlSetting().getCtrlSetRule().getAlias());
        }
        return paramMap;
    }

    public static Map<String, String> toThreadStackMap(String threadStack) {
        LinkedHashMap<String, String> conditionMap = new LinkedHashMap<String, String>();
        conditionMap.put("threadStack", threadStack);
        return conditionMap;
    }

    public static Map<String, String> toMap(String condition) {
        LinkedHashMap<String, String> conditionMap = new LinkedHashMap<String, String>();
        conditionMap.put("condition", condition);
        return conditionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryBgScheme(Context ctx, IControlParameter parameter, List<BgControlParam> params) throws BOSException, EASBizException {
        if (ctx == null || parameter == null || params == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            HashMap<String, Map<String, OrgUnitInfo>> bgSchemeIds = new HashMap<String, Map<String, OrgUnitInfo>>();
            for (BgControlParam param : params) {
                BgControlUtils.queryBgScheme(ctx, conn, parameter, param, bgSchemeMap, bgSchemeIds);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void queryBgScheme(Context ctx, Connection conn, IControlParameter parameter, BgControlParam param, Map<String, BgSchemeInfo> bgSchemeMap, Map<String, Map<String, OrgUnitInfo>> bgSchemeIds) throws BOSException, EASBizException {
        String schemeKey;
        if (ctx == null || conn == null || parameter == null || param == null || bgSchemeMap == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        if (param.getBgSchemeInfo() != null) {
            return;
        }
        if (!param.isQueryOrgEntrust()) {
            BgControlUtils.parseOrgEntrust(ctx, param);
        }
        if (bgSchemeMap.containsKey(schemeKey = param.getOrgUnit().getId() + "_" + param.getBgSchemeType().getId() + "_" + param.getBizDate().getTime())) {
            param.setBgSchemeInfo(bgSchemeMap.get(schemeKey));
            if (bgSchemeMap.get(schemeKey) != null && !bgSchemeIds.containsKey(bgSchemeMap.get(schemeKey).getId().toString())) {
                bgSchemeIds.put(bgSchemeMap.get(schemeKey).getId().toString(), new HashMap());
            }
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID from T_MBG_BgScheme t join T_MBG_BgDimSettings s on s.FBgSchemeId = t.FID join T_MBG_BgDimSettingsMember m on m.FBgDimSettingsId = s.FID join T_MBG_BgOrgUnit u on u.FViewId = m.FMemberId where u.FOrgUnitId = ? and t.FBgSchemeTypeID = ? and t.FDateFrom <= ? and t.FDateTo >= ? and t.FIsFormal = 1 and m.FType = 2");
            HashMap<String, BgSchemeInfo> bgSchemeIdMap = new HashMap<String, BgSchemeInfo>();
            BgSchemeInfo bgSchemeInfo = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, param.getOrgUnit().getId().toString());
                pstmt.setString(2, param.getBgSchemeType().getId().toString());
                pstmt.setTimestamp(3, param.getBizDate());
                pstmt.setTimestamp(4, param.getBizDate());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (bgSchemeIdMap.containsKey(rst.getString("FID"))) {
                        bgSchemeInfo = (BgSchemeInfo)bgSchemeIdMap.get(rst.getString("FID"));
                        continue;
                    }
                    bgSchemeInfo = BgViewServerHelper.getBgSchemeInfo((Locale)ctx.getLocale(), (Connection)conn, (BOSUuid)BOSUuid.read((String)rst.getString("FID")));
                    bgSchemeIdMap.put(rst.getString("FID"), bgSchemeInfo);
                }
                if (bgSchemeInfo == null) {
                    throw new BgControlException(BgControlException.NOFOUNDBGSCHEME, new Object[]{param.getOrgUnit().getName(), param.getBgSchemeType().getName()});
                }
                if (bgSchemeIdMap.size() != 1) {
                    throw new BgControlException(BgControlException.MULTISCHEMEEXECUTE, new Object[]{param.getOrgUnit().getName()});
                }
                param.setBgSchemeInfo(bgSchemeInfo);
                if (!bgSchemeIds.containsKey(bgSchemeInfo.getId().toString())) {
                    bgSchemeIds.put(bgSchemeInfo.getId().toString(), new HashMap());
                }
                bgSchemeMap.put(schemeKey, bgSchemeInfo);
                parameter.getDataManager().getBgSchemeMap().put(bgSchemeInfo.getRefCube(), bgSchemeInfo);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"query BgScheme Error:", (Throwable)ex);
                    throw new BgControlException(BgControlException.DATABASEEXCEPTION, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        BgControlUtils.checkScheme(param);
        BgControlUtils.transSchemeOrg(ctx, conn, bgSchemeIds, param);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void transSchemeOrg(Context ctx, Connection conn, Map<String, Map<String, OrgUnitInfo>> bgSchemeIds, BgControlParam param) throws BOSException, EASBizException {
        IRowSet res;
        block12: {
            if (param.getBgSchemeInfo() == null || param == null) {
                return;
            }
            String bgschemeId = param.getBgSchemeInfo().getId().toString();
            if (!bgSchemeIds.containsKey(bgschemeId) || param.getOrgUnit() == null) return;
            String orgUnitId = param.getOrgUnit().getId().toString();
            if (bgSchemeIds.get(bgschemeId).containsKey(orgUnitId)) {
                param.setOrgUnit(bgSchemeIds.get(bgschemeId).get(orgUnitId));
                return;
            }
            res = null;
            FullOrgUnitInfo orgUnit = null;
            String viewid = (String)new ArrayList(param.getBgSchemeInfo().getOrgViewIds()).get(0);
            String indexViewId = param.getBgSchemeInfo().getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString();
            try {
                String sql = null;
                String sql1 = null;
                if (param.isQueryOrgEntrust()) {
                    sql = "select t.FBgEntrustOrgUnitID fOrgUnitid, cc.FNumber fnumber, cc.FName_" + ctx.getLocale() + " name, cc.FLongNumber ,cc.fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgControlOrgEntrust t join T_MBG_BgAccountSort s on t.FBgIndexSortID = s.FID join T_MBG_BgAccount c on s.FID = c.FBgAccountSortID join T_MBG_BgOrgUnit cc on t.FBgEntrustOrgUnitID = cc.FORGUNITID where t.FBgOrgUnitID = ? and cc.FViewID = ? and t.FBeginTime <= ? and t.FEndTime >= ? and cc.FisVirtual = 0 and (( c.FNumber = ? and c.FBGACCOUNTVIEWID = ? ) or t.FBgIndexSortID is null) ";
                    String[] tmpStrs = param.getBgIndexNumber().split(":");
                    res = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{param.getReqOrgUnit().getId().toString(), viewid, param.getBizDate(), param.getBizDate(), tmpStrs[1], indexViewId});
                    sql1 = "select t.FBgEntrustOrgUnitID fOrgUnitid, cc.FNumber fnumber, cc.FName_" + ctx.getLocale() + " name, cc.FLongNumber ,cc.fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgControlOrgEntrust t join T_MBG_BgOrgUnit cc on t.FBgEntrustOrgUnitID = cc.FORGUNITID where t.FBgOrgUnitID = ? and cc.FViewID = ? and t.FBeginTime <= ? and t.FEndTime >= ? and cc.FisVirtual = 0 and t.FBgIndexSortID is null";
                } else {
                    sql = "select fOrgUnitid, fnumber, fname_" + ctx.getLocale() + " name,fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgOrgUnit where fOrgUnitid = ? and FViewID = ?  and FisVirtual = 0 ";
                    res = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{orgUnitId, viewid});
                }
                while (res.next()) {
                    orgUnit = new FullOrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)res.getString("fOrgUnitid")));
                    orgUnit.setNumber(res.getString("fnumber"));
                    orgUnit.setName(res.getString("name"));
                    orgUnit.setDisplayName(res.getString("displayName"));
                    bgSchemeIds.get(bgschemeId).put(orgUnitId, (OrgUnitInfo)orgUnit);
                    param.setOrgUnit((OrgUnitInfo)orgUnit);
                }
                if (param.isQueryOrgEntrust() && orgUnit == null) {
                    res = BgDBUtils.executeQuery((Connection)conn, sql1, (Object[])new Object[]{param.getReqOrgUnit().getId().toString(), viewid, param.getBizDate(), param.getBizDate()});
                    while (res.next()) {
                        orgUnit = new FullOrgUnitInfo();
                        orgUnit.setId(BOSUuid.read((String)res.getString("fOrgUnitid")));
                        orgUnit.setNumber(res.getString("fnumber"));
                        orgUnit.setName(res.getString("name"));
                        orgUnit.setDisplayName(res.getString("displayName"));
                        bgSchemeIds.get(bgschemeId).put(orgUnitId, (OrgUnitInfo)orgUnit);
                        param.setOrgUnit((OrgUnitInfo)orgUnit);
                    }
                }
                if (!param.isQueryOrgEntrust() || orgUnit != null) break block12;
                orgUnitId = param.getReqOrgUnit().getId().toString();
                sql = "select fOrgUnitid, fnumber, fname_" + ctx.getLocale() + " name,fdisplayName_" + ctx.getLocale() + " displayName from T_MBG_BgOrgUnit where fOrgUnitid = ? and FViewID = ?  and FisVirtual = 0 ";
                res = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{orgUnitId, viewid});
                while (res.next()) {
                    orgUnit = new FullOrgUnitInfo();
                    orgUnit.setId(BOSUuid.read((String)res.getString("fOrgUnitid")));
                    orgUnit.setNumber(res.getString("fnumber"));
                    orgUnit.setName(res.getString("name"));
                    orgUnit.setDisplayName(res.getString("displayName"));
                    bgSchemeIds.get(bgschemeId).put(orgUnitId, (OrgUnitInfo)orgUnit);
                    param.setOrgUnit((OrgUnitInfo)orgUnit);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"transOrg Sql Error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)res);
        return;
    }

    /*
     * Exception decompiling
     */
    private static void parseOrgEntrust(Context ctx, BgControlParam param) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkScheme(BgControlParam param) throws EASBizException {
        if (param.getBgSchemeInfo() == null || param == null) {
            return;
        }
        List scnearioNums = param.getBgSchemeInfo().getMemberNumber(DimensionBaseConstants.DEF_SCENARIO_NUMBER);
        if (!scnearioNums.contains(param.getBgScenario().getNumber())) {
            throw new BgControlException(BgControlException.NOFOUNDSCENARIO, new String[]{param.getBgSchemeInfo().getName(), param.getBgScenario().getNumber()});
        }
        if (!scnearioNums.contains(param.getAcScenario().getNumber())) {
            throw new BgControlException(BgControlException.NOFOUNDSCENARIO, new String[]{param.getBgSchemeInfo().getName(), param.getAcScenario().getNumber()});
        }
        List elementNums = param.getBgSchemeInfo().getMemberNumber(DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        if (!elementNums.contains(param.getBgElement().getNumber())) {
            throw new BgControlException(BgControlException.NOFOUNDELEMENT, new String[]{param.getBgSchemeInfo().getName(), param.getBgElement().getNumber()});
        }
        List versionNums = param.getBgSchemeInfo().getMemberNumber(DimensionBaseConstants.DEF_VERSION_NUMBER);
        if (param.getVersion() != null) {
            if (!versionNums.contains(param.getVersion().getNumber())) {
                throw new BgControlException(BgControlException.NOFOUNDVERSION, new String[]{param.getBgSchemeInfo().getName(), param.getVersion().getNumber()});
            }
        } else if (!versionNums.contains("Ve")) {
            throw new BgControlException(BgControlException.NOFOUNDVERSION, new String[]{param.getBgSchemeInfo().getName(), "Ve"});
        }
    }
}

