/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.InitImportBase;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.pca.InitPcAssistBalanceCollection;
import com.kingdee.eas.ma.pca.InitPcAssistBalanceFactory;
import com.kingdee.eas.ma.pca.InitPcAssistBalanceInfo;
import com.kingdee.eas.ma.pca.PcAssistInitFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InitPcAssistBalanceImport
extends InitImportBase {
    private static final Logger logger = Logger.getLogger(InitPcAssistBalanceImport.class);
    private String accountid = null;
    private String actualAssistantHGInfoID = null;
    private String currecyID = null;
    private String relatedCompanyId = null;
    private String profitCenterid = null;
    private String orgNumber = null;
    private Map companyMap = new HashMap();
    private int baseCurrencyPrecision = 4;
    private int reportCurrencyPrecision = 4;
    private int qtyScale = 0;
    private boolean isFirstLoaded = true;
    private Map currencyMap = new HashMap();
    private int rowNumber = 1;
    HashMap otherParam = new HashMap();
    HashMap<String, Boolean> paramCache = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InitPcAssistBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        InitPcAssistBalanceInfo infos = (InitPcAssistBalanceInfo)coreBaseInfo;
        InitPcAssistBalanceCollection col = new InitPcAssistBalanceCollection();
        col.add(infos);
        this.otherParam.put("curAsstAccountid", infos.getAccount().getCAA().getId().toString());
        try {
            PcAssistInitFacadeFactory.getLocalInstance(ctx).save((IObjectCollection)col, this.otherParam);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    protected ProfitCenterOrgUnitInfo getProfitCenter(Context ctx, Hashtable hsData, String profitCenterIdstr) throws UuidException, SQLException, Exception {
        String orgUnitID = ((DataToken)hsData.get((Object)"FProfitCenterId")).data.toString();
        IProfitCenterOrgUnit profitCenterOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        ProfitCenterOrgUnitInfo profitCenterInfo = profitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterIdstr));
        ObjectUuidPK pk = new ObjectUuidPK(profitCenterInfo.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)PcaUtils.getProfitCenterSic());
        profitCenterInfo = profitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)pk, sic);
        if (!profitCenterInfo.getNumber().equals(orgUnitID)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1011_InitImportBase", (Locale)ctx.getLocale()));
        }
        return profitCenterInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AccountViewInfo getAccount(Context ctx, CurrencyInfo currency, Hashtable hsData, String CompanyIdStr, boolean isCussent) throws Exception, SQLException {
        AccountViewInfo account = new AccountViewInfo();
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(CompanyIdStr));
        if ("InitPcAccountBalance".equals(this.getType())) {
            String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty,flongnumber from T_BD_ACCOUNTVIEW where fisleaf=1 and fcaa is null and fnumber=? and Fcompanyid=? and faccounttableid=?";
            IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountID, unitInfo.getId().toString(), unitInfo.getAccountTable().getId().toString()});
            if (rsToGetAccount == null || !rsToGetAccount.next()) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1014_InitImportBase", (Locale)ctx.getLocale()));
            if (rsToGetAccount.getInt("facctcurrency") == 0 && !currency.getId().equals((Object)unitInfo.getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setLongNumber(rsToGetAccount.getString("flongnumber"));
            account.setNumber(accountID);
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
            return account;
        } else {
            String sqlToGetAccount = "select top 1 fid,fcaa,fac,facctcurrency,fisQty from T_BD_ACCOUNTVIEW where fisleaf=1 and fcaa is not null and fnumber=? and Fcompanyid=? and faccounttableid=?";
            IRowSet rsToGetAccount = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAccount, (Object[])new Object[]{accountID, unitInfo.getId().toString(), unitInfo.getAccountTable().getId().toString()});
            if (rsToGetAccount == null || !rsToGetAccount.next()) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1015_InitImportBase", (Locale)ctx.getLocale()));
            if (rsToGetAccount.getInt("facctcurrency") == 0 && !currency.getId().equals((Object)unitInfo.getBaseCurrency().getId())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
            }
            account.setId(BOSUuid.read((String)rsToGetAccount.getString("fid")));
            AsstAccountInfo caa = new AsstAccountInfo();
            caa.setId(BOSUuid.read((String)rsToGetAccount.getString("fcaa")));
            account.setCAA(caa);
            account.setAC(rsToGetAccount.getBoolean("fac"));
            account.setIsQty(rsToGetAccount.getBoolean("fisQty"));
            account.setNumber(accountID);
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)rsToGetAccount.getInt("facctcurrency")));
        }
        return account;
    }

    public Object[] getExchangeRate(Context ctx, ProfitCenterOrgUnitInfo profitCenter, CompanyOrgUnitInfo curCompany, CompanyOrgUnitInfo relatedCompany, String orgCurrencyId) throws EASBizException, BOSException {
        CurrencyInfo reportCur = relatedCompany.getReportCurrency();
        CurrencyInfo localCur = relatedCompany.getBaseCurrency();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        AccountTableInfo accouttable = relatedCompany.getAccountTable();
        String cuid = relatedCompany.getCU().getId().toString();
        otherCtx.put("COMPANY", curCompany);
        otherCtx.put("COMPANYID", curCompany);
        otherCtx.put("PROFITCENTER", profitCenter);
        otherCtx.put("PROFITCENTERID", profitCenter.getId().toString());
        otherCtx.put("CUID", cuid);
        otherCtx.put("ACCOUNTTABLEID", accouttable.getId().toString());
        otherCtx.put("RELATEDCOMPANY", relatedCompany);
        otherCtx.put("RELATEDCOMPANYID", relatedCompany.getId().toString());
        LowTimer low = new LowTimer();
        low.reset();
        ArrayList al = PcAssistInitFacadeFactory.getLocalInstance(ctx).findInitData(otherCtx);
        int index = 0;
        ++index;
        int n = ++index;
        ++index;
        Boolean b = (Boolean)al.get(n);
        boolean isUsingReport = b;
        int n2 = ++index;
        ++index;
        PeriodInfo startPeriod = (PeriodInfo)al.get(n2);
        Object[] info = new Object[8];
        if (relatedCompany.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        info[0] = relatedCompany.getBaseExchangeTable().getId().toString();
        info[2] = orgCurrencyId;
        info[3] = localCur.getId().toString();
        if (isUsingReport) {
            info[4] = reportCur.getId().toString();
            info[1] = relatedCompany.getReportExchangeTable().getId().toString();
        }
        info[6] = startPeriod.getBeginDate();
        info[5] = startPeriod.getBeginDate();
        info[7] = relatedCompany.getId().toString();
        Object[] exes = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
        return exes;
    }

    public CompanyOrgUnitInfo getCompany(Context ctx) throws UuidException, SQLException, Exception {
        Map pageParam = super.getContextMap();
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String orgUnitId = pageParam.get("COMPANYID").toString();
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        ObjectUuidPK pk = new ObjectUuidPK(orgUnitId);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)PcaUtils.getCompanySic());
        CompanyOrgUnitInfo unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        if (this.paramCache.get(orgUnitId) != null) {
            this.otherParam.put("ISUSEREPORT", this.paramCache.get(unitInfo.getId().toString()));
        } else {
            GlParam glParam = GlParam.getGlParams((Context)ctx, (String)"G001", (String)unitInfo.getId().toString());
            glParam.getBoolean("G001");
            this.otherParam.put("ISUSEREPORT", glParam.getBoolean("G001"));
            this.paramCache.put(orgUnitId, glParam.getBoolean("G001"));
        }
        return unitInfo;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InitPcAssistBalanceInfo infos = new InitPcAssistBalanceInfo();
        infos.setFromExcel(true);
        infos.put("persist_status", "new");
        Map pageParam = super.getContextMap();
        String Fcaaname = ((DataToken)hsData.get((Object)"FCAA")).data.toString();
        String faccid = null;
        String fmeasureunitgroupid = null;
        try {
            BigDecimal amt;
            BigDecimal qty;
            boolean isSettleByLocal;
            MeasureUnitInfo minfo;
            String sqltoacctaccount;
            IRowSet rsToGetAcctname;
            CompanyOrgUnitInfo[] relateCompanys;
            ProfitCenterOrgUnitInfo profitCenter = this.getProfitCenter(ctx, hsData, pageParam.get("PROFITCENTERID").toString());
            this.otherParam.put("PROFITCENTER", profitCenter);
            this.profitCenterid = profitCenter.getId().toString();
            infos.setProfitCenter(profitCenter);
            String orgUnitNum = ((DataToken)hsData.get((Object)"FOrgUnitID")).data.toString();
            if (StringUtils.isEmpty((String)orgUnitNum)) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"companyIsNull", (Locale)ctx.getLocale()));
            }
            CompanyOrgUnitInfo company = null;
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isBizUnit"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportConvertMode"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("number", (Object)orgUnitNum));
            CompanyOrgUnitCollection cs = companyOrgUnit.getCompanyOrgUnitCollection(view);
            if (cs.size() == 1) {
                company = cs.get(0);
            }
            if ((relateCompanys = (CompanyOrgUnitInfo[])this.companyMap.get(profitCenter.getNumber() + "RelatedCom")) == null) {
                relateCompanys = PcaUtils.getRelatedAndAccountingCompany(ctx, profitCenter.getId().toString());
                this.companyMap.put(profitCenter.getNumber() + "RelatedCom", relateCompanys);
            }
            boolean isRelatedCom = false;
            for (int j = 0; j < relateCompanys.length && company != null; ++j) {
                if (!relateCompanys[j].getId().toString().equals(company.getId().toString())) continue;
                isRelatedCom = true;
                break;
            }
            if (!isRelatedCom) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"companyIsNotRelatedCompany", (Locale)ctx.getLocale()));
            }
            infos.setOrgUnit(company);
            this.otherParam.put("COMPANY", company);
            this.otherParam.put("COMPANYID", company.getId().toString());
            CompanyOrgUnitInfo relatedCompany = PcaUtils.getRelatedCompany(ctx, profitCenter.getId().toString());
            this.relatedCompanyId = relatedCompany.getId().toString();
            this.otherParam.put("RELATEDCOMPANY", relatedCompany);
            this.otherParam.put("RELATEDCOMPANYID", relatedCompany.getId().toString());
            if (this.paramCache.get(this.relatedCompanyId) != null) {
                this.otherParam.put("ISUSEREPORT", this.paramCache.get(this.relatedCompanyId));
            } else {
                GlParam glParam = GlParam.getGlParams((Context)ctx, (String)"G001", (String)this.relatedCompanyId);
                this.otherParam.put("ISUSEREPORT", glParam.getBoolean("G001"));
                this.paramCache.put(this.relatedCompanyId, glParam.getBoolean("G001"));
            }
            CurrencyInfo currency = this.getCurrency(ctx, hsData);
            this.currecyID = currency.getId().toString();
            infos.setCurrency(currency);
            AccountViewInfo account = this.getAccount(ctx, currency, hsData, this.relatedCompanyId, false);
            String FAccountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
            this.accountid = account.getId().toString();
            infos.setAccount(account);
            String sqlToGetAcctType = "SELECT TOP 1 b.FID,b.fmeasureunitgroupid FROM T_BD_AsstAccount b join t_bd_accountview a on a.fcaa=b.fid where rtrim(ltrim(b.Fname_" + ctx.getLocale() + "))=? and a.fnumber=? and a.fcompanyid=?";
            IRowSet rsToGetAcctType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctType, (Object[])new Object[]{Fcaaname, FAccountID, this.relatedCompanyId});
            if (rsToGetAcctType == null || !rsToGetAcctType.next()) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1074_InitAssistBalanceImport", (Locale)ctx.getLocale()));
            }
            faccid = rsToGetAcctType.getString("FID");
            fmeasureunitgroupid = rsToGetAcctType.getString("fmeasureunitgroupid");
            if (faccid != null && (rsToGetAcctname = DbUtil.executeQuery((Context)ctx, (String)(sqltoacctaccount = "select c.Fname_" + ctx.getLocale() + " Fname from T_BD_AsstAccount a  inner join T_BD_AsstActGroupDetail b on a.fid=b.fasstaccountid  inner join  t_bd_asstacttype c on b.fasstacttypeid=c.fid where a.FID=? order by c.fnumber"), (Object[])new Object[]{faccid})) != null) {
                int siz = rsToGetAcctname.size();
                String[] asstactTypeName = new String[siz];
                String[] asstactTypeNumber = new String[siz];
                String[] asstactType = new String[siz];
                for (int iop = 0; iop < siz; ++iop) {
                    rsToGetAcctname.next();
                    asstactType[iop] = rsToGetAcctname.getString("Fname");
                }
                for (int i = 0; i < siz; ++i) {
                    int counts = 8;
                    for (int ii = 0; ii < counts; ++ii) {
                        String Fitem = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fitem_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                        if (!Fitem.equals(asstactType[i]) || ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fnumber_").append((String)String.valueOf((int)(ii + 1))).toString())).data == null || ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fname_").append((String)String.valueOf((int)(ii + 1))).toString())).data == null) continue;
                        asstactTypeNumber[i] = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fnumber_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                        asstactTypeName[i] = ((DataToken)hsData.get((Object)new StringBuilder().append((String)"Fname_").append((String)String.valueOf((int)(ii + 1))).toString())).data.toString();
                        break;
                    }
                    if (asstactTypeNumber[i] != null) continue;
                    throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1016_InitImportBase", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1017_InitImportBase", (Locale)ctx.getLocale()));
                }
                AssistantHGInfo assistantHGInfo = new AssistantHGInfo();
                AsstActTypeCollection arrayAsstActTypeInfo = new AsstActTypeCollection();
                int count = asstactTypeName.length;
                for (int i = 0; i < count; ++i) {
                    this.constructAssistInfo(ctx, assistantHGInfo, asstactType[i], asstactTypeNumber[i], asstactTypeName[i], arrayAsstActTypeInfo, relatedCompany.getCU().getId().toString(), relatedCompany);
                }
                IAssistantHG igCtrl = AssistantHGFactory.getLocalInstance((Context)ctx);
                AssistantHGInfo actualAssistantHGInfo = igCtrl.getAssistantHG(assistantHGInfo, faccid, arrayAsstActTypeInfo);
                this.actualAssistantHGInfoID = actualAssistantHGInfo.getId().toString();
                infos.setAssistGrp(actualAssistantHGInfo);
            }
            String sqls = "select top 1 FID from T_PCA_InitPcAssistBalance  where FProfitCenterID=? and FOrgUnitID=? and FAccountID=?  and  FCurrencyID=? and FAssistGrpID=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqls, (Object[])new Object[]{this.profitCenterid, company.getId().toString(), this.accountid, this.currecyID, this.actualAssistantHGInfoID});
            if (this.isSltImportUpdate()) {
                if (rs.next()) {
                    String sql = "delete from T_PCA_InitPcAssistBalance  where FProfitCenterID=? and FOrgUnitID=? and FAccountID=?  and  FCurrencyID=? and FAssistGrpID=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{this.profitCenterid, company.getId().toString(), this.accountid, this.currecyID, this.actualAssistantHGInfoID});
                }
            } else if (rs.size() > 0) {
                throw new TaskExternalException(GLResUtil.getRes((String)"cannot_import_repeated_records"));
            }
            if ((minfo = this.getMeasureUnit(ctx, fmeasureunitgroupid, hsData)) != null) {
                infos.setMesureUnit(minfo);
            }
            Object[] exes = this.getExchangeRate(ctx, profitCenter, company, relatedCompany, this.currecyID);
            VoucherInfo.ExchangeRateWithValue lex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            VoucherInfo.ExchangeRateWithValue rex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            if (exes != null) {
                if (exes[0] != null) {
                    lex = (VoucherInfo.ExchangeRateWithValue)exes[0];
                }
                if (exes[1] != null) {
                    rex = (VoucherInfo.ExchangeRateWithValue)exes[1];
                }
            }
            boolean isLocal = this.currecyID.equals(relatedCompany.getBaseCurrency().getId().toString());
            BigDecimal yearDebitFor = new BigDecimal("0");
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearDebitFor")).data)) {
                infos.setYearDebitFor(this.getValue(hsData.get("FYearDebitFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitLocal")).data)) {
                BigDecimal yearDebitLocal;
                if (currency.getId().toString().equals(relatedCompany.getBaseCurrency().getId().toString())) {
                    yearDebitLocal = yearDebitFor;
                } else {
                    yearDebitLocal = this.getValue(hsData.get("FYearDebitLocal"));
                    yearDebitLocal = yearDebitLocal.setScale(relatedCompany.getBaseCurrency().getPrecision(), 4);
                }
                infos.setYearDebitLocal(yearDebitLocal);
            } else if (infos.getYearDebitFor() != null) {
                infos.setYearDebitLocal(lex.getValue().multiply(infos.getYearDebitFor()));
            }
            boolean bl = isSettleByLocal = 3 == relatedCompany.getReportConvertMode().getValue();
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitRpt")).data)) {
                infos.setYearDebitRpt(this.getValue(hsData.get("FYearDebitRpt")));
            } else if (infos.getYearDebitFor() != null) {
                if (isSettleByLocal) {
                    infos.setYearDebitRpt(rex.getValue().multiply(infos.getYearDebitLocal()));
                } else {
                    infos.setYearDebitRpt(rex.getValue().multiply(infos.getYearDebitFor()));
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitQty")).data)) {
                qty = this.getValue(hsData.get("FYearDebitQty"));
                infos.setYearDebitQty(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                }
                infos.setStabdardYearDebitQty(qty);
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditQty")).data)) {
                qty = this.getValue(hsData.get("FYearCreditQty"));
                infos.setYearCreditQty(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                }
                infos.setStabdardYearCreditQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearCreditFor")).data)) {
                infos.setYearCreditFor(this.getValue(hsData.get("FYearCreditFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditLocal")).data)) {
                infos.setYearCreditLocal(this.getValue(hsData.get("FYearCreditLocal")));
            } else if (infos.getYearCreditFor() != null) {
                infos.setYearCreditLocal(lex.getValue().multiply(infos.getYearCreditFor()));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditRpt")).data)) {
                infos.setYearCreditRpt(this.getValue(hsData.get("FYearCreditRpt")));
            } else if (infos.getYearCreditFor() != null) {
                if (isSettleByLocal) {
                    infos.setYearCreditRpt(rex.getValue().multiply(infos.getYearCreditLocal()));
                } else {
                    infos.setYearCreditRpt(rex.getValue().multiply(infos.getYearCreditFor()));
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FBeginQty")).data)) {
                infos.setEndQty(this.getValue(hsData.get("FBeginQty")));
                qty = this.getValue(hsData.get("FBeginQty"));
                infos.setBeginQty(qty);
                if (minfo != null) {
                    qty = qty.multiply(minfo.getCoefficient());
                }
                infos.setStabdardBeginQty(qty);
                infos.setStabdardEndQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceFor")).data)) {
                infos.setBeginBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
                infos.setEndBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceLocal")).data)) {
                infos.setBeginBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
                infos.setEndBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
            } else if (infos.getBeginBalanceFor() != null) {
                infos.setBeginBalanceLocal(lex.getValue().multiply(infos.getBeginBalanceFor()));
                infos.setEndBalanceLocal(lex.getValue().multiply(infos.getBeginBalanceFor()));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceRpt")).data)) {
                infos.setBeginBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
                infos.setEndBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
            } else if (infos.getBeginBalanceFor() != null) {
                if (isSettleByLocal) {
                    infos.setBeginBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceLocal()));
                    infos.setEndBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceLocal()));
                } else {
                    infos.setBeginBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceFor()));
                    infos.setEndBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceFor()));
                }
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearPnLFor")).data)) {
                infos.setYearPnLFor(this.getValue(hsData.get("FYearPnLFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLLocal")).data)) {
                infos.setYearPnLLocal(this.getValue(hsData.get("FYearPnLLocal")));
            } else if (infos.getYearPnLFor() != null) {
                infos.setYearPnLLocal(lex.getValue().multiply(infos.getYearPnLFor()));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLRpt")).data)) {
                infos.setYearPnLRpt(this.getValue(hsData.get("FYearPnLRpt")));
            } else if (infos.getYearPnLFor() != null) {
                if (isSettleByLocal) {
                    infos.setYearPnLRpt(rex.getValue().multiply(infos.getYearPnLLocal()));
                } else {
                    infos.setYearPnLRpt(rex.getValue().multiply(infos.getYearPnLFor()));
                }
            }
            if (infos.getYearDebitFor() != null) {
                amt = infos.getYearDebitFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearDebitFor(amt);
            }
            if (infos.getYearDebitLocal() != null) {
                amt = infos.getYearDebitLocal();
                amt = amt.setScale(relatedCompany.getBaseCurrency().getPrecision(), 4);
                infos.setYearDebitLocal(amt);
            }
            if (infos.getYearDebitRpt() != null) {
                amt = infos.getYearDebitRpt();
                int precision = relatedCompany.getBaseCurrency().getPrecision();
                if (relatedCompany.getReportCurrency() != null) {
                    precision = relatedCompany.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearDebitRpt(amt);
            }
            if (infos.getYearCreditFor() != null) {
                amt = infos.getYearCreditFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearCreditFor(amt);
            }
            if (infos.getYearCreditLocal() != null) {
                amt = infos.getYearCreditLocal();
                amt = amt.setScale(relatedCompany.getBaseCurrency().getPrecision(), 4);
                infos.setYearCreditLocal(amt);
            }
            if (infos.getYearCreditRpt() != null) {
                amt = infos.getYearCreditRpt();
                int precision = relatedCompany.getBaseCurrency().getPrecision();
                if (relatedCompany.getReportCurrency() != null) {
                    precision = relatedCompany.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearCreditRpt(amt);
            }
            if (infos.getBeginBalanceFor() != null) {
                amt = infos.getBeginBalanceFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setBeginBalanceFor(amt);
            }
            if (infos.getBeginBalanceLocal() != null) {
                amt = infos.getBeginBalanceLocal();
                amt = amt.setScale(relatedCompany.getBaseCurrency().getPrecision(), 4);
                infos.setBeginBalanceLocal(amt);
            }
            if (infos.getBeginBalanceRpt() != null) {
                amt = infos.getBeginBalanceRpt();
                int precision = relatedCompany.getBaseCurrency().getPrecision();
                if (relatedCompany.getReportCurrency() != null) {
                    precision = relatedCompany.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setBeginBalanceRpt(amt);
            }
            if (infos.getYearPnLFor() != null) {
                amt = infos.getYearPnLFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearPnLFor(amt);
            }
            if (infos.getYearPnLLocal() != null) {
                amt = infos.getYearPnLLocal();
                amt = amt.setScale(relatedCompany.getBaseCurrency().getPrecision(), 4);
                infos.setYearPnLLocal(amt);
            }
            if (infos.getYearPnLRpt() != null) {
                amt = infos.getYearPnLRpt();
                int precision = relatedCompany.getBaseCurrency().getPrecision();
                if (relatedCompany.getReportCurrency() != null) {
                    precision = relatedCompany.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearPnLRpt(amt);
            }
            return infos;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getType() {
        return "InitPcAssistBalance";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            this.getCurrencyPrecision(ctx);
            result.put("Fno", this.rowNumber);
            result.put("FProfitCenterId", rs.getString("profitCenter.number"));
            result.put("FOrgUnitID", rs.getString("orgUnit.number"));
            result.put("Fcurrency", rs.getString("currency.number"));
            result.put("FCAA", rs.getString("asstAccount.name"));
            result.put("FAccountID", rs.getString("account.number"));
            String assistGrpID = rs.getString("assistGrp.id");
            List<Map<String, String>> asstActItemList = this.getAsstActItemList(ctx, assistGrpID);
            int size = asstActItemList.size();
            for (int i = 0; i < size; ++i) {
                Map<String, String> tempList = asstActItemList.get(i);
                result.put("Fitem_" + (i + 1), tempList.get("asstActTypeName"));
                result.put("Fnumber_" + (i + 1), tempList.get("asstActItemNumber"));
                result.put("Fname_" + (i + 1), tempList.get("asstActItemName"));
            }
            String currencyId = rs.getString("currency.id");
            int currencyPre = this.currencyMap.get(currencyId) == null ? 2 : Integer.parseInt(this.currencyMap.get(currencyId).toString());
            result.put("MeasureUnit", rs.getString("mesureUnit.number") == null ? "" : rs.getString("mesureUnit.number"));
            result.put("FYearDebitQty", rs.getBigDecimal("yearDebitQty").setScale(this.qtyScale, 4));
            result.put("FYearDebitFor", rs.getBigDecimal("yearDebitFor").setScale(currencyPre, 4));
            result.put("FYearDebitLocal", rs.getBigDecimal("yearDebitLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearDebitRpt", rs.getBigDecimal("yearDebitRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearCreditQty", rs.getBigDecimal("yearCreditQty").setScale(this.qtyScale, 4));
            result.put("FYearCreditFor", rs.getBigDecimal("yearCreditFor").setScale(currencyPre, 4));
            result.put("FYearCreditLocal", rs.getBigDecimal("yearCreditLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearCreditRpt", rs.getBigDecimal("yearCreditRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FBeginQty", rs.getBigDecimal("beginQty").setScale(this.qtyScale, 4));
            result.put("FBeginBalanceFor", rs.getBigDecimal("beginBalanceFor").setScale(currencyPre, 4));
            result.put("FBeginBalanceLocal", rs.getBigDecimal("beginBalanceLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FBeginBalanceRpt", rs.getBigDecimal("beginBalanceRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearPnLFor", rs.getBigDecimal("yearPnLFor").setScale(currencyPre, 4));
            result.put("FYearPnLLocal", rs.getBigDecimal("yearPnLLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearPnLRpt", rs.getBigDecimal("yearPnLRpt").setScale(this.reportCurrencyPrecision, 4));
            ++this.rowNumber;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    private List<Map<String, String>> getAsstActItemList(Context ctx, String assistGrpID) throws BOSException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        StringBuffer sql = new StringBuffer();
        Locale locale = ctx.getLocale();
        sql.append("select type.FName_" + locale + " FName, type.FRealtionDataObject, type.FMappingFieldName");
        sql.append("  from T_BD_AsstActType type");
        sql.append("  inner join T_BD_AsstActGroupDetail detail on detail.FAsstActTypeID = type.FID");
        sql.append("  inner join T_BD_AsstAccount asstacc on asstacc.FID = detail.FAsstAccountID");
        sql.append("  inner join T_BD_AssistantHG hg on hg.FAsstAccountID = asstacc.FID");
        sql.append("  where hg.FID = ? order by detail.FSeq ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{assistGrpID});
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String asstActTypeName = rs.getString("FName");
                map.put("asstActTypeName", asstActTypeName);
                String tableName = rs.getString("FRealtionDataObject");
                String fieldName = rs.getString("FMappingFieldName");
                StringBuffer itemSql = new StringBuffer();
                String fnubmer = "t.FNumber";
                if ("T_BD_GeneralAsstActType".equalsIgnoreCase(tableName)) {
                    fnubmer = "t.FLongNumber FNumber";
                }
                itemSql.append("select t.FName_" + locale + " FName," + fnubmer);
                itemSql.append("  from T_BD_AssistantHG hg");
                itemSql.append(" inner join ").append(tableName).append(" t on t.FID = hg.").append(fieldName);
                itemSql.append(" where hg.FID = ? ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)itemSql.toString(), (Object[])new Object[]{assistGrpID});
                if (rowSet.next()) {
                    String number = rowSet.getString("FNumber");
                    if ("T_BD_GeneralAsstActType".equalsIgnoreCase(tableName) && number != null) {
                        number = number.replaceAll("!", ".");
                    }
                    map.put("asstActItemNumber", number);
                    map.put("asstActItemName", rowSet.getString("FName"));
                }
                result.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void getCurrencyPrecision(Context ctx) throws EASBizException, BOSException {
        if (!this.isFirstLoaded) {
            return;
        }
        Map paramMap = this.getContextMap();
        String profitCenterId = (String)paramMap.get("profitCenter.id");
        if (StringUtils.isEmpty((String)profitCenterId)) {
            profitCenterId = ContextUtil.getCurrentProfitUnit((Context)ctx).getId().toString();
        }
        CompanyOrgUnitInfo companyInfo = PcaUtils.getDelegateCompany(ctx, profitCenterId);
        this.orgNumber = companyInfo.getNumber();
        this.baseCurrencyPrecision = companyInfo.getBaseCurrency() == null ? 4 : companyInfo.getBaseCurrency().getPrecision();
        this.reportCurrencyPrecision = companyInfo.getReportCurrency() == null ? 4 : companyInfo.getReportCurrency().getPrecision();
        ArrayList<String> paramKeys = new ArrayList<String>();
        paramKeys.add("GL_002");
        Map hmParam = PcaUtils.getParamsByKeys(ctx, companyInfo.getId().toString(), paramKeys);
        this.qtyScale = hmParam.get("GL_002") == null ? 0 : Integer.parseInt(hmParam.get("GL_002").toString());
        CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id, precision ");
        for (CurrencyInfo currencyInfo : currencyColl) {
            this.currencyMap.put(currencyInfo.getId().toString(), currencyInfo.getPrecision());
        }
        this.isFirstLoaded = false;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        Set keySet = paramMap.keySet();
        for (String key : keySet) {
            String value = (String)paramMap.get(key);
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)value));
        }
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)"11111111-1111-1111-1111-111111111111DEB58FDC", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)"22222222-2222-2222-2222-222222222222DEB58FDC", CompareType.NOTEQUALS));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.ma.pca.app.PcaAsstInitQuery";
    }

    protected boolean constructAssistInfo(Context ctx, AssistantHGInfo assistantHGInfo, String strAsstActTypeName, String strAsstActID, String strAsstName, AsstActTypeCollection arrayAsstActTypeInfo, String cuId, CompanyOrgUnitInfo company) throws Exception {
        AsstActTypeInfo asstActTypeInfo;
        boolean isAssit = false;
        if (strAsstActTypeName != null && strAsstActTypeName.trim().length() > 0) {
            isAssit = true;
        }
        if (!StringUtil.isEmptyString((String)strAsstActID)) {
            isAssit = true;
            strAsstActID = strAsstActID.trim();
        }
        if (!StringUtil.isEmptyString((String)strAsstName)) {
            isAssit = true;
            strAsstName = strAsstName.trim();
        }
        if (isAssit && (asstActTypeInfo = GlWebServiceUtil.findAsstActtypeNumberByName((Context)ctx, (String)strAsstActTypeName)) != null) {
            arrayAsstActTypeInfo.add(asstActTypeInfo);
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            DataBaseInfo dataInfo = this.findAsstActObject(ctx, asstHGAttribute, assistantHGInfo, strAsstActTypeName, strAsstActID, strAsstName, arrayAsstActTypeInfo, cuId, company);
            if (dataInfo != null) {
                CostCenterOrgUnitInfo info;
                assistantHGInfo.put(asstHGAttribute, (Object)dataInfo);
                if (asstHGAttribute.equals("costOrg") ? (info = (CostCenterOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("adminOrg") ? (info = (AdminOrgUnitInfo)dataInfo) != null && !info.isIsLeaf() : (asstHGAttribute.equals("companyOrg") ? (info = (CompanyOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("saleOrg") ? (info = (SaleOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("purchaseOrg") ? (info = (PurchaseOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : (asstHGAttribute.equals("storeageOrg") ? (info = (StorageOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit() : asstHGAttribute.equals("profitOrg") && (info = (ProfitCenterOrgUnitInfo)dataInfo) != null && !info.isIsBizUnit())))))) {
                    throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1008_InitImportBase", (Locale)ctx.getLocale()));
                }
            } else {
                throw new Exception(strAsstActTypeName + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1009_InitImportBase", (Locale)ctx.getLocale()));
            }
        }
        return isAssit;
    }
}

