/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.ICrossPrintDataProvider;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucherAssistRecord;
import com.kingdee.eas.fi.gl.VoucherPrintDataProvider;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherPrintDataProvider;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PcVoucherCrossProvider
implements ICrossPrintDataProvider {
    private static final Logger logger = Logger.getLogger(PcVoucherCrossProvider.class);
    private Locale locale;
    private DateFormat df;
    private DateFormat dft;
    private PcVoucherCollection vchCol;
    private boolean isNext = false;
    private boolean isNextQty = false;
    private VoucherPrintSettingInfo settingInfo;
    private VoucherPrintDataProvider provider;
    private int index = 0;

    public PcVoucherCrossProvider(Locale locale, PcVoucherCollection vchCol, VoucherPrintSettingInfo settingInfo, boolean isNext, boolean isNextQty) throws EASBizException, BOSException {
        if (locale == null) {
            locale = SysContext.getSysContext().getLocale();
        }
        this.locale = locale;
        this.df = new SimpleDateFormat(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"20_RptAsstactXBalanceUI", (Locale)locale));
        this.dft = DateFormat.getDateTimeInstance(2, 2, locale);
        this.vchCol = vchCol;
        this.isNext = isNext;
        this.isNextQty = isNextQty;
        this.settingInfo = settingInfo;
        this.provider = new VoucherPrintDataProvider(settingInfo);
    }

    public boolean hasNext() {
        if (this.vchCol == null) {
            return false;
        }
        int size = this.vchCol.size();
        if (this.index < size) {
            PcVoucherInfo vch = this.vchCol.get(this.index);
            if (this.settingInfo.isAutoMachAsstTemplate()) {
                if (!this.isNext && !this.isNextQty && (this.isHasVchAsstRecord(vch) || this.isHasQty(vch))) {
                    this.getIndex();
                    return false;
                }
                if (this.isNext && (!this.isHasVchAsstRecord(vch) || this.isHasQty(vch))) {
                    this.getIndex();
                    return false;
                }
                if (this.isNextQty && !this.isHasQty(vch)) {
                    this.getIndex();
                    return false;
                }
            }
            if (this.isNext && !this.isHasVchAsstRecord(vch) || this.isNextQty && !this.isHasQty(vch)) {
                this.getIndex();
                return false;
            }
            return true;
        }
        return false;
    }

    protected PcVoucherInfo getVoucherInfo(int index) {
        return this.vchCol.get(index);
    }

    private boolean isHasVchAsstRecord(PcVoucherInfo vch) {
        for (PcVoucherEntryInfo e : vch.getEntries()) {
            if (e.getAssistRecords() == null || e.getAssistRecords().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isHasQty(PcVoucherInfo vch) {
        for (PcVoucherEntryInfo e : vch.getEntries()) {
            if (e.getAccount() == null || !e.getAccount().isIsQty()) continue;
            if (e.getAccount().isIsQty() && e.getAccount().getCAA() == null) {
                return true;
            }
            if (e.getAccount().isIsQty() && e.getAccount().getCAA() != null && e.getAccount().getCAA().isIsQty()) {
                return true;
            }
            if (this.provider.isAstQty() || e.getAccount().getCAA() == null || e.getAccount().getCAA().isIsQty()) continue;
            return true;
        }
        return false;
    }

    private synchronized int getIndex() {
        int count = this.index++;
        return count;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (("dsStandard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                break;
            }
            if (("flowStandard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                break;
            }
            if (("ds1_Standard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                break;
            }
            if (("flow1_Standard" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                break;
            }
            if (("ds" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 1);
                break;
            }
            if (("ds2_subtotal" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 2);
                break;
            }
            if (("voucher_ds" + i).equalsIgnoreCase(ds.getID())) {
                rs = this.getRowSet(i, 4);
                break;
            }
            if (!("vchFlow" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i, 5);
            break;
        }
        return rs;
    }

    private IRowSet getRowSet(int rowCount, int num) {
        int count = this.getIndex();
        if (count > this.vchCol.size()) {
            return null;
        }
        PcVoucherInfo vch = this.getVoucherInfo(count);
        return this.getRowSet(vch, rowCount, num);
    }

    private IRowSet getRowSet(PcVoucherInfo voucherInfo, int rowCount, int type) {
        switch (type) {
            case 1: {
                return this.getRowSet(rowCount, voucherInfo);
            }
            case 2: {
                return this.getRowSet2(rowCount, voucherInfo);
            }
            case 3: {
                return null;
            }
            case 4: {
                return this.getRowSet4(rowCount, voucherInfo);
            }
            case 5: {
                return this.getRowSet5(rowCount, voucherInfo);
            }
        }
        return null;
    }

    private IRowSet getRowSet(int rowLineCount, PcVoucherInfo vch) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = 1;
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            while (itr.hasNext()) {
                PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            int voucherCount = 0;
            voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
            int entryCount = 0;
            while (itrEntry.hasNext()) {
                PcVoucherEntryInfo e = (PcVoucherEntryInfo)itrEntry.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (PcVoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                        }
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        }
                        drs.insertRow();
                    }
                    continue;
                }
                drs.moveToInsertRow();
                this.provider.clearRow((IRowSet)drs);
                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                }
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet2(int rowLineCount, PcVoucherInfo vch) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            int seq = 0;
            while (itr.hasNext()) {
                PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                seq = e.getSeq();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            Object entryDC = null;
            int voucherCount = 0;
            voucherCount = (entrySize + seq) % rowLineCount == 0 ? (entrySize + seq) / rowLineCount : (entrySize + seq) / rowLineCount + 1;
            int entryCount = 1;
            while (itrEntry.hasNext()) {
                int page;
                PcVoucherEntryInfo e = (PcVoucherEntryInfo)itrEntry.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (PcVoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                            drs.updateString("e_account", null);
                        }
                        int page2 = 0;
                        page2 = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        drs.updateString("pageCount", page2 + "/" + voucherCount);
                        drs.updateString("pageCurrent", page2 + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page2 == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("sum", "");
                        }
                        drs.insertRow();
                    }
                } else {
                    drs.moveToInsertRow();
                    this.provider.clearRow((IRowSet)drs);
                    this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                    this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                    if (EntryDC.DEBIT.equals((Object)dc)) {
                        drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                        drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                        drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                        drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                        drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    } else {
                        drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                        drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                        drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                        drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                        drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                        drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    }
                    page = 0;
                    page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                    drs.updateString("pageCount", page + "/" + voucherCount);
                    drs.updateString("pageCurrent", page + "");
                    drs.updateString("pageTotal", "" + voucherCount);
                    drs.updateString("bizStatus", vch.getBizStatus().toString());
                    drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                    drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                    if (page == voucherCount) {
                        drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                        drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                        drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                        drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                        drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                        drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                        drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                        drs.updateString("sum", "");
                    }
                    drs.insertRow();
                }
                drs.moveToInsertRow();
                drs.updateString("e_seq", "");
                drs.updateString("e_description", "");
                drs.updateString("e_account", "");
                drs.updateString("zc_account", "");
                drs.updateString("e_currency", "");
                drs.updateString("e_measureUnitName", "");
                drs.updateString("e_measureUnitNumber", "");
                drs.updateString("periodYear", "");
                drs.updateString("periodNumber", "");
                drs.updateString("bizDate", "");
                drs.updateString("bookedDate", "");
                drs.updateString("bookedDateYear", "");
                drs.updateString("bookedDateMonth", "");
                drs.updateString("r_description", "");
                drs.updateString("r_settlementType", "");
                drs.updateString("r_settlementCode", "");
                drs.updateString("r_bizNumber", "");
                drs.updateString("r_originalAmount", "");
                drs.updateString("r_originalAmount", "");
                drs.updateString("r_originalAmountDebit", "");
                drs.updateString("r_reportingAmount", "");
                drs.updateString("r_localAmount", "");
                drs.updateString("r_localAmountDebit", "");
                drs.updateString("r_localAmountCredit", "");
                drs.updateString("r_price", "");
                drs.updateString("r_quantity", "");
                drs.updateString("r_bizDate", "");
                drs.updateString("r_invoice", "");
                drs.updateString("r_endDate", "");
                drs.updateString("r_assGrp", "");
                drs.updateString("r_longName", "");
                drs.updateString("r_accountAsst", "");
                drs.updateString("r_AsstHeadNumber", "");
                drs.updateString("r_AsstNumber", "");
                drs.updateString("r_AsstHeadName", "");
                drs.updateString("r_AsstName", "");
                drs.updateString("r_AsstLevelName", "");
                drs.updateString("zc_assGrp", "");
                drs.updateString("c_item", "");
                drs.updateString("c_itemEbb", "");
                drs.updateString("c_primItem", "");
                drs.updateString("c_suppItem", "");
                drs.updateString("c_oppAccount", "");
                drs.updateString("c_originalAmount", "");
                drs.updateString("c_localAmount", "");
                drs.updateString("c_reportingAmount", "");
                drs.updateString("customer.number", "");
                drs.updateString("customer.name", "");
                drs.updateString("cusNumberName", "");
                drs.updateString("vchId", vchId);
                drs.updateString("e_isoCode", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                }
                page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet4(int rowLineCount, PcVoucherInfo vch) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            while (itr.hasNext()) {
                PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            Object entryDC = null;
            boolean rowCount = false;
            int voucherCount = 0;
            voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
            int entryCount = 0;
            BigDecimal creditTotal = GlUtils.zero;
            BigDecimal debitTotal = GlUtils.zero;
            HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
            for (PcVoucherEntryInfo e : vch.getEntries()) {
                EntryDC dc = e.getEntryDC();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (PcVoucherAssistRecordInfo r : assitCollection) {
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        if (entryCount % rowLineCount != 0) continue;
                        creditmap.put(String.valueOf(page), creditTotal);
                        debitmap.put(String.valueOf(page), debitTotal);
                    }
                    continue;
                }
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                if (entryCount % rowLineCount == 1) {
                    creditTotal = GlUtils.zero;
                    debitTotal = GlUtils.zero;
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                if (entryCount % rowLineCount != 0) continue;
                creditmap.put(String.valueOf(page), creditTotal);
                debitmap.put(String.valueOf(page), debitTotal);
            }
            entryCount = 0;
            while (itrEntry.hasNext()) {
                PcVoucherEntryInfo e;
                e = (PcVoucherEntryInfo)itrEntry.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (PcVoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                        }
                        int page = 0;
                        if (++entryCount % rowLineCount == 0) {
                            page = entryCount / rowLineCount;
                        } else {
                            page = entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("sum", "");
                        } else {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("sum", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                        }
                        drs.insertRow();
                    }
                    continue;
                }
                drs.moveToInsertRow();
                this.provider.clearRow((IRowSet)drs);
                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                }
                int page = 0;
                if (++entryCount % rowLineCount == 0) {
                    page = entryCount / rowLineCount;
                } else {
                    page = entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = GlUtils.zero;
                        debitTotal = GlUtils.zero;
                    }
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                    drs.updateString("sum", "");
                } else {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                    drs.updateString("sum", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                }
                String acctname = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
                String zc_listacctname = null;
                zc_listacctname = acctname.indexOf("_", 0) != -1 ? acctname.substring(acctname.indexOf("_", 0) + 1, acctname.length()) : acctname.substring(acctname.indexOf("-", 0) + 1, acctname.length());
                drs.updateString("zc_assGrp", zc_listacctname);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    private IRowSet getRowSet5(int rowLineCount, PcVoucherInfo vch) {
        int colCount = PcVoucherPrintDataProvider.col.length;
        DynamicRowSet drs = null;
        IAssistantHG assistantHG = null;
        IBaseVoucherAssistRecord asstre = null;
        try {
            drs = new DynamicRowSet(colCount);
            for (int i = 0; i < colCount; ++i) {
                ColInfo ci = new ColInfo();
                ci.colType = 12;
                ci.columnName = PcVoucherPrintDataProvider.col[i];
                ci.nullable = 1;
                drs.setColInfo(i + 1, ci);
            }
            drs.beforeFirst();
            int size = this.vchCol.size();
            BigDecimal allDeit = SysConstant.BIGZERO;
            BigDecimal allCret = SysConstant.BIGZERO;
            int vchCount = 0;
            String vchId = Integer.toString(++vchCount);
            CompanyOrgUnitInfo com = vch.getCompany();
            CurrencyInfo localCurrency = com.getBaseCurrency();
            int lcpre = localCurrency.getPrecision();
            CurrencyInfo reportingCurrency = com.getReportCurrency();
            int rcpre = reportingCurrency == null ? lcpre : reportingCurrency.getPrecision();
            allDeit = vch.getLocalDebitAmount();
            allCret = vch.getLocalCreditAmount();
            Iterator itr = vch.getEntries().iterator();
            int entrySize = 0;
            while (itr.hasNext()) {
                PcVoucherEntryInfo e = (PcVoucherEntryInfo)itr.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    entrySize += assitCollection.size();
                    continue;
                }
                ++entrySize;
            }
            Iterator itrEntry = vch.getEntries().iterator();
            int voucherCount = 0;
            voucherCount = entrySize % rowLineCount == 0 ? entrySize / rowLineCount : entrySize / rowLineCount + 1;
            int entryCount = 0;
            BigDecimal creditTotal = GlUtils.zero;
            BigDecimal debitTotal = GlUtils.zero;
            HashMap<String, BigDecimal> creditmap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> debitmap = new HashMap<String, BigDecimal>();
            for (PcVoucherEntryInfo e : vch.getEntries()) {
                EntryDC dc = e.getEntryDC();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (PcVoucherAssistRecordInfo r : assitCollection) {
                        int page = 0;
                        page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                        if (entryCount % rowLineCount == 1) {
                            creditTotal = GlUtils.zero;
                            debitTotal = GlUtils.zero;
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        if (entryCount % rowLineCount != 0) continue;
                        creditmap.put(String.valueOf(page), creditTotal);
                        debitmap.put(String.valueOf(page), debitTotal);
                    }
                    continue;
                }
                int page = 0;
                page = ++entryCount % rowLineCount == 0 ? entryCount / rowLineCount : entryCount / rowLineCount + 1;
                if (entryCount % rowLineCount == 1) {
                    creditTotal = GlUtils.zero;
                    debitTotal = GlUtils.zero;
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                if (entryCount % rowLineCount != 0) continue;
                creditmap.put(String.valueOf(page), creditTotal);
                debitmap.put(String.valueOf(page), debitTotal);
            }
            entryCount = 0;
            while (itrEntry.hasNext()) {
                PcVoucherEntryInfo e;
                e = (PcVoucherEntryInfo)itrEntry.next();
                PcVoucherAssistRecordCollection assitCollection = e.getAssistRecords();
                EntryDC dc = e.getEntryDC();
                int asstCount = 0;
                if (assitCollection != null && assitCollection.size() > 0) {
                    for (PcVoucherAssistRecordInfo r : assitCollection) {
                        drs.moveToInsertRow();
                        this.provider.clearRow((IRowSet)drs);
                        this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                        this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                        if (this.settingInfo.isPrintAssistant()) {
                            this.provider.fillVoucherASSTData((BaseVoucherAssistRecordInfo)r, (IRowSet)drs, this.df, lcpre, dc, assistantHG, asstre, (BaseVoucherEntryInfo)e, vch.getCompany().getId().toString());
                        }
                        if (++asstCount > 1) {
                            drs.updateString("e_seq", " ");
                        }
                        int page = 0;
                        if (++entryCount % rowLineCount == 0) {
                            page = entryCount / rowLineCount;
                        } else {
                            page = entryCount / rowLineCount + 1;
                            if (entryCount % rowLineCount == 1) {
                                creditTotal = GlUtils.zero;
                                debitTotal = GlUtils.zero;
                            }
                        }
                        if (EntryDC.DEBIT.equals((Object)dc)) {
                            debitTotal = debitTotal.add(r.getLocalAmount());
                        } else {
                            creditTotal = creditTotal.add(r.getLocalAmount());
                        }
                        drs.updateString("pageCount", page + "/" + voucherCount);
                        drs.updateString("pageCurrent", page + "");
                        drs.updateString("pageTotal", "" + voucherCount);
                        drs.updateString("bizStatus", vch.getBizStatus().toString());
                        drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                        drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                        if (page == voucherCount) {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                            drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                            drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                            drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                            drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                            drs.updateString("sum", "");
                        } else {
                            drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                            drs.updateString("sum", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                        }
                        drs.insertRow();
                    }
                    continue;
                }
                drs.moveToInsertRow();
                this.provider.clearRow((IRowSet)drs);
                this.provider.fillVoucherHeaderData((BaseVoucherInfo)vch, (IRowSet)drs, this.df, this.dft, size, allDeit, allCret);
                this.provider.fillVoucherEntryData(vchId, (BaseVoucherEntryInfo)e, (IRowSet)drs, lcpre, rcpre, vch.getCompany().getId().toString());
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    drs.updateString("e_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    drs.updateString("r_originalAmountDebit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("r_localAmountDebit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("r_reportingAmountDebit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                } else {
                    drs.updateString("e_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("e_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("e_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                    drs.updateString("r_originalAmountCredit", GlUtils.formatNumber((BigDecimal)e.getOriginalAmount(), (int)lcpre));
                    drs.updateString("r_localAmountCredit", GlUtils.formatNumber((BigDecimal)e.getLocalAmount(), (int)lcpre));
                    drs.updateString("r_reportingAmountCredit", GlUtils.formatNumber((BigDecimal)e.getReportingAmount(), (int)lcpre));
                }
                int page = 0;
                if (++entryCount % rowLineCount == 0) {
                    page = entryCount / rowLineCount;
                } else {
                    page = entryCount / rowLineCount + 1;
                    if (entryCount % rowLineCount == 1) {
                        creditTotal = GlUtils.zero;
                        debitTotal = GlUtils.zero;
                    }
                }
                if (EntryDC.DEBIT.equals((Object)dc)) {
                    debitTotal = debitTotal.add(e.getLocalAmount());
                } else {
                    creditTotal = creditTotal.add(e.getLocalAmount());
                }
                drs.updateString("pageCount", page + "/" + voucherCount);
                drs.updateString("pageCurrent", page + "");
                drs.updateString("pageTotal", "" + voucherCount);
                drs.updateString("bizStatus", vch.getBizStatus().toString());
                drs.updateString("attachments", Integer.toString(vch.getAttachments()));
                drs.updateString("attachmentsChinese", GlUtils.getChineseBig((int)vch.getAttachments(), (Locale)this.locale));
                if (page == voucherCount) {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("localAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getLocalDebitAmount(), (int)lcpre));
                    drs.updateString("localAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getLocalCreditAmount(), (int)lcpre));
                    drs.updateString("reportingAmountDebit", GlUtils.formatNumber((BigDecimal)vch.getReportingDebitAmount(), (int)lcpre));
                    drs.updateString("reportingAmountCredit", GlUtils.formatNumber((BigDecimal)vch.getReportingCreditAmount(), (int)lcpre));
                    drs.updateString("amountTotalChinese", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                    drs.updateString("amountTotal", GlUtils.getChineseFormat((BigDecimal)vch.getLocalCreditAmount(), (boolean)false, (Locale)this.locale));
                    drs.updateString("sum", "");
                } else {
                    drs.updateString("debitTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)debitmap.get(String.valueOf(page))), (int)lcpre));
                    drs.updateString("creditTotal", GlUtils.formatNumber((BigDecimal)((BigDecimal)creditmap.get(String.valueOf(page))), (int)lcpre));
                    drs.updateString("sum", GLResUtil.getRes((String)"subtotal", (Locale)this.locale));
                }
                String acctname = GlUtils.getNumberAndLongName((IObjectValue)e, (String)"account");
                String zc_listacctname = null;
                zc_listacctname = acctname.indexOf("_", 0) != -1 ? acctname.substring(acctname.indexOf("_", 0) + 1, acctname.length()) : acctname.substring(acctname.indexOf("-", 0) + 1, acctname.length());
                drs.updateString("zc_assGrp", zc_listacctname);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
        return drs;
    }

    protected VoucherPrintSettingInfo getPrintSettingInfo() {
        return this.settingInfo;
    }
}

