/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherPostProcessorTypeEnum;
import com.kingdee.eas.ma.pca.IPcVoucherPostProcessor;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcVoucherPostProcessorCollection;
import com.kingdee.eas.ma.pca.PcVoucherPostProcessorFactory;
import com.kingdee.eas.ma.pca.PcVoucherPostProcessorInfo;
import com.kingdee.eas.ma.pca.app.voucher.IPcVoucherAntiCancelPostProcessor;
import com.kingdee.eas.ma.pca.app.voucher.IPcVoucherDeletePostProcessor;
import com.kingdee.eas.ma.pca.app.voucher.IPcVoucherPostPostProcessor;
import com.kingdee.eas.ma.pca.app.voucher.IPcVoucherSubmitPostProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcVoucherPostProcessorInvokeFactory {
    private static final Logger logger = Logger.getLogger(PcVoucherPostProcessorInvokeFactory.class);
    private static IPcVoucherPostProcessor iProcessor = null;
    private static Map postProcessorMap = new HashMap();

    public static void invokeVoucherSubmitPostProcessor(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = PcVoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.SUBMIT).iterator();
        while (it.hasNext()) {
            ((IPcVoucherSubmitPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherAntiCancelPostProcessor(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = PcVoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.ANTICANCEL).iterator();
        while (it.hasNext()) {
            ((IPcVoucherAntiCancelPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherPostPostProcessor(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = PcVoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.POST).iterator();
        while (it.hasNext()) {
            ((IPcVoucherPostPostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    public static void invokeVoucherDeletePostProcessor(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        Iterator it = PcVoucherPostProcessorInvokeFactory.getProcessorInstances(ctx, VoucherPostProcessorTypeEnum.DELETE).iterator();
        while (it.hasNext()) {
            ((IPcVoucherDeletePostProcessor)it.next()).process(ctx, voucherInfo);
        }
    }

    private static List getProcessorInstances(Context ctx, VoucherPostProcessorTypeEnum processorType) throws BOSException {
        PcVoucherPostProcessorCollection invokeCollection = PcVoucherPostProcessorInvokeFactory.getVoucherProcessor(ctx, processorType);
        ArrayList<Object> instances = new ArrayList<Object>();
        Iterator it = invokeCollection.iterator();
        while (it.hasNext()) {
            PcVoucherPostProcessorInfo processor = (PcVoucherPostProcessorInfo)it.next();
            String className = processor.getProcessorClass();
            Object classObj = null;
            try {
                if (className == null || className.length() < 0) continue;
                classObj = Class.forName(className).newInstance();
                instances.add(classObj);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                throw new BOSException("ClassNotFoundException:" + className, (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
                throw new BOSException("InstantiationException:" + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException("IllegalAccessException:" + className, (Throwable)e);
            }
        }
        return instances;
    }

    private static PcVoucherPostProcessorCollection getVoucherProcessor(Context ctx, VoucherPostProcessorTypeEnum processorType) throws BOSException {
        if (!postProcessorMap.containsKey(processorType)) {
            PcVoucherPostProcessorCollection collection = PcVoucherPostProcessorInvokeFactory.getVoucherPostProcessorCollection(ctx, processorType);
            postProcessorMap.put(processorType, collection);
        }
        return (PcVoucherPostProcessorCollection)((Object)postProcessorMap.get(processorType));
    }

    private static PcVoucherPostProcessorCollection getVoucherPostProcessorCollection(Context ctx, VoucherPostProcessorTypeEnum processorType) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("processorType"));
        coll.add(new SelectorItemInfo("processorClass"));
        evi.setSelector(coll);
        if (processorType != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("processorType", (Object)processorType.getValue(), CompareType.EQUALS));
            evi.setFilter(filter);
        }
        PcVoucherPostProcessorCollection collection = PcVoucherPostProcessorInvokeFactory.getBizInterface(ctx).getCollection(evi);
        return collection;
    }

    private static IPcVoucherPostProcessor getBizInterface(Context ctx) throws BOSException {
        if (iProcessor == null) {
            iProcessor = PcVoucherPostProcessorFactory.getLocalInstance(ctx);
        }
        return iProcessor;
    }
}

