/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.eas.ma.pca.PcaParamDefaultValueConstant;
import com.kingdee.eas.ma.pca.PcaParamDefaultValueInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcaParam
implements Serializable {
    private static final long serialVersionUID = 2110534075201979942L;
    private Map hmAllParam = null;
    private List paramList = new ArrayList();
    protected static final Logger logger = Logger.getLogger(PcaParam.class);

    public static PcaParam getAllPcaParams(Context ctx, String profitCenterId) throws EASBizException, BOSException {
        return PcaParam.getPcaParams(ctx, PcaUtils.getDefaultPcaParamList(), profitCenterId);
    }

    public static PcaParam getPcaParams(Context ctx, String paramName, String profitCenterId) throws EASBizException, BOSException {
        return PcaParam.getPcaParams(ctx, new String[]{paramName}, profitCenterId);
    }

    public static PcaParam getPcaParams(Context ctx, String[] paramList, String profitCenterId) throws EASBizException, BOSException {
        PcaParam glParam = new PcaParam();
        glParam.doGetPcaParams(ctx, paramList, profitCenterId);
        return glParam;
    }

    private PcaParam() {
    }

    private void doGetPcaParams(Context ctx, String[] paramList, String profitCenterId) throws EASBizException, BOSException {
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        Map defaultValueMap = this.getPcaParamDefaultValueMap();
        this.addParamList(paramList);
        ObjectUuidPK comPK = null;
        if (profitCenterId != null) {
            comPK = new ObjectUuidPK(profitCenterId);
        }
        int size = paramList.length;
        for (int i = 0; i < size; ++i) {
            String paramName;
            if (!defaultValueMap.containsKey(paramList[i])) continue;
            PcaParamDefaultValueInfo glValue = (PcaParamDefaultValueInfo)defaultValueMap.get(paramName = paramList[i]);
            hmParamIn.put(paramName, glValue.isGroupControl() ? null : comPK);
        }
        IParamControl iParamControl = null;
        iParamControl = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        this.hmAllParam = iParamControl.getParamHashMap(hmParamIn);
    }

    public String getString(String pcaParamConstant) throws PcaException, BOSException {
        return this.getParamValue(pcaParamConstant).toString();
    }

    public boolean getBoolean(String pcaParamConstant) throws PcaException, BOSException {
        return Boolean.valueOf(this.getParamValue(pcaParamConstant).toString());
    }

    public int getInt(String pcaParamConstant) throws PcaException, NumberFormatException, BOSException {
        return Integer.parseInt(this.getParamValue(pcaParamConstant).toString());
    }

    public void setParam(String pcaParamConstant, Object value) {
        this.hmAllParam.put(pcaParamConstant, value);
        this.addParamItem(pcaParamConstant);
    }

    public boolean isParamExisted(String pcaParamConstant) {
        return this.hmAllParam.get(pcaParamConstant) != null;
    }

    private PcaParamDefaultValueInfo getParamDefaultValue(String pcaParamConstant) throws PcaException {
        Map defaultValueMap = this.getPcaParamDefaultValueMap();
        if (!defaultValueMap.containsKey(pcaParamConstant)) {
            throw new PcaException(PcaException.NOPARAM, new Object[]{pcaParamConstant});
        }
        return (PcaParamDefaultValueInfo)defaultValueMap.get(pcaParamConstant);
    }

    private Map getPcaParamDefaultValueMap() {
        return PcaParamDefaultValueConstant.getDefaultValueMap();
    }

    private Object getParamValue(String pcaParamConstant) throws BOSException, PcaException {
        if (!this.isParamValide(pcaParamConstant)) {
            throw new BOSException("Param " + pcaParamConstant + " is not in the param list! Please fetch the param before use!");
        }
        if (this.isParamExisted(pcaParamConstant)) {
            return this.hmAllParam.get(pcaParamConstant);
        }
        logger.error((Object)("Get Param:" + pcaParamConstant + " From DefaultMap!"));
        return this.getParamDefaultValue(pcaParamConstant).getDefaultValue();
    }

    private boolean isParamValide(String pcaParamConstant) {
        return this.paramList.contains(pcaParamConstant);
    }

    private void addParamList(String[] params) {
        for (int i = 0; i < params.length; ++i) {
            this.addParamItem(params[i]);
        }
    }

    private void addParamItem(String pcaParamConstant) {
        if (!this.paramList.contains(pcaParamConstant)) {
            this.paramList.add(pcaParamConstant);
        }
    }

    public Map getParamMap() throws PcaException, BOSException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        int n = this.paramList.size();
        for (int i = 0; i < n; ++i) {
            m.put(this.paramList.get(i).toString(), this.getParamValue(this.paramList.get(i).toString()));
        }
        return m;
    }
}

