/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryDefaultCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryDefaultInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastEntryInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrastEntry;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActGroupDetail;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.IPcVoucher;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordCollection;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherException;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SynVoucherUtil {
    private static String RESOURCE = "com.kingdee.eas.ma.pca.PcaResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.pca.SynVoucherUtil");
    public static final BigDecimal zero = new BigDecimal("0");

    public static boolean isNeedSynPcVoucher(Context ctx, String companyId) throws EASBizException, BOSException {
        Object value = VoucherProcessCache.getParam((Context)ctx, (String)companyId, (String)"GL_111");
        boolean commonVoucherProcess = value == null ? false : new Boolean(value.toString());
        return commonVoucherProcess;
    }

    public static boolean getQuantityParam(Context ctx, String companyId) throws EASBizException, BOSException {
        Object value = VoucherProcessCache.getParam((Context)ctx, (String)companyId, (String)"G010");
        boolean quantityParam = value == null ? false : new Boolean(value.toString());
        return quantityParam;
    }

    public static boolean isUseProfitCenterAccount(Context ctx, String companyId) throws EASBizException, BOSException {
        Object value = VoucherProcessCache.getParam((Context)ctx, (String)companyId, (String)"GL_115");
        boolean useProfitCenterAccount = value == null ? false : new Boolean(value.toString());
        return useProfitCenterAccount;
    }

    protected static Map<String, AccountViewInfo> getAccountRefColl(Context ctx, String tabId, Set<String> actPro, String companyId, Map<String, HashSet<String>> profitAcctRelatMap) {
        HashMap<String, AccountViewInfo> accountRef = new HashMap<String, AccountViewInfo>();
        Set<String> keySet = profitAcctRelatMap.keySet();
        for (String profitCenterId : keySet) {
            Set<String> relatedCompanyIdSet = null;
            try {
                relatedCompanyIdSet = SynVoucherUtil.getRelatedCompanyIds(ctx, profitCenterId);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            String relatedCompanyId = relatedCompanyIdSet != null && relatedCompanyIdSet.size() > 0 ? (String)relatedCompanyIdSet.toArray()[0] : profitCenterId;
            HashSet<String> accountIdSet = profitAcctRelatMap.get(profitCenterId);
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter1 = new FilterInfo();
                view.setFilter(filter1);
                filter1.getFilterItems().add(new FilterItemInfo("acctRefContrast.enabledAcctTable", (Object)tabId));
                filter1.getFilterItems().add(new FilterItemInfo("acctRefContrast.isEnabled", (Object)1));
                filter1.getFilterItems().add(new FilterItemInfo("acctRefContrast.refType", (Object)3));
                filter1.getFilterItems().add(new FilterItemInfo("acctRefContrast.stCompany", (Object)companyId));
                StringBuffer idIn = new StringBuffer();
                idIn.append("SELECT FToUnitId FROM T_ORG_UnitRelation ");
                idIn.append("WHERE FTypeRelationId = (SELECT FID FROM T_ORG_TypeRelation WHERE FFromType = 6 AND FToType = 1) ");
                idIn.append("AND FFromUnitId = '");
                idIn.append(profitCenterId).append("' ");
                filter1.getFilterItems().add(new FilterItemInfo("acctRefContrast.company", (Object)idIn.toString(), CompareType.INNER));
                filter1.getFilterItems().add(new FilterItemInfo("newAcct.id", accountIdSet, CompareType.INCLUDE));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("acctRefContrast.disabledAcctTable.id"));
                sic.add(new SelectorItemInfo("newAcct.id"));
                sic.add(new SelectorItemInfo("oldAcct.*"));
                sic.add(new SelectorItemInfo("oldAcct.CAA.*"));
                sic.add(new SelectorItemInfo("defaultEntry.*"));
                view.setSelector(sic);
                IAccountRefContrastEntry ir = AccountRefContrastEntryFactory.getLocalInstance((Context)ctx);
                AccountRefContrastEntryCollection arc = ir.getAccountRefContrastEntryCollection(view);
                AccountRefContrastEntryInfo ar = null;
                String key = "";
                StringBuffer sql = new StringBuffer();
                for (int i = 0; i < arc.size(); ++i) {
                    ar = arc.get(i);
                    key = profitCenterId + ar.getNewAcct().getId().toString();
                    AccountViewInfo oldAcct = ar.getOldAcct();
                    AsstAccountInfo asst = oldAcct.getCAA();
                    if (oldAcct != null) {
                        oldAcct.put("isContrast", (Object)Boolean.TRUE);
                        oldAcct.put("defaultEntry", (Object)ar.getDefaultEntry());
                    }
                    accountRef.put(key, oldAcct);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"ma.pca.SynVoucherUtil.getAccountRefColl() error", (Throwable)e);
            }
        }
        return accountRef;
    }

    private static boolean isCurOrgAcc(String key, String newKey, Set<String> actPro, String companyId, StringBuffer sql) {
        Iterator<String> it = actPro.iterator();
        String val = null;
        String selectSql = "select ev.fid oid, av.fid nid, av.fnumber number, av.fcaa caa from t_bd_accountview av inner join t_bd_accountview ev on av.fnumber = ev.fnumber ";
        while (it.hasNext()) {
            val = it.next();
            if (!val.endsWith(key) || val.startsWith(companyId)) continue;
            sql.append(selectSql);
            sql.append("where ev.fid = '").append(newKey).append("' and av.fcompanyid ='").append(val.split("@")[0]).append("' \n").append(" union ");
            return true;
        }
        return false;
    }

    private static Map<String, List> setAsstActType(Context ctx, Set<String> asstIds) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("asstAccount.id"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        sic.add(new SelectorItemInfo("asstActType.defaultF7UI"));
        sic.add(new SelectorItemInfo("asstActType.isForCompany"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        sic.add(new SelectorItemInfo("asstActType.isQty"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", asstIds, CompareType.INCLUDE));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("seq"));
        sort.add(new SorterItemInfo("asstActType.number"));
        view.getSorter().addObjectCollection((IObjectCollection)sort);
        AsstActGroupDetailCollection rels = null;
        try {
            IAsstActGroupDetail relCtrl = AsstActGroupDetailFactory.getLocalInstance((Context)ctx);
            rels = relCtrl.getAsstActGroupDetailCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        boolean count = false;
        Iterator itr = rels.iterator();
        HashMap<String, List> types = new HashMap<String, List>();
        String asstId = null;
        ArrayList ts = null;
        while (itr.hasNext()) {
            AsstActGroupDetailInfo r = (AsstActGroupDetailInfo)itr.next();
            AsstActTypeInfo t = r.getAsstActType();
            asstId = t.get("").toString();
            if (types.containsKey(asstId)) {
                ((List)types.get(asstId)).add(t);
                continue;
            }
            ts = new ArrayList();
            types.put(asstId, ts);
        }
        return types;
    }

    private static Set<String> getRelatedCompanyIds(Context ctx, String profitCenterId) throws BOSException {
        Map datas = VoucherProcessCache.getDatas((Context)ctx, (String)"getRelatedCompanyIds");
        if (datas.containsKey(profitCenterId)) {
            return (Set)datas.get(profitCenterId);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(profitCenterId);
        Set relatedCompanyIdSet = GlUtils.getRelatedCompanyIds((Context)ctx, idSet);
        datas.put(profitCenterId, relatedCompanyIdSet);
        return relatedCompanyIdSet;
    }

    public static PcVoucherCollection transVoucher2PcVoucherCollectionNew(Context ctx, VoucherInfo voucherInfo, int opType) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = voucherInfo.getCompany();
        int basePrecision = SynVoucherUtil.getBaseCurrencyPrecision(ctx, companyInfo);
        int reportPrecision = SynVoucherUtil.getReportCurrencyPrecision(ctx, companyInfo);
        HashMap<String, String> queryKeys = new HashMap<String, String>();
        queryKeys.put("G001", voucherInfo.getCompany().getId().toString());
        queryKeys.put("PCA_031", voucherInfo.getCompany().getId().toString());
        Map hmParam = VoucherProcessCache.getParams((Context)ctx, queryKeys);
        boolean isHandCoding = hmParam.get("PCA_031") == null ? false : new Boolean(hmParam.get("PCA_031").toString());
        boolean isUseReportCurrency = hmParam.get("G001") == null ? false : new Boolean(hmParam.get("G001").toString());
        BaseVoucherInfo baseVoucherInfo = SynVoucherUtil.CloneVoucherInfo(voucherInfo);
        PcVoucherInfo pcVoucherInfo = new PcVoucherInfo();
        pcVoucherInfo.putAll((IObjectValue)baseVoucherInfo);
        pcVoucherInfo.setSourceSys(SystemEnum.GENERALLEDGER);
        if (!SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
            pcVoucherInfo.setSourceType(SourceType.GLVOUCHER);
        }
        pcVoucherInfo.setEntryCount(0);
        pcVoucherInfo.setLocalCreditAmount(zero);
        pcVoucherInfo.setLocalDebitAmount(zero);
        pcVoucherInfo.setReportingCreditAmount(zero);
        pcVoucherInfo.setReportingDebitAmount(zero);
        pcVoucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
        pcVoucherInfo.setSourceBillId(voucherInfo.getId().toString());
        if (!isHandCoding) {
            pcVoucherInfo.setNumber(null);
        }
        String tabId = companyInfo.getAccountTable().getId().toString();
        Set actPro = (Set)voucherInfo.get("actPro");
        Map<String, AccountViewInfo> accountRef = null;
        if (actPro != null) {
            Map<String, HashSet<String>> profitAccountRelationMap = SynVoucherUtil.getProfitAccountRelationMap(voucherInfo);
            accountRef = SynVoucherUtil.getAccountRefColl(ctx, tabId, actPro, voucherInfo.getCompany().getId().toString(), profitAccountRelationMap);
            accountRef.putAll(VoucherProcessCache.getCache((Context)ctx).getRelatedCompanyAccountSuccessMapping());
        }
        IPcVoucher iPcVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        String oql = "select id, number, profitCenter.id where sourceBillId = '" + voucherInfo.getId() + "'";
        PcVoucherCollection pcVoucherColl = iPcVoucher.getPcVoucherCollection(oql);
        PcVoucherCollection pvReverseColl = new PcVoucherCollection();
        if (voucherInfo.isIsReverseVoucher()) {
            oql = "select id, number, description,period.id,period.number,period.periodYear,period.periodNumber, profitCenter.id where sourceBillId = '" + voucherInfo.getSourceBillId() + "'";
            pvReverseColl = iPcVoucher.getPcVoucherCollection(oql);
        }
        HashMap<String, Object> cache = new HashMap<String, Object>();
        HashMap<String, PcVoucherInfo> result = new HashMap<String, PcVoucherInfo>();
        BaseVoucherInfo baseVoucherInfoTemp = new BaseVoucherInfo();
        baseVoucherInfoTemp = (BaseVoucherInfo)voucherInfo.clone();
        Iterator itor = baseVoucherInfoTemp.getEntries().iterator();
        String companyId = companyInfo.getId().toString();
        while (itor.hasNext()) {
            PcVoucherAssistRecordCollection pcBaseAssistColl;
            PcVoucherEntryInfo tempPcVoucherEntryInfo;
            BaseVoucherEntryInfo baseEntryInfo;
            AccountViewInfo oldAc;
            PcVoucherInfo tempPcVoucherInfo;
            VoucherEntryInfo entryInfo = (VoucherEntryInfo)itor.next();
            if (entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().getId() == null) continue;
            Object pObject = VoucherProcessCache.getParam((Context)ctx, (String)entryInfo.getProfitCenter().getId().toString(), (String)"PCA_031");
            isHandCoding = pObject == null ? false : new Boolean(pObject.toString());
            String profitCenterId = entryInfo.getProfitCenter().getId().toString();
            if (result.containsKey(entryInfo.getProfitCenter().getId().toString())) {
                tempPcVoucherInfo = (PcVoucherInfo)result.get(profitCenterId);
                if (!isHandCoding) {
                    tempPcVoucherInfo.setNumber(null);
                }
                oldAc = entryInfo.getAccount();
                baseEntryInfo = SynVoucherUtil.CloneVoucherEntryInfo(entryInfo, accountRef);
                entryInfo.setAccount(oldAc);
                tempPcVoucherEntryInfo = new PcVoucherEntryInfo();
                tempPcVoucherEntryInfo.putAll((IObjectValue)baseEntryInfo);
                tempPcVoucherEntryInfo.setSeq(tempPcVoucherInfo.getEntries().size());
                pcBaseAssistColl = SynVoucherUtil.getBaseVoucherAssistReCollNew(ctx, cache, entryInfo.getAssistRecords(), tempPcVoucherEntryInfo, tempPcVoucherInfo, entryInfo);
                SynVoucherUtil.setQuantity(ctx, cache, entryInfo.getAssistRecords(), tempPcVoucherEntryInfo, tempPcVoucherInfo, entryInfo);
                tempPcVoucherEntryInfo.setAssistRecords((AbstractObjectCollection)pcBaseAssistColl);
                tempPcVoucherEntryInfo.setBill(tempPcVoucherInfo);
                tempPcVoucherInfo.getEntries().add(tempPcVoucherEntryInfo);
                BigDecimal localCreditAount = tempPcVoucherInfo.getLocalCreditAmount();
                BigDecimal localDebitAmount = tempPcVoucherInfo.getLocalDebitAmount();
                if (tempPcVoucherEntryInfo.getEntryDC() == EntryDC.CREDIT) {
                    tempPcVoucherInfo.setLocalCreditAmount(tempPcVoucherEntryInfo.getLocalAmount().add(localCreditAount).setScale(basePrecision, 4));
                } else {
                    tempPcVoucherInfo.setLocalDebitAmount(tempPcVoucherEntryInfo.getLocalAmount().add(localDebitAmount).setScale(basePrecision, 4));
                }
                if (isUseReportCurrency) {
                    BigDecimal reportingCreditAmount = tempPcVoucherInfo.getReportingCreditAmount();
                    BigDecimal reportingDebitAmount = tempPcVoucherInfo.getReportingDebitAmount();
                    if (tempPcVoucherEntryInfo.getEntryDC() == EntryDC.CREDIT) {
                        tempPcVoucherInfo.setReportingCreditAmount(tempPcVoucherEntryInfo.getReportingAmount().add(reportingCreditAmount).setScale(reportPrecision, 4));
                    } else {
                        tempPcVoucherInfo.setReportingDebitAmount(tempPcVoucherEntryInfo.getReportingAmount().add(reportingDebitAmount).setScale(reportPrecision, 4));
                    }
                }
                tempPcVoucherInfo.setEntryCount(tempPcVoucherInfo.getEntries().size());
                continue;
            }
            tempPcVoucherInfo = new PcVoucherInfo();
            tempPcVoucherInfo.putAll((IObjectValue)baseVoucherInfo);
            tempPcVoucherInfo.setSourceSys(SystemEnum.GENERALLEDGER);
            if (!SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
                tempPcVoucherInfo.setSourceType(SourceType.GLVOUCHER);
            }
            tempPcVoucherInfo.setEntryCount(0);
            tempPcVoucherInfo.setLocalCreditAmount(zero);
            tempPcVoucherInfo.setLocalDebitAmount(zero);
            tempPcVoucherInfo.setReportingCreditAmount(zero);
            tempPcVoucherInfo.setReportingDebitAmount(zero);
            tempPcVoucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
            tempPcVoucherInfo.setSourceBillId(voucherInfo.getId().toString());
            if (!isHandCoding) {
                tempPcVoucherInfo.setNumber(null);
            }
            tempPcVoucherInfo.setProfitCenter(entryInfo.getProfitCenter());
            oldAc = entryInfo.getAccount();
            baseEntryInfo = SynVoucherUtil.CloneVoucherEntryInfo(entryInfo, accountRef);
            entryInfo.setAccount(oldAc);
            tempPcVoucherEntryInfo = new PcVoucherEntryInfo();
            tempPcVoucherEntryInfo.putAll((IObjectValue)baseEntryInfo);
            tempPcVoucherEntryInfo.setSeq(0);
            pcBaseAssistColl = SynVoucherUtil.getBaseVoucherAssistReCollNew(ctx, cache, entryInfo.getAssistRecords(), tempPcVoucherEntryInfo, tempPcVoucherInfo, entryInfo);
            SynVoucherUtil.setQuantity(ctx, cache, entryInfo.getAssistRecords(), tempPcVoucherEntryInfo, tempPcVoucherInfo, entryInfo);
            tempPcVoucherEntryInfo.setAssistRecords((AbstractObjectCollection)pcBaseAssistColl);
            tempPcVoucherEntryInfo.setBill(tempPcVoucherInfo);
            PcVoucherEntryCollection entryColl = new PcVoucherEntryCollection();
            entryColl.add(tempPcVoucherEntryInfo);
            tempPcVoucherInfo.setEntries((AbstractObjectCollection)entryColl);
            int count = pcVoucherColl.size();
            for (int i = 0; i < count; ++i) {
                PcVoucherInfo pcInfo = pcVoucherColl.get(i);
                if (!profitCenterId.equals(pcInfo.getProfitCenter().getId().toString())) continue;
                tempPcVoucherInfo.setId(pcInfo.getId());
                tempPcVoucherInfo.setNumber(pcInfo.getNumber());
                tempPcVoucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            }
            if (tempPcVoucherEntryInfo.getEntryDC() == EntryDC.CREDIT) {
                tempPcVoucherInfo.setLocalCreditAmount(tempPcVoucherEntryInfo.getLocalAmount().setScale(basePrecision, 4));
                if (isUseReportCurrency) {
                    tempPcVoucherInfo.setReportingCreditAmount(tempPcVoucherEntryInfo.getReportingAmount().setScale(reportPrecision, 4));
                }
            } else {
                tempPcVoucherInfo.setLocalDebitAmount(tempPcVoucherEntryInfo.getLocalAmount().setScale(basePrecision, 4));
                if (isUseReportCurrency) {
                    tempPcVoucherInfo.setReportingDebitAmount(tempPcVoucherEntryInfo.getReportingAmount().setScale(reportPrecision, 4));
                }
            }
            tempPcVoucherInfo.setEntryCount(tempPcVoucherInfo.getEntries().size());
            if (tempPcVoucherInfo.isIsReverseVoucher()) {
                PcVoucherInfo pvInfo = SynVoucherUtil.getSrcPcVoucherInfo(ctx, tempPcVoucherInfo.getProfitCenter().getId().toString(), pvReverseColl);
                tempPcVoucherInfo.setSrcVoucherInfo((BaseVoucherInfo)pvInfo);
            }
            result.put(profitCenterId, tempPcVoucherInfo);
        }
        PcVoucherCollection resultColl = new PcVoucherCollection();
        Iterator it = result.keySet().iterator();
        UserInfo creator = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        while (it.hasNext()) {
            PcVoucherInfo info = (PcVoucherInfo)result.get(it.next());
            info.setCreator(creator);
            info.setLastUpdateUser(creator);
            info.setCreateTime(now);
            info.setLastUpdateTime(now);
            resultColl.add(info);
        }
        return resultColl;
    }

    public static PcVoucherCollection transVoucher2PcVoucherCollection(Context ctx, VoucherInfo voucherInfo, int opType) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = voucherInfo.getCompany();
        int basePrecision = SynVoucherUtil.getBaseCurrencyPrecision(ctx, companyInfo);
        int reportPrecision = SynVoucherUtil.getReportCurrencyPrecision(ctx, companyInfo);
        HashMap<String, String> queryKeys = new HashMap<String, String>();
        queryKeys.put("G001", voucherInfo.getCompany().getId().toString());
        queryKeys.put("PCA_031", voucherInfo.getCompany().getId().toString());
        Map hmParam = VoucherProcessCache.getParams((Context)ctx, queryKeys);
        boolean isHandCoding = hmParam.get("PCA_031") == null ? false : new Boolean(hmParam.get("PCA_031").toString());
        boolean isUseReportCurrency = hmParam.get("G001") == null ? false : new Boolean(hmParam.get("G001").toString());
        BaseVoucherInfo baseVoucherInfo = SynVoucherUtil.CloneVoucherInfo(voucherInfo);
        PcVoucherInfo pcVoucherInfo = new PcVoucherInfo();
        pcVoucherInfo.putAll((IObjectValue)baseVoucherInfo);
        pcVoucherInfo.setSourceSys(SystemEnum.GENERALLEDGER);
        if (!SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
            pcVoucherInfo.setSourceType(SourceType.GLVOUCHER);
        }
        pcVoucherInfo.setEntryCount(0);
        pcVoucherInfo.setLocalCreditAmount(zero);
        pcVoucherInfo.setLocalDebitAmount(zero);
        pcVoucherInfo.setReportingCreditAmount(zero);
        pcVoucherInfo.setReportingDebitAmount(zero);
        pcVoucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
        pcVoucherInfo.setSourceBillId(voucherInfo.getId().toString());
        if (!isHandCoding) {
            pcVoucherInfo.setNumber(null);
        }
        String tabId = companyInfo.getAccountTable().getId().toString();
        Set actPro = (Set)voucherInfo.get("actPro");
        Map<String, AccountViewInfo> accountRef = null;
        if (actPro != null) {
            Map<String, HashSet<String>> profitAccountRelationMap = SynVoucherUtil.getProfitAccountRelationMap(voucherInfo);
            accountRef = SynVoucherUtil.getAccountRefColl(ctx, tabId, actPro, voucherInfo.getCompany().getId().toString(), profitAccountRelationMap);
        }
        IPcVoucher iPcVoucher = PcVoucherFactory.getLocalInstance((Context)ctx);
        String oql = "select id, number, profitCenter.id where sourceBillId = '" + voucherInfo.getId() + "'";
        PcVoucherCollection pcVoucherColl = iPcVoucher.getPcVoucherCollection(oql);
        PcVoucherCollection pvReverseColl = new PcVoucherCollection();
        if (voucherInfo.isIsReverseVoucher()) {
            oql = "select id, number, description,period.id,period.number,period.periodYear,period.periodNumber, profitCenter.id where sourceBillId = '" + voucherInfo.getSourceBillId() + "'";
            pvReverseColl = iPcVoucher.getPcVoucherCollection(oql);
        }
        HashMap<String, Object> cache = new HashMap<String, Object>();
        HashMap<String, PcVoucherInfo> result = new HashMap<String, PcVoucherInfo>();
        BaseVoucherInfo baseVoucherInfoTemp = new BaseVoucherInfo();
        baseVoucherInfoTemp = (BaseVoucherInfo)voucherInfo.clone();
        for (VoucherEntryInfo entryInfo : baseVoucherInfoTemp.getEntries()) {
            PcVoucherAssistRecordCollection pcBaseAssistColl;
            PcVoucherEntryInfo tempPcVoucherEntryInfo;
            BaseVoucherEntryInfo baseEntryInfo;
            PcVoucherInfo tempPcVoucherInfo;
            if (entryInfo.getProfitCenter() == null || entryInfo.getProfitCenter().getId() == null) continue;
            Object pObject = VoucherProcessCache.getParam((Context)ctx, (String)entryInfo.getProfitCenter().getId().toString(), (String)"PCA_031");
            isHandCoding = pObject == null ? false : new Boolean(pObject.toString());
            String profitCenterId = entryInfo.getProfitCenter().getId().toString();
            if (result.containsKey(entryInfo.getProfitCenter().getId().toString())) {
                tempPcVoucherInfo = (PcVoucherInfo)result.get(profitCenterId);
                if (!isHandCoding) {
                    tempPcVoucherInfo.setNumber(null);
                }
                baseEntryInfo = SynVoucherUtil.CloneVoucherEntryInfo(entryInfo, accountRef);
                tempPcVoucherEntryInfo = new PcVoucherEntryInfo();
                tempPcVoucherEntryInfo.putAll((IObjectValue)baseEntryInfo);
                tempPcVoucherEntryInfo.setSeq(tempPcVoucherInfo.getEntries().size());
                pcBaseAssistColl = SynVoucherUtil.getBaseVoucherAssistReColl(ctx, cache, entryInfo.getAssistRecords(), tempPcVoucherEntryInfo, tempPcVoucherInfo, entryInfo);
                tempPcVoucherEntryInfo.setAssistRecords((AbstractObjectCollection)pcBaseAssistColl);
                tempPcVoucherEntryInfo.setBill(tempPcVoucherInfo);
                tempPcVoucherInfo.getEntries().add(tempPcVoucherEntryInfo);
                BigDecimal localCreditAount = tempPcVoucherInfo.getLocalCreditAmount();
                BigDecimal localDebitAmount = tempPcVoucherInfo.getLocalDebitAmount();
                if (tempPcVoucherEntryInfo.getEntryDC() == EntryDC.CREDIT) {
                    tempPcVoucherInfo.setLocalCreditAmount(tempPcVoucherEntryInfo.getLocalAmount().add(localCreditAount).setScale(basePrecision, 4));
                } else {
                    tempPcVoucherInfo.setLocalDebitAmount(tempPcVoucherEntryInfo.getLocalAmount().add(localDebitAmount).setScale(basePrecision, 4));
                }
                if (isUseReportCurrency) {
                    BigDecimal reportingCreditAmount = tempPcVoucherInfo.getReportingCreditAmount();
                    BigDecimal reportingDebitAmount = tempPcVoucherInfo.getReportingDebitAmount();
                    if (tempPcVoucherEntryInfo.getEntryDC() == EntryDC.CREDIT) {
                        tempPcVoucherInfo.setReportingCreditAmount(tempPcVoucherEntryInfo.getReportingAmount().add(reportingCreditAmount).setScale(reportPrecision, 4));
                    } else {
                        tempPcVoucherInfo.setReportingDebitAmount(tempPcVoucherEntryInfo.getReportingAmount().add(reportingDebitAmount).setScale(reportPrecision, 4));
                    }
                }
                tempPcVoucherInfo.setEntryCount(tempPcVoucherInfo.getEntries().size());
                continue;
            }
            tempPcVoucherInfo = new PcVoucherInfo();
            tempPcVoucherInfo.putAll((IObjectValue)baseVoucherInfo);
            tempPcVoucherInfo.setSourceSys(SystemEnum.GENERALLEDGER);
            if (!SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
                tempPcVoucherInfo.setSourceType(SourceType.GLVOUCHER);
            }
            tempPcVoucherInfo.setEntryCount(0);
            tempPcVoucherInfo.setLocalCreditAmount(zero);
            tempPcVoucherInfo.setLocalDebitAmount(zero);
            tempPcVoucherInfo.setReportingCreditAmount(zero);
            tempPcVoucherInfo.setReportingDebitAmount(zero);
            tempPcVoucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
            tempPcVoucherInfo.setSourceBillId(voucherInfo.getId().toString());
            if (!isHandCoding) {
                tempPcVoucherInfo.setNumber(null);
            }
            tempPcVoucherInfo.setProfitCenter(entryInfo.getProfitCenter());
            baseEntryInfo = SynVoucherUtil.CloneVoucherEntryInfo(entryInfo, accountRef);
            tempPcVoucherEntryInfo = new PcVoucherEntryInfo();
            tempPcVoucherEntryInfo.putAll((IObjectValue)baseEntryInfo);
            tempPcVoucherEntryInfo.setSeq(0);
            pcBaseAssistColl = SynVoucherUtil.getBaseVoucherAssistReColl(ctx, cache, entryInfo.getAssistRecords(), tempPcVoucherEntryInfo, tempPcVoucherInfo, entryInfo);
            tempPcVoucherEntryInfo.setAssistRecords((AbstractObjectCollection)pcBaseAssistColl);
            tempPcVoucherEntryInfo.setBill(tempPcVoucherInfo);
            PcVoucherEntryCollection entryColl = new PcVoucherEntryCollection();
            entryColl.add(tempPcVoucherEntryInfo);
            tempPcVoucherInfo.setEntries((AbstractObjectCollection)entryColl);
            int count = pcVoucherColl.size();
            for (int i = 0; i < count; ++i) {
                PcVoucherInfo pcInfo = pcVoucherColl.get(i);
                if (!profitCenterId.equals(pcInfo.getProfitCenter().getId().toString())) continue;
                tempPcVoucherInfo.setId(pcInfo.getId());
                tempPcVoucherInfo.setNumber(pcInfo.getNumber());
                tempPcVoucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            }
            if (tempPcVoucherEntryInfo.getEntryDC() == EntryDC.CREDIT) {
                tempPcVoucherInfo.setLocalCreditAmount(tempPcVoucherEntryInfo.getLocalAmount().setScale(basePrecision, 4));
                if (isUseReportCurrency) {
                    tempPcVoucherInfo.setReportingCreditAmount(tempPcVoucherEntryInfo.getReportingAmount().setScale(reportPrecision, 4));
                }
            } else {
                tempPcVoucherInfo.setLocalDebitAmount(tempPcVoucherEntryInfo.getLocalAmount().setScale(basePrecision, 4));
                if (isUseReportCurrency) {
                    tempPcVoucherInfo.setReportingDebitAmount(tempPcVoucherEntryInfo.getReportingAmount().setScale(reportPrecision, 4));
                }
            }
            tempPcVoucherInfo.setEntryCount(tempPcVoucherInfo.getEntries().size());
            if (tempPcVoucherInfo.isIsReverseVoucher()) {
                PcVoucherInfo pvInfo = SynVoucherUtil.getSrcPcVoucherInfo(ctx, tempPcVoucherInfo.getProfitCenter().getId().toString(), pvReverseColl);
                tempPcVoucherInfo.setSrcVoucherInfo((BaseVoucherInfo)pvInfo);
            }
            result.put(profitCenterId, tempPcVoucherInfo);
        }
        PcVoucherCollection resultColl = new PcVoucherCollection();
        Iterator it = result.keySet().iterator();
        while (it.hasNext()) {
            PcVoucherInfo info = (PcVoucherInfo)result.get(it.next());
            resultColl.add(info);
        }
        return resultColl;
    }

    private static Map<String, HashSet<String>> getProfitAccountRelationMap(VoucherInfo voucherInfo) {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        VoucherEntryCollection voucherEntryColl = voucherInfo.getEntries();
        int size = voucherEntryColl.size();
        for (int i = 0; i < size; ++i) {
            VoucherEntryInfo voucherEntryInfo = voucherEntryColl.get(i);
            if (voucherEntryInfo.getAccount() == null || voucherEntryInfo.getAccount().getId() == null || voucherEntryInfo.getProfitCenter() == null || voucherEntryInfo.getProfitCenter().getId() == null) continue;
            String profitCenterId = voucherEntryInfo.getProfitCenter().getId().toString();
            if (result.get(profitCenterId) == null) {
                HashSet<String> acctIdSet = new HashSet<String>();
                acctIdSet.add(voucherEntryInfo.getAccount().getId().toString());
                result.put(profitCenterId, acctIdSet);
                continue;
            }
            HashSet accountIdSet = (HashSet)result.get(profitCenterId);
            accountIdSet.add(voucherEntryInfo.getAccount().getId().toString());
            result.put(profitCenterId, accountIdSet);
        }
        return result;
    }

    private static PcVoucherInfo getSrcPcVoucherInfo(Context ctx, String profitCenterId, PcVoucherCollection pvReverseColl) {
        for (PcVoucherInfo pvInfo : pvReverseColl) {
            if (!profitCenterId.equals(pvInfo.getProfitCenter().getId().toString())) continue;
            return pvInfo;
        }
        return null;
    }

    private static PcVoucherAssistRecordCollection getPcBaseAssistCollByProperty(VoucherAssistRecordCollection assistRecords, PcVoucherEntryInfo tempPcVoucherEntryInfo, PcVoucherInfo tempPcVoucherInfo) {
        PcVoucherAssistRecordCollection pcBaseAssistColl = new PcVoucherAssistRecordCollection();
        int count = assistRecords.size();
        for (int i = 0; i < count; ++i) {
            VoucherAssistRecordInfo assistInfoBefore = assistRecords.get(i);
            assistInfoBefore.setEntry(null);
            assistInfoBefore.setBill(null);
            VoucherAssistRecordInfo assistInfo = (VoucherAssistRecordInfo)assistInfoBefore.clone();
            assistInfo.setId(null);
            assistInfo.setEntry(null);
            assistInfo.setBill(null);
            assistInfo.setAssGrp(null);
            PcVoucherAssistRecordInfo pcAssistInfo = new PcVoucherAssistRecordInfo();
            pcAssistInfo.putAll((IObjectValue)assistInfo);
            pcAssistInfo.setEntry(tempPcVoucherEntryInfo);
            pcAssistInfo.setBill(tempPcVoucherInfo);
            pcBaseAssistColl.add(pcAssistInfo);
        }
        return pcBaseAssistColl;
    }

    private static void setQuantity(Context ctx, Map<String, Object> cache, VoucherAssistRecordCollection assistRecords, PcVoucherEntryInfo tempPcVoucherEntryInfo, PcVoucherInfo tempPcVoucherInfo, VoucherEntryInfo entryInfo) throws EASBizException, BOSException {
        boolean quantityParam = SynVoucherUtil.getQuantityParam(ctx, tempPcVoucherInfo.getCompany().getId().toString());
        AccountViewInfo oldAccount = entryInfo.getAccount();
        AccountViewInfo newAccount = tempPcVoucherEntryInfo.getAccount();
        if (!quantityParam) {
            MeasureUnitGroupInfo entryMeasureUnitGroupID = entryInfo.getMeasureUnit() != null ? entryInfo.getMeasureUnit().getMeasureUnitGroup() : null;
            MeasureUnitGroupInfo mainMeasureUnitGroupID = newAccount.getMeasureUnitGroupID();
            if (!(entryMeasureUnitGroupID == null && mainMeasureUnitGroupID == null || entryMeasureUnitGroupID != null && mainMeasureUnitGroupID != null && entryMeasureUnitGroupID.getId().toString().equals(mainMeasureUnitGroupID.getIdentity().toString()))) {
                SynVoucherUtil.setQuantityNull(ctx, tempPcVoucherEntryInfo);
            }
        } else {
            AsstAccountInfo oldCaa = entryInfo.getCAA();
            AsstAccountInfo newCaa = null;
            String newCaaId = SynVoucherUtil.getNewCaaId(ctx, cache, newAccount.getId().toString());
            if (newCaaId != null) {
                newCaa = SynVoucherUtil.getCaa(ctx, cache, newCaaId);
            }
            if (oldCaa != null && oldCaa.isIsQty()) {
                if (newCaa == null && newCaa == null && newAccount.isIsQty()) {
                    MeasureUnitGroupInfo caaMeasureUnitGroupID = oldCaa.getMeasureUnitGroup();
                    oldCaa.getMeasureUnitGroup().getDefaultUnit();
                    MeasureUnitGroupInfo mainMeasureUnitGroupID = newAccount.getMeasureUnitGroupID();
                    if (caaMeasureUnitGroupID == null && mainMeasureUnitGroupID == null || caaMeasureUnitGroupID != null && mainMeasureUnitGroupID != null && caaMeasureUnitGroupID.getId().toString().equals(mainMeasureUnitGroupID.getIdentity().toString())) {
                        SynVoucherUtil.setAssistMeasureIsSameByEntry(ctx, tempPcVoucherEntryInfo, entryInfo);
                    } else {
                        SynVoucherUtil.setQuantityNull(ctx, tempPcVoucherEntryInfo);
                    }
                }
            } else if (oldCaa == null) {
                if (newCaa != null) {
                    SynVoucherUtil.setQuantityNull(ctx, tempPcVoucherEntryInfo);
                } else {
                    MeasureUnitGroupInfo oldMeasureUnitGroupID = entryInfo.getMeasureUnit() != null ? entryInfo.getMeasureUnit().getMeasureUnitGroup() : null;
                    MeasureUnitGroupInfo newMeasureUnitGroupID = newAccount.getMeasureUnitGroupID();
                    if (!(oldMeasureUnitGroupID == null && newMeasureUnitGroupID == null || oldMeasureUnitGroupID != null && newMeasureUnitGroupID != null && oldMeasureUnitGroupID.getId().toString().equals(newMeasureUnitGroupID.getIdentity().toString()))) {
                        SynVoucherUtil.setQuantityNull(ctx, tempPcVoucherEntryInfo);
                    }
                }
            } else if (oldCaa != null && !oldCaa.isIsQty()) {
                SynVoucherUtil.setQuantityNull(ctx, tempPcVoucherEntryInfo);
            }
        }
    }

    private static void setAssistMeasureIsSameByEntry(Context ctx, PcVoucherEntryInfo tempPcVoucherEntryInfo, VoucherEntryInfo entryInfo) {
        boolean result = true;
        MeasureUnitInfo measureUnitInfo = null;
        VoucherAssistRecordCollection baseAssistColl = entryInfo.getAssistRecords();
        if (baseAssistColl != null) {
            block0: for (int i = 0; i < baseAssistColl.size(); ++i) {
                for (int j = 0; j < baseAssistColl.size(); ++j) {
                    if (baseAssistColl.get(i).getMeasureUnit().getId().toString().equals(baseAssistColl.get(j).getMeasureUnit().getId().toString())) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        if (result) {
            measureUnitInfo = baseAssistColl.get(0).getMeasureUnit();
            tempPcVoucherEntryInfo.setMeasureUnit(measureUnitInfo);
        } else {
            measureUnitInfo = entryInfo.getCAA().getMeasureUnitGroup().getDefaultUnit();
            BigDecimal quantity = BigDecimal.ZERO;
            if (baseAssistColl != null) {
                for (int i = 0; i < baseAssistColl.size(); ++i) {
                    VoucherAssistRecordInfo info = baseAssistColl.get(i);
                    quantity = quantity.add(info.getQuantity().multiply(info.getMeasureUnit().getCoefficient()));
                }
            }
            tempPcVoucherEntryInfo.setMeasureUnit(measureUnitInfo);
            tempPcVoucherEntryInfo.setPrice(tempPcVoucherEntryInfo.getOriginalAmount().divide(quantity, 3));
            tempPcVoucherEntryInfo.setQuantity(quantity);
        }
    }

    private static void setQuantityNull(Context ctx, PcVoucherEntryInfo tempPcVoucherEntryInfo) {
        tempPcVoucherEntryInfo.setQuantity(BigDecimal.ZERO);
        tempPcVoucherEntryInfo.setPrice(BigDecimal.ZERO);
        tempPcVoucherEntryInfo.setMeasureUnit(null);
        PcVoucherAssistRecordCollection pcBaseAssistColl = tempPcVoucherEntryInfo.getAssistRecords();
        if (pcBaseAssistColl != null) {
            for (int i = 0; i < pcBaseAssistColl.size(); ++i) {
                PcVoucherAssistRecordInfo info = pcBaseAssistColl.get(i);
                info.setQuantity(BigDecimal.ZERO);
                info.setPrice(BigDecimal.ZERO);
            }
        }
    }

    private static PcVoucherAssistRecordCollection getBaseVoucherAssistReCollNew(Context ctx, Map<String, Object> cache, VoucherAssistRecordCollection assistRecords, PcVoucherEntryInfo tempPcVoucherEntryInfo, PcVoucherInfo tempPcVoucherInfo, VoucherEntryInfo entryInfo) throws EASBizException, BOSException {
        boolean needSetProperty;
        PcVoucherAssistRecordCollection pcBaseAssistColl = new PcVoucherAssistRecordCollection();
        AccountViewInfo oldAccount = entryInfo.getAccount();
        AccountViewInfo asstAcct = tempPcVoucherEntryInfo.getAccount();
        boolean bl = needSetProperty = asstAcct.isHasUserProperty() && oldAccount.isHasUserProperty() && !asstAcct.getId().equals((Object)oldAccount.getId().toString());
        if (oldAccount == null || asstAcct == null) {
            if (needSetProperty) {
                pcBaseAssistColl = SynVoucherUtil.getPcBaseAssistCollByProperty(assistRecords, tempPcVoucherEntryInfo, tempPcVoucherInfo);
            }
            return pcBaseAssistColl;
        }
        AsstAccountInfo oldCaa = entryInfo.getCAA();
        AsstAccountInfo newCaa = null;
        String newCaaId = SynVoucherUtil.getNewCaaId(ctx, cache, asstAcct.getId().toString());
        if (newCaaId != null) {
            newCaa = SynVoucherUtil.getCaa(ctx, cache, newCaaId);
        }
        if (newCaa == null) {
            if (needSetProperty) {
                pcBaseAssistColl = SynVoucherUtil.getPcBaseAssistCollByProperty(assistRecords, tempPcVoucherEntryInfo, tempPcVoucherInfo);
            }
            return pcBaseAssistColl;
        }
        boolean isChangeAsst = false;
        if (oldCaa == null || !newCaa.getId().equals((Object)oldCaa.getId())) {
            isChangeAsst = true;
        }
        Map<Object, Object> oldAssistantHgs = new HashMap();
        HashMap defaultVal = new HashMap();
        if (isChangeAsst) {
            if (oldCaa != null) {
                HashSet<String> assistGrpIds = new HashSet<String>();
                for (VoucherAssistRecordInfo assistInfo : assistRecords) {
                    if (assistInfo.getAssGrp() == null) continue;
                    assistGrpIds.add(assistInfo.getAssGrp().getId().toString());
                }
                if (assistGrpIds.size() > 0) {
                    oldAssistantHgs = SynVoucherUtil.getOldAssistantHgs(ctx, cache, oldCaa.getId().toString(), assistGrpIds);
                }
            }
            AsstActTypeCollection oldAsstActTypes = new AsstActTypeCollection();
            if (oldCaa != null) {
                oldAsstActTypes = SynVoucherUtil.getAsstActTypes(ctx, cache, oldCaa.getId().toString());
            }
            HashMap<String, AsstActTypeInfo> oldAsstActTypeMap = new HashMap<String, AsstActTypeInfo>();
            for (AsstActTypeInfo asstActType : oldAsstActTypes) {
                oldAsstActTypeMap.put(asstActType.getId().toString(), asstActType);
            }
            HashMap<String, AsstActTypeInfo> lossAsstActTypeMap = new HashMap<String, AsstActTypeInfo>();
            AsstActTypeCollection newAsstActTypes = SynVoucherUtil.getAsstActTypes(ctx, cache, newCaaId);
            for (AsstActTypeInfo asstActType : newAsstActTypes) {
                if (oldAsstActTypeMap.containsKey(asstActType.getId().toString())) continue;
                lossAsstActTypeMap.put(asstActType.getId().toString(), asstActType);
            }
            if (lossAsstActTypeMap.size() > 0) {
                Map<Object, Object> val;
                if (asstAcct.get("isContrast") != null) {
                    val = new HashMap();
                    AccountRefContrastEntryDefaultCollection defColl = (AccountRefContrastEntryDefaultCollection)asstAcct.get("defaultEntry");
                    if (defColl != null) {
                        for (int i = 0; i < defColl.size(); ++i) {
                            AccountRefContrastEntryDefaultInfo def = defColl.get(i);
                            if (def.getAsstActType() == null || def.getDefaultId() == null) continue;
                            val.put(def.getAsstActType().getId().toString(), def.getDefaultId().toString());
                        }
                    }
                    for (String asstActTypeId : lossAsstActTypeMap.keySet()) {
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)lossAsstActTypeMap.get(asstActTypeId);
                        String asstActId = (String)val.get(asstActTypeId);
                        if (asstActId == null) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1001", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), oldAccount.getNumber(), oldAccount.getId(), asstAcct.getNumber(), asstAcct.getId()})));
                        }
                        Object value = null;
                        HashSet<String> asstActIds = new HashSet<String>();
                        asstActIds.add(asstActId);
                        try {
                            if ("bankAccount".equals(asstActType.getAsstHGAttribute()) || "provider".equals(asstActType.getAsstHGAttribute())) {
                                entryInfo.getBill().getCompany().put("relatedcompanys", SynVoucherUtil.getRelatedCompanys(ctx, entryInfo.getProfitCenter().getId().toString()));
                            }
                            Map r = VoucherProcessCache.findAsstActByIds((Context)ctx, (AsstActTypeInfo)asstActType, asstActIds, (CompanyOrgUnitInfo)entryInfo.getBill().getCompany(), null, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                            value = r.get(asstActId);
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                        if (value == null || value instanceof String) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1002", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), asstActId, oldAccount.getNumber(), oldAccount.getId(), asstAcct.getNumber(), asstAcct.getId()})));
                        }
                        defaultVal.put(asstActType.getAsstHGAttribute(), value);
                    }
                } else {
                    val = SynVoucherUtil.getdefaultVal(ctx, cache, asstAcct.getId().toString(), -1);
                    for (String asstActTypeId : lossAsstActTypeMap.keySet()) {
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)lossAsstActTypeMap.get(asstActTypeId);
                        String asstActId = (String)val.get(asstActTypeId);
                        if (asstActId == null) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1003", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), oldAccount.getNumber(), oldAccount.getId()})));
                        }
                        Object value = null;
                        HashSet<String> asstActIds = new HashSet<String>();
                        asstActIds.add(asstActId);
                        try {
                            if ("bankAccount".equals(asstActType.getAsstHGAttribute()) || "provider".equals(asstActType.getAsstHGAttribute()) || "customer".equals(asstActType.getAsstHGAttribute()) || "material".equals(asstActType.getAsstHGAttribute())) {
                                entryInfo.getBill().getCompany().put("relatedcompanys", SynVoucherUtil.getRelatedCompanys(ctx, entryInfo.getProfitCenter().getId().toString()));
                            }
                            Map r = VoucherProcessCache.findAsstActByIds((Context)ctx, (AsstActTypeInfo)asstActType, asstActIds, (CompanyOrgUnitInfo)entryInfo.getBill().getCompany(), null, (String)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                            value = r.get(asstActId);
                        }
                        catch (Exception e) {
                            throw new BOSException((Throwable)e);
                        }
                        if (value == null || value instanceof String) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1004", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), asstActId, oldAccount.getNumber(), oldAccount.getId()})));
                        }
                        defaultVal.put(asstActType.getAsstHGAttribute(), value);
                    }
                }
            }
        }
        if (assistRecords.size() == 0) {
            assistRecords = new VoucherAssistRecordCollection();
            VoucherAssistRecordInfo info = new VoucherAssistRecordInfo();
            info.putAll((IObjectValue)entryInfo);
            info.setSeq(1);
            info.setBizDate(tempPcVoucherInfo.getBizDate());
            info.setEndDate(tempPcVoucherInfo.getBizDate());
            assistRecords.add(info);
        }
        HashMap resultMap = new HashMap();
        int count = assistRecords.size();
        for (int i = 0; i < count; ++i) {
            VoucherAssistRecordInfo assistInfoBefore = assistRecords.get(i);
            assistInfoBefore.setEntry(null);
            assistInfoBefore.setBill(null);
            PcVoucherAssistRecordInfo pcAssistInfo = new PcVoucherAssistRecordInfo();
            pcAssistInfo.putAll((IObjectValue)assistInfoBefore);
            pcAssistInfo.setId(null);
            pcAssistInfo.setEntry(null);
            pcAssistInfo.setBill(null);
            if (isChangeAsst) {
                AssistantHGInfo oldAssistantHg = assistInfoBefore.getAssGrp();
                if (oldAssistantHg != null) {
                    oldAssistantHg = (AssistantHGInfo)oldAssistantHgs.get(oldAssistantHg.getId().toString());
                }
                VoucherProcessCache vpc = VoucherProcessCache.getCache((Context)ctx);
                AssistantHGInfo inHg = new AssistantHGInfo();
                AsstActTypeCollection aats = VoucherProcessCache.getAsstActTypes((Context)ctx, (String)newCaa.getId().toString());
                for (AsstActTypeInfo aat : aats) {
                    Object aa;
                    Object object = aa = oldAssistantHg != null ? oldAssistantHg.get(aat.getAsstHGAttribute()) : null;
                    if (aa == null) {
                        aa = defaultVal.get(aat.getAsstHGAttribute());
                    }
                    inHg.put(aat.getAsstHGAttribute(), aa);
                }
                AssistantHGInfo assg = vpc.findAssistantHG(ctx, newCaa, aats, inHg);
                pcAssistInfo.setAssGrp(assg);
            }
            pcAssistInfo.setEntry(tempPcVoucherEntryInfo);
            pcAssistInfo.setBill(tempPcVoucherInfo);
            pcBaseAssistColl.add(pcAssistInfo);
            String assitId = pcAssistInfo.getAssGrp().getId().toString() + i;
            if (!resultMap.containsKey(assitId)) {
                ArrayList<PcVoucherAssistRecordInfo> pcList = new ArrayList<PcVoucherAssistRecordInfo>();
                pcList.add(pcAssistInfo);
                resultMap.put(assitId, pcList);
                continue;
            }
            ((List)resultMap.get(assitId)).add(pcAssistInfo);
        }
        Set keySet = resultMap.keySet();
        PcVoucherAssistRecordCollection resultPcColl = new PcVoucherAssistRecordCollection();
        for (String key : keySet) {
            List infoList = (List)resultMap.get(key);
            PcVoucherAssistRecordInfo info = (PcVoucherAssistRecordInfo)infoList.get(0);
            if (infoList.size() > 1) {
                for (int i = 1; i < infoList.size(); ++i) {
                    info.setLocalAmount(info.getLocalAmount().add(((PcVoucherAssistRecordInfo)infoList.get(i)).getLocalAmount()));
                    info.setOriginalAmount(info.getOriginalAmount().add(((PcVoucherAssistRecordInfo)infoList.get(i)).getOriginalAmount()));
                    info.setQuantity(info.getQuantity().add(((PcVoucherAssistRecordInfo)infoList.get(i)).getQuantity()));
                }
            }
            resultPcColl.add(info);
        }
        return resultPcColl;
    }

    public static Set<String> getRelatedCompanys(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        Map datas = VoucherProcessCache.getDatas((Context)ctx, (String)"getRelatedCompanys");
        if (datas.containsKey(profitCenterId)) {
            return (Set)datas.get(profitCenterId);
        }
        Set relatedCompanys = GlWebServiceUtil.getRelatedCompanyIdsAndAccountRange((Context)ctx, (String)profitCenterId);
        datas.put(profitCenterId, relatedCompanys);
        return relatedCompanys;
    }

    private static PcVoucherAssistRecordCollection getBaseVoucherAssistReColl(Context ctx, Map<String, Object> cache, VoucherAssistRecordCollection assistRecords, PcVoucherEntryInfo tempPcVoucherEntryInfo, PcVoucherInfo tempPcVoucherInfo, VoucherEntryInfo entryInfo) throws EASBizException, BOSException {
        PcVoucherAssistRecordCollection pcBaseAssistColl = new PcVoucherAssistRecordCollection();
        AccountViewInfo oldAccount = entryInfo.getAccount();
        AccountViewInfo asstAcct = tempPcVoucherEntryInfo.getAccount();
        if (oldAccount == null || asstAcct == null) {
            return pcBaseAssistColl;
        }
        AsstAccountInfo oldCaa = entryInfo.getCAA();
        AsstAccountInfo newCaa = null;
        String newCaaId = SynVoucherUtil.getNewCaaId(ctx, cache, asstAcct.getId().toString());
        if (newCaaId != null) {
            newCaa = SynVoucherUtil.getCaa(ctx, cache, newCaaId);
        }
        if (newCaa == null) {
            return pcBaseAssistColl;
        }
        boolean isChangeAsst = false;
        if (oldCaa == null || !newCaa.getId().equals((Object)oldCaa.getId())) {
            isChangeAsst = true;
        }
        Map<Object, Object> oldAssistantHgs = new HashMap();
        HashMap<AsstActTypeInfo, Object> defaultVal = new HashMap<AsstActTypeInfo, Object>();
        if (isChangeAsst) {
            if (oldCaa != null) {
                HashSet<String> assistGrpIds = new HashSet<String>();
                for (VoucherAssistRecordInfo assistInfo : assistRecords) {
                    if (assistInfo.getAssGrp() == null) continue;
                    assistGrpIds.add(assistInfo.getAssGrp().getId().toString());
                }
                if (assistGrpIds.size() > 0) {
                    oldAssistantHgs = SynVoucherUtil.getOldAssistantHgs(ctx, cache, oldCaa.getId().toString(), assistGrpIds);
                }
            }
            AsstActTypeCollection oldAsstActTypes = new AsstActTypeCollection();
            if (oldCaa != null) {
                oldAsstActTypes = SynVoucherUtil.getAsstActTypes(ctx, cache, oldCaa.getId().toString());
            }
            HashMap<String, AsstActTypeInfo> oldAsstActTypeMap = new HashMap<String, AsstActTypeInfo>();
            for (AsstActTypeInfo asstActType : oldAsstActTypes) {
                oldAsstActTypeMap.put(asstActType.getId().toString(), asstActType);
            }
            HashMap<String, AsstActTypeInfo> lossAsstActTypeMap = new HashMap<String, AsstActTypeInfo>();
            AsstActTypeCollection newAsstActTypes = SynVoucherUtil.getAsstActTypes(ctx, cache, newCaaId);
            for (AsstActTypeInfo asstActType : newAsstActTypes) {
                if (oldAsstActTypeMap.containsKey(asstActType.getId().toString())) continue;
                lossAsstActTypeMap.put(asstActType.getId().toString(), asstActType);
            }
            if (lossAsstActTypeMap.size() > 0) {
                Map<Object, Object> val;
                if (asstAcct.get("isContrast") != null) {
                    val = new HashMap();
                    AccountRefContrastEntryDefaultCollection defColl = (AccountRefContrastEntryDefaultCollection)asstAcct.get("defaultEntry");
                    if (defColl != null) {
                        for (int i = 0; i < defColl.size(); ++i) {
                            AccountRefContrastEntryDefaultInfo def = defColl.get(i);
                            if (def.getAsstActType() == null || def.getDefaultId() == null) continue;
                            val.put(def.getAsstActType().getId().toString(), def.getDefaultId().toString());
                        }
                    }
                    for (String asstActTypeId : lossAsstActTypeMap.keySet()) {
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)lossAsstActTypeMap.get(asstActTypeId);
                        String asstActId = (String)val.get(asstActTypeId);
                        if (asstActId == null) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1005", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), oldAccount.getNumber(), oldAccount.getId(), asstAcct.getNumber(), asstAcct.getId()})));
                        }
                        ObjectBaseInfo value = GlWebServiceUtil.findAsstActObject((Context)ctx, (String)asstActType.getAsstHGAttribute(), (String)asstActId);
                        if (value == null) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1006", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), asstActId, oldAccount.getNumber(), oldAccount.getId(), asstAcct.getNumber(), asstAcct.getId()})));
                        }
                        defaultVal.put(asstActType, value);
                    }
                } else {
                    val = SynVoucherUtil.getdefaultVal(ctx, cache, oldAccount.getId().toString(), -1);
                    for (String asstActTypeId : lossAsstActTypeMap.keySet()) {
                        AsstActTypeInfo asstActType = (AsstActTypeInfo)lossAsstActTypeMap.get(asstActTypeId);
                        String asstActId = (String)val.get(asstActTypeId);
                        if (asstActId == null) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1007", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), oldAccount.getNumber(), oldAccount.getId()})));
                        }
                        ObjectBaseInfo value = GlWebServiceUtil.findAsstActObject((Context)ctx, (String)asstActType.getAsstHGAttribute(), (String)asstActId);
                        if (value == null) {
                            throw new EASBizException(new NumericExceptionSubItem("101", ResourceBase.getString((String)RESOURCE, (String)"SynVoucherUtil1008", (Locale)ctx.getLocale(), (Object[])new Object[]{asstActType.getName(), asstActId, oldAccount.getNumber(), oldAccount.getId()})));
                        }
                        defaultVal.put(asstActType, value);
                    }
                }
            }
        }
        if (assistRecords.size() == 0) {
            assistRecords = new VoucherAssistRecordCollection();
            VoucherAssistRecordInfo info = new VoucherAssistRecordInfo();
            info.putAll((IObjectValue)entryInfo);
            info.setSeq(1);
            info.setBizDate(tempPcVoucherInfo.getBizDate());
            info.setEndDate(tempPcVoucherInfo.getBizDate());
            assistRecords.add(info);
        }
        int count = assistRecords.size();
        for (int i = 0; i < count; ++i) {
            VoucherAssistRecordInfo assistInfoBefore = assistRecords.get(i);
            assistInfoBefore.setEntry(null);
            assistInfoBefore.setBill(null);
            VoucherAssistRecordInfo assistInfo = (VoucherAssistRecordInfo)assistInfoBefore.clone();
            assistInfo.setId(null);
            assistInfo.setEntry(null);
            assistInfo.setBill(null);
            PcVoucherAssistRecordInfo pcAssistInfo = new PcVoucherAssistRecordInfo();
            pcAssistInfo.putAll((IObjectValue)assistInfo);
            if (isChangeAsst) {
                AssistantHGInfo oldAssistantHg = assistInfo.getAssGrp();
                if (oldAssistantHg != null) {
                    oldAssistantHg = (AssistantHGInfo)oldAssistantHgs.get(oldAssistantHg.getId().toString());
                }
                AssistantHGInfo assg = SynVoucherUtil.getNewAssistantHg(ctx, cache, newCaa.getId().toString(), oldAssistantHg, defaultVal);
                pcAssistInfo.setAssGrp(assg);
            }
            pcAssistInfo.setEntry(tempPcVoucherEntryInfo);
            pcAssistInfo.setBill(tempPcVoucherInfo);
            pcBaseAssistColl.add(pcAssistInfo);
        }
        return pcBaseAssistColl;
    }

    private static String getNewCaaId(Context ctx, Map<String, Object> cache, String accountId) throws EASBizException, BOSException {
        HashMap<String, String> newCaaIds = (HashMap<String, String>)cache.get("newCaaIds");
        if (newCaaIds == null) {
            newCaaIds = new HashMap<String, String>();
            cache.put("newCaaIds", newCaaIds);
        }
        if (newCaaIds.containsKey(accountId)) {
            return (String)newCaaIds.get(accountId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add(new SelectorItemInfo("CAA.id"));
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), selector);
        String newCaaId = null;
        if (account.getCAA() != null) {
            newCaaId = account.getCAA().getId().toString();
        }
        newCaaIds.put(accountId, newCaaId);
        return newCaaId;
    }

    private static AsstAccountInfo getCaa(Context ctx, Map<String, Object> cache, String caaId) throws BOSException, EASBizException {
        HashMap<String, AsstAccountInfo> caas = (HashMap<String, AsstAccountInfo>)cache.get("caas");
        if (caas == null) {
            caas = new HashMap<String, AsstAccountInfo>();
            cache.put("caas", caas);
        }
        if (caas.containsKey(caaId)) {
            return (AsstAccountInfo)caas.get(caaId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("isQty");
        selector.add("measureUnit.id");
        selector.add("measureUnit.coefficient");
        selector.add("measureUnit.qtyPrecision");
        selector.add("measureUnitGroup.id");
        AsstAccountInfo asstAccount = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(caaId), selector);
        caas.put(caaId, asstAccount);
        return asstAccount;
    }

    private static AsstActTypeCollection getAsstActTypes(Context ctx, Map<String, Object> cache, String caaId) throws BOSException {
        HashMap<String, AsstActTypeCollection> asstActTypess = (HashMap<String, AsstActTypeCollection>)cache.get("asstActTypess");
        if (asstActTypess == null) {
            asstActTypess = new HashMap<String, AsstActTypeCollection>();
            cache.put("asstActTypess", asstActTypess);
        }
        if (asstActTypess.containsKey(caaId)) {
            return (AsstActTypeCollection)asstActTypess.get(caaId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)caaId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        asstActTypess.put(caaId, asstActTypes);
        return asstActTypes;
    }

    private static Map<String, AssistantHGInfo> getOldAssistantHgs(Context ctx, Map<String, Object> cache, String caaId, Set<String> assistGrpIds) throws BOSException {
        HashMap<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
        HashMap<String, AssistantHGInfo> allHgs = (HashMap<String, AssistantHGInfo>)cache.get("hgs");
        if (allHgs == null) {
            allHgs = new HashMap<String, AssistantHGInfo>();
            cache.put("hgs", allHgs);
        }
        HashSet<String> subIds = new HashSet<String>();
        for (String id : assistGrpIds) {
            if (allHgs.containsKey(id)) {
                hgs.put(id, (AssistantHGInfo)allHgs.get(id));
                continue;
            }
            subIds.add(id);
        }
        if (subIds.size() == 0) {
            return hgs;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstAccount.id"));
        AsstActTypeCollection asstActTypeList = SynVoucherUtil.getAsstActTypes(ctx, cache, caaId);
        if (asstActTypeList != null && asstActTypeList.size() > 0) {
            for (int i = 0; i < asstActTypeList.size(); ++i) {
                AsstActTypeInfo asstActType = asstActTypeList.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".id");
                selectors.add(attr + ".name");
                if ("provider".equals(attr) || "customer".equals(attr)) {
                    selectors.add(attr + ".browseGroup.displayName");
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    selectors.add(attr + ".materialGroup.displayName");
                } else if (asstActType.isIsMultilevel()) {
                    selectors.add(attr + ".displayName");
                }
                selectors.add(attr + ".number");
            }
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", subIds, CompareType.INCLUDE));
        IAssistantHG assistanthg = AssistantHGFactory.getLocalInstance((Context)ctx);
        AssistantHGCollection assistantHgColl = assistanthg.getAssistantHGCollection(view);
        for (int i = 0; i < assistantHgColl.size(); ++i) {
            AssistantHGInfo hg = assistantHgColl.get(i);
            String hgFid = hg.getId().toString();
            hgs.put(hgFid, assistantHgColl.get(i));
            allHgs.put(hgFid, assistantHgColl.get(i));
        }
        return hgs;
    }

    private static AssistantHGInfo getNewAssistantHg(Context ctx, Map<String, Object> cache, String newCaaId, AssistantHGInfo oldHgInfo, Map<AsstActTypeInfo, Object> defaultVal) throws EASBizException, BOSException {
        String asstHGAttribute;
        AsstActTypeCollection asstActTypes = SynVoucherUtil.getAsstActTypes(ctx, cache, newCaaId);
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        hgInfo.setId(null);
        hgInfo.setAsstAccount(SynVoucherUtil.getCaa(ctx, cache, newCaaId));
        for (AsstActTypeInfo oldInfo : defaultVal.keySet()) {
            asstHGAttribute = oldInfo.getAsstHGAttribute();
            if (defaultVal.get(oldInfo) == null) continue;
            hgInfo.put(asstHGAttribute, defaultVal.get(oldInfo));
        }
        if (oldHgInfo != null) {
            for (int i = 0; i < asstActTypes.size(); ++i) {
                asstHGAttribute = asstActTypes.get(i).getAsstHGAttribute();
                Object value = oldHgInfo.get(asstHGAttribute);
                if (value == null) continue;
                hgInfo.put(asstHGAttribute, value);
            }
        }
        hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(hgInfo, newCaaId, asstActTypes);
        return hgInfo;
    }

    private static Map<String, String> getdefaultVal(Context ctx, Map<String, Object> cache, String accountId, int period) throws BOSException {
        HashMap<String, HashMap<String, String>> defaultVals = (HashMap<String, HashMap<String, String>>)cache.get("defaultVals");
        if (defaultVals == null) {
            defaultVals = new HashMap<String, HashMap<String, String>>();
            cache.put("defaultVals", defaultVals);
        }
        if (defaultVals.containsKey(accountId)) {
            return (Map)defaultVals.get(accountId);
        }
        HashMap<String, String> defaultVal = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    ce.FASSTACTTYPEID, ce.FASSTACTID \n");
        sql.append("from T_BD_AsstAccountChange c \n");
        sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
        sql.append("join T_BD_AsstAccountChangeEntry ce on ce.FPARENTID = c.FID \n");
        sql.append("where c.FAccountID = ? \n");
        if (period > 0) {
            sql.append("and p.FNumber >= ? \n");
        }
        sql.append("and ce.FASSTACTTYPEID is not null \n");
        sql.append("and ce.FASSTACTID is not null \n");
        sql.append("order by p.FNumber desc \n");
        Object[] params = period > 0 ? new Object[]{accountId, period} : new Object[]{accountId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rs.next()) {
                String asstActTypeId = rs.getString("FASSTACTTYPEID");
                String asstActId = rs.getString("FASSTACTID");
                if (defaultVal.containsKey(asstActTypeId)) continue;
                defaultVal.put(asstActTypeId, asstActId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        defaultVals.put(accountId, defaultVal);
        return defaultVal;
    }

    public static int getReportCurrencyPrecision(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        int reportPrecision = 2;
        if (companyInfo.getReportCurrency() != null && companyInfo.getReportCurrency().get("precision") != null) {
            reportPrecision = companyInfo.getReportCurrency().getPrecision();
        }
        if (companyInfo.getReportCurrency() == null || companyInfo.getReportCurrency().get("precision") == null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id, reportCurrency.precision where id='" + companyInfo.getId() + "'");
            reportPrecision = company.getReportCurrency() != null ? company.getReportCurrency().getPrecision() : 2;
        }
        return reportPrecision;
    }

    public static int getBaseCurrencyPrecision(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        int basePrecision = 2;
        if (companyInfo.getBaseCurrency() != null && companyInfo.getBaseCurrency().get("precision") != null) {
            basePrecision = companyInfo.getBaseCurrency().getPrecision();
        }
        if (companyInfo.getBaseCurrency() == null || companyInfo.getBaseCurrency().get("precision") == null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + companyInfo.getId() + "'");
            basePrecision = company.getBaseCurrency().getPrecision();
        }
        return basePrecision;
    }

    public static BaseVoucherInfo CloneVoucherInfo(VoucherInfo voucherInfo) {
        BaseVoucherInfo baseVoucherInfo = new BaseVoucherInfo();
        baseVoucherInfo.putAll((IObjectValue)voucherInfo);
        baseVoucherInfo.setEntries(null);
        baseVoucherInfo.setId(null);
        baseVoucherInfo.setCashflowRecords(null);
        return baseVoucherInfo;
    }

    public static BaseVoucherEntryInfo CloneVoucherEntryInfo(VoucherEntryInfo entryInfo, Map<String, AccountViewInfo> accountRef) {
        String key;
        AccountViewInfo newAc;
        BaseVoucherEntryInfo baseVoucherEntryInfo = new BaseVoucherEntryInfo();
        entryInfo.getCashflowEntry().clear();
        if (accountRef != null && !accountRef.isEmpty() && (newAc = accountRef.get(key = entryInfo.getProfitCenter().getId().toString() + entryInfo.getAccount().getId().toString())) != null) {
            entryInfo.setAccount(newAc);
        }
        entryInfo.getCashflowRecords().clear();
        baseVoucherEntryInfo.putAll((IObjectValue)entryInfo);
        baseVoucherEntryInfo.setAssistRecords(null);
        baseVoucherEntryInfo.setBill(null);
        baseVoucherEntryInfo.setId(null);
        return baseVoucherEntryInfo;
    }

    public static void setPcVoucherStatus(PcVoucherInfo pcVoucherInfo, int opType) {
        switch (opType) {
            case 1: 
            case 2: {
                pcVoucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
                break;
            }
        }
    }

    public static PeriodInfo getVoucherPeriod(Context ctx, PeriodInfo period) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        IPeriod iPeriod = null;
        iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo prd = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()), sic);
        return prd;
    }

    public static PeriodInfo getPcaCurrentPeriod(Context ctx, String profigCenterId) throws BOSException, EASBizException {
        if (ctx == null) {
            return SystemStatusCtrolFactory.getRemoteInstance().getProfitCurrentPeriod(new Integer(SystemEnum.PROFIT_CENTER_ACCOUNTING.getValue()).intValue(), profigCenterId);
        }
        return VoucherProcessCache.getPcaCurrentPeriod((Context)ctx, (String)profigCenterId);
    }

    public static void checkVoucherPeriod(Context ctx, PeriodInfo voucherPeriodInfo, ProfitCenterOrgUnitInfo profitCenterInfo, VoucherOperateStatusEnum operateEnum) throws EASBizException, BOSException {
        PeriodInfo pcaPeriodInfo = SynVoucherUtil.getPcaCurrentPeriod(ctx, profitCenterInfo.getId().toString());
        if (voucherPeriodInfo != null && pcaPeriodInfo != null && voucherPeriodInfo.getNumber() < pcaPeriodInfo.getNumber()) {
            throw new PcVoucherException(PcVoucherException.VOUCHER_PERIOD_BEFORE_PCAPERIOD, new String[]{profitCenterInfo.getName(), operateEnum.getAlias()});
        }
    }

    public static void profitCenterBalanceDebitCreditAmount(Context ctx, PcVoucherInfo pcVoucherInfo) throws EASBizException, BOSException {
        boolean profitCenterBalanceChecked;
        HashMap<String, String> paramKeys = new HashMap<String, String>();
        paramKeys.put("GL_111", pcVoucherInfo.getCompany().getId().toString());
        paramKeys.put("GL_112", pcVoucherInfo.getCompany().getId().toString());
        paramKeys.put("G001", pcVoucherInfo.getCompany().getId().toString());
        Map hmParam = VoucherProcessCache.getParams((Context)ctx, paramKeys);
        boolean commonVoucherProcess = hmParam.get("GL_111") == null ? false : new Boolean(hmParam.get("GL_111").toString());
        boolean bl = profitCenterBalanceChecked = hmParam.get("GL_112") == null ? false : new Boolean(hmParam.get("GL_112").toString());
        if (commonVoucherProcess && profitCenterBalanceChecked) {
            boolean useReportingCurrency = hmParam.get("G001") == null ? false : new Boolean(hmParam.get("G001").toString());
            BigDecimal result = zero;
            BigDecimal repotyResult = zero;
            for (PcVoucherEntryInfo entryInfo : pcVoucherInfo.getEntries()) {
                EntryDC entryDC = entryInfo.getEntryDC();
                BigDecimal localAmount = entryInfo.getLocalAmount();
                BigDecimal tempLocalAmount = EntryDC.DEBIT == entryDC ? localAmount : localAmount.multiply(new BigDecimal("-1"));
                result = result.add(tempLocalAmount);
                if (!useReportingCurrency) continue;
                BigDecimal reportingAmount = entryInfo.getReportingAmount();
                BigDecimal tempReportingAmount = EntryDC.DEBIT == entryDC ? reportingAmount : reportingAmount.multiply(new BigDecimal("-1"));
                repotyResult = repotyResult.add(tempReportingAmount);
            }
            if (result.compareTo(new BigDecimal("0.00")) != 0) {
                throw new VoucherException(VoucherException.LOCALAMOUNT_DC_NOT_EQUAL);
            }
            if (repotyResult.compareTo(new BigDecimal("0.00")) != 0) {
                throw new VoucherException(VoucherException.REPORTAMOUNT_DC_NOT_EQUAL);
            }
        }
    }

    public static PcVoucherCollection getPcVoucherCollectionBySourceBillId(Context ctx, VoucherInfo voucherInfo, SelectorItemCollection sic) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("sourceBillId", (Object)voucherInfo.getId().toString()));
        view.setSelector(sic);
        IPcVoucher iPc = null;
        iPc = ctx == null ? PcVoucherFactory.getRemoteInstance() : PcVoucherFactory.getLocalInstance((Context)ctx);
        return iPc.getPcVoucherCollection(view);
    }

    public static SelectorItemCollection getSynPcVoucherSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("profitCenter.id"));
        sic.add(new SelectorItemInfo("profitCenter.name"));
        sic.add(new SelectorItemInfo("profitCenter.number"));
        return sic;
    }

    public static void checkPcVoucherCannotOperateInPca(Context ctx, PcVoucherInfo pcVoucherInfo, VoucherOperateStatusEnum operateEnum) throws EASBizException {
        if (pcVoucherInfo.getSourceType() == SourceType.GLVOUCHER) {
            throw new PcVoucherException(PcVoucherException.PCVOUCHER_CANNOT_OPERATE_IN_PCA, new String[]{operateEnum.getAlias()});
        }
    }

    public static void insertBOTRelation(Context ctx, BOTRelationCollection botRelationColls) throws BOSException {
        int tmpRelationSize = 0;
        int tmpRelationEntrySize = 0;
        BOTRelationInfo botRelationInfo = null;
        BOTRelationEntryCollection relationEntryCollection = null;
        BOTRelationEntryInfo relationEntryInfo = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramsEntryList = new ArrayList<Object[]>();
        String sql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (?,?,?,?,?,?,?,?,?,?)";
        String sqlEntry = "insert into t_bot_relationentry (FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID) values (?,?,?,?,?,?,?,?,?,?,?)";
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int count = botRelationColls.size();
        for (int i = 0; i < count; ++i) {
            botRelationInfo = botRelationColls.get(i);
            if (botRelationInfo.getId() != null && ibotRelation.exists((IObjectPK)new ObjectUuidPK(botRelationInfo.getId().toString()))) continue;
            String billid = null;
            billid = botRelationInfo.getId() == null ? BOSUuid.create((String)"59302EC6").toString() : botRelationInfo.getId().toString();
            Object[] params = new Object[]{billid, botRelationInfo.getSrcEntityID(), botRelationInfo.getDestEntityID(), botRelationInfo.getSrcObjectID(), botRelationInfo.getDestObjectID(), botRelationInfo.getDate(), botRelationInfo.getOperatorID(), new Boolean(botRelationInfo.isIsEffected()), botRelationInfo.getBOTMappingID(), new Integer(botRelationInfo.getType())};
            paramList.add(params);
            tmpRelationSize = paramList.size();
            if (tmpRelationSize > 2000) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                paramList.clear();
                tmpRelationSize = 0;
            }
            relationEntryCollection = botRelationInfo.getRelationEntries();
            for (int j = 0; j < relationEntryCollection.size(); ++j) {
                relationEntryInfo = relationEntryCollection.get(j);
                String entryid = null;
                entryid = relationEntryInfo.getId() == null ? BOSUuid.create((String)"B99C354C").toString() : relationEntryInfo.getId().toString();
                Object[] paramsEntry = new Object[]{entryid, relationEntryInfo.getSrcObjectID(), relationEntryInfo.getDestObjectID(), relationEntryInfo.getSrcEntryID(), relationEntryInfo.getDestEntryID(), relationEntryInfo.getSrcEntryPropName(), relationEntryInfo.getDestEntryPropName(), relationEntryInfo.getSrcPropertyName(), relationEntryInfo.getDestPropertyName(), relationEntryInfo.getValue(), botRelationInfo.getId().toString()};
                paramsEntryList.add(paramsEntry);
                tmpRelationEntrySize = paramsEntryList.size();
                if (tmpRelationEntrySize <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sqlEntry, paramsEntryList);
                paramsEntryList.clear();
                tmpRelationEntrySize = 0;
            }
        }
        if (tmpRelationSize != 0) {
            DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
            paramList.clear();
        }
        if (tmpRelationEntrySize != 0) {
            DbUtil.executeBatch((Context)ctx, (String)sqlEntry, paramsEntryList);
            paramsEntryList.clear();
        }
    }

    public static void deleteBOTRelation(Context ctx, String voucherId, String pcVoucherId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BOT_Relation ");
        sql.append(" where FSrcObjectId = ? ");
        sql.append("   and FDestObjectId = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherId, pcVoucherId});
    }

    public static GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "ISubmitVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache((Context)ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])GlUtils.getDefaultGLParamList(), (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }
}

