/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.common;

import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import org.apache.log4j.Logger;

public class PCABalanceUtils {
    private static final Logger logger = Logger.getLogger(SQLUtil.class);
    public static final int ACCOUNT_BALANCE = 1;
    public static final int ASSIST_BALANCE = 2;
    public static final int MEASURE_BALANCE = 3;

    public static String getBalanceTable(int tableType, int balType, String currencyId) {
        String table = null;
        if (tableType == 1) {
            table = "T_PCA_PCAccountBalance";
        } else if (tableType == 2) {
            table = "T_PCA_PCAssistBalance";
        } else if (tableType == 3) {
            table = "T_PCA_PCAssistMeasBalance";
        } else {
            throw new IllegalArgumentException("tableType must be 1, 2 or 3.");
        }
        if (balType == 1) {
            table = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? table + "_1L" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? table + "_1R" : table + "_1F");
        } else if (balType == 5) {
            table = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId) ? table + "_5L" : ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId) ? table + "_5R" : table + "_5F");
        } else {
            throw new IllegalArgumentException("balType must be 1 or 5.");
        }
        return table;
    }

    public static String getAccountBalanceTable(int baltype, String currencyId) {
        return PCABalanceUtils.getBalanceTable(1, baltype, currencyId);
    }

    public static String getAssistBalanceTable(int baltype, String currencyId) {
        return PCABalanceUtils.getBalanceTable(2, baltype, currencyId);
    }

    public static String getAssistMeasureBalanceTable(int baltype, String currencyId) {
        return PCABalanceUtils.getBalanceTable(3, baltype, currencyId);
    }

    public static String getAccountBalanceTable(int balType) {
        return PCABalanceUtils.getAccountBalanceTable(balType, null);
    }

    public static String getAssistBalanceTable(int balType) {
        return PCABalanceUtils.getAssistBalanceTable(balType, null);
    }

    public static String getAssistMeasureBalanceTable(int balType) {
        return PCABalanceUtils.getAssistMeasureBalanceTable(balType, null);
    }

    public static String getAccountBalanceTable(GLRptBaseCondition cond) {
        return PCABalanceUtils.getAccountBalanceTable(cond.getOptionPosting() ? 1 : 5, cond.getCurrencyID());
    }

    public static String getAssistBalanceTable(GLRptBaseCondition cond) {
        return PCABalanceUtils.getAssistBalanceTable(cond.getOptionPosting() ? 1 : 5, cond.getCurrencyID());
    }

    public static String getAssistMeasureBalanceTable(GLRptBaseCondition cond) {
        return PCABalanceUtils.getAssistMeasureBalanceTable(cond.getOptionPosting() ? 1 : 5, cond.getCurrencyID());
    }
}

