/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import com.kingdee.eas.ma.pca.PcVoucherException;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.validator.AbstractPcVoucherBaseValidator;
import org.apache.log4j.Logger;

public class PcVoucherBaseSaveValidator
extends AbstractPcVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(PcVoucherBaseSaveValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected PcVoucherInfo voucherInfo;
    protected IVoucherEntryValidator entryValidator;

    public PcVoucherBaseSaveValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        if (voucherInfo.getProfitCenter() == null) {
            throw new PcVoucherException(PcVoucherException.PROFITCENTER_CANNOT_NULL);
        }
        if (voucherInfo.getReportingCreditAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.getReportingDebitAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        this.checkStatusAndOperate(ctx, voucherInfo, VoucherOperateStatusEnum.TEMP);
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, voucherInfo, VoucherOperateStatusEnum.TEMP);
        this.checkVoucherHeadEmpty(ctx, voucherInfo, this.sysParam);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVoucherType(ctx, voucherInfo);
        int entryCount = voucherInfo.getEntryCount();
        if (entryCount == 0) {
            throw new VoucherException(VoucherException.ONE_ENTRY_AT_LEAST);
        }
    }

    private void checkVoucherHeadEmpty(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        if (!sysParam.isParamExisted("GL_008")) {
            throw new GLException(GLException.NOPARAM, new Object[]{"GL_008"});
        }
        boolean isFzz = sysParam.getBoolean("GL_008");
        if (isFzz && voucherInfo.getCurrency() == null) {
            throw new VoucherException(VoucherException.VOUCHER_CURRENCY_NULL);
        }
        if (voucherInfo.getCompany() == null) {
            throw new VoucherException(VoucherException.COMPANY_CANNOT_NULL);
        }
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        if (voucherInfo.getVoucherType() == null) {
            throw new VoucherException(VoucherException.TYPE_CANNOT_NULL);
        }
        if (voucherInfo.getBookedDate() == null) {
            throw new VoucherException(VoucherException.BOOKEDDATE_NULL);
        }
        if (voucherInfo.getBizDate() == null) {
            throw new VoucherException(VoucherException.BIZDATE_NULL);
        }
        if (voucherInfo.getSourceSys() == null) {
            throw new VoucherException(VoucherException.SOUCESYS_NULL);
        }
        if (voucherInfo.getSourceType() == null) {
            throw new VoucherException(VoucherException.SOUCETYPE_NULL);
        }
    }
}

