/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountViewDcCtrlUtil;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class PcVoucherEntrySubmitValidator
implements IVoucherEntryValidator {
    protected static final Logger logger = Logger.getLogger(PcVoucherEntrySubmitValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected PcVoucherInfo voucherInfo;
    protected PcVoucherEntryInfo entryInfo;

    public PcVoucherEntrySubmitValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo, BaseVoucherEntryInfo baseEntryInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherEntryInfo entryInfo = (PcVoucherEntryInfo)baseEntryInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        this.entryInfo = entryInfo;
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        CompanyOrgUnitInfo company = PcaUtils.getRelatedCompany(ctx, voucherInfo.getProfitCenter().getId().toString());
        if (!(accountViewInfo == null || company.getId().toString().equals(accountViewInfo.getCompanyID().getId().toString()) && company.getAccountTable().getId().toString().equals(accountViewInfo.getAccountTableID().getId().toString()))) {
            PcVoucherUtil.replaceAccount((Context)ctx, (String)company.getId().toString(), (String)company.getAccountTable().getId().toString(), (PcVoucherEntryInfo)entryInfo);
        }
        this.checkEntryRemark(ctx, voucherInfo, entryInfo);
        this.checkEntryAccount(ctx, voucherInfo, entryInfo);
        this.checkEntryCurrency(ctx, voucherInfo, entryInfo);
        this.checkEntryDC(ctx, voucherInfo, entryInfo);
        this.checkEntryMeasureUnit(ctx, voucherInfo, entryInfo);
        this.checkEntryVerify(ctx, voucherInfo, entryInfo);
        this.checkEntryAmount(ctx, voucherInfo, entryInfo);
        this.checkRecordsIsNull(ctx, voucherInfo, entryInfo);
    }

    private void checkEntryRemark(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        String remark;
        boolean entryNeedRemark = this.sysParam.getBoolean("GL_030");
        if (entryNeedRemark && ((remark = entryInfo.getDescription()) == null || remark.trim().length() == 0)) {
            throw new VoucherException(VoucherException.ENTRY_NOT_REMARK, (Object[])this.getSeq());
        }
    }

    private void checkEntryAccount(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (accountViewInfo == null) {
            throw new VoucherException(VoucherException.ACCOUNT_CANNOT_NULL, (Object[])this.getSeq());
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        if (isFzz) {
            try {
                AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (String)entryInfo.getAccount().getId().toString(), (String)voucherInfo.getCurrency().getId().toString(), (CompanyOrgUnitInfo)voucherInfo.getCompany());
            }
            catch (Exception ex) {
                throw new VoucherException(VoucherException.ACCOUNT_CURRENCY_ERROR, (Throwable)ex, (Object[])this.getSeq());
            }
        }
        if (!voucherInfo.getSourceSys().equals((Object)SystemEnum.GENERALLEDGER)) {
            CurrencyInfo curreny = isFzz ? voucherInfo.getCurrency() : entryInfo.getCurrency();
            try {
                AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (String)entryInfo.getAccount().getId().toString(), (String)curreny.getId().toString(), (CompanyOrgUnitInfo)voucherInfo.getCompany());
            }
            catch (Exception ex) {
                if (curreny.getName() == null) {
                    curreny = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(curreny.getId().toString()));
                }
                throw new VoucherException(VoucherException.CURRENCY_NOT_ACCORD_ACCT, (Throwable)ex, new Object[]{this.getSeq()[0], accountViewInfo.getNumber() + "  " + accountViewInfo.getName(), curreny});
            }
        }
        if (!accountViewInfo.isIsLeaf()) {
            throw new VoucherException(VoucherException.ACCOUNT_ISNOT_LEAF, new Object[]{this.getSeq()[0], accountViewInfo.getNumber()});
        }
        if (accountViewInfo.isIsGFreeze() || accountViewInfo.isIsCFreeze() || accountViewInfo.isIsSelfFreeze()) {
            throw new VoucherException(VoucherException.ACCOUNT_FREEZE, new Object[]{this.getSeq()[0], accountViewInfo.getNumber()});
        }
    }

    private void checkEntryVerify(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        boolean allowCussent;
        boolean isAdj;
        boolean bl = isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        if (!isAdj && (allowCussent = this.sysParam.getBoolean("GL_028"))) {
            boolean isVer;
            boolean bl2 = isVer = allowCussent && this.isVerify(entryInfo.getAccount(), entryInfo.getEntryDC());
            if (isVer != entryInfo.isIsVerify()) {
                if (isVer) {
                    entryInfo.setIsVerify(true);
                } else {
                    entryInfo.setIsVerify(false);
                }
                if (entryInfo.getOprStatus() == 0) {
                    entryInfo.setOprStatus(2);
                }
            }
        }
    }

    private void checkEntryMeasureUnit(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws VoucherException, GLException, BOSException {
        boolean useQtyAsst = this.sysParam.getBoolean("G010");
        if (!useQtyAsst && entryInfo.getAccount().isIsQty() && entryInfo.getQuantity() != null && GlUtils.zero.compareTo(entryInfo.getQuantity()) != 0 && entryInfo.getMeasureUnit() == null) {
            throw new VoucherException(VoucherException.ENTRY_NEED_MU, (Object[])this.getSeq());
        }
    }

    private void checkEntryAmount(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        if (entryInfo.getReportingAmount() != null && entryInfo.getReportingAmount().compareTo(GlUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        if (!isFzz) {
            String profitCenterID;
            CompanyOrgUnitInfo relatedCompany;
            String locCurrencyID;
            String oriCurrencyID = entryInfo.getCurrency().getId().toString();
            if (oriCurrencyID.equals(locCurrencyID = (relatedCompany = PcaUtils.getDelegateCompany(ctx, profitCenterID = voucherInfo.getProfitCenter().getId().toString())).getBaseCurrency().getId().toString()) && entryInfo.getOriginalAmount().compareTo(entryInfo.getLocalAmount()) != 0) {
                throw new VoucherException(VoucherException.ORI_NOT_EQUAL_LOCAL);
            }
            boolean useReportingCurrency = this.sysParam.getBoolean("G001");
            if (useReportingCurrency && relatedCompany.getReportConvertMode() != null) {
                boolean isSettleByLocal = 3 == relatedCompany.getReportConvertMode().getValue();
                String rptCurrencyID = relatedCompany.getReportCurrency().getId().toString();
                if (voucherInfo.getSourceType() != SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT) {
                    if (isSettleByLocal && locCurrencyID.equals(rptCurrencyID) && entryInfo.getLocalAmount().compareTo(entryInfo.getReportingAmount()) != 0) {
                        throw new VoucherException(VoucherException.LOC_NOT_EQUAL_RPT);
                    }
                    if (!isSettleByLocal && oriCurrencyID.equals(rptCurrencyID) && entryInfo.getOriginalAmount().compareTo(entryInfo.getReportingAmount()) != 0) {
                        throw new VoucherException(VoucherException.ORI_NOT_EQUAL_RPT);
                    }
                }
            }
        }
        boolean checkAmount = voucherInfo.isPostedByUI();
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT == voucherInfo.getSourceType() || SourceType.PROFIT_AND_LOSS == voucherInfo.getSourceType()) {
            checkAmount = false;
        }
        boolean canSaveZero = this.sysParam.getBoolean("GL_0301");
        if (voucherInfo.isWebVoucher() ? !canSaveZero && checkAmount && GlUtils.isAllZeroOrNull((BigDecimal[])new BigDecimal[]{entryInfo.getLocalAmount(), entryInfo.getOriginalAmount(), entryInfo.getReportingAmount(), entryInfo.getQuantity()}) : !canSaveZero && checkAmount && entryInfo.getAssistRecords().isEmpty() && GlUtils.isAllZeroOrNull((BigDecimal[])new BigDecimal[]{entryInfo.getLocalAmount(), entryInfo.getOriginalAmount(), entryInfo.getReportingAmount(), entryInfo.getQuantity()})) {
            throw new VoucherException(VoucherException.ENTRY_ZERO_AMOUNT, (Object[])this.getSeq());
        }
    }

    private void checkEntryDC(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws VoucherException {
        if (entryInfo.get("entryDC") == null) {
            throw new VoucherException(VoucherException.ENTRYDC_CANNOT_NULL, (Object[])this.getSeq());
        }
        EntryDC dc = entryInfo.getEntryDC();
        AccountViewInfo account = entryInfo.getAccount();
        if (AccountViewDcCtrlUtil.ctrlEntryDC((BaseVoucherInfo)voucherInfo) && !AccountViewDcCtrlUtil.verifyEntryDC((EntryDC)dc, (AccountViewInfo)account)) {
            throw new VoucherException(VoucherException.ENTRYDC_INVALID_FOR_ACCTDC_CHECKED, (Object[])this.getSeq());
        }
    }

    private void checkEntryCurrency(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws VoucherException, GLException, BOSException {
        CurrencyInfo entryCur = entryInfo.getCurrency();
        if (entryCur == null) {
            throw new VoucherException(VoucherException.CURRENCY_CANNOT_NULL, (Object[])this.getSeq());
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        CurrencyInfo acctCur = entryInfo.getAccount().getCurrencyID();
        if (!isFzz && acctCur != null && !acctCur.getId().equals((Object)entryCur.getId())) {
            throw new VoucherException(VoucherException.CURRENCY_NOT_ACCORD_ACCT, new Object[]{this.getSeq()[0], entryInfo.getAccount().getNumber(), entryCur.getName()});
        }
    }

    private void checkRecordsIsNull(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        if ((entryInfo.getAccount().isHasUserProperty() || entryInfo.getAccount().getCAA() != null) && entryInfo.getAssistRecords().size() == 0) {
            throw new VoucherException(VoucherException.MUST_HAVE_ASSIST, (Object[])this.getSeq());
        }
    }

    protected boolean isVerify(AccountViewInfo acc, EntryDC entryDC) {
        BalanceDirectionEnum accDC;
        return acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }

    private Integer[] getSeq() {
        Integer[] lineSeq = new Integer[]{new Integer(this.entryInfo.getSeq())};
        return lineSeq;
    }
}

