/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.validator.ReversePcVoucherValidatorUtils;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.Locale;

public class ReversePcVoucherBaseAntiCancelValidator
implements IVoucherBaseValidator {
    private PcVoucherInfo sourceVoucher = null;
    private PcVoucherInfo reverseVoucher = null;
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, voucherInfo, VoucherOperateStatusEnum.ANTICANCLE);
        this.checkReverseSrcVchBeforeAntiCancel(ctx, voucherInfo);
        this.checkCouldReverse(ctx, voucherInfo);
    }

    private void checkReverseSrcVchBeforeAntiCancel(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo srcVch = this.getSourceVoucherInfo(ctx, voucherInfo);
        if (!VoucherStatusEnum.POSTED.equals((Object)srcVch.getBizStatus())) {
            throw new VoucherException(VoucherException.SRC_UNPOSTED);
        }
        PcVoucherEntryCollection entries = srcVch.getEntries();
        PcVoucherEntryInfo entry = null;
        String currentAcctTable = srcVch.getCompany().getAccountTable().getId().toString();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (currentAcctTable.equals(entry.getAccount().getAccountTableID().getId().toString())) continue;
            throw new VoucherException(VoucherException.REV_ANTICANCEL_FAIL_FOR_ACCOUNT_CHANGED);
        }
    }

    private void checkCouldReverse(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo srcVch = this.getSourceVoucherInfo(ctx, voucherInfo);
        PcVoucherInfo reverseVch = this.getReverseVoucherInfo(ctx, voucherInfo);
        StringBuffer msgCollector = new StringBuffer();
        msgCollector.append(this.getResource(ctx, resource, "BEYOND_SRC_AMOUNT_ANTICANCEL", new Object[]{srcVch.getVoucherType().getName(ctx.getLocale()), srcVch.getNumber(), srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber()}));
        msgCollector.append("\r\n");
        int result = ReversePcVoucherValidatorUtils.checkReverse(ctx, reverseVch, srcVch, msgCollector);
        if (result == -1) {
            throw new VoucherException(VoucherException.NO_MSG, (Object[])new String[]{msgCollector.toString()});
        }
        if (result == 0) {
            voucherInfo.put("ReverseComplete", (Object)true);
        }
    }

    private PcVoucherInfo getSourceVoucherInfo(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo srcVch;
        if (this.sourceVoucher != null) {
            return this.sourceVoucher;
        }
        ObjectUuidPK srcVchPK = new ObjectUuidPK(BOSUuid.read((String)voucherInfo.getSourceBillId()));
        this.sourceVoucher = srcVch = (PcVoucherInfo)PcVoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)srcVchPK, PcVoucherInfo.getReverseSelector());
        return srcVch;
    }

    private PcVoucherInfo getReverseVoucherInfo(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        PcVoucherInfo reverseVch;
        if (this.reverseVoucher != null) {
            return this.reverseVoucher;
        }
        ObjectUuidPK vchPK = new ObjectUuidPK(BOSUuid.read((String)voucherInfo.getId().toString()));
        this.reverseVoucher = reverseVch = (PcVoucherInfo)PcVoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)vchPK, PcVoucherInfo.getDefaultSelector());
        return reverseVch;
    }

    protected String getResource(Context ctx, String resName, String key, Object[] params) {
        String message = ResourceBase.getString((String)resName, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

